/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.kar.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.karaf.kar.internal.FeatureDetector;
import org.apache.karaf.kar.internal.KarServiceImpl;
import org.apache.karaf.util.StreamUtils;
import org.apache.karaf.util.maven.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Kar {
    public static final Logger LOGGER = LoggerFactory.getLogger(KarServiceImpl.class);
    public static final String MANIFEST_ATTR_KARAF_FEATURE_START = "Karaf-Feature-Start";
    public static final String MANIFEST_ATTR_KARAF_FEATURE_REPOS = "Karaf-Feature-Repos";
    private final URI karUri;
    private boolean shouldInstallFeatures;
    private List<URI> featureRepos;

    public Kar(URI karUri) {
        this.karUri = karUri;
    }

    public void extract(File repoDir, File resourceDir) {
        InputStream is = null;
        JarInputStream zipIs = null;
        FeatureDetector featureDetector = new FeatureDetector();
        this.featureRepos = new ArrayList<URI>();
        this.shouldInstallFeatures = true;
        try {
            is = this.karUri.toURL().openStream();
            repoDir.mkdirs();
            if (!repoDir.isDirectory()) {
                throw new RuntimeException("The KAR file " + this.karUri + " is already installed");
            }
            LOGGER.debug("Uncompress the KAR file {} into directory {}", (Object)this.karUri, (Object)repoDir);
            zipIs = new JarInputStream(is);
            boolean scanForRepos = true;
            Manifest manifest = zipIs.getManifest();
            if (manifest != null) {
                String featureReposAttr;
                Attributes attr = manifest.getMainAttributes();
                String featureStartSt = (String)attr.get(new Attributes.Name(MANIFEST_ATTR_KARAF_FEATURE_START));
                if ("false".equals(featureStartSt)) {
                    this.shouldInstallFeatures = false;
                }
                if ((featureReposAttr = (String)attr.get(new Attributes.Name(MANIFEST_ATTR_KARAF_FEATURE_REPOS))) != null) {
                    this.featureRepos.add(new URI(featureReposAttr));
                    scanForRepos = false;
                }
            }
            ZipEntry entry = zipIs.getNextEntry();
            while (entry != null) {
                if (entry.getName().contains("..") || entry.getName().contains("%2e%2e")) {
                    LOGGER.warn("kar entry {} contains a .. relative path. For security reasons, it's not allowed.", (Object)entry.getName());
                } else {
                    File destFile;
                    String path;
                    if (entry.getName().startsWith("repository/")) {
                        path = entry.getName().substring("repository/".length());
                        destFile = new File(repoDir, path);
                        Kar.extract(zipIs, entry, destFile);
                        if (scanForRepos && featureDetector.isFeaturesRepository(destFile)) {
                            HashMap map = new HashMap();
                            String uri = Parser.pathToMaven(path, map);
                            if (map.get("classifier") != null && ((String)map.get("classifier")).equalsIgnoreCase("features")) {
                                this.featureRepos.add(URI.create(uri));
                            } else {
                                this.featureRepos.add(destFile.toURI());
                            }
                        }
                    }
                    if (entry.getName().startsWith("resources/")) {
                        path = entry.getName().substring("resources/".length());
                        destFile = new File(resourceDir, path);
                        Kar.extract(zipIs, entry, destFile);
                    }
                }
                entry = zipIs.getNextEntry();
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Error extracting kar file " + this.karUri + " into dir " + repoDir + ": " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                Kar.closeStream(zipIs);
                Kar.closeStream(is);
                throw throwable;
            }
        }
        Kar.closeStream(zipIs);
        Kar.closeStream(is);
    }

    private static File extract(InputStream is, ZipEntry zipEntry, File dest) throws Exception {
        if (zipEntry.isDirectory()) {
            LOGGER.debug("Creating directory {}", (Object)dest.getName());
            dest.mkdirs();
        } else {
            dest.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(dest);
            StreamUtils.copy(is, out);
            out.close();
        }
        return dest;
    }

    private static void closeStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                LOGGER.warn("Error closing stream", (Throwable)e);
            }
        }
    }

    public String getKarName() {
        try {
            String url = this.karUri.toURL().toString();
            if (url.startsWith("mvn")) {
                int index = url.indexOf("/");
                url = url.substring(index + 1);
                index = url.indexOf("/");
                url = url.substring(0, index);
                return url;
            }
            String karName = new File(this.karUri.toURL().getFile()).getName();
            karName = karName.substring(0, karName.lastIndexOf("."));
            return karName;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid kar URI " + this.karUri, e);
        }
    }

    public URI getKarUri() {
        return this.karUri;
    }

    public boolean isShouldInstallFeatures() {
        return this.shouldInstallFeatures;
    }

    public List<URI> getFeatureRepos() {
        return this.featureRepos;
    }
}

