/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.internal.utils;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.aries.component.dsl.CachingServiceReference;
import org.apache.aries.jax.rs.whiteboard.internal.utils.Utils;
import org.osgi.framework.ServiceObjects;

public class ServiceTuple<T>
implements Comparable<ServiceTuple<T>> {
    private final CachingServiceReference<T> _serviceReference;
    private ServiceObjects<T> _serviceObjects;
    private AtomicReference<T> _service;

    ServiceTuple(CachingServiceReference<T> cachingServiceReference, ServiceObjects<T> serviceObjects, T service) {
        this._serviceReference = cachingServiceReference;
        this._serviceObjects = serviceObjects;
        this._service = new AtomicReference<T>(service);
    }

    @Override
    public int compareTo(ServiceTuple<T> o) {
        return this._serviceReference.compareTo(o._serviceReference);
    }

    public void dispose() {
        Object service = this._service.getAndSet(null);
        if (service != null) {
            this._serviceObjects.ungetService(service);
        }
    }

    public void refresh() {
        this.dispose();
        if (this.isAvailable()) {
            this._service.set(this._serviceObjects.getService());
        }
    }

    public T getService() {
        return this._service.get();
    }

    public ServiceObjects<T> getServiceObjects() {
        return this._serviceObjects;
    }

    public int hashCode() {
        return this._serviceReference.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceTuple that = (ServiceTuple)o;
        return this._serviceReference.equals(that._serviceReference);
    }

    public CachingServiceReference<T> getCachingServiceReference() {
        return this._serviceReference;
    }

    public boolean isAvailable() {
        return Utils.isAvailable(this._serviceObjects.getServiceReference());
    }
}

