/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.handler.BaseConditionModuleHandler;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventFilter;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.events.TopicPrefixEventFilter;
import org.openhab.core.i18n.TimeZoneProvider;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.events.ItemAddedEvent;
import org.openhab.core.items.events.ItemRemovedEvent;
import org.openhab.core.library.types.DateTimeType;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.PercentType;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.library.unit.Units;
import org.openhab.core.types.State;
import org.openhab.core.types.TypeParser;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ItemStateConditionHandler
extends BaseConditionModuleHandler
implements EventSubscriber {
    public static final String ITEM_NAME = "itemName";
    public static final String OPERATOR = "operator";
    public static final String STATE = "state";
    private final Logger logger = LoggerFactory.getLogger(ItemStateConditionHandler.class);
    public static final String ITEM_STATE_CONDITION = "core.ItemStateCondition";
    private final ItemRegistry itemRegistry;
    private final String ruleUID;
    private final String itemName;
    private final EventFilter eventFilter;
    private final BundleContext bundleContext;
    private final Set<String> types;
    private final ServiceRegistration<?> eventSubscriberRegistration;
    private final TimeZoneProvider timeZoneProvider;

    public ItemStateConditionHandler(Condition condition, String ruleUID, BundleContext bundleContext, ItemRegistry itemRegistry, TimeZoneProvider timeZoneProvider) {
        super(condition);
        this.itemRegistry = itemRegistry;
        this.bundleContext = bundleContext;
        this.timeZoneProvider = timeZoneProvider;
        this.itemName = (String)((Condition)this.module).getConfiguration().get(ITEM_NAME);
        this.eventFilter = new TopicPrefixEventFilter("openhab/items/" + this.itemName + "/");
        this.types = Set.of(ItemAddedEvent.TYPE, ItemRemovedEvent.TYPE);
        this.ruleUID = ruleUID;
        this.eventSubscriberRegistration = this.bundleContext.registerService(EventSubscriber.class.getName(), (Object)this, null);
        if (itemRegistry.get((Object)this.itemName) == null) {
            this.logger.warn("Item '{}' needed for rule '{}' is missing. Condition '{}' will not work.", new Object[]{this.itemName, ruleUID, ((Condition)this.module).getId()});
        }
    }

    public Set<String> getSubscribedEventTypes() {
        return this.types;
    }

    public @Nullable EventFilter getEventFilter() {
        return this.eventFilter;
    }

    /*
     * WARNING - void declaration
     */
    public void receive(Event event) {
        Event event2 = event;
        if (event2 instanceof ItemAddedEvent) {
            void addedEvent;
            ItemAddedEvent itemAddedEvent = (ItemAddedEvent)event2;
            ItemAddedEvent cfr_ignored_0 = (ItemAddedEvent)event2;
            if (this.itemName.equals(addedEvent.getItem().name)) {
                this.logger.info("Item '{}' needed for rule '{}' added. Condition '{}' will now work.", new Object[]{this.itemName, this.ruleUID, ((Condition)this.module).getId()});
                return;
            }
        } else {
            Event event3 = event;
            if (event3 instanceof ItemRemovedEvent) {
                void removedEvent;
                ItemRemovedEvent itemRemovedEvent = (ItemRemovedEvent)event3;
                ItemRemovedEvent cfr_ignored_1 = (ItemRemovedEvent)event3;
                if (this.itemName.equals(removedEvent.getItem().name)) {
                    this.logger.warn("Item '{}' needed for rule '{}' removed. Condition '{}' will no longer work.", new Object[]{this.itemName, this.ruleUID, ((Condition)this.module).getId()});
                    return;
                }
            }
        }
    }

    @Override
    public boolean isSatisfied(Map<String, Object> inputs) {
        String state = (String)((Condition)this.module).getConfiguration().get(STATE);
        String operator = (String)((Condition)this.module).getConfiguration().get(OPERATOR);
        if (operator == null || state == null || this.itemName == null) {
            this.logger.error("Module is not well configured: itemName={}  operator={}  state = {} for rule {}", new Object[]{this.itemName, operator, state, this.ruleUID});
            return false;
        }
        try {
            this.logger.debug("ItemStateCondition '{}' checking if {} {} {} for rule {}", new Object[]{((Condition)this.module).getId(), this.itemName, operator, state, this.ruleUID});
            switch (operator) {
                case "=": {
                    return this.equalsToItemState(this.itemName, state);
                }
                case "!=": {
                    return !this.equalsToItemState(this.itemName, state);
                }
                case "<": {
                    return !this.greaterThanOrEqualsToItemState(this.itemName, state);
                }
                case "<=": 
                case "=<": {
                    return this.lessThanOrEqualsToItemState(this.itemName, state);
                }
                case ">": {
                    return !this.lessThanOrEqualsToItemState(this.itemName, state);
                }
                case "=>": 
                case ">=": {
                    return this.greaterThanOrEqualsToItemState(this.itemName, state);
                }
            }
        }
        catch (ItemNotFoundException e) {
            this.logger.error("Item with name {} not found in ItemRegistry for condition of rule {}.", (Object)this.itemName, (Object)this.ruleUID);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean lessThanOrEqualsToItemState(String itemName, String state) throws ItemNotFoundException {
        void type;
        DecimalType decimalState;
        State state2;
        Item item = this.itemRegistry.getItem(itemName);
        State compareState = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)state);
        State itemState = item.getState();
        State state3 = itemState;
        if (state3 instanceof DateTimeType) {
            void dateTimeState;
            DateTimeType dateTimeType = (DateTimeType)state3;
            DateTimeType cfr_ignored_0 = (DateTimeType)state3;
            Instant itemTime = dateTimeState.getInstant();
            Instant compareTime = this.getCompareTime(state);
            return itemTime.compareTo(compareTime) <= 0;
        }
        State state4 = itemState;
        if (state4 instanceof QuantityType) {
            void type2;
            void qtState;
            QuantityType itemTime = (QuantityType)state4;
            QuantityType cfr_ignored_1 = (QuantityType)state4;
            State state5 = compareState;
            if (state5 instanceof DecimalType) {
                void type3;
                DecimalType decimalType = (DecimalType)state5;
                DecimalType cfr_ignored_2 = (DecimalType)state5;
                if (Units.ONE.equals(qtState.getUnit())) return qtState.compareTo(new QuantityType((Number)type3.toBigDecimal(), qtState.getUnit())) <= 0;
                this.logger.warn("Received a QuantityType state '{}' with unit for item {}, but the condition is defined as a plain number without unit ({}), please consider adding a unit to the condition for rule {}.", new Object[]{qtState, itemName, state, this.ruleUID});
                return qtState.compareTo(new QuantityType((Number)type3.toBigDecimal(), qtState.getUnit())) <= 0;
            }
            State state6 = compareState;
            if (!(state6 instanceof QuantityType)) return false;
            QuantityType quantityType = (QuantityType)state6;
            QuantityType cfr_ignored_3 = (QuantityType)state6;
            return qtState.compareTo((QuantityType)type2) <= 0;
        }
        State state7 = itemState;
        if (state7 instanceof PercentType) {
            PercentType type3 = (PercentType)state7;
            PercentType cfr_ignored_4 = (PercentType)state7;
            if (compareState != null) {
                PercentType percentState = (PercentType)compareState.as(PercentType.class);
                if (percentState == null) return false;
                return type3.compareTo((DecimalType)percentState) <= 0;
            }
        }
        if (!((state2 = itemState) instanceof DecimalType)) return false;
        DecimalType percentState = (DecimalType)state2;
        DecimalType cfr_ignored_5 = (DecimalType)state2;
        if (compareState == null || (decimalState = (DecimalType)compareState.as(DecimalType.class)) == null) return false;
        return type.compareTo(decimalState) <= 0;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean greaterThanOrEqualsToItemState(String itemName, String state) throws ItemNotFoundException {
        void type;
        DecimalType decimalState;
        State state2;
        Item item = this.itemRegistry.getItem(itemName);
        State compareState = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)state);
        State itemState = item.getState();
        State state3 = itemState;
        if (state3 instanceof DateTimeType) {
            void dateTimeState;
            DateTimeType dateTimeType = (DateTimeType)state3;
            DateTimeType cfr_ignored_0 = (DateTimeType)state3;
            Instant itemTime = dateTimeState.getInstant();
            Instant compareTime = this.getCompareTime(state);
            return itemTime.compareTo(compareTime) >= 0;
        }
        State state4 = itemState;
        if (state4 instanceof QuantityType) {
            void type2;
            void qtState;
            QuantityType itemTime = (QuantityType)state4;
            QuantityType cfr_ignored_1 = (QuantityType)state4;
            State state5 = compareState;
            if (state5 instanceof DecimalType) {
                void type3;
                DecimalType decimalType = (DecimalType)state5;
                DecimalType cfr_ignored_2 = (DecimalType)state5;
                if (Units.ONE.equals(qtState.getUnit())) return qtState.compareTo(new QuantityType((Number)type3.toBigDecimal(), qtState.getUnit())) >= 0;
                this.logger.warn("Received a QuantityType state '{}' with unit for item {}, but the condition is defined as a plain number without unit ({}), please consider adding a unit to the condition for rule {}.", new Object[]{qtState, itemName, state, this.ruleUID});
                return qtState.compareTo(new QuantityType((Number)type3.toBigDecimal(), qtState.getUnit())) >= 0;
            }
            State state6 = compareState;
            if (!(state6 instanceof QuantityType)) return false;
            QuantityType quantityType = (QuantityType)state6;
            QuantityType cfr_ignored_3 = (QuantityType)state6;
            return qtState.compareTo((QuantityType)type2) >= 0;
        }
        State state7 = itemState;
        if (state7 instanceof PercentType) {
            PercentType type3 = (PercentType)state7;
            PercentType cfr_ignored_4 = (PercentType)state7;
            if (compareState != null) {
                PercentType percentState = (PercentType)compareState.as(PercentType.class);
                if (percentState == null) return false;
                return type3.compareTo((DecimalType)percentState) >= 0;
            }
        }
        if (!((state2 = itemState) instanceof DecimalType)) return false;
        DecimalType percentState = (DecimalType)state2;
        DecimalType cfr_ignored_5 = (DecimalType)state2;
        if (compareState == null || (decimalState = (DecimalType)compareState.as(DecimalType.class)) == null) return false;
        return type.compareTo(decimalState) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    private boolean equalsToItemState(String itemName, String state) throws ItemNotFoundException {
        Item item = this.itemRegistry.getItem(itemName);
        State compareState = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)state);
        State itemState = item.getState();
        State state2 = itemState;
        if (state2 instanceof QuantityType) {
            QuantityType quantityType = (QuantityType)state2;
            QuantityType cfr_ignored_0 = (QuantityType)state2;
            State state3 = compareState;
            if (state3 instanceof DecimalType) {
                void qtState;
                DecimalType decimalType = (DecimalType)state3;
                DecimalType cfr_ignored_1 = (DecimalType)state3;
                if (Units.ONE.equals(qtState.getUnit())) {
                    void type;
                    return itemState.equals(new QuantityType((Number)type.toBigDecimal(), qtState.getUnit()));
                }
                this.logger.warn("Received a QuantityType state '{}' with unit for item {}, but the condition is defined as a plain number without unit ({}), comparison will fail unless a unit is added to the condition for rule {}.", new Object[]{itemState, itemName, state, this.ruleUID});
                return false;
            }
        }
        return itemState.equals(compareState);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.eventSubscriberRegistration.unregister();
    }

    private Instant getCompareTime(String input) {
        if (input.isBlank()) {
            return Instant.now();
        }
        try {
            return ZonedDateTime.parse(input).toInstant();
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                return LocalDateTime.parse(input, DateTimeFormatter.ISO_LOCAL_DATE_TIME).atZone(this.timeZoneProvider.getTimeZone()).toInstant();
            }
            catch (DateTimeParseException dateTimeParseException2) {
                try {
                    int dayPosition = input.indexOf("D");
                    if (dayPosition == -1) {
                        return Instant.now().plus(Duration.parse("PT" + input));
                    }
                    if (dayPosition == input.length() - 1) {
                        return Instant.now().plus(Duration.parse("P" + input));
                    }
                    return Instant.now().plus(Duration.parse("P" + input.substring(0, dayPosition + 1) + "T" + input.substring(dayPosition + 1)));
                }
                catch (DateTimeParseException e) {
                    this.logger.warn("Couldn't get a comparable time from '{}', using now", (Object)input);
                    return Instant.now();
                }
            }
        }
    }
}

