.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/comp/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.TH "PG_SQLITE" "" "17 September 2020" "" "PostgreSQL Tcl Interface Documentation"

.SH NAME
pg_sqlite \- implements a bridge between PostgreSQL and Sqlite3 using the Pgtcl and sqlite3 packages.

.SH SYNOPSIS

.nf
pg_sqlite \fIsqlite_db\fR \fIcommand\fR [args]
.fi
.SH "DESCRIPTION"
.PP
\fBpg_sqlite\fR can import the results of a Postgres SQL query
(previously made via \fBpg_exec\fR)
directly into an sqlite3 table, export the results of an Sqlite SQL query into
a Postgres table (via write_tabsep), or import TSV files directly into sqlite3.
.PP
The commands currently implemented are import_postgres_result, read_tabsep, write_tabsep, and read_tabsep_keylist.
.SH "ARGUMENTS"
.TP
\fB\fIsqlite_db\fB\fR
An Sqlite3 database handle previously created via the sqlite3 command.
.TP
\fB\fIcommand\fB\fR
The command, one of
info,
import_postgres_result,
read_tabsep,
write_tabsep, or
read_tabsep_keylist,
.TP
\fB\fIargs\fB\fR
Command-specific arguments.
.SH "COMMANDS"
.PP
\fBinfo\fR

.nf
    \fBpg_sqlite\fR \fIsqlite_db\fR info
	[-busy]
	[-filename]
	[-db \fIdatabase_name\fR]
   
.fi
.PP
Request information from an SQLITE database connection. Returns a key-value list containing the values requested if available. With no arguments, all available info is returned.
.TP
\fB-filename\fR
Request the filename associated with a database.
.TP
\fB-db \fIdatabase\fB\fR
For the -filename option, specify the database name (default "main").
.TP
\fB-busy\fR
Request a list of prepared commands that are currently busy.
.PP
\fBimport_postgres_result\fR

.nf
    \fBpg_sqlite\fR \fIsqlite_db\fR import_postgres_result \fIhandle\fR
	[-rowbyrow]
	[-sql \fItarget_sql\fR]
	[-create \fInew_table\fR]
	[-into \fItable\fR]
	[-replace]
	[-as \fIname_type_list\fR]
	[-types \fItype_list\fR]
	[-names \fIname_list\fR]
	[-pkey \fIprimary_key\fR]
	[-sep \fIseparator\fR]
	[-null \fInull_string\fR]
	[-poll_interval \fIrows\fR]
	[-recommit \fIrows\fR]
	[-check]
	[-max \fIcolumn-name variable-name\fR]
   
.fi
.PP
Import the result of a PostgreSQL request into an sqlite3 table.
.TP
\fB\fIhandle\fB\fR
A database or result handle. Normally, you would call \fBpg_exec\fR and pass the result
handle to \fBpg_sqlite\fR here. If you are using row_by_row mode, though, you use pg_sendquery and pass the
PostgreSQL database handle here.
.TP
\fB-rowbyrow\fR
Perform the request using row-by-row mode. This injects the data to sqlite directly without making
an internal copy, but the result may be incomplete or inconsistent if an error occurs during the
request.
.TP
\fB-sep \fIseparator\fB\fR
String to use to separate columns. Default is "\\t" (tab).
.TP
\fB-null \fInull_string\fB\fR
String to use to indicate a null value. Default is to treat all strings literally.
.TP
\fB-sql \fItarget_sql\fB\fR
An INSERT statement, suitable to be compiled into a prepared statement to be applied to each row.
For example "INSERT INTO newtable (id, name, value) VALUES (?,?,?)"
.TP
\fB-create \fInew_table\fB\fR
A table to be created in sqlite. The names and types of columns, and the primary key, must be provided.
.TP
\fB-into \fItable\fB\fR
An existing sqlite table to insert the data. The names of the columns must be provided, if the type can not be inferred it will be assumed to be "text".
.TP
\fB-replace\fR
When performing the insert on an existing or newly create table, use "INSERT OR REPLACE" semantics. Not compatible with "-sql".
.TP
\fB-as \fIname-type-list\fB\fR
A list of alternating column names and types. See note on types.
.TP
\fB-types \fItype-list\fB\fR
A list of column types. See note on types.
.TP
\fB-names \fIname-list\fB\fR
A list of column names.
.TP
\fB-pkey \fIprimary_key\fB\fR
A list containing key names and optional sorting to indicate primary key where needed. For example
\fB-pkey {{clock ASC} {sequence ASC}}\fR\&.
.TP
\fB-poll_interval \fIcount\fB\fR
Call DoOneEvent() every \fIcount\fR rows to keep the event loop alive
during long transactions.
.TP
\fB-recommit \fIcount\fB\fR
Chunk the operation in transactions, with one transaction every \fIcount\fR rows.
.TP
\fB-check\fR
Check (via a SELECT) whether the exact row is already present, and skip inserting the row if so. This
avoids bloating the WAL log during large re-loads of databases, at some performance cost.
.TP
\fB-max \fIcolumn-name variable-name\fB\fR
Set $variable-name to the maximum value of column-name imported.
.PP
\fBwrite_tabsep\fR

.nf
    \fBpg_sqlite\fR \fIsqlite_db\fR write_tabsep \fIhandle\fR \fIsql\fR
	[\fIsql\fR]
	[-sep \fIseparator\fR]
	[-null \fInull_string\fR]
	[-poll_interval \fIrows\fR]
   
.fi
.PP
Write the results of the provided \fIsql\fR to a file handle
.PP
This command may be used to export sqlite3 data to postgres. You issue a \fBCOPY FROM STDIN ... FORMAT text\fR command, then use \fBpg_sqlite write_tabsep ...\fR to write the data directly to the Postgresql handle, followed by writing the terminator line to the same handle. See the PostgreSQL documentation on the "COPY" command for more details.
.TP
\fB\fIhandle\fB\fR
File handle.
.TP
\fB-sep \fIseparator\fB\fR
String to use to separate columns. Default is "\\t" (tab).
.TP
\fB-null \fInull_string\fB\fR
String to use to indicate a null value. Default is to treat all strings literally.
.TP
\fB-poll_interval \fIcount\fB\fR
Call DoOneEvent() every \fIcount\fR rows to keep the event loop alive
during long transactions.
.PP
\fBread_tabsep\fR

.nf
    \fBpg_sqlite\fR \fIsqlite_db\fR read_tabsep
	[-row \fIsingle_tab_separated_row\fR]
	[-file \fIfile_handle\fR]
	[-sql \fItarget_sql\fR]
	[-create \fInew_table\fR]
	[-into \fItable\fR]
	[-replace]
	[-as \fIname_type_list\fR]
	[-types \fItype_list\fR]
	[-names \fIname_list\fR]
	[-pkey \fIprimary_key\fR]
	[-sep \fIseparator\fR]
	[-null \fInull_string\fR]
	[-poll_interval \fIrows\fR]
	[-recommit \fIrows\fR]
	[-check]
   
.fi
.PP
Read a previously opened file into an sqlite3 table.
.TP
\fB-row \fIsingle_tab_separated_row\fB\fR
An already read tab-separated line.
.TP
\fB-file \fIfile_handle\fB\fR
An open file consistion of tab-separated rows.
.TP
\fB-sep \fIseparator\fB\fR
String to use to separate columns. Default is "\\t" (tab).
.TP
\fB-null \fInull_string\fB\fR
String to use to indicate a null value. Default is to treat all strings literally.
.TP
\fB-sql \fItarget_sql\fB\fR
An INSERT statement, suitable to be compiled into a prepared statement to be applied to each row.
For example "INSERT INTO newtable (id, name, value) VALUES (?,?,?)"
.TP
\fB-create \fInew_table\fB\fR
A table to be created in sqlite. The names and types of columns, and the primary key, must be provided.
.TP
\fB-into \fItable\fB\fR
An existing sqlite table to insert the data. The names of the columns must be provided, if the type can not be inferred it will be assumed to be "text".
.TP
\fB-replace\fR
When performing the insert on an existing or newly create table, use "INSERT OR REPLACE" semantics. Not compatible with "-sql".
.TP
\fB-as \fIname-type-list\fB\fR
A list of alternating column names and types. See note on types.
.TP
\fB-types \fItype-list\fB\fR
A list of column types. See note on types.
.TP
\fB-names \fIname-list\fB\fR
A list of column names.
.TP
\fB-pkey \fIprimary_key\fB\fR
A list containing key names and optional sorting to indicate primary key where needed. For example
\fB-pkey {{clock ASC} {sequence ASC}}\fR\&.
.TP
\fB-poll_interval \fIcount\fB\fR
Call DoOneEvent() every \fIcount\fR rows to keep the event loop alive
during long transactions.
.TP
\fB-recommit \fIcount\fB\fR
Chunk the operation in transactions, with one transaction every \fIcount\fR rows.
.TP
\fB-check\fR
Check (via a SELECT) whether the exact row is already present, and skip inserting the row if so. This
avoids bloating the WAL log during large re-loads of databases, at some performance cost.
.PP
\fBread_tabsep_keylist\fR

.nf
    \fBpg_sqlite\fR \fIsqlite_db\fR read_tabsep_keylist
	[-row \fIsingle_tab_separated_row\fR]
	[-file \fIfile_handle\fR]
	[-create \fInew_table\fR]
	[-into \fItable\fR]
	[-replace]
	[-as \fIname_type_list\fR]
	[-names \fIname_list\fR]
	[-pkey \fIprimary_key\fR]
	[-sep \fIseparator\fR]
	[-null \fInull_string\fR]
	[-poll_interval \fIrows\fR]
	[-recommit \fIrows\fR]
   
.fi
.PP
Read a previously opened file containing alternating key-value columns into an sqlite3 table.
.TP
\fB-row \fIsingle_tab_separated_row\fB\fR
An already read tab-separated key-value list line.
.TP
\fB-file \fIfile_handle\fB\fR
An open file consistion of tab-separated key-value list rows.
.TP
\fB-sep \fIseparator\fB\fR
String to use to separate columns. Default is "\\t" (tab).
.TP
\fB-null \fInull_string\fB\fR
String to use to indicate a null value. Default is to treat all strings literally.
.TP
\fB-create \fInew_table\fB\fR
A table to be created in sqlite. The names and types of columns, and the primary key, must be provided.
.TP
\fB-into \fItable\fB\fR
An existing sqlite table to insert the data. The names of the columns must be provided, if the type can not be inferred it will be assumed to be "text".
.TP
\fB-replace\fR
When performing the insert on an existing or newly create table, use "INSERT OR REPLACE" semantics. Not compatible with "-sql".
.TP
\fB-as \fIname-type-list\fB\fR
A list of alternating column names and types. See note on types.
.TP
\fB-names \fIname-list\fB\fR
A list of column names.
.TP
\fB-pkey \fIprimary_key\fB\fR
A list containing key names and optional sorting to indicate primary key where needed. For example
\fB-pkey {{clock ASC} {sequence ASC}}\fR\&.
.TP
\fB-poll_interval \fIcount\fB\fR
Call DoOneEvent() every \fIcount\fR rows to keep the event loop alive
during long transactions.
.TP
\fB-recommit \fIcount\fB\fR
Chunk the operation in transactions, with one transaction every \fIcount\fR rows.
.SH "TYPES"
.PP
\fBA note on types:\fR \fBpg_sqlite\fR supports four types: integer (or int), boolean (or bool), double (or real), and text\&. Integer, double, and text match both sqlite and postgresql types. Boolean is an integer type in sqlite, and boolean in postgresql, and converts postgresql boolean values (such as 'yes', 'no', 'true', or 'false') to integer 1 and 0.
.PP
In addition, \fBpg_sqlite\fR will accept PostgreSQL boolean values for the integer type. This may be made conditional on a "strict" mode in the future.
.SH "RETURN VALUE"
.PP
Number of rows imported or exported.
.SH "SEE ALSO"
.PP
Sqlite 3
