/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geocoder;

import jakarta.json.JsonObject;
import jakarta.ws.rs.client.Client;
import org.traccar.geocoder.Address;
import org.traccar.geocoder.AddressFormat;
import org.traccar.geocoder.JsonGeocoder;

public class GeocodeFarmGeocoder
extends JsonGeocoder {
    private static String formatUrl(String key, String language) {
        Object url = "https://api.geocode.farm/reverse/?lat=%f&lon=%f";
        if (key != null) {
            url = (String)url + "&key=" + key;
        }
        if (language != null) {
            url = (String)url + "&lang=" + language;
        }
        return url;
    }

    public GeocodeFarmGeocoder(Client client, String key, String language, int cacheSize, AddressFormat addressFormat) {
        super(client, GeocodeFarmGeocoder.formatUrl(key, language), cacheSize, addressFormat);
    }

    @Override
    public Address parseAddress(JsonObject json) {
        Address address = new Address();
        JsonObject result = json.getJsonObject("RESULTS").getJsonObject("result").getJsonObject("0");
        if (result.containsKey((Object)"formatted_address")) {
            address.setFormattedAddress(result.getString("formatted_address"));
        }
        if (result.containsKey((Object)"house_number")) {
            address.setHouse(result.getString("house_number"));
        }
        if (result.containsKey((Object)"street_name")) {
            address.setStreet(result.getString("street_name"));
        }
        if (result.containsKey((Object)"locality")) {
            address.setSettlement(result.getString("locality"));
        }
        if (result.containsKey((Object)"admin_1")) {
            address.setState(result.getString("admin_1"));
        }
        if (result.containsKey((Object)"country")) {
            address.setCountry(result.getString("country"));
        }
        if (result.containsKey((Object)"postal_code")) {
            address.setPostcode(result.getString("postal_code"));
        }
        return address;
    }
}

