/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.kafka.clients.consumer.internals.Utils;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;

public class TopicIdPartitionSet {
    static final Utils.TopicPartitionComparator TOPIC_PARTITION_COMPARATOR = new Utils.TopicPartitionComparator();
    static final Utils.TopicIdPartitionComparator TOPIC_ID_PARTITION_COMPARATOR = new Utils.TopicIdPartitionComparator();
    private final SortedSet<TopicIdPartition> topicIdPartitions = new TreeSet<TopicIdPartition>(TOPIC_ID_PARTITION_COMPARATOR);
    private final SortedSet<TopicPartition> topicPartitions = new TreeSet<TopicPartition>(TOPIC_PARTITION_COMPARATOR);
    private final Set<Uuid> topicIds = new HashSet<Uuid>();
    private final SortedSet<String> topicNames = new TreeSet<String>();

    void add(TopicIdPartition topicIdPartition) {
        this.topicIdPartitions.add(topicIdPartition);
        this.topicPartitions.add(topicIdPartition.topicPartition());
        this.topicIds.add(topicIdPartition.topicId());
        this.topicNames.add(topicIdPartition.topicPartition().topic());
    }

    public void addAll(Uuid topicId, String topicName, Set<Integer> partitions) {
        partitions.forEach(tp -> this.add(new TopicIdPartition(topicId, (int)tp, topicName)));
    }

    public boolean isEmpty() {
        return this.topicIdPartitions.isEmpty();
    }

    public SortedSet<TopicPartition> topicPartitions() {
        return Collections.unmodifiableSortedSet(this.topicPartitions);
    }

    public Set<Uuid> topicIds() {
        return Collections.unmodifiableSet(this.topicIds);
    }

    public SortedSet<String> topicNames() {
        return Collections.unmodifiableSortedSet(this.topicNames);
    }

    public Map<Uuid, SortedSet<Integer>> toTopicIdPartitionMap() {
        HashMap<Uuid, SortedSet<Integer>> partitions = new HashMap<Uuid, SortedSet<Integer>>();
        this.topicIdPartitions.forEach(topicIdPartition -> {
            Uuid topicId = topicIdPartition.topicId();
            partitions.computeIfAbsent(topicId, k -> new TreeSet()).add(topicIdPartition.partition());
        });
        return partitions;
    }

    protected SortedSet<TopicPartition> toTopicNamePartitionSet() {
        TreeSet<TopicPartition> result = new TreeSet<TopicPartition>(TOPIC_PARTITION_COMPARATOR);
        this.topicIdPartitions.forEach(topicIdPartition -> result.add(topicIdPartition.topicPartition()));
        return result;
    }

    public String toString() {
        return this.topicIdPartitions.toString();
    }
}

