/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.stacktrace.graph;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.JfrLoaderToolkit;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.graph.AggregatableFrame;
import org.openjdk.jmc.flightrecorder.stacktrace.graph.Edge;
import org.openjdk.jmc.flightrecorder.stacktrace.graph.GraphModelUtils;
import org.openjdk.jmc.flightrecorder.stacktrace.graph.Node;

public final class StacktraceGraphModel {
    private final FrameSeparator frameSeparator;
    private final IItemCollection items;
    private final IAttribute<IQuantity> attribute;
    private int totalTraceCount;
    private int totalEdgeCount;
    private int nodeCounter;
    private final Map<Integer, Set<Edge>> edges = new HashMap<Integer, Set<Edge>>(1024);
    private final Map<AggregatableFrame, Node> nodes = new HashMap<AggregatableFrame, Node>(1024);

    public StacktraceGraphModel(FrameSeparator frameSeparator, IItemCollection items, IAttribute<IQuantity> attribute) {
        this.frameSeparator = frameSeparator;
        this.items = items;
        this.attribute = attribute;
        this.buildModel(Collections.emptySet());
    }

    StacktraceGraphModel(StacktraceGraphModel model, Set<AggregatableFrame> keptNodes) {
        this.frameSeparator = model.frameSeparator;
        this.items = model.items;
        this.attribute = model.attribute;
        this.buildModel(keptNodes);
    }

    public Collection<Edge> getEdges() {
        return this.edges.values().stream().flatMap(c -> c.stream()).collect(Collectors.toSet());
    }

    public Collection<Node> getNodes() {
        return this.nodes.values();
    }

    public IAttribute<IQuantity> getAttribute() {
        return this.attribute;
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public IItemCollection getItems() {
        return this.items;
    }

    public int getTotalEdgeCount() {
        return this.totalEdgeCount;
    }

    public int getTotalTraceCount() {
        return this.totalTraceCount;
    }

    public int findNodeMinCount() {
        int minCount = Integer.MAX_VALUE;
        for (Node n : this.getNodes()) {
            minCount = Math.min(n.getCount(), minCount);
        }
        return minCount;
    }

    public int findNodeMaxCount() {
        int maxCount = 0;
        for (Node n : this.getNodes()) {
            maxCount = Math.max(n.getCount(), maxCount);
        }
        return maxCount;
    }

    public double findNodeMinWeight() {
        double minWeight = Double.MAX_VALUE;
        for (Node n : this.getNodes()) {
            minWeight = Math.min(n.getWeight(), minWeight);
        }
        return minWeight;
    }

    public double findNodeMaxWeight() {
        double maxWeight = 0.0;
        for (Node n : this.getNodes()) {
            maxWeight = Math.max(n.getWeight(), maxWeight);
        }
        return maxWeight;
    }

    public double findEdgeMinValue() {
        double minValue = Double.MAX_VALUE;
        for (Edge e : this.getEdges()) {
            minValue = Math.min(e.getValue(), minValue);
        }
        return minValue;
    }

    public double findEdgeMaxValue() {
        double maxValue = 0.0;
        for (Edge e : this.getEdges()) {
            maxValue = Math.max(e.getValue(), maxValue);
        }
        return maxValue;
    }

    public int findEdgeMinCount() {
        int minValue = Integer.MAX_VALUE;
        for (Edge e : this.getEdges()) {
            minValue = Math.min(e.getCount(), minValue);
        }
        return minValue;
    }

    public int findEdgeMaxCount() {
        int maxValue = 0;
        for (Edge e : this.getEdges()) {
            maxValue = Math.max(e.getCount(), maxValue);
        }
        return maxValue;
    }

    public String toString() {
        return String.format("=== StackTraceModel ===\nNode Count:%d\nEdge Count:%d\nNodes: %s\nEdges: %s\n========================", this.nodes.size(), this.edges.size(), this.nodes.toString(), this.edges.toString());
    }

    private void buildModel(Set<AggregatableFrame> keptNodes) {
        for (IItemIterable iterable : this.items) {
            IMemberAccessor<IMCStackTrace, IItem> stacktraceAccessor = StacktraceGraphModel.getAccessor(iterable, JfrAttributes.EVENT_STACKTRACE);
            if (stacktraceAccessor == null) continue;
            iterable.forEach(item -> this.addItem((IItem)item, stacktraceAccessor, StacktraceGraphModel.getAccessor(iterable, this.attribute), keptNodes));
        }
    }

    private static <T> IMemberAccessor<T, IItem> getAccessor(IItemIterable iterable, IAttribute<T> attr) {
        return attr != null ? iterable.getType().getAccessor(attr.getKey()) : null;
    }

    private void addItem(IItem item, IMemberAccessor<IMCStackTrace, IItem> stackTraceAccessor, IMemberAccessor<IQuantity, IItem> quantityAccessor, Set<AggregatableFrame> keptNodes) {
        AggregatableFrame firstFrame;
        IMCStackTrace stackTrace = (IMCStackTrace)stackTraceAccessor.getMember((Object)item);
        if (stackTrace == null) {
            return;
        }
        List frames = stackTrace.getFrames();
        if (frames.isEmpty()) {
            return;
        }
        double value = 1.0;
        if (quantityAccessor != null) {
            value = ((IQuantity)quantityAccessor.getMember((Object)item)).doubleValue();
        }
        if (this.keepFrame(keptNodes, firstFrame = new AggregatableFrame(this.frameSeparator, (IMCFrame)frames.get(0)))) {
            Node n = this.getOrCreateNode(firstFrame);
            ++this.totalTraceCount;
            ++n.count;
            n.weight += value;
            for (int i = frames.size() - 1; i > 0; --i) {
                AggregatableFrame currentFrame = new AggregatableFrame(this.frameSeparator, (IMCFrame)frames.get(i));
                AggregatableFrame nextFrame = new AggregatableFrame(this.frameSeparator, (IMCFrame)frames.get(i - 1));
                if (!this.keepFrame(keptNodes, currentFrame)) continue;
                Node currentNode = this.getOrCreateNode(currentFrame);
                ++currentNode.cumulativeCount;
                currentNode.cumulativeWeight += value;
                if (!this.keepFrame(keptNodes, nextFrame)) continue;
                Node nextNode = this.getOrCreateNode(nextFrame);
                ++nextNode.cumulativeCount;
                nextNode.cumulativeWeight += value;
                Edge e = this.getOrCreateLink(currentNode, nextNode, value);
                ++e.count;
                ++this.totalEdgeCount;
            }
        }
    }

    private boolean keepFrame(Set<AggregatableFrame> keptNodes, AggregatableFrame frame) {
        return keptNodes.isEmpty() || keptNodes.contains(frame);
    }

    private Node getOrCreateNode(AggregatableFrame frame) {
        Node n = this.nodes.get(frame);
        if (n == null) {
            n = new Node(this.nodeCounter++, frame);
            this.nodes.put(frame, n);
        }
        return n;
    }

    private Edge getOrCreateLink(Node fromNode, Node toNode, double value) {
        if (!this.edges.containsKey(fromNode.getNodeId())) {
            Edge edge = new Edge(fromNode, toNode, value);
            HashSet<Edge> newEdgeSet = new HashSet<Edge>();
            newEdgeSet.add(edge);
            this.edges.put(fromNode.getNodeId(), newEdgeSet);
            this.updateNodeEdges(fromNode, toNode, edge, value);
            return edge;
        }
        Set<Edge> toSet = this.edges.get(fromNode.getNodeId());
        for (Edge edge : toSet) {
            if (!edge.getTo().equals(toNode)) continue;
            return edge;
        }
        Edge edge = new Edge(fromNode, toNode, value);
        toSet.add(edge);
        this.updateNodeEdges(fromNode, toNode, edge, value);
        return edge;
    }

    private void updateNodeEdges(Node fromNode, Node toNode, Edge edge, double value) {
        Edge outEdge = fromNode.getOut().get(new Node.NodeWrapper(toNode.getNodeId(), toNode));
        if (outEdge != null) {
            outEdge.value += value;
        }
        fromNode.getOut().put(new Node.NodeWrapper(toNode.getNodeId(), toNode), edge);
        toNode.getIn().put(new Node.NodeWrapper(fromNode.getNodeId(), fromNode), edge);
    }

    public static void main(String[] args) throws IOException, CouldNotLoadRecordingException {
        IItemCollection items = JfrLoaderToolkit.loadEvents(new File(args[0]));
        IItemCollection filteredItems = items.apply(JdkFilters.EXECUTION_SAMPLE);
        FrameSeparator frameSeparator = new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false);
        StacktraceGraphModel model = new StacktraceGraphModel(frameSeparator, filteredItems, null);
        System.out.println(GraphModelUtils.printGraph(model));
    }
}

