# The Nu Html Checker (vnu)

With the Nu Html Checker (vnu), you can:

- [catch unintended mistakes in your HTML, CSS, and SVG][1]
- [batch-check documents from the command line][2] and from other scripts/apps
- [deploy your own instance of the vnu checker as a service][3] (like [validator.w3.org/nu][4])

   [1]: https://validator.w3.org/nu/about.html#why-validate
   [2]: #usage
   [3]: #standalone-web-server
   [4]: https://validator.w3.org/nu/

## Usage
You can run the vnu checker with one of the invocations from the [vnu manual page](docs/vnu.1.md). For example:

    java -jar ~/vnu.jar [OPTIONS]... FILES|DIRECTORY|URL...

The [OPTIONS section of the vnu manual page](docs/vnu.1.md#options) has details on all available options.

## Sources

The vnu source code is available on [GitHub][5], as are [instructions on how to build, test, and run the code][6].

   [5]: https://github.com/validator/validator
   [6]: #build-instructions

## Binaries and packages

The Nu Html Checker (vnu) is released upstream in these formats:

- pre-compiled Linux, Windows, and macOS binaries that include an embedded Java runtime
- `vnu.jar` — a portable version you can use on any system that has Java 11 or above installed
- `vnu.war` — for [deploying the vnu checker service through a servlet container such as Tomcat][11]

   [11]: #servlet-container

> [!NOTE]
> The `vnu.jar` and `vnu.war` files require you to have Java 11 or above installed. The pre-compiled Linux, Windows, and macOS binaries don’t require you to have any version of Java already installed at all.

A [Dockerfile][7] (see **[Pulling the Docker image][36]** below) and [npm][8], [pip][9], and [brew][10] packages are also available.

   [7]: https://ghcr.io/validator/validator
   [8]: https://www.npmjs.com/package/vnu-jar
   [9]: https://github.com/svenkreiss/html5validator
   [10]: https://formulae.brew.sh/formula/vnu
   [36]: #pulling-the-docker-image

You can [get the latest release][12] or run one of the following:

- [`docker run -it --rm -p 8888:8888 ghcr.io/validator/validator:latest`][13]
- [`npm install vnu-jar`][14]
- [`npm install --registry=https://npm.pkg.github.com @validator/vnu-jar`][15]
- [`brew install vnu`][16]
- [`pip install html5validator`][17]

…and see the **[Usage](#usage)** and **[Web-based checking](#web-based-checking)** sections here. Or automate your checking with a frontend such as:

   [12]: https://github.com/validator/validator/releases/tag/latest
   [13]: https://github.com/validator/validator/pkgs/container/validator
   [14]: https://www.npmjs.com/package/vnu-jar
   [15]: https://github.com/validator/validator/packages/892707
   [16]: https://libraries.io/homebrew/vnu
   [17]: https://github.com/svenkreiss/html5validator

- [Grunt plugin for HTML validation][18] or [Gulp plugin for HTML validation][19] or [Maven plugin for HTML validation][20]
- [html5validator `pip` package][21] (for integration in Travis CI, CircleCI, CodeShip, Jekyll, Pelican, etc.)
- [LMVTFY: Let Me Validate That For You][22] (auto-check JSFiddle/JSBin, etc., links in GitHub issue comments)

   [18]: https://github.com/validator/grunt-html
   [19]: https://github.com/validator/gulp-html
   [20]: https://github.com/validator/maven-plugin
   [21]: https://github.com/svenkreiss/html5validator
   [22]: https://github.com/cvrebert/lmvtfy/

