/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.row.RowMetaInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowSet
implements Comparable<RowSet> {
    public static final int ERR_NO_ERROR = 0;
    public static final int ERR_ROW_IS_BUSY = 1;
    private RowMetaInterface rowMeta;
    private BlockingQueue<Object[]> queArray;
    private AtomicBoolean done;
    private String originStepName;
    private AtomicInteger originStepCopy;
    private String destinationStepName;
    private AtomicInteger destinationStepCopy;
    private String remoteSlaveServerName;

    public RowSet(int maxSize) {
        this.queArray = new ArrayBlockingQueue<Object[]>(maxSize, false);
        this.done = new AtomicBoolean(false);
        this.originStepCopy = new AtomicInteger(0);
        this.destinationStepCopy = new AtomicInteger(0);
    }

    @Override
    public int compareTo(RowSet rowSet) {
        String target = this.remoteSlaveServerName + "." + this.destinationStepName + "." + this.destinationStepCopy.intValue();
        String comp = rowSet.remoteSlaveServerName + "." + rowSet.destinationStepName + "." + rowSet.destinationStepCopy.intValue();
        return target.compareTo(comp);
    }

    public boolean equals(RowSet rowSet) {
        return this.compareTo(rowSet) == 0;
    }

    public boolean putRow(RowMetaInterface rowMeta, Object[] rowData) {
        return this.putRowWait(rowMeta, rowData, 50L, TimeUnit.MILLISECONDS);
    }

    public boolean putRowImmediate(RowMetaInterface rowMeta, Object[] rowData) {
        this.rowMeta = rowMeta;
        try {
            return this.queArray.offer(rowData);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public boolean putRowWait(RowMetaInterface rowMeta, Object[] rowData, long time, TimeUnit tu) {
        this.rowMeta = rowMeta;
        try {
            return this.queArray.offer(rowData, time, tu);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public Object[] getRow() {
        return this.getRowWait(50L, TimeUnit.MILLISECONDS);
    }

    public Object[] getRowImmediate() {
        return (Object[])this.queArray.poll();
    }

    public Object[] getRowWait(long timeout, TimeUnit tu) {
        try {
            return this.queArray.poll(timeout, tu);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public Object[] getRowUnitlSuccess() {
        try {
            return this.queArray.take();
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public void setDone() {
        this.done.set(true);
    }

    public boolean isDone() {
        return this.done.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOriginStepName() {
        String string = this.originStepName;
        synchronized (string) {
            return this.originStepName;
        }
    }

    public int getOriginStepCopy() {
        return this.originStepCopy.get();
    }

    public String getDestinationStepName() {
        return this.destinationStepName;
    }

    public int getDestinationStepCopy() {
        return this.destinationStepCopy.get();
    }

    public String getName() {
        return this.toString();
    }

    public int size() {
        return this.queArray.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadNameFromToCopy(String from, int from_copy, String to, int to_copy) {
        String string;
        if (this.originStepName == null) {
            this.originStepName = from;
        } else {
            string = this.originStepName;
            synchronized (string) {
                this.originStepName = from;
            }
        }
        this.originStepCopy.set(from_copy);
        if (this.destinationStepName == null) {
            this.destinationStepName = to;
        } else {
            string = this.destinationStepName;
            synchronized (string) {
                this.destinationStepName = to;
            }
        }
        this.destinationStepCopy.set(to_copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer str;
        Object object = this.originStepName;
        synchronized (object) {
            str = new StringBuffer(this.originStepName);
        }
        str.append(".");
        object = this.originStepCopy;
        synchronized (object) {
            str.append(this.originStepCopy);
        }
        str.append(" - ");
        object = this.destinationStepName;
        synchronized (object) {
            str.append(this.destinationStepName);
        }
        str.append(".");
        object = this.destinationStepCopy;
        synchronized (object) {
            str.append(this.destinationStepCopy);
        }
        if (!Const.isEmpty(this.remoteSlaveServerName)) {
            object = this.remoteSlaveServerName;
            synchronized (object) {
                str.append(" (");
                str.append(this.remoteSlaveServerName);
                str.append(")");
            }
        }
        return str.toString();
    }

    public RowMetaInterface getRowMeta() {
        return this.rowMeta;
    }

    public void setRowMeta(RowMetaInterface rowMeta) {
        this.rowMeta = rowMeta;
    }

    public String getRemoteSlaveServerName() {
        return this.remoteSlaveServerName;
    }

    public void setRemoteSlaveServerName(String remoteSlaveServerName) {
        this.remoteSlaveServerName = remoteSlaveServerName;
    }
}

