/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.util.FS;

public class NetRC {
    static final Pattern NETRC = Pattern.compile("(\\S+)");
    static final String DEFAULT_ENTRY = "default";
    private File netrc;
    private Instant lastModified;
    private Map<String, NetRCEntry> hosts = new HashMap<String, NetRCEntry>();
    private static final TreeMap<String, State> STATE = new TreeMap<String, State>(){
        private static final long serialVersionUID = -4285910831814853334L;
        {
            this.put("machine", State.MACHINE);
            this.put("login", State.LOGIN);
            this.put("password", State.PASSWORD);
            this.put(NetRC.DEFAULT_ENTRY, State.DEFAULT);
            this.put("account", State.ACCOUNT);
            this.put("macdef", State.MACDEF);
        }
    };

    public NetRC() {
        this.netrc = NetRC.getDefaultFile();
        if (this.netrc != null) {
            this.parse();
        }
    }

    public NetRC(File netrc) {
        this.netrc = netrc;
        this.parse();
    }

    private static File getDefaultFile() {
        File home = FS.DETECTED.userHome();
        File netrc = new File(home, ".netrc");
        if (netrc.exists()) {
            return netrc;
        }
        netrc = new File(home, "_netrc");
        if (netrc.exists()) {
            return netrc;
        }
        return null;
    }

    public NetRCEntry getEntry(String host) {
        NetRCEntry entry;
        if (this.netrc == null) {
            return null;
        }
        if (!this.lastModified.equals(FS.DETECTED.lastModifiedInstant(this.netrc))) {
            this.parse();
        }
        if ((entry = this.hosts.get(host)) == null) {
            entry = this.hosts.get(DEFAULT_ENTRY);
        }
        return entry;
    }

    public Collection<NetRCEntry> getEntries() {
        return this.hosts.values();
    }

    private void parse() {
        this.hosts.clear();
        this.lastModified = FS.DETECTED.lastModifiedInstant(this.netrc);
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.netrc), StandardCharsets.UTF_8));){
                String line = null;
                NetRCEntry entry = new NetRCEntry();
                State state = State.COMMAND;
                String macbody = "";
                Matcher matcher = NETRC.matcher("");
                while ((line = r.readLine()) != null) {
                    if (entry.macdef != null && entry.macbody == null) {
                        if (line.length() == 0) {
                            entry.macbody = macbody;
                            macbody = "";
                            continue;
                        }
                        macbody = String.valueOf(macbody) + line + "\n";
                        continue;
                    }
                    matcher.reset(line);
                    while (matcher.find()) {
                        String command = matcher.group().toLowerCase(Locale.ROOT);
                        if (command.startsWith("#")) {
                            matcher.reset("");
                            continue;
                        }
                        state = STATE.get(command);
                        if (state == null) {
                            state = State.COMMAND;
                        }
                        switch (state) {
                            case COMMAND: {
                                break;
                            }
                            case ACCOUNT: {
                                if (entry.account != null && entry.complete()) {
                                    this.hosts.put(entry.machine, entry);
                                    entry = new NetRCEntry();
                                }
                                if (matcher.find()) {
                                    entry.account = matcher.group();
                                }
                                state = State.COMMAND;
                                break;
                            }
                            case LOGIN: {
                                if (entry.login != null && entry.complete()) {
                                    this.hosts.put(entry.machine, entry);
                                    entry = new NetRCEntry();
                                }
                                if (matcher.find()) {
                                    entry.login = matcher.group();
                                }
                                state = State.COMMAND;
                                break;
                            }
                            case PASSWORD: {
                                if (entry.password != null && entry.complete()) {
                                    this.hosts.put(entry.machine, entry);
                                    entry = new NetRCEntry();
                                }
                                if (matcher.find()) {
                                    entry.password = matcher.group().toCharArray();
                                }
                                state = State.COMMAND;
                                break;
                            }
                            case DEFAULT: {
                                if (entry.machine != null && entry.complete()) {
                                    this.hosts.put(entry.machine, entry);
                                    entry = new NetRCEntry();
                                }
                                entry.machine = DEFAULT_ENTRY;
                                state = State.COMMAND;
                                break;
                            }
                            case MACDEF: {
                                if (entry.macdef != null && entry.complete()) {
                                    this.hosts.put(entry.machine, entry);
                                    entry = new NetRCEntry();
                                }
                                if (matcher.find()) {
                                    entry.macdef = matcher.group();
                                }
                                state = State.COMMAND;
                                break;
                            }
                            case MACHINE: {
                                if (entry.machine != null && entry.complete()) {
                                    this.hosts.put(entry.machine, entry);
                                    entry = new NetRCEntry();
                                }
                                if (matcher.find()) {
                                    entry.machine = matcher.group();
                                }
                                state = State.COMMAND;
                            }
                        }
                    }
                }
                if (entry.macdef != null && entry.macbody == null) {
                    entry.macbody = macbody;
                }
                if (entry.complete()) {
                    this.hosts.put(entry.machine, entry);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class NetRCEntry {
        public String login;
        public char[] password;
        public String machine;
        public String account;
        public String macdef;
        public String macbody;

        boolean complete() {
            return this.login != null && this.password != null && this.machine != null;
        }
    }

    static enum State {
        COMMAND,
        MACHINE,
        LOGIN,
        PASSWORD,
        DEFAULT,
        ACCOUNT,
        MACDEF;

    }
}

