open GtkSignal
open Gobject
open Data
let set = set
let get = get
let param = param

open GtkPackProps

open GtkPackProps

class virtual paned_props = object
  val virtual obj : _ obj
  method set_position = set Paned.P.position obj
  method position = get Paned.P.position obj
  method max_position = get Paned.P.max_position obj
  method min_position = get Paned.P.min_position obj
end

class virtual paned_notify obj = object (self)
  val obj : 'a obj = obj
  method private notify : 'b. ('a, 'b) property ->
    callback:('b -> unit) -> _ =
  fun prop ~callback -> GtkSignal.connect_property obj
    ~prop ~callback
  method position = self#notify Paned.P.position
  method max_position = self#notify Paned.P.max_position
  method min_position = self#notify Paned.P.min_position
end

class virtual notebook_props = object
  val virtual obj : _ obj
  method set_enable_popup = set Notebook.P.enable_popup obj
  method set_homogeneous_tabs = set Notebook.P.homogeneous obj
  method set_scrollable = set Notebook.P.scrollable obj
  method set_show_border = set Notebook.P.show_border obj
  method set_show_tabs = set Notebook.P.show_tabs obj
  method set_tab_border = set Notebook.P.tab_border obj
  method set_tab_hborder = set Notebook.P.tab_hborder obj
  method set_tab_pos = set Notebook.P.tab_pos obj
  method set_tab_vborder = set Notebook.P.tab_vborder obj
  method enable_popup = get Notebook.P.enable_popup obj
  method homogeneous_tabs = get Notebook.P.homogeneous obj
  method scrollable = get Notebook.P.scrollable obj
  method show_border = get Notebook.P.show_border obj
  method show_tabs = get Notebook.P.show_tabs obj
  method tab_hborder = get Notebook.P.tab_hborder obj
  method tab_pos = get Notebook.P.tab_pos obj
  method tab_vborder = get Notebook.P.tab_vborder obj
end

class virtual notebook_notify obj = object (self)
  val obj : 'a obj = obj
  method private notify : 'b. ('a, 'b) property ->
    callback:('b -> unit) -> _ =
  fun prop ~callback -> GtkSignal.connect_property obj
    ~prop ~callback
  method enable_popup = self#notify Notebook.P.enable_popup
  method homogeneous_tabs = self#notify Notebook.P.homogeneous
  method scrollable = self#notify Notebook.P.scrollable
  method show_border = self#notify Notebook.P.show_border
  method show_tabs = self#notify Notebook.P.show_tabs
  method tab_hborder = self#notify Notebook.P.tab_hborder
  method tab_pos = self#notify Notebook.P.tab_pos
  method tab_vborder = self#notify Notebook.P.tab_vborder
end

class virtual notebook_sigs = object (self)
  method private virtual connect :
    'b. ('a,'b) GtkSignal.t -> callback:'b -> GtkSignal.id
  method private virtual notify :
    'b. ('a,'b) property -> callback:('b -> unit) -> GtkSignal.id
  method select_page = self#connect Notebook.S.select_page
  method reorder_tab = self#connect Notebook.S.reorder_tab
  method change_current_page = self#connect Notebook.S.change_current_page
  method move_focus_out = self#connect Notebook.S.move_focus_out
  method page_added = self#connect
    {Notebook.S.page_added with marshaller = fun f ->
     marshal2 GObj.conv_widget uint "GtkNotebook::page_added" f}
  method page_removed = self#connect
    {Notebook.S.page_removed with marshaller = fun f ->
     marshal2 GObj.conv_widget uint "GtkNotebook::page_removed" f}
  method page_reordered = self#connect
    {Notebook.S.page_reordered with marshaller = fun f ->
     marshal2 GObj.conv_widget uint "GtkNotebook::page_reordered" f}
  method create_window = self#connect
    {Notebook.S.create_window with marshaller = fun f ->
     marshal3 GObj.conv_widget int int "GtkNotebook::create_window"
       (fun x1 x2 x3 -> f ~page:x1 ~x:x2 ~y:x3)}
  method notify_enable_popup ~callback =
    self#notify Notebook.P.enable_popup ~callback
  method notify_homogeneous_tabs ~callback =
    self#notify Notebook.P.homogeneous ~callback
  method notify_scrollable ~callback =
    self#notify Notebook.P.scrollable ~callback
  method notify_show_border ~callback =
    self#notify Notebook.P.show_border ~callback
  method notify_show_tabs ~callback =
    self#notify Notebook.P.show_tabs ~callback
  method notify_tab_hborder ~callback =
    self#notify Notebook.P.tab_hborder ~callback
  method notify_tab_pos ~callback = self#notify Notebook.P.tab_pos ~callback
  method notify_tab_vborder ~callback =
    self#notify Notebook.P.tab_vborder ~callback
end

class virtual table_props = object
  val virtual obj : _ obj
  method set_columns = set Table.P.n_columns obj
  method set_rows = set Table.P.n_rows obj
  method set_homogeneous = set Table.P.homogeneous obj
  method set_row_spacings = set Table.P.row_spacing obj
  method set_col_spacings = set Table.P.column_spacing obj
  method columns = get Table.P.n_columns obj
  method rows = get Table.P.n_rows obj
  method homogeneous = get Table.P.homogeneous obj
  method row_spacings = get Table.P.row_spacing obj
  method col_spacings = get Table.P.column_spacing obj
end

class virtual table_notify obj = object (self)
  val obj : 'a obj = obj
  method private notify : 'b. ('a, 'b) property ->
    callback:('b -> unit) -> _ =
  fun prop ~callback -> GtkSignal.connect_property obj
    ~prop ~callback
  method columns = self#notify Table.P.n_columns
  method rows = self#notify Table.P.n_rows
  method homogeneous = self#notify Table.P.homogeneous
  method row_spacings = self#notify Table.P.row_spacing
  method col_spacings = self#notify Table.P.column_spacing
end

