/*
 * Decompiled with CFR 0.152.
 */
package lucee.runtime.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import lucee.commons.io.res.Resource;
import lucee.loader.engine.CFMLEngine;
import lucee.loader.engine.CFMLEngineFactory;
import lucee.loader.util.Util;
import lucee.runtime.PageContext;
import lucee.runtime.exp.PageException;
import lucee.runtime.type.Struct;
import lucee.runtime.util.IO;
import lucee.runtime.util.XMLUtil;
import lucee.runtime.util.XMLValidator;
import org.ccil.cowan.tagsoup.Parser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public final class XMLUtilImpl
implements XMLUtil {
    public static final String NON_VALIDATING_DTD_GRAMMAR = "http://apache.org/xml/features/nonvalidating/load-dtd-grammar";
    public static final String NON_VALIDATING_DTD_EXTERNAL = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    public static final String VALIDATION_SCHEMA = "http://apache.org/xml/features/validation/schema";
    public static final String VALIDATION_SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    public static final short UNDEFINED_NODE = -1;
    private static DocumentBuilder docBuilder;
    private static TransformerFactory transformerFactory;

    @Override
    public String unescapeXMLString(String str) {
        StringBuilder rtn = new StringBuilder();
        int posStart = -1;
        int posFinish = -1;
        while ((posStart = str.indexOf(38, posStart)) != -1) {
            int last = posFinish + 1;
            posFinish = str.indexOf(59, posStart);
            if (posFinish == -1) break;
            rtn.append(str.substring(last, posStart));
            if (posStart + 1 < posFinish) {
                rtn.append(XMLUtilImpl.unescapeXMLEntity(str.substring(posStart + 1, posFinish)));
            } else {
                rtn.append("&;");
            }
            posStart = posFinish + 1;
        }
        rtn.append(str.substring(posFinish + 1));
        return rtn.toString();
    }

    private static String unescapeXMLEntity(String str) {
        if ("lt".equals(str)) {
            return "<";
        }
        if ("gt".equals(str)) {
            return ">";
        }
        if ("amp".equals(str)) {
            return "&";
        }
        if ("apos".equals(str)) {
            return "'";
        }
        if ("quot".equals(str)) {
            return "\"";
        }
        return "&" + str + ";";
    }

    @Override
    public String escapeXMLString(String xmlStr) {
        StringBuffer sb = new StringBuffer();
        int len = xmlStr.length();
        for (int i = 0; i < len; ++i) {
            char c = xmlStr.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public TransformerFactory getTransformerFactory() {
        return XMLUtilImpl.transformerFactory();
    }

    public static TransformerFactory transformerFactory() {
        if (transformerFactory == null) {
            try {
                Class<?> clazz = CFMLEngineFactory.getInstance().getClassUtil().loadClass("lucee.runtime.text.xml.XMLUtil");
                transformerFactory = (TransformerFactory)clazz.getMethod("getTransformerFactory", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                transformerFactory = TransformerFactory.newInstance();
            }
        }
        return transformerFactory;
    }

    @Override
    public final Document parse(InputSource xml, InputSource validator, boolean isHtml) throws SAXException, IOException {
        if (!isHtml) {
            DocumentBuilderFactory factory = this.newDocumentBuilderFactory();
            if (validator == null) {
                XMLUtilImpl.setAttributeEL(factory, NON_VALIDATING_DTD_EXTERNAL, Boolean.FALSE);
                XMLUtilImpl.setAttributeEL(factory, NON_VALIDATING_DTD_GRAMMAR, Boolean.FALSE);
            } else {
                XMLUtilImpl.setAttributeEL(factory, VALIDATION_SCHEMA, Boolean.TRUE);
                XMLUtilImpl.setAttributeEL(factory, VALIDATION_SCHEMA_FULL_CHECKING, Boolean.TRUE);
            }
            factory.setNamespaceAware(true);
            factory.setValidating(validator != null);
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setEntityResolver(new XMLEntityResolverDefaultHandler(validator));
                builder.setErrorHandler(new ThrowingErrorHandler(true, true, false));
                return builder.parse(xml);
            }
            catch (ParserConfigurationException e) {
                throw new SAXException(e);
            }
        }
        Parser reader = new Parser();
        reader.setFeature("http://xml.org/sax/features/namespaces", true);
        reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMResult result = new DOMResult();
            transformer.transform(new SAXSource((XMLReader)reader, xml), result);
            return this.getDocument(result.getNode());
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    private DocumentBuilderFactory newDocumentBuilderFactory() {
        return DocumentBuilderFactory.newInstance();
    }

    private static void setAttributeEL(DocumentBuilderFactory factory, String name, Object value) {
        try {
            factory.setAttribute(name, value);
        }
        catch (Throwable t) {
            Util.rethrowIfNecessary(t);
        }
    }

    @Override
    public void replaceChild(Node newChild, Node oldChild) {
        Node nc = newChild;
        Node oc = oldChild;
        Node p = oc.getParentNode();
        if (nc != oc) {
            p.replaceChild(nc, oc);
        }
    }

    @Override
    public boolean nameEqual(Node node, String name) {
        if (name == null) {
            return false;
        }
        return name.equals(node.getNodeName()) || name.equals(node.getLocalName());
    }

    @Override
    public Element getRootElement(Node node) {
        Document doc = null;
        doc = node instanceof Document ? (Document)node : node.getOwnerDocument();
        return doc.getDocumentElement();
    }

    @Override
    public Document newDocument() throws ParserConfigurationException, FactoryConfigurationError {
        if (docBuilder == null) {
            docBuilder = this.newDocumentBuilderFactory().newDocumentBuilder();
        }
        return docBuilder.newDocument();
    }

    @Override
    public Document getDocument(NodeList nodeList) throws PageException {
        if (nodeList instanceof Document) {
            return (Document)((Object)nodeList);
        }
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodeList.item(i);
            if (node == null) continue;
            return node.getOwnerDocument();
        }
        throw CFMLEngineFactory.getInstance().getExceptionUtil().createXMLException("can't get Document from NodeList, in NoteList are no Nodes");
    }

    @Override
    public Document getDocument(Node node) {
        if (node instanceof Document) {
            return (Document)node;
        }
        return node.getOwnerDocument();
    }

    @Override
    public synchronized ArrayList<Node> getChildNodes(Node node, short type, String filter) {
        ArrayList<Node> rtn = new ArrayList<Node>();
        NodeList nodes = node.getChildNodes();
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            try {
                Node n = nodes.item(i);
                if (n == null || type != -1 && n.getNodeType() != type || filter != null && !filter.equals(n.getLocalName())) continue;
                rtn.add(n);
                continue;
            }
            catch (Throwable t) {
                Util.rethrowIfNecessary(t);
            }
        }
        return rtn;
    }

    public synchronized List<Node> getChildNodesAsList(Node node, short type, String filter) {
        ArrayList<Node> rtn = new ArrayList<Node>();
        NodeList nodes = node.getChildNodes();
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            try {
                Node n = nodes.item(i);
                if (n == null || n.getNodeType() != type && type != -1 || filter != null && !filter.equals(n.getLocalName())) continue;
                rtn.add(n);
                continue;
            }
            catch (Throwable t) {
                Util.rethrowIfNecessary(t);
            }
        }
        return rtn;
    }

    @Override
    public synchronized Node getChildNode(Node node, short type, String filter, int index) {
        NodeList nodes = node.getChildNodes();
        int len = nodes.getLength();
        int count = 0;
        for (int i = 0; i < len; ++i) {
            try {
                Node n = nodes.item(i);
                if (n == null || type != -1 && n.getNodeType() != type || filter != null && !filter.equals(n.getLocalName())) continue;
                if (count == index) {
                    return n;
                }
                ++count;
                continue;
            }
            catch (Throwable t) {
                Util.rethrowIfNecessary(t);
            }
        }
        return null;
    }

    public Node[] getChildNodesAsArray(Node node, short type) {
        ArrayList<Node> nodeList = this.getChildNodes(node, type, null);
        return nodeList.toArray(new Node[nodeList.size()]);
    }

    public Node[] getChildNodesAsArray(Node node, short type, String filter) {
        ArrayList<Node> nodeList = this.getChildNodes(node, type, filter);
        return nodeList.toArray(new Node[nodeList.size()]);
    }

    public Element[] getChildElementsAsArray(Node node) {
        ArrayList<Node> nodeList = this.getChildNodes(node, (short)1, null);
        return nodeList.toArray(new Element[nodeList.size()]);
    }

    @Override
    public String transform(InputSource xml, InputSource xsl, Map<String, Object> parameters) throws TransformerException, SAXException, IOException {
        return this.transform(this.parse(xml, null, false), xsl, parameters);
    }

    @Override
    public String transform(Document doc, InputSource xsl, Map<String, Object> parameters) throws TransformerException {
        StringWriter sw = new StringWriter();
        TransformerFactory factory = this.getTransformerFactory();
        factory.setErrorListener(SimpleErrorListener.THROW_FATAL);
        Transformer transformer = factory.newTransformer(new StreamSource(xsl.getCharacterStream()));
        if (parameters != null) {
            for (Map.Entry<String, Object> e : parameters.entrySet()) {
                transformer.setParameter(e.getKey().toString(), e.getValue());
            }
        }
        transformer.transform(new DOMSource(doc), new StreamResult(sw));
        return sw.toString();
    }

    public String getTypeAsString(Node node, boolean cftype) {
        String suffix = cftype ? "" : "_NODE";
        switch (node.getNodeType()) {
            case 2: {
                return "ATTRIBUTE" + suffix;
            }
            case 4: {
                return "CDATA_SECTION" + suffix;
            }
            case 8: {
                return "COMMENT" + suffix;
            }
            case 11: {
                return "DOCUMENT_FRAGMENT" + suffix;
            }
            case 9: {
                return "DOCUMENT" + suffix;
            }
            case 10: {
                return "DOCUMENT_TYPE" + suffix;
            }
            case 1: {
                return "ELEMENT" + suffix;
            }
            case 6: {
                return "ENTITY" + suffix;
            }
            case 5: {
                return "ENTITY_REFERENCE" + suffix;
            }
            case 12: {
                return "NOTATION" + suffix;
            }
            case 7: {
                return "PROCESSING_INSTRUCTION" + suffix;
            }
            case 3: {
                return "TEXT" + suffix;
            }
        }
        return "UNKNOW" + suffix;
    }

    @Override
    public synchronized Element getChildWithName(String name, Element el) {
        Element[] children = this.getChildElementsAsArray(el);
        for (int i = 0; i < children.length; ++i) {
            if (!name.equalsIgnoreCase(children[i].getNodeName())) continue;
            return children[i];
        }
        return null;
    }

    @Override
    public InputSource toInputSource(Resource res, Charset cs) throws IOException {
        String str = CFMLEngineFactory.getInstance().getIOUtil().toString(res, cs);
        return new InputSource(new StringReader(str));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputSource toInputSource(PageContext pc, Object value) throws IOException, PageException {
        if (value instanceof InputSource) {
            return (InputSource)value;
        }
        if (value instanceof String) {
            return this.toInputSource(pc, (String)value);
        }
        if (value instanceof StringBuffer) {
            return this.toInputSource(pc, value.toString());
        }
        CFMLEngine engine = CFMLEngineFactory.getInstance();
        IO io = engine.getIOUtil();
        if (value instanceof Resource) {
            String str = io.toString((Resource)value, (Charset)null);
            return new InputSource(new StringReader(str));
        }
        if (value instanceof File) {
            String str = io.toString(engine.getCastUtil().toResource(value), (Charset)null);
            return new InputSource(new StringReader(str));
        }
        if (value instanceof InputStream) {
            InputStream is = (InputStream)value;
            try {
                String str = io.toString(is, (Charset)null);
                InputSource inputSource = new InputSource(new StringReader(str));
                return inputSource;
            }
            finally {
                io.closeSilent(is);
            }
        }
        if (value instanceof Reader) {
            Reader reader = (Reader)value;
            try {
                String str = io.toString(reader);
                InputSource inputSource = new InputSource(new StringReader(str));
                return inputSource;
            }
            finally {
                io.closeSilent(reader);
            }
        }
        if (value instanceof byte[]) {
            return new InputSource(new ByteArrayInputStream((byte[])value));
        }
        throw engine.getExceptionUtil().createXMLException("can't cast object of type [" + value + "] to an Input for xml parser");
    }

    public InputSource toInputSource(PageContext pc, String xml) throws IOException, PageException {
        return this.toInputSource(pc, xml, true);
    }

    public InputSource toInputSource(PageContext pc, String xml, boolean canBePath) throws IOException, PageException {
        xml = xml.trim();
        if (!canBePath || xml.startsWith("<")) {
            return new InputSource(new StringReader(xml));
        }
        if (pc == null) {
            pc = CFMLEngineFactory.getInstance().getThreadPageContext();
        }
        Resource res = CFMLEngineFactory.getInstance().getResourceUtil().toResourceExisting(pc, xml);
        return this.toInputSource(pc, res);
    }

    @Override
    public Struct validate(InputSource xml, InputSource schema, String strSchema) throws PageException {
        return new XMLValidator(schema, strSchema).validate(xml);
    }

    @Override
    public void prependChild(Element parent, Element child) {
        Node first = parent.getFirstChild();
        if (first == null) {
            parent.appendChild(child);
        } else {
            parent.insertBefore(child, first);
        }
    }

    @Override
    public void setFirst(Node parent, Node node) {
        Node first = parent.getFirstChild();
        if (first != null) {
            parent.insertBefore(node, first);
        } else {
            parent.appendChild(node);
        }
    }

    public XMLReader createXMLReader(String oprionalDefaultSaxParser) throws SAXException {
        try {
            return XMLReaderFactory.createXMLReader(oprionalDefaultSaxParser);
        }
        catch (Throwable t) {
            Util.rethrowIfNecessary(t);
            return XMLReaderFactory.createXMLReader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputSource toInputSource(Object value) throws IOException, PageException {
        if (value instanceof InputSource) {
            return (InputSource)value;
        }
        if (value instanceof String) {
            return this.toInputSource(CFMLEngineFactory.getInstance().getThreadPageContext(), (String)value, true);
        }
        if (value instanceof StringBuffer) {
            return this.toInputSource(CFMLEngineFactory.getInstance().getThreadPageContext(), value.toString(), true);
        }
        if (value instanceof Resource) {
            IO io = CFMLEngineFactory.getInstance().getIOUtil();
            String str = io.toString((Resource)value, (Charset)null);
            return new InputSource(new StringReader(str));
        }
        if (value instanceof File) {
            CFMLEngine e = CFMLEngineFactory.getInstance();
            String str = e.getIOUtil().toString(e.getCastUtil().toResource(value), (Charset)null);
            return new InputSource(new StringReader(str));
        }
        if (value instanceof InputStream) {
            InputStream is = (InputStream)value;
            IO io = CFMLEngineFactory.getInstance().getIOUtil();
            try {
                String str = io.toString(is, (Charset)null);
                InputSource inputSource = new InputSource(new StringReader(str));
                return inputSource;
            }
            finally {
                io.closeSilent(is);
            }
        }
        if (value instanceof Reader) {
            Reader reader = (Reader)value;
            IO io = CFMLEngineFactory.getInstance().getIOUtil();
            try {
                String str = io.toString(reader);
                InputSource inputSource = new InputSource(new StringReader(str));
                return inputSource;
            }
            finally {
                io.closeSilent(reader);
            }
        }
        if (value instanceof byte[]) {
            return new InputSource(new ByteArrayInputStream((byte[])value));
        }
        throw CFMLEngineFactory.getInstance().getExceptionUtil().createExpressionException("can't cast object of type [" + value + "] to an Input for xml parser");
    }

    @Override
    public void writeTo(Node node, Resource file) throws PageException {
        BufferedOutputStream os = null;
        CFMLEngine e = CFMLEngineFactory.getInstance();
        IO io = e.getIOUtil();
        try {
            os = io.toBufferedOutputStream(file.getOutputStream());
            this.writeTo(node, new StreamResult(os), false, false, null, null, null);
        }
        catch (IOException ioe) {
            throw e.getCastUtil().toPageException(ioe);
        }
        finally {
            e.getIOUtil().closeSilent(os);
        }
    }

    @Override
    public void writeTo(Node node, Result res, boolean omitXMLDecl, boolean indent, String publicId, String systemId, String encoding) throws PageException {
        try {
            Transformer t = this.getTransformerFactory().newTransformer();
            t.setOutputProperty("indent", indent ? "yes" : "no");
            t.setOutputProperty("omit-xml-declaration", omitXMLDecl ? "yes" : "no");
            if (!Util.isEmpty(publicId, true)) {
                t.setOutputProperty("doctype-public", publicId);
            }
            if (!Util.isEmpty(systemId, true)) {
                t.setOutputProperty("doctype-system", systemId);
            }
            if (!Util.isEmpty(encoding, true)) {
                t.setOutputProperty("encoding", encoding);
            }
            t.transform(new DOMSource(node), res);
        }
        catch (Exception e) {
            throw CFMLEngineFactory.getInstance().getCastUtil().toPageException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString(Node node, boolean omitXMLDecl, boolean indent, String publicId, String systemId, String encoding) throws PageException {
        StringWriter sw = new StringWriter();
        try {
            this.writeTo(node, new StreamResult(sw), omitXMLDecl, indent, publicId, systemId, encoding);
        }
        finally {
            CFMLEngineFactory.getInstance().getIOUtil().closeSilent(sw);
        }
        return sw.getBuffer().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString(NodeList nodes, boolean omitXMLDecl, boolean indent) throws PageException {
        StringWriter sw = new StringWriter();
        try {
            int len = nodes.getLength();
            for (int i = 0; i < len; ++i) {
                this.writeTo(nodes.item(i), new StreamResult(sw), omitXMLDecl, indent, null, null, null);
            }
        }
        finally {
            Util.closeEL(sw);
        }
        return sw.getBuffer().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString(Node node, String defaultValue) {
        StringWriter sw = new StringWriter();
        try {
            this.writeTo(node, new StreamResult(sw), false, false, null, null, null);
        }
        catch (Throwable t) {
            Util.rethrowIfNecessary(t);
            String string = defaultValue;
            return string;
        }
        finally {
            Util.closeEL(sw);
        }
        return sw.getBuffer().toString();
    }

    @Override
    public Node toNode(Object value) throws PageException {
        if (value instanceof Node) {
            return (Node)value;
        }
        try {
            return this.parse(this.toInputSource(CFMLEngineFactory.getInstance().getThreadPageContext(), value), null, false);
        }
        catch (Exception outer) {
            throw CFMLEngineFactory.getInstance().getCastUtil().toPageException(outer);
        }
    }

    @Override
    public Document createDocument(Resource res, boolean isHTML) throws PageException {
        Document document;
        InputStream is = null;
        try {
            is = res.getInputStream();
            document = this.parse(new InputSource(is), null, isHTML);
        }
        catch (Exception e) {
            try {
                throw CFMLEngineFactory.getInstance().getCastUtil().toPageException(e);
            }
            catch (Throwable throwable) {
                Util.closeEL(is);
                throw throwable;
            }
        }
        Util.closeEL(is);
        return document;
    }

    @Override
    public Document createDocument(String xml, boolean isHTML) throws PageException {
        try {
            return this.parse(this.toInputSource(null, xml), null, isHTML);
        }
        catch (Exception e) {
            throw CFMLEngineFactory.getInstance().getCastUtil().toPageException(e);
        }
    }

    @Override
    public Document createDocument(InputStream is, boolean isHTML) throws PageException {
        try {
            return this.parse(new InputSource(is), null, isHTML);
        }
        catch (Exception e) {
            throw CFMLEngineFactory.getInstance().getCastUtil().toPageException(e);
        }
    }

    static class XMLEntityResolverDefaultHandler
    extends DefaultHandler {
        private InputSource entityRes;

        public XMLEntityResolverDefaultHandler(InputSource entityRes) {
            this.entityRes = entityRes;
        }

        @Override
        public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
            if (this.entityRes != null) {
                return this.entityRes;
            }
            try {
                CFMLEngine engine = CFMLEngineFactory.getInstance();
                return new InputSource(engine.getIOUtil().toBufferedInputStream(engine.getHTTPUtil().toURL(systemID).openStream()));
            }
            catch (Throwable t) {
                Util.rethrowIfNecessary(t);
                return null;
            }
        }
    }

    static class ThrowingErrorHandler
    implements ErrorHandler {
        private boolean throwFatalError;
        private boolean throwError;
        private boolean throwWarning;

        public ThrowingErrorHandler(boolean throwFatalError, boolean throwError, boolean throwWarning) {
            this.throwFatalError = throwFatalError;
            this.throwError = throwError;
            this.throwWarning = throwWarning;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            if (this.throwError) {
                throw new SAXException(e);
            }
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            if (this.throwFatalError) {
                throw new SAXException(e);
            }
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            if (this.throwWarning) {
                throw new SAXException(e);
            }
        }
    }

    static class SimpleErrorListener
    implements ErrorListener {
        public static final ErrorListener THROW_FATAL = new SimpleErrorListener(false, true, true);
        public static final ErrorListener THROW_ERROR = new SimpleErrorListener(false, false, true);
        public static final ErrorListener THROW_WARNING = new SimpleErrorListener(false, false, false);
        private boolean ignoreFatal;
        private boolean ignoreError;
        private boolean ignoreWarning;

        public SimpleErrorListener(boolean ignoreFatal, boolean ignoreError, boolean ignoreWarning) {
            this.ignoreFatal = ignoreFatal;
            this.ignoreError = ignoreError;
            this.ignoreWarning = ignoreWarning;
        }

        @Override
        public void error(TransformerException te) throws TransformerException {
            if (!this.ignoreError) {
                throw te;
            }
        }

        @Override
        public void fatalError(TransformerException te) throws TransformerException {
            if (!this.ignoreFatal) {
                throw te;
            }
        }

        @Override
        public void warning(TransformerException te) throws TransformerException {
            if (!this.ignoreWarning) {
                throw te;
            }
        }
    }
}

