/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.mapper;

import com.igormaznitsa.jbbp.exceptions.JBBPMapperException;
import com.igormaznitsa.jbbp.io.JBBPBitNumber;
import com.igormaznitsa.jbbp.io.JBBPBitOrder;
import com.igormaznitsa.jbbp.mapper.Bin;
import com.igormaznitsa.jbbp.mapper.BinType;
import com.igormaznitsa.jbbp.mapper.JBBPMapperCustomFieldProcessor;
import com.igormaznitsa.jbbp.mapper.instantiators.JBBPClassInstantiator;
import com.igormaznitsa.jbbp.mapper.instantiators.JBBPClassInstantiatorFactory;
import com.igormaznitsa.jbbp.model.BitEntity;
import com.igormaznitsa.jbbp.model.JBBPAbstractArrayField;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayBit;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayByte;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayInt;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayLong;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayShort;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayStruct;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayUByte;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayUShort;
import com.igormaznitsa.jbbp.model.JBBPFieldInt;
import com.igormaznitsa.jbbp.model.JBBPFieldLong;
import com.igormaznitsa.jbbp.model.JBBPFieldString;
import com.igormaznitsa.jbbp.model.JBBPFieldStruct;
import com.igormaznitsa.jbbp.model.JBBPNumericField;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import com.igormaznitsa.jbbp.utils.ReflectUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public final class JBBPMapper {
    public static final int FLAG_IGNORE_MISSING_VALUES = 1;
    private static final JBBPClassInstantiator CLASS_INSTANTIATOR = JBBPClassInstantiatorFactory.getInstance().make();

    public static <T> T map(JBBPFieldStruct root, String structPath, Class<T> mappingClass) {
        return JBBPMapper.map(root, structPath, mappingClass, null);
    }

    public static <T> T map(JBBPFieldStruct root, String structPath, Class<T> mappingClass, int flags) {
        return JBBPMapper.map(root, structPath, mappingClass, null, flags);
    }

    public static <T> T map(JBBPFieldStruct root, String structPath, Class<T> mappingClass, JBBPMapperCustomFieldProcessor customFieldProcessor) {
        return JBBPMapper.map(root, structPath, mappingClass, customFieldProcessor, 0);
    }

    public static <T> T map(JBBPFieldStruct root, String structPath, Class<T> mappingClass, JBBPMapperCustomFieldProcessor customFieldProcessor, int flags) {
        JBBPUtils.assertNotNull(structPath, "Path must not be null");
        JBBPFieldStruct struct = root.findFieldForPathAndType(structPath, JBBPFieldStruct.class);
        if (struct == null) {
            throw new JBBPMapperException("Can't find a structure field for its path [" + structPath + ']', null, mappingClass, null, null);
        }
        return JBBPMapper.map(struct, mappingClass, customFieldProcessor);
    }

    public static <T> T map(JBBPFieldStruct root, Class<T> mappingClass) {
        return mappingClass.cast(JBBPMapper.map(root, JBBPMapper.allocateMemoryForClass(root, mappingClass), null));
    }

    public static <T> T map(JBBPFieldStruct root, Class<T> mappingClass, int flags) {
        return mappingClass.cast(JBBPMapper.map(root, JBBPMapper.allocateMemoryForClass(root, mappingClass), null, flags));
    }

    public static <T> T map(JBBPFieldStruct root, Class<T> mappingClass, JBBPMapperCustomFieldProcessor customFieldProcessor) {
        return mappingClass.cast(JBBPMapper.map(root, JBBPMapper.allocateMemoryForClass(root, mappingClass), customFieldProcessor));
    }

    public static <T> T map(JBBPFieldStruct root, Class<T> mappingClass, JBBPMapperCustomFieldProcessor customFieldProcessor, int flags) {
        return mappingClass.cast(JBBPMapper.map(root, JBBPMapper.allocateMemoryForClass(root, mappingClass), customFieldProcessor, flags));
    }

    public static Object map(JBBPFieldStruct rootStructure, Object mappingClassInstance, JBBPMapperCustomFieldProcessor customFieldProcessor) {
        return JBBPMapper.map(rootStructure, mappingClassInstance, customFieldProcessor, 0);
    }

    public static Object map(JBBPFieldStruct rootStructure, Object mappingClassInstance, JBBPMapperCustomFieldProcessor customFieldProcessor, int flags) {
        JBBPUtils.assertNotNull(rootStructure, "The Root structure must not be null");
        JBBPUtils.assertNotNull(mappingClassInstance, "The Mapping class instance must not be null");
        Class<?> mappingClass = mappingClassInstance.getClass();
        Bin defaultAnno = mappingClass.getAnnotation(Bin.class);
        ArrayList listOfClassHierarchy = new ArrayList();
        for (Class<?> current = mappingClassInstance.getClass(); current != Object.class; current = current.getSuperclass()) {
            listOfClassHierarchy.add(current);
        }
        for (Class clazz : listOfClassHierarchy) {
            for (Field mappingField : clazz.getDeclaredFields()) {
                String convertedValue;
                BinType fieldType;
                Bin mappedAnno;
                Bin fieldAnno;
                int modifiers = mappingField.getModifiers();
                if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers) || (fieldAnno = (mappingField = ReflectUtils.makeAccessible(mappingField)).getAnnotation(Bin.class)) == null && defaultAnno == null || mappingField.getName().indexOf(36) >= 0) continue;
                Bin bin = mappedAnno = fieldAnno == null ? defaultAnno : fieldAnno;
                if (mappedAnno.custom()) {
                    JBBPUtils.assertNotNull(customFieldProcessor, "There is a custom mapping field, in the case you must provide a custom mapping field processor");
                    Object value = customFieldProcessor.prepareObjectForMapping(rootStructure, mappedAnno, mappingField);
                    JBBPMapper.setFieldValue(mappingClassInstance, mappingField, null, value);
                    continue;
                }
                JBBPBitNumber mappedBitNumber = mappedAnno.outBitNumber();
                if (mappedAnno.type() == BinType.UNDEFINED) {
                    BinType thetype = BinType.findCompatible(mappingField.getType());
                    if (thetype == null) {
                        throw new JBBPMapperException("Can't find compatible type for a mapping field", rootStructure, mappingClass, mappingField, null);
                    }
                    if (mappedBitNumber.getBitNumber() < 8 && thetype != BinType.STRUCT && thetype != BinType.STRUCT_ARRAY) {
                        thetype = thetype.isArray() ? BinType.BIT_ARRAY : BinType.BIT;
                    }
                    fieldType = thetype;
                } else {
                    fieldType = mappedAnno.type();
                }
                boolean bitWideField = fieldType == BinType.BIT || fieldType == BinType.BIT_ARRAY;
                String fieldName = mappedAnno.name().length() == 0 ? mappingField.getName() : mappedAnno.name();
                String fieldPath = mappedAnno.path();
                JBBPAbstractField binField = fieldPath.length() == 0 ? (fieldName.length() == 0 ? rootStructure.findFieldForType(fieldType.getFieldClass()) : rootStructure.findFieldForNameAndType(fieldName, fieldType.getFieldClass())) : rootStructure.findFieldForPathAndType(fieldPath, fieldType.getFieldClass());
                if (binField == null) {
                    if ((flags & 1) != 0) continue;
                    throw new JBBPMapperException("Can't find value to be mapped to a mapping field [" + mappingField + ']', null, mappingClass, mappingField, null);
                }
                if (bitWideField && mappedBitNumber != JBBPBitNumber.BITS_8 && ((BitEntity)((Object)binField)).getBitWidth() != mappedBitNumber) {
                    throw new JBBPMapperException("Can't map value to a mapping field for different field bit width [" + (Object)((Object)mappedBitNumber) + "!=" + ((BitEntity)((Object)binField)).getBitWidth().getBitNumber() + ']', null, mappingClass, mappingField, null);
                }
                if (mappingField.getType().isArray()) {
                    if (binField instanceof JBBPAbstractArrayField) {
                        if (binField instanceof JBBPFieldArrayStruct) {
                            JBBPFieldArrayStruct structArray = (JBBPFieldArrayStruct)binField;
                            Class<?> componentType = mappingField.getType().getComponentType();
                            Object valueArray = JBBPMapper.getFieldValue(mappingClassInstance, mappingField);
                            Object object = valueArray = valueArray == null ? Array.newInstance(componentType, structArray.size()) : valueArray;
                            if (Array.getLength(valueArray) != structArray.size()) {
                                throw new JBBPMapperException("Can't map an array field for different expected size [" + Array.getLength(valueArray) + "!=" + structArray.size() + ']', binField, mappingClass, mappingField, null);
                            }
                            for (int i = 0; i < structArray.size(); ++i) {
                                Object curInstance = Array.get(valueArray, i);
                                if (curInstance == null) {
                                    Array.set(valueArray, i, JBBPMapper.map(structArray.getElementAt(i), componentType, customFieldProcessor));
                                    continue;
                                }
                                Array.set(valueArray, i, JBBPMapper.map(structArray.getElementAt(i), curInstance, customFieldProcessor));
                            }
                            JBBPMapper.setFieldValue(mappingClassInstance, mappingField, binField, valueArray);
                            continue;
                        }
                        JBBPMapper.mapArrayField(mappingClassInstance, mappingField, (JBBPAbstractArrayField)binField, mappedAnno.bitOrder() == JBBPBitOrder.MSB0);
                        continue;
                    }
                    throw new JBBPMapperException("Can't map a non-array value to an array mapping field", binField, mappingClass, mappingField, null);
                }
                if (binField instanceof JBBPNumericField) {
                    JBBPMapper.mapNumericField(mappingClassInstance, mappingField, (JBBPNumericField)((Object)binField), mappedAnno.bitOrder() == JBBPBitOrder.MSB0);
                    continue;
                }
                if (binField instanceof JBBPFieldString) {
                    if (mappingField.getType().isPrimitive()) {
                        throw new JBBPMapperException("Can't map a string to a primitive mapping field", binField, mappingClass, mappingField, null);
                    }
                    JBBPMapper.setFieldValue(mappingClassInstance, mappingField, binField, ((JBBPFieldString)binField).getAsString());
                    continue;
                }
                if (binField instanceof JBBPFieldStruct) {
                    if (mappingField.getType().isPrimitive()) {
                        throw new JBBPMapperException("Can't map a structure to a primitive mapping field", binField, mappingClass, mappingField, null);
                    }
                    Object curValue = JBBPMapper.getFieldValue(mappingClassInstance, mappingField);
                    if (curValue == null) {
                        JBBPMapper.setFieldValue(mappingClassInstance, mappingField, binField, JBBPMapper.map((JBBPFieldStruct)binField, mappingField.getType(), customFieldProcessor));
                        continue;
                    }
                    JBBPMapper.setFieldValue(mappingClassInstance, mappingField, binField, JBBPMapper.map((JBBPFieldStruct)binField, curValue, customFieldProcessor));
                    continue;
                }
                boolean processed = false;
                if (mappingField.getType() == String.class && binField instanceof JBBPAbstractArrayField && (convertedValue = JBBPMapper.convertFieldValueToString((JBBPAbstractArrayField)binField)) != null) {
                    JBBPMapper.setFieldValue(mappingClassInstance, mappingField, binField, convertedValue);
                    processed = true;
                }
                if (processed) continue;
                throw new JBBPMapperException("Can't map a field for its value incompatibility", binField, mappingClass, mappingField, null);
            }
        }
        return mappingClassInstance;
    }

    private static String convertFieldValueToString(JBBPAbstractArrayField<?> field) {
        StringBuilder result;
        if (field instanceof JBBPFieldArrayBit) {
            JBBPFieldArrayBit array = (JBBPFieldArrayBit)field;
            result = new StringBuilder(array.size());
            for (byte b : array.getArray()) {
                result.append((char)(b & 0xFF));
            }
        } else if (field instanceof JBBPFieldArrayByte) {
            JBBPFieldArrayByte array = (JBBPFieldArrayByte)field;
            result = new StringBuilder(array.size());
            for (byte b : array.getArray()) {
                result.append((char)(b & 0xFF));
            }
        } else if (field instanceof JBBPFieldArrayUByte) {
            JBBPFieldArrayUByte array = (JBBPFieldArrayUByte)field;
            result = new StringBuilder(array.size());
            for (byte b : array.getArray()) {
                result.append((char)(b & 0xFF));
            }
        } else if (field instanceof JBBPFieldArrayShort) {
            JBBPFieldArrayShort array = (JBBPFieldArrayShort)field;
            result = new StringBuilder(array.size());
            for (short b : array.getArray()) {
                result.append((char)b);
            }
        } else if (field instanceof JBBPFieldArrayUShort) {
            JBBPFieldArrayUShort array = (JBBPFieldArrayUShort)field;
            result = new StringBuilder(array.size());
            for (short b : array.getArray()) {
                result.append((char)b);
            }
        } else {
            result = null;
        }
        return result == null ? null : result.toString();
    }

    private static void setFieldValue(Object classInstance, Field classField, JBBPAbstractField binField, Object value) {
        try {
            classField.set(classInstance, value);
        }
        catch (IllegalArgumentException ex) {
            throw new JBBPMapperException("Can't set value to a mapping field", binField, classInstance.getClass(), classField, ex);
        }
        catch (IllegalAccessException ex) {
            throw new JBBPMapperException("Can't get access to a mapping field", binField, classInstance.getClass(), classField, ex);
        }
    }

    private static Object getFieldValue(Object classInstance, Field classField) {
        try {
            return classField.get(classInstance);
        }
        catch (IllegalArgumentException ex) {
            throw new JBBPMapperException("Can't set get value from a mapping field", null, classInstance.getClass(), classField, ex);
        }
        catch (IllegalAccessException ex) {
            throw new JBBPMapperException("Can't get access to a mapping field", null, classInstance.getClass(), classField, ex);
        }
    }

    private static void mapNumericField(Object mappingClassInstance, Field mappingField, JBBPNumericField numericField, boolean invertBitOrder) {
        block15: {
            Class<?> fieldClass = mappingField.getType();
            try {
                if (fieldClass == Byte.TYPE) {
                    mappingField.setByte(mappingClassInstance, (byte)(invertBitOrder ? numericField.getAsInvertedBitOrder() : (long)numericField.getAsInt()));
                    break block15;
                }
                if (fieldClass == Boolean.TYPE) {
                    mappingField.setBoolean(mappingClassInstance, numericField.getAsBool());
                    break block15;
                }
                if (fieldClass == Character.TYPE) {
                    mappingField.setChar(mappingClassInstance, (char)(invertBitOrder ? numericField.getAsInvertedBitOrder() : (long)numericField.getAsInt()));
                    break block15;
                }
                if (fieldClass == Short.TYPE) {
                    mappingField.setShort(mappingClassInstance, (short)(invertBitOrder ? numericField.getAsInvertedBitOrder() : (long)numericField.getAsInt()));
                    break block15;
                }
                if (fieldClass == Integer.TYPE) {
                    mappingField.setInt(mappingClassInstance, (int)(invertBitOrder ? numericField.getAsInvertedBitOrder() : (long)numericField.getAsInt()));
                    break block15;
                }
                if (fieldClass == Long.TYPE) {
                    mappingField.setLong(mappingClassInstance, invertBitOrder ? numericField.getAsInvertedBitOrder() : numericField.getAsLong());
                    break block15;
                }
                if (fieldClass == Float.TYPE) {
                    if (numericField instanceof JBBPFieldInt) {
                        mappingField.setFloat(mappingClassInstance, invertBitOrder ? Float.intBitsToFloat((int)numericField.getAsInvertedBitOrder()) : Float.intBitsToFloat(numericField.getAsInt()));
                    } else {
                        mappingField.setFloat(mappingClassInstance, invertBitOrder ? Float.intBitsToFloat((int)numericField.getAsInvertedBitOrder()) : numericField.getAsFloat());
                    }
                    break block15;
                }
                if (fieldClass == Double.TYPE) {
                    if (numericField instanceof JBBPFieldLong) {
                        mappingField.setDouble(mappingClassInstance, invertBitOrder ? Double.longBitsToDouble(numericField.getAsInvertedBitOrder()) : Double.longBitsToDouble(numericField.getAsLong()));
                    } else {
                        mappingField.setDouble(mappingClassInstance, invertBitOrder ? Double.longBitsToDouble(numericField.getAsInvertedBitOrder()) : numericField.getAsDouble());
                    }
                    break block15;
                }
                throw new JBBPMapperException("Unsupported mapping class field type to be mapped for binary parsed data", (JBBPAbstractField)((Object)numericField), mappingClassInstance.getClass(), mappingField, null);
            }
            catch (IllegalAccessException ex) {
                throw new JBBPMapperException("Can't get access to a mapping field", (JBBPAbstractField)((Object)numericField), mappingClassInstance.getClass(), mappingField, ex);
            }
            catch (IllegalArgumentException ex) {
                throw new JBBPMapperException("Can't set argument to a mapping field", (JBBPAbstractField)((Object)numericField), mappingClassInstance.getClass(), mappingField, ex);
            }
        }
    }

    private static void mapArrayField(Object mappingClassInstance, Field mappingField, JBBPAbstractArrayField<?> arrayField, boolean invertBitOrder) {
        try {
            if (arrayField instanceof JBBPFieldArrayLong && mappingField.getType().getComponentType() == Double.TYPE) {
                long[] longarray = (long[])arrayField.getValueArrayAsObject(invertBitOrder);
                double[] doublearray = new double[longarray.length];
                for (int i = 0; i < longarray.length; ++i) {
                    doublearray[i] = Double.longBitsToDouble(longarray[i]);
                }
                mappingField.set(mappingClassInstance, doublearray);
            } else if (arrayField instanceof JBBPFieldArrayInt && mappingField.getType().getComponentType() == Float.TYPE) {
                int[] intarray = (int[])arrayField.getValueArrayAsObject(invertBitOrder);
                float[] floatarray = new float[intarray.length];
                for (int i = 0; i < intarray.length; ++i) {
                    floatarray[i] = Float.intBitsToFloat(intarray[i]);
                }
                mappingField.set(mappingClassInstance, floatarray);
            } else if (arrayField instanceof JBBPFieldArrayUShort && mappingField.getType().getComponentType() == Character.TYPE) {
                short[] shortarray = (short[])arrayField.getValueArrayAsObject(invertBitOrder);
                char[] chararray = new char[shortarray.length];
                for (int i = 0; i < shortarray.length; ++i) {
                    chararray[i] = (char)shortarray[i];
                }
                mappingField.set(mappingClassInstance, chararray);
            } else {
                mappingField.set(mappingClassInstance, arrayField.getValueArrayAsObject(invertBitOrder));
            }
        }
        catch (IllegalAccessException ex) {
            throw new JBBPMapperException("Can't get access to a mapping field", arrayField, mappingClassInstance.getClass(), mappingField, ex);
        }
        catch (IllegalArgumentException ex) {
            throw new JBBPMapperException("Can't set argument to a mapping field", arrayField, mappingClassInstance.getClass(), mappingField, ex);
        }
    }

    private static <T> T allocateMemoryForClass(JBBPFieldStruct root, Class<T> klazz) {
        try {
            return CLASS_INSTANTIATOR.makeClassInstance(klazz);
        }
        catch (InstantiationException ex) {
            throw new JBBPMapperException("Can't make an instance of a class", root, klazz, null, ex);
        }
    }
}

