/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSMessage;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;

public class HandshakeState {
    private final ContentType contentType;
    private final HandshakeType handshakeType;
    private final boolean optional;

    public HandshakeState(ContentType contentType) {
        this(contentType, null, false);
    }

    public HandshakeState(HandshakeType handshakeType) {
        this(ContentType.HANDSHAKE, handshakeType, false);
    }

    public HandshakeState(HandshakeType handshakeType, boolean optional) {
        this(ContentType.HANDSHAKE, handshakeType, optional);
    }

    private HandshakeState(ContentType contentType, HandshakeType handshakeType, boolean optional) {
        this.contentType = contentType;
        this.handshakeType = handshakeType;
        this.optional = optional;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public HandshakeType getHandshakeType() {
        return this.handshakeType;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean expect(DTLSMessage message) {
        HandshakeMessage handshake;
        if (message.getContentType() != this.contentType) {
            return false;
        }
        return !(message instanceof HandshakeMessage) || (handshake = (HandshakeMessage)message).getMessageType() == this.handshakeType;
    }

    public String toString() {
        return HandshakeState.toString(this.contentType, this.handshakeType);
    }

    public static String toString(DTLSMessage message) {
        if (message instanceof HandshakeMessage) {
            HandshakeMessage handshake = (HandshakeMessage)message;
            return HandshakeState.toString(message.getContentType(), handshake.getMessageType());
        }
        return HandshakeState.toString(message.getContentType(), null);
    }

    private static String toString(ContentType contentType, HandshakeType handshakeType) {
        if (handshakeType != null) {
            return contentType.name() + "/" + handshakeType.name();
        }
        return contentType.name();
    }
}

