/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.internal.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Objects;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.i18n.UnitProvider;
import org.openhab.core.io.rest.RESTConstants;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.internal.resources.beans.SystemInfoBean;
import org.openhab.core.io.rest.internal.resources.beans.UoMInfoBean;
import org.openhab.core.service.StartLevelService;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

@Path(value="systeminfo")
@RolesAllowed(value={"administrator"})
@SecurityRequirement(name="oauth2", scopes={"admin"})
@Tag(name="systeminfo")
@Component
@JaxrsResource
@JaxrsName(value="systeminfo")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class SystemInfoResource
implements RESTResource,
ConfigurationListener {
    public static final String PATH_SYSTEMINFO = "systeminfo";
    private final StartLevelService startLevelService;
    private final UnitProvider unitProvider;
    private @Nullable Date lastModified = null;

    @Activate
    public SystemInfoResource(@Reference StartLevelService startLevelService, @Reference UnitProvider unitProvider) {
        this.startLevelService = startLevelService;
        this.unitProvider = unitProvider;
    }

    public void configurationEvent(@Nullable ConfigurationEvent event) {
        if (Objects.equals(event.getPid(), "org.openhab.i18n")) {
            this.lastModified = null;
        }
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @Operation(operationId="getSystemInformation", summary="Gets information about the system.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SystemInfoBean.class))})})
    public Response getSystemInfo(@Context UriInfo uriInfo) {
        SystemInfoBean bean = new SystemInfoBean(this.startLevelService.getStartLevel());
        return Response.ok((Object)bean).build();
    }

    @GET
    @Path(value="/uom")
    @Produces(value={"application/json"})
    @Operation(operationId="getUoMInformation", summary="Get all supported dimensions and their system units.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=UoMInfoBean.class))})})
    public Response getUoMInfo(@Context Request request, @Context UriInfo uriInfo) {
        if (this.lastModified != null) {
            Response.ResponseBuilder responseBuilder = request.evaluatePreconditions(this.lastModified);
            if (responseBuilder != null) {
                return responseBuilder.build();
            }
        } else {
            this.lastModified = Date.from(Instant.now().truncatedTo(ChronoUnit.SECONDS));
        }
        UoMInfoBean bean = new UoMInfoBean(this.unitProvider);
        return Response.ok((Object)bean).lastModified(this.lastModified).cacheControl(RESTConstants.CACHE_CONTROL).build();
    }
}

