/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.factory;

import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.handler.BaseModuleHandlerFactory;
import org.openhab.core.automation.handler.ModuleHandler;
import org.openhab.core.automation.handler.ModuleHandlerFactory;
import org.openhab.core.automation.internal.module.handler.EphemerisConditionHandler;
import org.openhab.core.ephemeris.EphemerisManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@NonNullByDefault
public class EphemerisModuleHandlerFactory
extends BaseModuleHandlerFactory
implements ModuleHandlerFactory {
    private final Logger logger = LoggerFactory.getLogger(EphemerisModuleHandlerFactory.class);
    private static final Collection<String> TYPES = List.of("ephemeris.HolidayCondition", "ephemeris.NotHolidayCondition", "ephemeris.WeekendCondition", "ephemeris.WeekdayCondition", "ephemeris.DaysetCondition");
    private final EphemerisManager ephemerisManager;

    @Activate
    public EphemerisModuleHandlerFactory(@Reference EphemerisManager ephemerisManager) {
        this.ephemerisManager = ephemerisManager;
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    @Override
    public Collection<String> getTypes() {
        return TYPES;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected @Nullable ModuleHandler internalCreate(Module module, String ruleUID) {
        String moduleTypeUID;
        block15: {
            moduleTypeUID = module.getTypeUID();
            this.logger.trace("create {} -> {} : {}", new Object[]{module.getId(), moduleTypeUID, ruleUID});
            Module module2 = module;
            if (!(module2 instanceof Condition)) break block15;
            Condition condition = (Condition)module2;
            Condition cfr_ignored_0 = (Condition)module2;
            switch (moduleTypeUID) {
                case "ephemeris.DaysetCondition": 
                case "ephemeris.WeekdayCondition": 
                case "ephemeris.NotHolidayCondition": 
                case "ephemeris.WeekendCondition": 
                case "ephemeris.HolidayCondition": {
                    void condition2;
                    return new EphemerisConditionHandler((Condition)condition2, this.ephemerisManager);
                }
            }
        }
        this.logger.error("The ModuleHandler is not supported: {}", (Object)moduleTypeUID);
        return null;
    }
}

