/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.async;

import java.util.concurrent.Executor;
import org.jupnp.UpnpService;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.model.ValidationError;
import org.jupnp.model.ValidationException;
import org.jupnp.model.message.IncomingDatagramMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.discovery.IncomingSearchResponse;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.model.types.UDN;
import org.jupnp.protocol.ReceivingAsync;
import org.jupnp.protocol.RetrieveRemoteDescriptors;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingSearchResponse
extends ReceivingAsync<IncomingSearchResponse> {
    private final Logger logger = LoggerFactory.getLogger(ReceivingSearchResponse.class);

    public ReceivingSearchResponse(UpnpService upnpService, IncomingDatagramMessage<UpnpResponse> inputMessage) {
        super(upnpService, new IncomingSearchResponse(inputMessage));
    }

    @Override
    protected void execute() throws RouterException {
        Executor executor;
        RemoteDevice rd;
        if (!((IncomingSearchResponse)this.getInputMessage()).isSearchResponseMessage()) {
            this.logger.trace("Ignoring invalid search response message: {}", this.getInputMessage());
            return;
        }
        UDN udn = ((IncomingSearchResponse)this.getInputMessage()).getRootDeviceUDN();
        if (udn == null) {
            this.logger.trace("Ignoring search response message without UDN: {}", this.getInputMessage());
            return;
        }
        RemoteDeviceIdentity rdIdentity = new RemoteDeviceIdentity((IncomingSearchResponse)this.getInputMessage());
        this.logger.trace("Received device search response: {}", (Object)rdIdentity);
        if (this.getUpnpService().getRegistry().update(rdIdentity)) {
            this.logger.trace("Remote device was already known: {}", (Object)udn);
            return;
        }
        try {
            rd = new RemoteDevice(rdIdentity);
        }
        catch (ValidationException e) {
            this.logger.warn("Validation errors of device during discovery: {}", (Object)rdIdentity);
            for (ValidationError validationError : e.getErrors()) {
                this.logger.warn(validationError.toString());
            }
            return;
        }
        if (rdIdentity.getDescriptorURL() == null) {
            this.logger.trace("Ignoring message without location URL header: {}", this.getInputMessage());
            return;
        }
        if (rdIdentity.getMaxAgeSeconds() == null) {
            this.logger.trace("Ignoring message without max-age header: {}", this.getInputMessage());
            return;
        }
        if (RetrieveRemoteDescriptors.isRetrievalInProgress(rd)) {
            this.logger.trace("Skip submitting task, active retrieval for URL already in progress: {}", (Object)((RemoteDeviceIdentity)rd.getIdentity()).getDescriptorURL());
            return;
        }
        UpnpServiceConfiguration conf = this.getUpnpService().getConfiguration();
        if (conf != null && (executor = conf.getAsyncProtocolExecutor()) != null) {
            executor.execute(new RetrieveRemoteDescriptors(this.getUpnpService(), rd));
        }
    }
}

