/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.format;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import javax.measure.format.UnitFormat;
import org.apiguardian.api.API;
import tech.units.indriya.internal.format.RationalNumberFormat;
import tech.units.indriya.quantity.MixedQuantity;
import tech.units.indriya.quantity.Quantities;

@API(status=API.Status.INTERNAL)
abstract class CommonFormatter {
    private static final String ERR_PRIMARY_UNIT_NOT_FOUND = "The primary unit <%s> is not part of the mixed units <%s>";

    CommonFormatter() {
    }

    static MixedQuantity<?> parseMixed(String str, NumberFormat numberFormat, UnitFormat unitFormat, String delimiter, String mixDelimiter, int position) throws IllegalArgumentException, MeasurementParseException {
        String section = str.substring(position);
        String[] sectionParts = section.split(mixDelimiter);
        ArrayList quants = new ArrayList();
        RationalNumberFormat rationalNumberFormat = RationalNumberFormat.wrap(numberFormat);
        for (String compStr : sectionParts) {
            String[] parts = compStr.split(delimiter);
            if (parts.length < 2) {
                throw new IllegalArgumentException("No Unit found");
            }
            Number num = null;
            try {
                num = rationalNumberFormat.parse(parts[0]);
            }
            catch (ParseException pe) {
                throw new MeasurementParseException((Throwable)pe);
            }
            Unit unit = unitFormat.parse((CharSequence)parts[1]);
            if (num == null || unit == null) continue;
            quants.add(Quantities.getQuantity(num, unit));
        }
        Quantity[] qArray = new Quantity[quants.size()];
        quants.toArray(qArray);
        MixedQuantity comp = MixedQuantity.of(qArray);
        return comp;
    }

    static MixedQuantity<?> parseMixed(String str, NumberFormat numberFormat, UnitFormat unitFormat, String delimiter, String mixDelimiter) throws IllegalArgumentException, MeasurementParseException {
        return CommonFormatter.parseMixed(str, numberFormat, unitFormat, delimiter, mixDelimiter, 0);
    }

    static MixedQuantity<?> parseMixed(String str, NumberFormat numberFormat, UnitFormat unitFormat, String delimiter, int position) throws IllegalArgumentException, MeasurementParseException {
        Objects.requireNonNull(str);
        String section = str.substring(position);
        ArrayList quants = new ArrayList();
        RationalNumberFormat rationalNumberFormat = RationalNumberFormat.wrap(numberFormat);
        String[] parts = section.split(delimiter);
        if (parts.length < 2) {
            throw new IllegalArgumentException("No Unit found");
        }
        for (int i = 0; i < parts.length - 1; ++i) {
            Number num = null;
            try {
                num = rationalNumberFormat.parse(parts[i]);
            }
            catch (ParseException pe) {
                throw new MeasurementParseException((Throwable)pe);
            }
            Unit unit = unitFormat.parse((CharSequence)parts[i + 1]);
            if (num != null && unit != null) {
                quants.add(Quantities.getQuantity(num, unit));
            }
            ++i;
        }
        Quantity[] qArray = new Quantity[quants.size()];
        qArray = quants.toArray(qArray);
        MixedQuantity comp = MixedQuantity.of(qArray);
        return comp;
    }

    static MixedQuantity<?> parseMixed(String str, NumberFormat numberFormat, UnitFormat unitFormat, String delimiter) throws IllegalArgumentException, MeasurementParseException {
        return CommonFormatter.parseMixed(str, numberFormat, unitFormat, delimiter, 0);
    }

    static Quantity<?> parseMixedAsLeading(String str, NumberFormat numberFormat, UnitFormat unitFormat, String delimiter, String compDelim, int position) throws IllegalArgumentException, MeasurementParseException {
        MixedQuantity<?> comp = CommonFormatter.parseMixed(str, numberFormat, unitFormat, delimiter, compDelim, position);
        Unit<?> u = CommonFormatter.getLeadingUnit(comp);
        return comp.to(u);
    }

    static Quantity<?> parseMixedAsLeading(String str, NumberFormat numberFormat, UnitFormat unitFormat, String delimiter, int position) throws IllegalArgumentException, MeasurementParseException {
        MixedQuantity<?> comp = CommonFormatter.parseMixed(str, numberFormat, unitFormat, delimiter, position);
        Unit<?> u = CommonFormatter.getLeadingUnit(comp);
        return comp.to(u);
    }

    static Quantity<?> parseMixedAsLeading(String str, NumberFormat numberFormat, UnitFormat unitFormat, String delimiter) throws IllegalArgumentException, MeasurementParseException {
        return CommonFormatter.parseMixedAsLeading(str, numberFormat, unitFormat, delimiter, 0);
    }

    static Quantity<?> parseMixedAsPrimary(String str, NumberFormat numberFormat, UnitFormat unitFormat, Unit primaryUnit, String delimiter, String compDelim, int position) throws IllegalArgumentException, MeasurementParseException {
        MixedQuantity<?> comp = CommonFormatter.parseMixed(str, numberFormat, unitFormat, delimiter, compDelim, position);
        if (comp.getUnits().contains(primaryUnit)) {
            return comp.to(primaryUnit);
        }
        throw new IllegalArgumentException(String.format(ERR_PRIMARY_UNIT_NOT_FOUND, primaryUnit, comp.getUnits()));
    }

    static Quantity<?> parseMixedAsPrimary(String str, NumberFormat numberFormat, UnitFormat unitFormat, Unit primaryUnit, String delimiter, int position) throws IllegalArgumentException, MeasurementParseException {
        MixedQuantity<?> comp = CommonFormatter.parseMixed(str, numberFormat, unitFormat, delimiter, position);
        if (comp.getUnits().contains(primaryUnit)) {
            return comp.to(primaryUnit);
        }
        throw new IllegalArgumentException(String.format(ERR_PRIMARY_UNIT_NOT_FOUND, primaryUnit, comp.getUnits()));
    }

    static Quantity<?> parseMixedAsPrimary(String str, NumberFormat numberFormat, UnitFormat unitFormat, Unit primaryUnit, String delimiter) throws IllegalArgumentException, MeasurementParseException {
        return CommonFormatter.parseMixedAsPrimary(str, numberFormat, unitFormat, primaryUnit, delimiter, 0);
    }

    private static final <Q extends Quantity<Q>> Unit<Q> getLeadingUnit(MixedQuantity<Q> comp) {
        Unit<Q> unit;
        block0: {
            Unit<Q> u;
            Objects.requireNonNull(comp);
            unit = null;
            Iterator<Unit<Q>> iterator = comp.getUnits().iterator();
            if (!iterator.hasNext()) break block0;
            unit = u = iterator.next();
        }
        return unit;
    }
}

