/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.items;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.items.GenericItem;
import org.openhab.core.library.types.PercentType;
import org.openhab.core.library.types.StopMoveType;
import org.openhab.core.library.types.UpDownType;
import org.openhab.core.types.Command;
import org.openhab.core.types.RefreshType;
import org.openhab.core.types.State;
import org.openhab.core.types.TimeSeries;
import org.openhab.core.types.UnDefType;

@NonNullByDefault
public class RollershutterItem
extends GenericItem {
    private static final List<Class<? extends State>> ACCEPTED_DATA_TYPES = List.of(PercentType.class, UpDownType.class, UnDefType.class);
    private static final List<Class<? extends Command>> ACCEPTED_COMMAND_TYPES = List.of(PercentType.class, UpDownType.class, StopMoveType.class, RefreshType.class);

    public RollershutterItem(String name) {
        super("Rollershutter", name);
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        return ACCEPTED_DATA_TYPES;
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        return ACCEPTED_COMMAND_TYPES;
    }

    public void send(UpDownType command) {
        this.internalSend(command);
    }

    public void send(StopMoveType command) {
        this.internalSend(command);
    }

    public void send(PercentType command) {
        this.internalSend(command);
    }

    @Override
    public void setState(State state) {
        if (this.isAcceptedState(ACCEPTED_DATA_TYPES, state)) {
            PercentType convertedState = state.as(PercentType.class);
            if (convertedState != null) {
                this.applyState(convertedState);
            } else {
                this.applyState(state);
            }
        } else {
            this.logSetTypeError(state);
        }
    }

    @Override
    public void setTimeSeries(TimeSeries timeSeries) {
        if (timeSeries.getStates().allMatch(s -> this.isAcceptedState(ACCEPTED_DATA_TYPES, s.state()))) {
            this.applyTimeSeries(timeSeries);
        } else {
            this.logSetTypeError(timeSeries);
        }
    }
}

