/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.modbus;

import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class ModbusConstants {
    public static final int MAX_BITS_READ_COUNT = 2000;
    public static final int MAX_REGISTERS_READ_COUNT = 125;
    public static final int MAX_BITS_WRITE_COUNT = 1968;
    public static final int MAX_REGISTERS_WRITE_COUNT = 123;

    public static enum ValueType {
        BIT("bit", 1),
        INT8("int8", 8),
        UINT8("uint8", 8),
        INT16("int16", 16),
        UINT16("uint16", 16),
        INT32("int32", 32),
        UINT32("uint32", 32),
        FLOAT32("float32", 32),
        INT64("int64", 64),
        UINT64("uint64", 64),
        INT32_SWAP("int32_swap", 32),
        UINT32_SWAP("uint32_swap", 32),
        FLOAT32_SWAP("float32_swap", 32),
        INT64_SWAP("int64_swap", 64),
        UINT64_SWAP("uint64_swap", 64);

        private final String configValue;
        private final int bits;

        private ValueType(String configValue, int bits) {
            this.configValue = configValue;
            this.bits = bits;
        }

        public int getBits() {
            return this.bits;
        }

        public String getConfigValue() {
            return this.configValue;
        }

        public String toString() {
            return this.getConfigValue();
        }

        public static ValueType fromConfigValue(@Nullable String configValueType) throws IllegalArgumentException {
            return Stream.of(ValueType.values()).filter(v -> v.getConfigValue().equals(configValueType)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid valueType " + configValueType));
        }
    }
}

