/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.addon.marketplace.internal.community;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.addon.Addon;
import org.openhab.core.addon.marketplace.MarketplaceAddonHandler;
import org.openhab.core.addon.marketplace.MarketplaceHandlerException;
import org.openhab.core.addon.marketplace.internal.community.SerializedNameAnnotationIntrospector;
import org.openhab.core.common.registry.Provider;
import org.openhab.core.common.registry.ProviderChangeListener;
import org.openhab.core.storage.Storage;
import org.openhab.core.storage.StorageService;
import org.openhab.core.transform.ManagedTransformationProvider;
import org.openhab.core.transform.Transformation;
import org.openhab.core.transform.TransformationProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@NonNullByDefault
public class CommunityTransformationAddonHandler
implements MarketplaceAddonHandler,
TransformationProvider {
    private final Logger logger = LoggerFactory.getLogger(CommunityTransformationAddonHandler.class);
    private final ObjectMapper yamlMapper;
    private final Gson gson = new Gson();
    private final Storage<ManagedTransformationProvider.PersistedTransformation> storage;
    private final List<ProviderChangeListener<Transformation>> changeListeners = new CopyOnWriteArrayList<ProviderChangeListener<Transformation>>();

    @Activate
    public CommunityTransformationAddonHandler(@Reference StorageService storageService) {
        this.storage = storageService.getStorage("org.openhab.marketplace.transformation", this.getClass().getClassLoader());
        this.yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        this.yamlMapper.findAndRegisterModules();
        this.yamlMapper.setDateFormat((DateFormat)new SimpleDateFormat("MMM d, yyyy, hh:mm:ss aa", Locale.ENGLISH));
        this.yamlMapper.setAnnotationIntrospector((AnnotationIntrospector)new AnnotationIntrospectorPair((AnnotationIntrospector)new SerializedNameAnnotationIntrospector(), this.yamlMapper.getSerializationConfig().getAnnotationIntrospector()));
    }

    @Override
    public boolean supports(String type, String contentType) {
        return "transformation".equals(type) && "application/vnd.openhab.transformation".equals(contentType);
    }

    @Override
    public boolean isInstalled(String id) {
        return this.storage.containsKey(id);
    }

    @Override
    public void install(Addon addon) throws MarketplaceHandlerException {
        try {
            ManagedTransformationProvider.PersistedTransformation persistedTransformation;
            String yamlDownloadUrl = (String)addon.getProperties().get("yaml_download_url");
            String yamlContent = (String)addon.getProperties().get("yaml_content");
            String jsonDownloadUrl = (String)addon.getProperties().get("json_download_url");
            String jsonContent = (String)addon.getProperties().get("json_content");
            if (yamlDownloadUrl != null) {
                persistedTransformation = this.addTransformationFromYAML(addon.getUid(), this.downloadTransformation(yamlDownloadUrl));
            } else if (yamlContent != null) {
                persistedTransformation = this.addTransformationFromYAML(addon.getUid(), yamlContent);
            } else if (jsonDownloadUrl != null) {
                persistedTransformation = this.addTransformationFromJSON(addon.getUid(), this.downloadTransformation(jsonDownloadUrl));
            } else if (jsonContent != null) {
                persistedTransformation = this.addTransformationFromJSON(addon.getUid(), jsonContent);
            } else {
                throw new IllegalArgumentException("Couldn't find the transformation in the add-on entry. The starting code fence may not be marked as ```yaml");
            }
            Transformation transformation = this.map(persistedTransformation);
            this.changeListeners.forEach(l -> l.added((Provider)this, (Object)transformation));
        }
        catch (IOException e) {
            this.logger.error("Transformation from marketplace cannot be downloaded: {}", (Object)e.getMessage());
            throw new MarketplaceHandlerException("Transformation cannot be downloaded.", e);
        }
        catch (Exception e) {
            this.logger.error("Transformation from marketplace is invalid: {}", (Object)e.getMessage());
            throw new MarketplaceHandlerException("Transformation is not valid.", e);
        }
    }

    @Override
    public void uninstall(Addon addon) throws MarketplaceHandlerException {
        ManagedTransformationProvider.PersistedTransformation toRemoveElement = (ManagedTransformationProvider.PersistedTransformation)this.storage.remove(addon.getUid());
        if (toRemoveElement != null) {
            Transformation toRemove = this.map(toRemoveElement);
            this.changeListeners.forEach(l -> l.removed((Provider)this, (Object)toRemove));
        }
    }

    private String downloadTransformation(String urlString) throws IOException {
        URL u;
        try {
            u = new URI(urlString).toURL();
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            throw new IOException(e);
        }
        Throwable throwable = null;
        Object var4_6 = null;
        try (InputStream in = u.openStream();){
            return new String(in.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private ManagedTransformationProvider.PersistedTransformation addTransformationFromYAML(String id, String yaml) {
        try {
            ManagedTransformationProvider.PersistedTransformation transformation = (ManagedTransformationProvider.PersistedTransformation)this.yamlMapper.readValue(yaml, ManagedTransformationProvider.PersistedTransformation.class);
            this.storage.put(id, (Object)transformation);
            return transformation;
        }
        catch (IOException e) {
            this.logger.error("Unable to parse YAML: {}", (Object)e.getMessage());
            throw new IllegalArgumentException("Unable to parse YAML");
        }
    }

    private ManagedTransformationProvider.PersistedTransformation addTransformationFromJSON(String id, String json) {
        try {
            ManagedTransformationProvider.PersistedTransformation transformation = Objects.requireNonNull((ManagedTransformationProvider.PersistedTransformation)this.gson.fromJson(json, ManagedTransformationProvider.PersistedTransformation.class));
            this.storage.put(id, (Object)transformation);
            return transformation;
        }
        catch (JsonParseException e) {
            this.logger.error("Unable to parse JSON: {}", (Object)e.getMessage());
            throw new IllegalArgumentException("Unable to parse JSON");
        }
    }

    public void addProviderChangeListener(ProviderChangeListener<Transformation> listener) {
        this.changeListeners.add(listener);
    }

    public Collection<Transformation> getAll() {
        return this.storage.getValues().stream().filter(Objects::nonNull).map(Objects::requireNonNull).map(this::map).toList();
    }

    public void removeProviderChangeListener(ProviderChangeListener<Transformation> listener) {
        this.changeListeners.remove(listener);
    }

    private Transformation map(ManagedTransformationProvider.PersistedTransformation persistedTransformation) {
        return new Transformation(persistedTransformation.uid, persistedTransformation.label, persistedTransformation.type, persistedTransformation.configuration);
    }
}

