/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.voice.text;

import java.util.ResourceBundle;
import java.util.Set;
import org.openhab.core.voice.text.ASTNode;
import org.openhab.core.voice.text.Expression;
import org.openhab.core.voice.text.TokenList;

public final class ExpressionMatch
extends Expression {
    private String pattern;

    public ExpressionMatch(String pattern) {
        this.pattern = pattern;
    }

    @Override
    ASTNode parse(ResourceBundle language, TokenList list) {
        ASTNode node = new ASTNode();
        node.setSuccess(list.checkHead(this.pattern));
        if (node.isSuccess()) {
            node.setRemainingTokens(list.skipHead());
            node.setValue(this.pattern);
            node.setChildren(new ASTNode[0]);
            this.generateValue(node);
        }
        return node;
    }

    @Override
    boolean collectFirsts(ResourceBundle language, Set<String> firsts) {
        firsts.add(this.pattern);
        return true;
    }

    public String toString() {
        return "match(\"" + this.pattern + "\")";
    }

    public String getPattern() {
        return this.pattern;
    }
}

