/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;

public abstract class BaseProtocolPoller
extends ChannelDuplexHandler {
    private final long interval;
    private Future<?> timeout;

    public BaseProtocolPoller(long interval) {
        this.interval = interval;
    }

    protected abstract void sendRequest(Channel var1, SocketAddress var2);

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        if (this.interval > 0L) {
            this.timeout = ctx.executor().scheduleAtFixedRate(() -> this.sendRequest(ctx.channel(), ctx.channel().remoteAddress()), 0L, this.interval, TimeUnit.SECONDS);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (this.timeout != null) {
            this.timeout.cancel(false);
            this.timeout = null;
        }
    }
}

