/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.signature;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.traccar.api.signature.CryptoManager;
import org.traccar.model.RevokedToken;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Singleton
public class TokenManager {
    private static final int DEFAULT_EXPIRATION_DAYS = 7;
    private final ObjectMapper objectMapper;
    private final CryptoManager cryptoManager;
    private final Storage storage;
    private final SecureRandom random = new SecureRandom();

    @Inject
    public TokenManager(ObjectMapper objectMapper, CryptoManager cryptoManager, Storage storage) {
        this.objectMapper = objectMapper;
        this.cryptoManager = cryptoManager;
        this.storage = storage;
    }

    public String generateToken(long userId) throws IOException, GeneralSecurityException, StorageException {
        return this.generateToken(userId, null);
    }

    public String generateToken(long userId, Date expiration) throws IOException, GeneralSecurityException, StorageException {
        TokenData data = new TokenData();
        data.userId = userId;
        data.id = this.random.nextLong() & Long.MAX_VALUE;
        data.expiration = expiration != null ? expiration : new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(7L));
        byte[] encoded = this.objectMapper.writeValueAsBytes((Object)data);
        return Base64.encodeBase64URLSafeString((byte[])this.cryptoManager.sign(encoded));
    }

    public TokenData verifyToken(String token) throws IOException, GeneralSecurityException, StorageException {
        TokenData data = this.decodeToken(token);
        if (data.expiration.before(new Date())) {
            throw new SecurityException("Token has expired");
        }
        RevokedToken revoked = this.storage.getObject(RevokedToken.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", data.getId())));
        if (revoked != null) {
            throw new SecurityException("Token has been revoked");
        }
        return data;
    }

    public TokenData decodeToken(String token) throws IOException, GeneralSecurityException, StorageException {
        byte[] encoded = this.cryptoManager.verify(Base64.decodeBase64((String)token));
        return (TokenData)this.objectMapper.readValue(encoded, TokenData.class);
    }

    public static class TokenData {
        @JsonProperty(value="i")
        private long id;
        @JsonProperty(value="u")
        private long userId;
        @JsonProperty(value="e")
        private Date expiration;

        public long getId() {
            return this.id;
        }

        public long getUserId() {
            return this.userId;
        }

        public Date getExpiration() {
            return this.expiration;
        }
    }
}

