/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.helper.Checksum;
import org.traccar.model.Command;

public class TotemProtocolEncoder
extends StringProtocolEncoder {
    public TotemProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    public static String formatContent(Command command) {
        return switch (command.getType()) {
            case "custom" -> String.format("%s,%s", command.getAttributes().get("devicePassword"), command.getAttributes().get("data"));
            case "rebootDevice" -> String.format("%s,006", command.getAttributes().get("devicePassword"));
            case "factoryReset" -> String.format("%s,007", command.getAttributes().get("devicePassword"));
            case "getVersion" -> String.format("%s,056", command.getAttributes().get("devicePassword"));
            case "positionSingle" -> String.format("%s,012", command.getAttributes().get("devicePassword"));
            case "engineStop" -> String.format("%s,025,C,1", command.getAttributes().get("devicePassword"));
            case "engineResume" -> String.format("%s,025,C,0", command.getAttributes().get("devicePassword"));
            default -> null;
        };
    }

    @Override
    protected Object encodeCommand(Command command) {
        this.initDevicePassword(command, "000000");
        String commandString = TotemProtocolEncoder.formatContent(command);
        String builtCommand = String.format("$$%04dCF%s", 10 + commandString.getBytes().length, commandString);
        return String.format("%s%02X", builtCommand, Checksum.xor(builtCommand));
    }
}

