/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import java.util.function.Consumer;

final class Utils {
    private static final Consumer NO_OP_CONSUMER = o -> {};
    static final boolean IS_NETTY_4_2;
    private static final int AVAILABLE_PROCESSORS;

    private Utils() {
    }

    static int availableProcessors() {
        return AVAILABLE_PROCESSORS;
    }

    static EventLoopGroup eventLoopGroup() {
        if (IS_NETTY_4_2) {
            return new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory());
        }
        return new NioEventLoopGroup();
    }

    static ByteBufAllocator byteBufAllocator() {
        return ByteBufAllocator.DEFAULT;
    }

    static <T> Consumer<T> noOpConsumer() {
        return NO_OP_CONSUMER;
    }

    static {
        AVAILABLE_PROCESSORS = Integer.parseInt(System.getProperty("rabbitmq.amqp.client.availableProcessors", String.valueOf(Runtime.getRuntime().availableProcessors())));
        boolean netty4_2 = true;
        try {
            Class.forName("io.netty.channel.MultiThreadIoEventLoopGroup");
        }
        catch (ClassNotFoundException e) {
            netty4_2 = false;
        }
        IS_NETTY_4_2 = netty4_2;
    }
}

