/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

public class DiscriminatorState {
    private String propertyName;
    private String discriminatingValue;
    private String mappedSchema = null;
    private boolean explicitMapping = false;
    private String matchedSchema;

    public boolean matches(String refSchema) {
        boolean discriminatorMatchFound = false;
        String mappedSchema = this.getMappedSchema();
        if (mappedSchema != null) {
            if (this.isExplicitMapping() && refSchema.equals(mappedSchema)) {
                discriminatorMatchFound = true;
                this.setMatchedSchema(refSchema);
            } else if (!this.isExplicitMapping() && DiscriminatorState.isImplicitMatch(refSchema, mappedSchema)) {
                discriminatorMatchFound = true;
                this.setMatchedSchema(refSchema);
            }
        }
        return discriminatorMatchFound;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getDiscriminatingValue() {
        return this.discriminatingValue;
    }

    public void setDiscriminatingValue(String discriminatingValue) {
        this.discriminatingValue = discriminatingValue;
    }

    public boolean hasDiscriminatingValue() {
        return this.discriminatingValue != null;
    }

    public String getMappedSchema() {
        return this.mappedSchema;
    }

    public void setMappedSchema(String mappedSchema) {
        this.mappedSchema = mappedSchema;
    }

    public boolean isExplicitMapping() {
        return this.explicitMapping;
    }

    public void setExplicitMapping(boolean explicitMapping) {
        this.explicitMapping = explicitMapping;
    }

    public void setMatchedSchema(String matchedSchema) {
        this.matchedSchema = matchedSchema;
    }

    public String getMatchedSchema() {
        return this.matchedSchema;
    }

    public boolean hasMatchedSchema() {
        return this.matchedSchema != null;
    }

    private static boolean isImplicitMatch(String refSchema, String mappedSchema) {
        if (mappedSchema.startsWith(".")) {
            return refSchema.equals(mappedSchema);
        }
        int found = refSchema.lastIndexOf(47);
        if (found == -1) {
            return refSchema.equals(mappedSchema);
        }
        return refSchema.substring(found + 1).equals(mappedSchema);
    }
}

