/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core.view;

import com.google.firebase.database.core.Context;
import com.google.firebase.database.core.EventTarget;
import com.google.firebase.database.core.view.Event;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventRaiser {
    private static final Logger logger = LoggerFactory.getLogger(EventRaiser.class);
    private final EventTarget eventTarget;

    public EventRaiser(Context ctx) {
        this.eventTarget = ctx.getEventTarget();
    }

    public void raiseEvents(List<? extends Event> events) {
        logger.debug("Raising {} event(s)", (Object)events.size());
        final ArrayList<? extends Event> eventsClone = new ArrayList<Event>(events);
        this.eventTarget.postEvent(new Runnable(){

            @Override
            public void run() {
                for (Event event : eventsClone) {
                    logger.debug("Raising {}", (Object)event);
                    event.fire();
                }
            }
        });
    }
}

