/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.jdk11.model.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.RecordedClass;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedStackTrace;
import jdk.jfr.consumer.RecordedThread;
import org.graalvm.visualvm.jfr.jdk11.model.impl.DisplayableSupport;
import org.graalvm.visualvm.jfr.jdk11.model.impl.JFRJDK11Class;
import org.graalvm.visualvm.jfr.jdk11.model.impl.JFRJDK11StackTrace;
import org.graalvm.visualvm.jfr.jdk11.model.impl.JFRJDK11Thread;
import org.graalvm.visualvm.jfr.model.JFRClass;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.model.JFRStackTrace;
import org.graalvm.visualvm.jfr.model.JFRThread;

final class JFRJDK11Event
extends JFREvent {
    protected final RecordedEvent event;

    public JFRJDK11Event(RecordedEvent event, long id) {
        super(id);
        this.event = event;
    }

    public JFRClass getClass(String key) throws JFRPropertyNotAvailableException {
        Object rclass = this.getValue(key);
        if (rclass == null) {
            return null;
        }
        if (rclass instanceof RecordedClass) {
            return new JFRJDK11Class((RecordedClass)rclass);
        }
        throw new JFRPropertyNotAvailableException("No class value available: " + key);
    }

    public JFRThread getThread(String key) throws JFRPropertyNotAvailableException {
        if ("eventThread".equals(key)) {
            RecordedThread thread = this.event.getThread();
            return thread == null ? null : new JFRJDK11Thread(thread);
        }
        Object thread = this.getValue(key);
        if (thread instanceof RecordedThread) {
            return new JFRJDK11Thread((RecordedThread)thread);
        }
        if (thread == null) {
            return null;
        }
        throw new JFRPropertyNotAvailableException("No thread value available: " + key);
    }

    public JFRStackTrace getStackTrace(String key) throws JFRPropertyNotAvailableException {
        if ("eventStackTrace".equals(key)) {
            RecordedStackTrace stackTrace = this.event.getStackTrace();
            return stackTrace == null ? null : new JFRJDK11StackTrace(stackTrace);
        }
        Object stackTrace = this.getValue(key);
        if (stackTrace instanceof RecordedStackTrace) {
            return new JFRJDK11StackTrace((RecordedStackTrace)stackTrace);
        }
        if (stackTrace == null) {
            return null;
        }
        throw new JFRPropertyNotAvailableException("No stacktrace value available: " + key);
    }

    public Object getValue(String key) throws JFRPropertyNotAvailableException {
        try {
            return this.event.getValue(key);
        }
        catch (IllegalArgumentException e) {
            throw new JFRPropertyNotAvailableException((Throwable)e);
        }
    }

    public List<Comparable<?>> getDisplayableValues(boolean includeExperimental) {
        ArrayList values = new ArrayList();
        Iterator<ValueDescriptor> descriptors = DisplayableSupport.displayableValueDescriptors(this.event.getEventType(), includeExperimental);
        while (descriptors.hasNext()) {
            values.add(DisplayableSupport.getDisplayValue(this, descriptors.next()));
        }
        return values;
    }

    public boolean getBoolean(String key) throws JFRPropertyNotAvailableException {
        try {
            return this.event.getBoolean(key);
        }
        catch (IllegalArgumentException e) {
            throw new JFRPropertyNotAvailableException((Throwable)e);
        }
    }

    public byte getByte(String key) throws JFRPropertyNotAvailableException {
        try {
            return this.event.getByte(key);
        }
        catch (IllegalArgumentException e) {
            throw new JFRPropertyNotAvailableException((Throwable)e);
        }
    }

    public char getChar(String key) throws JFRPropertyNotAvailableException {
        try {
            return this.event.getChar(key);
        }
        catch (IllegalArgumentException e) {
            throw new JFRPropertyNotAvailableException((Throwable)e);
        }
    }

    public double getDouble(String key) throws JFRPropertyNotAvailableException {
        try {
            return this.event.getDouble(key);
        }
        catch (IllegalArgumentException e) {
            throw new JFRPropertyNotAvailableException((Throwable)e);
        }
    }

    public float getFloat(String key) throws JFRPropertyNotAvailableException {
        try {
            return this.event.getFloat(key);
        }
        catch (IllegalArgumentException e) {
            throw new JFRPropertyNotAvailableException((Throwable)e);
        }
    }

    public int getInt(String key) throws JFRPropertyNotAvailableException {
        try {
            return this.event.getInt(key);
        }
        catch (IllegalArgumentException e) {
            throw new JFRPropertyNotAvailableException((Throwable)e);
        }
    }

    public long getLong(String key) throws JFRPropertyNotAvailableException {
        try {
            return this.event.getLong(key);
        }
        catch (IllegalArgumentException e) {
            throw new JFRPropertyNotAvailableException((Throwable)e);
        }
    }

    public short getShort(String key) throws JFRPropertyNotAvailableException {
        try {
            return this.event.getShort(key);
        }
        catch (IllegalArgumentException e) {
            throw new JFRPropertyNotAvailableException((Throwable)e);
        }
    }

    public String getString(String key) throws JFRPropertyNotAvailableException {
        try {
            return this.event.getString(key);
        }
        catch (IllegalArgumentException e) {
            throw new JFRPropertyNotAvailableException((Throwable)e);
        }
    }

    public Instant getInstant(String key) throws JFRPropertyNotAvailableException {
        switch (key) {
            case "eventTime": 
            case "startTime": {
                return this.event.getStartTime();
            }
            case "endTime": {
                return this.event.getEndTime();
            }
        }
        try {
            return this.event.getInstant(key);
        }
        catch (IllegalArgumentException e) {
            throw new JFRPropertyNotAvailableException((Throwable)e);
        }
    }

    public Duration getDuration(String key) throws JFRPropertyNotAvailableException {
        if ("eventDuration".equals(key)) {
            return this.event.getDuration();
        }
        try {
            return this.event.getDuration(key);
        }
        catch (IllegalArgumentException e) {
            throw new JFRPropertyNotAvailableException((Throwable)e);
        }
    }

    public int hashCode() {
        return this.event.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof JFRJDK11Event && this.event.equals(((JFRJDK11Event)((Object)o)).event);
    }
}

