/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.json;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.List;
import nu.validator.json.JsonHandler;
import org.xml.sax.SAXException;

public class Serializer
implements JsonHandler {
    private final List<State> stack = new ArrayList<State>();
    private boolean hadCallback = false;
    private boolean first = false;
    private final Writer writer;

    private static Writer newOutputStreamWriter(OutputStream out) {
        CharsetEncoder enc = Charset.forName("UTF-8").newEncoder();
        enc.onMalformedInput(CodingErrorAction.REPLACE);
        enc.onUnmappableCharacter(CodingErrorAction.REPLACE);
        return new OutputStreamWriter(out, enc);
    }

    public Serializer(OutputStream out) {
        this.writer = Serializer.newOutputStreamWriter(out);
        this.push(State.INITIAL);
    }

    private void push(State state) {
        this.stack.add(state);
    }

    private void pop() {
        this.stack.remove(this.stack.size() - 1);
    }

    private State peek() {
        int size = this.stack.size();
        if (size == 0) {
            return null;
        }
        return this.stack.get(size - 1);
    }

    @Override
    public void bool(boolean bool) throws SAXException {
        try {
            State state = this.peek();
            switch (state.ordinal()) {
                case 2: {
                    if (!this.first) {
                        this.writer.write(44);
                    }
                }
                case 1: 
                case 4: {
                    this.writer.write(Boolean.toString(bool));
                    if (state == State.VALUE) {
                        this.pop();
                    }
                    this.first = false;
                    break;
                }
                default: {
                    throw new SAXException("Illegal state for callback.");
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    private void charactersImpl(char[] ch, int start, int length) throws IOException {
        int s = start;
        int end = start + length;
        block9: for (int i = start; i < end; ++i) {
            char c = ch[i];
            if (c > '\u001f' && c != '\"' && c != '\\') continue;
            if (s < i) {
                this.writer.write(ch, s, i - s);
            }
            s = i + 1;
            this.writer.write(92);
            switch (c) {
                case '\"': {
                    this.writer.write(34);
                    continue block9;
                }
                case '\\': {
                    this.writer.write(92);
                    continue block9;
                }
                case '\b': {
                    this.writer.write(98);
                    continue block9;
                }
                case '\f': {
                    this.writer.write(102);
                    continue block9;
                }
                case '\n': {
                    this.writer.write(110);
                    continue block9;
                }
                case '\r': {
                    this.writer.write(114);
                    continue block9;
                }
                case '\t': {
                    this.writer.write(116);
                    continue block9;
                }
                default: {
                    String hex = Integer.toHexString(c);
                    if (hex.length() == 1) {
                        this.writer.write("u000");
                        this.writer.write(hex);
                        continue block9;
                    }
                    this.writer.write("u00");
                    this.writer.write(hex);
                }
            }
        }
        if (s < end) {
            this.writer.write(ch, s, end - s);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            State state = this.peek();
            switch (state.ordinal()) {
                case 5: {
                    this.charactersImpl(ch, start, length);
                    break;
                }
                default: {
                    throw new SAXException("Illegal state for callback.");
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endArray() throws SAXException {
        try {
            State state = this.peek();
            switch (state.ordinal()) {
                case 2: {
                    this.writer.write(93);
                    this.pop();
                    this.first = false;
                    if (this.peek() == State.VALUE) {
                        this.pop();
                    }
                    break;
                }
                default: {
                    throw new SAXException("Illegal state for callback.");
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            State state = this.peek();
            switch (state.ordinal()) {
                case 1: {
                    if (this.hadCallback) {
                        this.writer.write(41);
                    }
                    this.writer.write(10);
                    this.writer.flush();
                    this.writer.close();
                    this.pop();
                    break;
                }
                default: {
                    throw new SAXException("Illegal state for callback.");
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endObject() throws SAXException {
        try {
            State state = this.peek();
            switch (state.ordinal()) {
                case 3: {
                    this.writer.write(125);
                    this.writer.flush();
                    this.pop();
                    this.first = false;
                    if (this.peek() == State.VALUE) {
                        this.pop();
                    }
                    break;
                }
                default: {
                    throw new SAXException("Illegal state for callback.");
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endString() throws SAXException {
        try {
            State state = this.peek();
            switch (state.ordinal()) {
                case 5: {
                    this.writer.write(34);
                    this.pop();
                    this.first = false;
                    if (this.peek() == State.VALUE) {
                        this.pop();
                    }
                    break;
                }
                default: {
                    throw new SAXException("Illegal state for callback.");
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void key(String key) throws SAXException {
        try {
            State state = this.peek();
            switch (state.ordinal()) {
                case 3: {
                    if (!this.first) {
                        this.writer.write(44);
                    }
                    this.writer.write(34);
                    this.charactersImpl(key.toCharArray(), 0, key.length());
                    this.writer.write(34);
                    this.writer.write(58);
                    this.push(State.VALUE);
                    break;
                }
                default: {
                    throw new SAXException("Illegal state for callback.");
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void number(int number) throws SAXException {
        try {
            State state = this.peek();
            switch (state.ordinal()) {
                case 2: {
                    if (!this.first) {
                        this.writer.write(44);
                    }
                }
                case 1: 
                case 4: {
                    this.writer.write(Integer.toString(number));
                    if (state == State.VALUE) {
                        this.pop();
                    }
                    this.first = false;
                    break;
                }
                default: {
                    throw new SAXException("Illegal state for callback.");
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void number(long number) throws SAXException {
        try {
            State state = this.peek();
            switch (state.ordinal()) {
                case 2: {
                    if (!this.first) {
                        this.writer.write(44);
                    }
                }
                case 1: 
                case 4: {
                    this.writer.write(Long.toString(number));
                    if (state == State.VALUE) {
                        this.pop();
                    }
                    this.first = false;
                    break;
                }
                default: {
                    throw new SAXException("Illegal state for callback.");
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void number(float number) throws SAXException {
        try {
            State state = this.peek();
            switch (state.ordinal()) {
                case 2: {
                    if (!this.first) {
                        this.writer.write(44);
                    }
                }
                case 1: 
                case 4: {
                    this.writer.write(Float.toString(number));
                    if (state == State.VALUE) {
                        this.pop();
                    }
                    this.first = false;
                    break;
                }
                default: {
                    throw new SAXException("Illegal state for callback.");
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void number(double number) throws SAXException {
        try {
            State state = this.peek();
            switch (state.ordinal()) {
                case 2: {
                    if (!this.first) {
                        this.writer.write(44);
                    }
                }
                case 1: 
                case 4: {
                    this.writer.write(Double.toString(number));
                    if (state == State.VALUE) {
                        this.pop();
                    }
                    this.first = false;
                    break;
                }
                default: {
                    throw new SAXException("Illegal state for callback.");
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void startArray() throws SAXException {
        try {
            State state = this.peek();
            switch (state.ordinal()) {
                case 2: {
                    if (!this.first) {
                        this.writer.write(44);
                    }
                }
                case 1: 
                case 4: {
                    this.writer.write(91);
                    this.push(State.ARRAY);
                    this.first = true;
                    break;
                }
                default: {
                    throw new SAXException("Illegal state for callback.");
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void startDocument(String callback) throws SAXException {
        try {
            State state = this.peek();
            switch (state.ordinal()) {
                case 0: {
                    if (callback == null) {
                        this.hadCallback = false;
                    } else {
                        this.hadCallback = true;
                        this.writer.write(callback);
                        this.writer.write(40);
                    }
                    this.push(State.DOCUMENT);
                    this.first = true;
                    break;
                }
                default: {
                    throw new SAXException("Illegal state for callback.");
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void startObject() throws SAXException {
        try {
            State state = this.peek();
            switch (state.ordinal()) {
                case 2: {
                    if (!this.first) {
                        this.writer.write(44);
                    }
                }
                case 1: 
                case 4: {
                    this.writer.write(123);
                    this.push(State.OBJECT);
                    this.first = true;
                    break;
                }
                default: {
                    throw new SAXException("Illegal state for callback.");
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void startString() throws SAXException {
        try {
            State state = this.peek();
            switch (state.ordinal()) {
                case 2: {
                    if (!this.first) {
                        this.writer.write(44);
                    }
                }
                case 1: 
                case 4: {
                    this.writer.write(34);
                    this.push(State.STRING);
                    break;
                }
                default: {
                    throw new SAXException("Illegal state for callback.");
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void string(String string) throws SAXException {
        try {
            State state = this.peek();
            switch (state.ordinal()) {
                case 2: {
                    if (!this.first) {
                        this.writer.write(44);
                    }
                }
                case 1: 
                case 4: {
                    if (string == null) {
                        this.writer.write("null");
                    } else {
                        this.writer.write(34);
                        this.charactersImpl(string.toCharArray(), 0, string.length());
                        this.writer.write(34);
                    }
                    if (state == State.VALUE) {
                        this.pop();
                    }
                    this.first = false;
                    break;
                }
                default: {
                    throw new SAXException("Illegal state for callback.");
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    private static enum State {
        INITIAL,
        DOCUMENT,
        ARRAY,
        OBJECT,
        VALUE,
        STRING;

    }
}

