<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::table('wireless_sensors', function (Blueprint $table) {
            $table->foreign('device_id')->references('device_id')->on('devices')->onUpdate('RESTRICT')->onDelete('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        if (LibreNMS\DB\Eloquent::getDriver() !== 'sqlite') {
            Schema::table('wireless_sensors', function (Blueprint $table) {
                $table->dropForeign('wireless_sensors_device_id_foreign');
            });
        }
    }
};
