/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.geom.GeneralPath;
import java.util.Collection;
import java.util.Collections;
import javax.swing.event.EventListenerList;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.draw.HandleEvent;
import org.jhotdraw.draw.HandleListener;

public abstract class AbstractHandle
implements Handle,
FigureListener {
    private final Figure owner;
    protected DrawingView view;
    private String toolTipText;
    protected EventListenerList listenerList = new EventListenerList();
    private Rectangle bounds;

    public AbstractHandle(Figure figure) {
        if (figure == null) {
            throw new IllegalArgumentException("owner must not be null");
        }
        this.owner = figure;
        figure.addFigureListener(this);
    }

    protected int getHandlesize() {
        return this.getEditor().getHandleAttribute(HandleAttributeKeys.HANDLE_SIZE);
    }

    @Override
    public void addHandleListener(HandleListener handleListener) {
        this.listenerList.add(HandleListener.class, handleListener);
    }

    @Override
    public void removeHandleListener(HandleListener handleListener) {
        this.listenerList.remove(HandleListener.class, handleListener);
    }

    @Override
    public Figure getOwner() {
        return this.owner;
    }

    @Override
    public void setView(DrawingView drawingView) {
        this.view = drawingView;
    }

    public DrawingView getView() {
        return this.view;
    }

    public DrawingEditor getEditor() {
        return this.view.getEditor();
    }

    protected void fireAreaInvalidated(Rectangle rectangle) {
        HandleEvent handleEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != HandleListener.class) continue;
            if (handleEvent == null) {
                handleEvent = new HandleEvent(this, rectangle);
            }
            ((HandleListener)objectArray[i + 1]).areaInvalidated(handleEvent);
        }
    }

    protected void fireUndoableEditHappened(UndoableEdit undoableEdit) {
        this.view.getDrawing().fireUndoableEditHappened(undoableEdit);
    }

    protected void fireHandleRequestRemove(Rectangle rectangle) {
        HandleEvent handleEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != HandleListener.class) continue;
            if (handleEvent == null) {
                handleEvent = new HandleEvent(this, rectangle);
            }
            ((HandleListener)objectArray[i + 1]).handleRequestRemove(handleEvent);
        }
    }

    protected void fireHandleRequestSecondaryHandles() {
        HandleEvent handleEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != HandleListener.class) continue;
            if (handleEvent == null) {
                handleEvent = new HandleEvent(this, null);
            }
            ((HandleListener)objectArray[i + 1]).handleRequestSecondaryHandles(handleEvent);
        }
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        this.drawCircle(graphics2D, this.getEditor().getHandleAttribute(HandleAttributeKeys.HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.HANDLE_STROKE_COLOR));
    }

    protected void drawCircle(Graphics2D graphics2D, Color color, Color color2) {
        Rectangle rectangle = this.getBounds();
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fillOval(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
        }
        if (color2 != null) {
            graphics2D.setStroke(new BasicStroke());
            graphics2D.setColor(color2);
            graphics2D.drawOval(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            if (this.getView().getActiveHandle() == this) {
                graphics2D.fillOval(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
            }
        }
    }

    protected void drawRectangle(Graphics2D graphics2D, Color color, Color color2) {
        Rectangle rectangle;
        if (color != null) {
            rectangle = this.getBounds();
            graphics2D.setColor(color);
            ++rectangle.x;
            ++rectangle.y;
            rectangle.width -= 2;
            rectangle.height -= 2;
            graphics2D.fill(rectangle);
        }
        graphics2D.setStroke(new BasicStroke());
        if (color2 != null) {
            rectangle = this.getBounds();
            --rectangle.width;
            --rectangle.height;
            graphics2D.setColor(color2);
            graphics2D.draw(rectangle);
            if (this.getView().getActiveHandle() == this) {
                rectangle.x += 2;
                rectangle.y += 2;
                rectangle.width -= 3;
                rectangle.height -= 3;
                graphics2D.fill(rectangle);
            }
        }
    }

    protected void drawDiamond(Graphics2D graphics2D, Color color, Color color2) {
        GeneralPath generalPath;
        Rectangle rectangle;
        if (color2 != null) {
            rectangle = this.getBounds();
            rectangle.grow(1, 1);
            generalPath = new GeneralPath();
            generalPath.moveTo((float)rectangle.x + (float)rectangle.width / 2.0f, rectangle.y);
            generalPath.lineTo(rectangle.x + rectangle.width, (float)rectangle.y + (float)rectangle.height / 2.0f);
            generalPath.lineTo((float)rectangle.x + (float)rectangle.width / 2.0f, rectangle.y + rectangle.height);
            generalPath.lineTo(rectangle.x, (float)rectangle.y + (float)rectangle.height / 2.0f);
            generalPath.closePath();
            graphics2D.setColor(color2);
            graphics2D.fill(generalPath);
        }
        if (color != null) {
            rectangle = this.getBounds();
            generalPath = new GeneralPath();
            generalPath.moveTo((float)rectangle.x + (float)rectangle.width / 2.0f, rectangle.y);
            generalPath.lineTo(rectangle.x + rectangle.width, (float)rectangle.y + (float)rectangle.height / 2.0f);
            generalPath.lineTo((float)rectangle.x + (float)rectangle.width / 2.0f, rectangle.y + rectangle.height);
            generalPath.lineTo(rectangle.x, (float)rectangle.y + (float)rectangle.height / 2.0f);
            generalPath.closePath();
            graphics2D.setColor(color);
            graphics2D.fill(generalPath);
        }
        if (color2 != null && this.getView().getActiveHandle() == this) {
            rectangle = this.getBounds();
            rectangle.grow(-1, -1);
            generalPath = new GeneralPath();
            generalPath.moveTo((float)rectangle.x + (float)rectangle.width / 2.0f, rectangle.y);
            generalPath.lineTo(rectangle.x + rectangle.width, (float)rectangle.y + (float)rectangle.height / 2.0f);
            generalPath.lineTo((float)rectangle.x + (float)rectangle.width / 2.0f, rectangle.y + rectangle.height);
            generalPath.lineTo(rectangle.x, (float)rectangle.y + (float)rectangle.height / 2.0f);
            generalPath.closePath();
            graphics2D.setColor(color2);
            graphics2D.fill(generalPath);
        }
    }

    @Override
    public boolean contains(Point point) {
        return this.getBounds().contains(point);
    }

    @Override
    public void invalidate() {
        this.bounds = null;
    }

    @Override
    public void dispose() {
        this.owner.removeFigureListener(this);
    }

    @Override
    public void areaInvalidated(FigureEvent figureEvent) {
        this.updateBounds();
    }

    @Override
    public void figureAdded(FigureEvent figureEvent) {
    }

    @Override
    public void figureRemoved(FigureEvent figureEvent) {
    }

    @Override
    public void figureRequestRemove(FigureEvent figureEvent) {
    }

    @Override
    public void figureChanged(FigureEvent figureEvent) {
        this.updateBounds();
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(13);
    }

    @Override
    public boolean isCombinableWith(Handle handle) {
        return this.getClass().isAssignableFrom(handle.getClass());
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public final Rectangle getBounds() {
        if (this.bounds == null) {
            this.bounds = this.basicGetBounds();
        }
        return (Rectangle)this.bounds.clone();
    }

    @Override
    public Rectangle getDrawingArea() {
        Rectangle rectangle = this.getBounds();
        rectangle.grow(2, 2);
        return rectangle;
    }

    protected abstract Rectangle basicGetBounds();

    protected void updateBounds() {
        Rectangle rectangle = this.basicGetBounds();
        if (this.bounds == null || !rectangle.equals(this.bounds)) {
            if (this.bounds != null) {
                this.fireAreaInvalidated(this.getDrawingArea());
            }
            this.bounds = rectangle;
            this.fireAreaInvalidated(this.getDrawingArea());
        }
    }

    @Override
    public void trackDoubleClick(Point point, int n) {
    }

    @Override
    public void attributeChanged(FigureEvent figureEvent) {
    }

    @Override
    public void viewTransformChanged() {
        this.invalidate();
    }

    @Override
    public Collection<Handle> createSecondaryHandles() {
        return Collections.emptyList();
    }

    @Override
    public String getToolTipText(Point point) {
        return this.toolTipText;
    }

    public void setToolTipText(String string) {
        this.toolTipText = string;
    }

    @Override
    public void figureHandlesChanged(FigureEvent figureEvent) {
    }
}

