/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.action.AttributeAction;

public class EditorColorChooserAction
extends AttributeAction {
    protected AttributeKey<Color> key;
    protected static JColorChooser colorChooser;

    public EditorColorChooserAction(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey) {
        this(drawingEditor, attributeKey, null, null);
    }

    public EditorColorChooserAction(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey, Icon icon) {
        this(drawingEditor, attributeKey, null, icon);
    }

    public EditorColorChooserAction(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey, String string) {
        this(drawingEditor, attributeKey, string, null);
    }

    public EditorColorChooserAction(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey, String string, Icon icon) {
        this(drawingEditor, attributeKey, string, icon, new HashMap<AttributeKey, Object>());
    }

    public EditorColorChooserAction(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey, String string, Icon icon, Map<AttributeKey, Object> map) {
        super(drawingEditor, map, string, icon);
        this.key = attributeKey;
        this.putValue("Name", string);
        this.putValue("SmallIcon", icon);
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (colorChooser == null) {
            colorChooser = new JColorChooser();
        }
        Color color = this.getInitialColor();
        Color color2 = JColorChooser.showDialog((Component)actionEvent.getSource(), this.labels.getString("attribute.color.text"), color);
        if (color2 != null) {
            HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>(this.attributes);
            hashMap.put(this.key, color2);
            this.applyAttributesTo(hashMap, this.getView().getSelectedFigures());
        }
    }

    public void selectionChanged(FigureSelectionEvent figureSelectionEvent) {
    }

    protected Color getInitialColor() {
        Color color = this.getEditor().getDefaultAttribute(this.key);
        if (color == null) {
            color = Color.red;
        }
        return color;
    }
}

