(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/srfi/133#nonneg-int?
    (lambda (_x2476_) (if (integer? _x2476_) (not (negative? _x2476_)) '#f)))
  (define std/srfi/133#between?
    (lambda (_x2472_ _y2473_ _z2474_)
      (if (< _x2472_ _y2473_) (<= _y2473_ _z2474_) '#f)))
  (define std/srfi/133#unspecified-value (lambda () (if '#f '#f '#!void)))
  (define std/srfi/133#vectors-ref
    (lambda (_vectors2466_ _i2467_)
      (map (lambda (_v2469_) (vector-ref _v2469_ _i2467_)) _vectors2466_)))
  (define std/srfi/133#check-type
    (lambda (_pred?2462_ _value2463_ _callee2464_)
      (if (_pred?2462_ _value2463_)
          _value2463_
          (std/srfi/133#check-type
           _pred?2462_
           (error '"erroneous value"
                  (list _pred?2462_ _value2463_)
                  (cons 'while (cons 'calling (cons _callee2464_ '()))))
           _callee2464_))))
  (define std/srfi/133#check-index
    (lambda (_vec2456_ _index2457_ _callee2458_)
      (let ((_index2460_
             (std/srfi/133#check-type integer? _index2457_ _callee2458_)))
        (if (< _index2460_ '0)
            (std/srfi/133#check-index
             _vec2456_
             (error '"vector index too low"
                    _index2460_
                    (cons 'into (cons 'vector (cons _vec2456_ '())))
                    (cons 'while (cons 'calling (cons _callee2458_ '()))))
             _callee2458_)
            (if (>= _index2460_ (vector-length _vec2456_))
                (std/srfi/133#check-index
                 _vec2456_
                 (error '"vector index too high"
                        _index2460_
                        (cons 'into (cons 'vector (cons _vec2456_ '())))
                        (cons 'while (cons 'calling (cons _callee2458_ '()))))
                 _callee2458_)
                _index2460_)))))
  (define std/srfi/133#check-indices
    (lambda (_vec2440_
             _start2441_
             _start-name2442_
             _end2443_
             _end-name2444_
             _callee2445_)
      (let ((_lose2449_
             (lambda _things2447_
               (apply error
                      '"vector range out of bounds"
                      (append _things2447_
                              (cons 'vector (cons 'was (cons _vec2440_ '())))
                              (cons _start-name2442_
                                    (cons 'was (cons _start2441_ '())))
                              (cons _end-name2444_
                                    (cons 'was (cons _end2443_ '())))
                              (cons 'while
                                    (cons 'calling
                                          (cons _callee2445_ '())))))))
            (_start2450_
             (std/srfi/133#check-type integer? _start2441_ _callee2445_))
            (_end2451_
             (std/srfi/133#check-type integer? _end2443_ _callee2445_)))
        (if (> _start2450_ _end2451_)
            (let ((_g6249_ (_lose2449_
                            (cons _end-name2444_
                                  (cons '< (cons _start-name2442_ '()))))))
              (begin
                (let ((_g6250_ (let ()
                                 (declare (not safe))
                                 (if (##values? _g6249_)
                                     (##vector-length _g6249_)
                                     1))))
                  (if (not (let () (declare (not safe)) (##fx= _g6250_ 2)))
                      (error "Context expects 2 values" _g6250_)))
                (let ((_new-start2453_
                       (let () (declare (not safe)) (##vector-ref _g6249_ 0)))
                      (_new-end2454_
                       (let () (declare (not safe)) (##vector-ref _g6249_ 1))))
                  (std/srfi/133#check-indices
                   _vec2440_
                   _new-start2453_
                   _start-name2442_
                   _new-end2454_
                   _end-name2444_
                   _callee2445_))))
            (if (< _start2450_ '0)
                (std/srfi/133#check-indices
                 _vec2440_
                 (_lose2449_ (cons _start-name2442_ (cons '< (cons '0 '()))))
                 _start-name2442_
                 _end2451_
                 _end-name2444_
                 _callee2445_)
                (if (>= _start2450_ (vector-length _vec2440_))
                    (std/srfi/133#check-indices
                     _vec2440_
                     (_lose2449_
                      (cons _start-name2442_ (cons '> (cons 'len '())))
                      (cons 'len
                            (cons 'was (cons (vector-length _vec2440_) '()))))
                     _start-name2442_
                     _end2451_
                     _end-name2444_
                     _callee2445_)
                    (if (> _end2451_ (vector-length _vec2440_))
                        (std/srfi/133#check-indices
                         _vec2440_
                         _start2450_
                         _start-name2442_
                         (_lose2449_
                          (cons _end-name2444_ (cons '> (cons 'len '())))
                          (cons 'len
                                (cons 'was
                                      (cons (vector-length _vec2440_) '()))))
                         _end-name2444_
                         _callee2445_)
                        (values _start2450_ _end2451_))))))))
  (define std/srfi/133#vector-parse-start+end
    (lambda (_vec2432_ _args2433_ _start-name2434_ _end-name2435_ _callee2436_)
      (let ((_len2438_ (vector-length _vec2432_)))
        (if (null? _args2433_)
            (values '0 _len2438_)
            (if (null? (cdr _args2433_))
                (std/srfi/133#check-indices
                 _vec2432_
                 (car _args2433_)
                 _start-name2434_
                 _len2438_
                 _end-name2435_
                 _callee2436_)
                (if (null? (cddr _args2433_))
                    (std/srfi/133#check-indices
                     _vec2432_
                     (car _args2433_)
                     _start-name2434_
                     (cadr _args2433_)
                     _end-name2435_
                     _callee2436_)
                    (error '"too many arguments"
                           (cons 'extra
                                 (cons 'args
                                       (cons 'were
                                             (cons (cddr _args2433_) '()))))
                           (cons 'while
                                 (cons 'calling
                                       (cons _callee2436_ '()))))))))))
  (define std/srfi/133#%smallest-length
    (letrec ((_loop2426_
              (lambda (_vector-list2428_ _length2429_ _callee2430_)
                (if (null? _vector-list2428_)
                    _length2429_
                    (_loop2426_
                     (cdr _vector-list2428_)
                     (min (vector-length
                           (std/srfi/133#check-type
                            vector?
                            (car _vector-list2428_)
                            _callee2430_))
                          _length2429_)
                     _callee2430_)))))
      _loop2426_))
  (define std/srfi/133#%vector-copy!
    (letrec ((_loop/l->r2405_
              (lambda (_target2408_ _source2409_ _send2410_ _i2411_ _j2412_)
                (if (< _i2411_ _send2410_)
                    (begin
                      (vector-set!
                       _target2408_
                       _j2412_
                       (vector-ref _source2409_ _i2411_))
                      (_loop/l->r2405_
                       _target2408_
                       _source2409_
                       _send2410_
                       (+ _i2411_ '1)
                       (+ _j2412_ '1)))
                    '#!void)))
             (_loop/r->l2406_
              (lambda (_target2414_ _source2415_ _sstart2416_ _i2417_ _j2418_)
                (if (>= _i2417_ _sstart2416_)
                    (begin
                      (vector-set!
                       _target2414_
                       _j2418_
                       (vector-ref _source2415_ _i2417_))
                      (_loop/r->l2406_
                       _target2414_
                       _source2415_
                       _sstart2416_
                       (- _i2417_ '1)
                       (- _j2418_ '1)))
                    '#!void))))
      (lambda (_target2420_ _tstart2421_ _source2422_ _sstart2423_ _send2424_)
        (if (> _sstart2423_ _tstart2421_)
            (_loop/l->r2405_
             _target2420_
             _source2422_
             _send2424_
             _sstart2423_
             _tstart2421_)
            (_loop/r->l2406_
             _target2420_
             _source2422_
             _sstart2423_
             (- _send2424_ '1)
             (+ '-1 _tstart2421_ _send2424_ (- _sstart2423_)))))))
  (define std/srfi/133#%vector-reverse-copy!
    (letrec ((_loop2391_
              (lambda (_target2393_ _source2394_ _sstart2395_ _i2396_ _j2397_)
                (if (>= _i2396_ _sstart2395_)
                    (begin
                      (vector-set!
                       _target2393_
                       _j2397_
                       (vector-ref _source2394_ _i2396_))
                      (_loop2391_
                       _target2393_
                       _source2394_
                       _sstart2395_
                       (- _i2396_ '1)
                       (+ _j2397_ '1)))
                    '#!void))))
      (lambda (_target2399_ _tstart2400_ _source2401_ _sstart2402_ _send2403_)
        (_loop2391_
         _target2399_
         _source2401_
         _sstart2402_
         (- _send2403_ '1)
         _tstart2400_))))
  (define std/srfi/133#%vector-reverse!
    (letrec ((_loop2379_
              (lambda (_vec2381_ _i2382_ _j2383_)
                (if (<= _i2382_ _j2383_)
                    (let ((_v2385_ (vector-ref _vec2381_ _i2382_)))
                      (vector-set!
                       _vec2381_
                       _i2382_
                       (vector-ref _vec2381_ _j2383_))
                      (vector-set! _vec2381_ _j2383_ _v2385_)
                      (_loop2379_ _vec2381_ (+ _i2382_ '1) (- _j2383_ '1)))
                    '#!void))))
      (lambda (_vec2387_ _start2388_ _end2389_)
        (_loop2379_ _vec2387_ _start2388_ (- _end2389_ '1)))))
  (define std/srfi/133#%vector-fold1
    (letrec ((_loop2366_
              (lambda (_kons2368_ _knil2369_ _len2370_ _vec2371_ _i2372_)
                (if (= _i2372_ _len2370_)
                    _knil2369_
                    (_loop2366_
                     _kons2368_
                     (_kons2368_ _knil2369_ (vector-ref _vec2371_ _i2372_))
                     _len2370_
                     _vec2371_
                     (+ _i2372_ '1))))))
      (lambda (_kons2374_ _knil2375_ _len2376_ _vec2377_)
        (_loop2366_ _kons2374_ _knil2375_ _len2376_ _vec2377_ '0))))
  (define std/srfi/133#%vector-fold2+
    (letrec ((_loop2353_
              (lambda (_kons2355_ _knil2356_ _len2357_ _vectors2358_ _i2359_)
                (if (= _i2359_ _len2357_)
                    _knil2356_
                    (_loop2353_
                     _kons2355_
                     (apply _kons2355_
                            _knil2356_
                            (std/srfi/133#vectors-ref _vectors2358_ _i2359_))
                     _len2357_
                     _vectors2358_
                     (+ _i2359_ '1))))))
      (lambda (_kons2361_ _knil2362_ _len2363_ _vectors2364_)
        (_loop2353_ _kons2361_ _knil2362_ _len2363_ _vectors2364_ '0))))
  (define std/srfi/133#%vector-map1!
    (letrec ((_loop2339_
              (lambda (_f2341_ _target2342_ _vec2343_ _i2344_)
                (if (zero? _i2344_)
                    _target2342_
                    (let ((_j2346_ (- _i2344_ '1)))
                      (vector-set!
                       _target2342_
                       _j2346_
                       (_f2341_ (vector-ref _vec2343_ _j2346_)))
                      (_loop2339_ _f2341_ _target2342_ _vec2343_ _j2346_))))))
      (lambda (_f2348_ _target2349_ _vec2350_ _len2351_)
        (_loop2339_ _f2348_ _target2349_ _vec2350_ _len2351_))))
  (define std/srfi/133#%vector-map2+!
    (letrec ((_loop2325_
              (lambda (_f2327_ _target2328_ _vectors2329_ _i2330_)
                (if (zero? _i2330_)
                    _target2328_
                    (let ((_j2332_ (- _i2330_ '1)))
                      (vector-set!
                       _target2328_
                       _j2332_
                       (apply _f2327_
                              (std/srfi/133#vectors-ref
                               _vectors2329_
                               _j2332_)))
                      (_loop2325_
                       _f2327_
                       _target2328_
                       _vectors2329_
                       _j2332_))))))
      (lambda (_f2334_ _target2335_ _vectors2336_ _len2337_)
        (_loop2325_ _f2334_ _target2335_ _vectors2336_ _len2337_))))
  (define std/srfi/133#vector-unfold
    (lambda (_f2319_ _length2320_ . _initial-seeds2321_)
      (letrec* ((_vec2323_ (make-vector _length2320_)))
        (apply std/srfi/133#vector-unfold!
               _f2319_
               _vec2323_
               '0
               _length2320_
               _initial-seeds2321_)
        _vec2323_)))
  (define std/srfi/133#vector-unfold!
    (letrec ((_tabulate!2281_
              (lambda (_f2285_ _vec2286_ _i2287_ _len2288_)
                (if (< _i2287_ _len2288_)
                    (begin
                      (vector-set! _vec2286_ _i2287_ (_f2285_ _i2287_))
                      (_tabulate!2281_
                       _f2285_
                       _vec2286_
                       (+ _i2287_ '1)
                       _len2288_))
                    '#!void)))
             (_unfold1!2282_
              (lambda (_f2290_ _vec2291_ _i2292_ _len2293_ _seed2294_)
                (if (< _i2292_ _len2293_)
                    (let ((_g6251_ (_f2290_ _i2292_ _seed2294_)))
                      (begin
                        (let ((_g6252_ (let ()
                                         (declare (not safe))
                                         (if (##values? _g6251_)
                                             (##vector-length _g6251_)
                                             1))))
                          (if (not (let ()
                                     (declare (not safe))
                                     (##fx= _g6252_ 2)))
                              (error "Context expects 2 values" _g6252_)))
                        (let ((_elt2296_
                               (let ()
                                 (declare (not safe))
                                 (##vector-ref _g6251_ 0)))
                              (_new-seed2297_
                               (let ()
                                 (declare (not safe))
                                 (##vector-ref _g6251_ 1))))
                          (begin
                            (vector-set! _vec2291_ _i2292_ _elt2296_)
                            (_unfold1!2282_
                             _f2290_
                             _vec2291_
                             (+ _i2292_ '1)
                             _len2293_
                             _new-seed2297_)))))
                    '#!void)))
             (_unfold2+!2283_
              (lambda (_f2299_ _vec2300_ _i2301_ _len2302_ _seeds2303_)
                (if (< _i2301_ _len2302_)
                    (let ((_g6253_ (apply _f2299_ _i2301_ _seeds2303_)))
                      (begin
                        (let ((_g6254_ (let ()
                                         (declare (not safe))
                                         (if (##values? _g6253_)
                                             (##vector-length _g6253_)
                                             1))))
                          (if (not (let ()
                                     (declare (not safe))
                                     (##fx>= _g6254_ 1)))
                              (error "Context expects at least 1 values"
                                     _g6254_)))
                        (let ((_elt2305_
                               (let ()
                                 (declare (not safe))
                                 (if (##values? _g6253_)
                                     (##vector-ref _g6253_ 0)
                                     _g6253_)))
                              (_new-seeds2306_
                               (let ()
                                 (declare (not safe))
                                 (if (##values? _g6253_)
                                     (##cdr (##vector->list _g6253_))
                                     '()))))
                          (begin
                            (vector-set! _vec2300_ _i2301_ _elt2305_)
                            (_unfold2+!2283_
                             _f2299_
                             _vec2300_
                             (+ _i2301_ '1)
                             _len2302_
                             _new-seeds2306_)))))
                    '#!void))))
      (lambda (_f2308_ _vec2309_ _start2310_ _end2311_ . _initial-seeds2312_)
        (let ((_f2314_ (std/srfi/133#check-type
                        procedure?
                        _f2308_
                        std/srfi/133#vector-unfold!))
              (_start2315_
               (std/srfi/133#check-type
                std/srfi/133#nonneg-int?
                _start2310_
                std/srfi/133#vector-unfold!))
              (_end2316_
               (std/srfi/133#check-type
                std/srfi/133#nonneg-int?
                _end2311_
                std/srfi/133#vector-unfold!)))
          (let ()
            (if (null? _initial-seeds2312_)
                (_tabulate!2281_ _f2314_ _vec2309_ _start2315_ _end2316_)
                (if (null? (cdr _initial-seeds2312_))
                    (_unfold1!2282_
                     _f2314_
                     _vec2309_
                     _start2315_
                     _end2316_
                     (car _initial-seeds2312_))
                    (_unfold2+!2283_
                     _f2314_
                     _vec2309_
                     _start2315_
                     _end2316_
                     _initial-seeds2312_))))))))
  (define std/srfi/133#vector-unfold-right
    (lambda (_f2275_ _len2276_ . _initial-seeds2277_)
      (letrec* ((_vec2279_ (make-vector _len2276_)))
        (apply std/srfi/133#vector-unfold-right!
               _f2275_
               _vec2279_
               '0
               _len2276_
               _initial-seeds2277_)
        _vec2279_)))
  (define std/srfi/133#vector-unfold-right!
    (lambda (_f2239_ _vec2240_ _start2241_ _end2242_ . _initial-seeds2243_)
      (letrec ((_tabulate!2245_
                (lambda (_f2249_ _vec2250_ _i2251_)
                  (if (>= _i2251_ _start2241_)
                      (begin
                        (vector-set! _vec2250_ _i2251_ (_f2249_ _i2251_))
                        (_tabulate!2245_ _f2249_ _vec2250_ (- _i2251_ '1)))
                      '#!void)))
               (_unfold1!2246_
                (lambda (_f2253_ _vec2254_ _i2255_ _seed2256_)
                  (if (>= _i2255_ _start2241_)
                      (let ((_g6255_ (_f2253_ _i2255_ _seed2256_)))
                        (begin
                          (let ((_g6256_ (let ()
                                           (declare (not safe))
                                           (if (##values? _g6255_)
                                               (##vector-length _g6255_)
                                               1))))
                            (if (not (let ()
                                       (declare (not safe))
                                       (##fx= _g6256_ 2)))
                                (error "Context expects 2 values" _g6256_)))
                          (let ((_elt2258_
                                 (let ()
                                   (declare (not safe))
                                   (##vector-ref _g6255_ 0)))
                                (_new-seed2259_
                                 (let ()
                                   (declare (not safe))
                                   (##vector-ref _g6255_ 1))))
                            (begin
                              (vector-set! _vec2254_ _i2255_ _elt2258_)
                              (_unfold1!2246_
                               _f2253_
                               _vec2254_
                               (- _i2255_ '1)
                               _new-seed2259_)))))
                      '#!void)))
               (_unfold2+!2247_
                (lambda (_f2261_ _vec2262_ _i2263_ _seeds2264_)
                  (if (>= _i2263_ _start2241_)
                      (let ((_g6257_ (apply _f2261_ _i2263_ _seeds2264_)))
                        (begin
                          (let ((_g6258_ (let ()
                                           (declare (not safe))
                                           (if (##values? _g6257_)
                                               (##vector-length _g6257_)
                                               1))))
                            (if (not (let ()
                                       (declare (not safe))
                                       (##fx>= _g6258_ 1)))
                                (error "Context expects at least 1 values"
                                       _g6258_)))
                          (let ((_elt2266_
                                 (let ()
                                   (declare (not safe))
                                   (if (##values? _g6257_)
                                       (##vector-ref _g6257_ 0)
                                       _g6257_)))
                                (_new-seeds2267_
                                 (let ()
                                   (declare (not safe))
                                   (if (##values? _g6257_)
                                       (##cdr (##vector->list _g6257_))
                                       '()))))
                            (begin
                              (vector-set! _vec2262_ _i2263_ _elt2266_)
                              (_unfold2+!2247_
                               _f2261_
                               _vec2262_
                               (- _i2263_ '1)
                               _new-seeds2267_)))))
                      '#!void))))
        (let ((_f2269_ (std/srfi/133#check-type
                        procedure?
                        _f2239_
                        std/srfi/133#vector-unfold-right!))
              (_start2270_
               (std/srfi/133#check-type
                std/srfi/133#nonneg-int?
                _start2241_
                std/srfi/133#vector-unfold-right!))
              (_end2271_
               (std/srfi/133#check-type
                std/srfi/133#nonneg-int?
                _end2242_
                std/srfi/133#vector-unfold-right!)))
          (let ((_i2273_ (- _end2271_ '1)))
            (if (null? _initial-seeds2243_)
                (_tabulate!2245_ _f2269_ _vec2240_ _i2273_)
                (if (null? (cdr _initial-seeds2243_))
                    (_unfold1!2246_
                     _f2269_
                     _vec2240_
                     _i2273_
                     (car _initial-seeds2243_))
                    (_unfold2+!2247_
                     _f2269_
                     _vec2240_
                     _i2273_
                     _initial-seeds2243_))))))))
  (define std/srfi/133#vector-copy
    (lambda (_vec2228_ . _args2229_)
      (let* ((_vec2231_
              (std/srfi/133#check-type
               vector?
               _vec2228_
               std/srfi/133#vector-copy))
             (_g6259_ (std/srfi/133#vector-copy:parse-args
                       _vec2231_
                       _args2229_)))
        (begin
          (let ((_g6260_ (let ()
                           (declare (not safe))
                           (if (##values? _g6259_)
                               (##vector-length _g6259_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g6260_ 3)))
                (error "Context expects 3 values" _g6260_)))
          (let ((_start2233_
                 (let () (declare (not safe)) (##vector-ref _g6259_ 0)))
                (_end2234_
                 (let () (declare (not safe)) (##vector-ref _g6259_ 1)))
                (_fill2235_
                 (let () (declare (not safe)) (##vector-ref _g6259_ 2))))
            (let ((_new-vector2237_
                   (make-vector (- _end2234_ _start2233_) _fill2235_)))
              (std/srfi/133#%vector-copy!
               _new-vector2237_
               '0
               _vec2231_
               _start2233_
               (if (> _end2234_ (vector-length _vec2231_))
                   (vector-length _vec2231_)
                   _end2234_))
              _new-vector2237_))))))
  (define std/srfi/133#vector-copy:parse-args
    (lambda (_vec2213_ _args2214_)
      (letrec ((_parse-args2216_
                (lambda (_start2220_ _end2221_ _n2222_ _fill2223_)
                  (let ((_start2225_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _start2220_
                          std/srfi/133#vector-copy))
                        (_end2226_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _end2221_
                          std/srfi/133#vector-copy)))
                    (if (and (<= '0 _start2225_ _end2226_)
                             (<= _start2225_ _n2222_))
                        (values _start2225_ _end2226_ _fill2223_)
                        (error '"illegal arguments"
                               (cons 'while
                                     (cons 'calling
                                           (cons std/srfi/133#vector-copy
                                                 '())))
                               (cons 'start (cons 'was (cons _start2225_ '())))
                               (cons 'end (cons 'was (cons _end2226_ '())))
                               (cons 'vector
                                     (cons 'was (cons _vec2213_ '())))))))))
        (let ((_n2218_ (vector-length _vec2213_)))
          (if (null? _args2214_)
              (_parse-args2216_
               '0
               _n2218_
               _n2218_
               (std/srfi/133#unspecified-value))
              (if (null? (cdr _args2214_))
                  (_parse-args2216_
                   (car _args2214_)
                   _n2218_
                   _n2218_
                   (std/srfi/133#unspecified-value))
                  (if (null? (cddr _args2214_))
                      (_parse-args2216_
                       (car _args2214_)
                       (cadr _args2214_)
                       _n2218_
                       (std/srfi/133#unspecified-value))
                      (if (null? (cdddr _args2214_))
                          (_parse-args2216_
                           (car _args2214_)
                           (cadr _args2214_)
                           _n2218_
                           (caddr _args2214_))
                          (error '"too many arguments"
                                 std/srfi/133#vector-copy
                                 (cdddr _args2214_))))))))))
  (define std/srfi/133#vector-reverse-copy
    (lambda (_vec2203_ . _maybe-start+end2204_)
      (let* ((_vec2206_
              (std/srfi/133#check-type
               vector?
               _vec2203_
               std/srfi/133#vector-reverse-copy))
             (_g6261_ (std/srfi/133#vector-parse-start+end
                       _vec2206_
                       _maybe-start+end2204_
                       'start
                       'end
                       std/srfi/133#vector-reverse-copy)))
        (begin
          (let ((_g6262_ (let ()
                           (declare (not safe))
                           (if (##values? _g6261_)
                               (##vector-length _g6261_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g6262_ 2)))
                (error "Context expects 2 values" _g6262_)))
          (let ((_start2208_
                 (let () (declare (not safe)) (##vector-ref _g6261_ 0)))
                (_end2209_
                 (let () (declare (not safe)) (##vector-ref _g6261_ 1))))
            (let ((_new2211_ (make-vector (- _end2209_ _start2208_))))
              (std/srfi/133#%vector-reverse-copy!
               _new2211_
               '0
               _vec2206_
               _start2208_
               _end2209_)
              _new2211_))))))
  (define std/srfi/133#vector-append
    (lambda _vectors2201_
      (std/srfi/133#vector-concatenate:aux
       _vectors2201_
       std/srfi/133#vector-append)))
  (define std/srfi/133#vector-concatenate
    (lambda (_vector-list2199_)
      (std/srfi/133#vector-concatenate:aux
       _vector-list2199_
       std/srfi/133#vector-concatenate)))
  (define std/srfi/133#vector-concatenate:aux
    (letrec ((_compute-length2169_
              (lambda (_vectors2172_ _len2173_ _callee2174_)
                (if (null? _vectors2172_)
                    _len2173_
                    (let ((_vec2176_
                           (std/srfi/133#check-type
                            vector?
                            (car _vectors2172_)
                            _callee2174_)))
                      (_compute-length2169_
                       (cdr _vectors2172_)
                       (+ (vector-length _vec2176_) _len2173_)
                       _callee2174_)))))
             (_concatenate!2170_
              (lambda (_vectors2178_ _target2179_ _to2180_)
                (if (null? _vectors2178_)
                    _target2179_
                    (let* ((_vec12182_ (car _vectors2178_))
                           (_len2184_ (vector-length _vec12182_)))
                      (std/srfi/133#%vector-copy!
                       _target2179_
                       _to2180_
                       _vec12182_
                       '0
                       _len2184_)
                      (_concatenate!2170_
                       (cdr _vectors2178_)
                       _target2179_
                       (+ _to2180_ _len2184_)))))))
      (lambda (_vectors2187_ _callee2188_)
        (if (null? _vectors2187_)
            (make-vector '0)
            (if (null? (cdr _vectors2187_))
                (let* ((_vec2190_
                        (std/srfi/133#check-type
                         vector?
                         (car _vectors2187_)
                         _callee2188_))
                       (_len2192_ (vector-length _vec2190_))
                       (_new2194_ (make-vector _len2192_)))
                  (std/srfi/133#%vector-copy!
                   _new2194_
                   '0
                   _vec2190_
                   '0
                   _len2192_)
                  _new2194_)
                (let ((_new-vector2197_
                       (make-vector
                        (_compute-length2169_ _vectors2187_ '0 _callee2188_))))
                  (_concatenate!2170_ _vectors2187_ _new-vector2197_ '0)
                  _new-vector2197_))))))
  (define std/srfi/133#vector-append-subvectors
    (lambda _args2120_
      (letrec ((_gather-args2122_
                (lambda (_args2160_)
                  (let _loop2162_ ((_args2164_ _args2160_)
                                   (_vecs2165_ '())
                                   (_starts2166_ '())
                                   (_ends2167_ '()))
                    (if (null? _args2164_)
                        (values (reverse _vecs2165_)
                                (reverse _starts2166_)
                                (reverse _ends2167_))
                        (_loop2162_
                         (cdddr _args2164_)
                         (cons (car _args2164_) _vecs2165_)
                         (cons (cadr _args2164_) _starts2166_)
                         (cons (caddr _args2164_) _ends2167_))))))
               (_total-length2123_
                (lambda (_starts2148_ _ends2149_)
                  (let _loop2151_ ((_count2153_ '0)
                                   (_starts2154_ _starts2148_)
                                   (_ends2155_ _ends2149_))
                    (if (null? _starts2154_)
                        _count2153_
                        (let ((_start2157_ (car _starts2154_))
                              (_end2158_ (car _ends2155_)))
                          (_loop2151_
                           (+ _count2153_ (- _end2158_ _start2157_))
                           (cdr _starts2154_)
                           (cdr _ends2155_)))))))
               (_copy-each!2124_
                (lambda (_result2132_ _vecs2133_ _starts2134_ _ends2135_)
                  (let _loop2137_ ((_at2139_ '0)
                                   (_vecs2140_ _vecs2133_)
                                   (_starts2141_ _starts2134_)
                                   (_ends2142_ _ends2135_))
                    (if (null? _vecs2140_)
                        _result2132_
                        (let ((_vec2144_ (car _vecs2140_))
                              (_start2145_ (car _starts2141_))
                              (_end2146_ (car _ends2142_)))
                          (std/srfi/133#%vector-copy!
                           _result2132_
                           _at2139_
                           _vec2144_
                           _start2145_
                           _end2146_)
                          (_loop2137_
                           (+ _at2139_ (- _end2146_ _start2145_))
                           (cdr _vecs2140_)
                           (cdr _starts2141_)
                           (cdr _ends2142_))))))))
        (let ((_g6263_ (_gather-args2122_ _args2120_)))
          (begin
            (let ((_g6264_ (let ()
                             (declare (not safe))
                             (if (##values? _g6263_)
                                 (##vector-length _g6263_)
                                 1))))
              (if (not (let () (declare (not safe)) (##fx= _g6264_ 3)))
                  (error "Context expects 3 values" _g6264_)))
            (let ((_vecs2126_
                   (let () (declare (not safe)) (##vector-ref _g6263_ 0)))
                  (_starts2127_
                   (let () (declare (not safe)) (##vector-ref _g6263_ 1)))
                  (_ends2128_
                   (let () (declare (not safe)) (##vector-ref _g6263_ 2))))
              (letrec* ((_result2130_
                         (make-vector
                          (_total-length2123_ _starts2127_ _ends2128_))))
                (_copy-each!2124_
                 _result2130_
                 _vecs2126_
                 _starts2127_
                 _ends2128_))))))))
  (define std/srfi/133#vector-empty?
    (lambda (_vec2116_)
      (let ((_vec2118_
             (std/srfi/133#check-type
              vector?
              _vec2116_
              std/srfi/133#vector-empty?)))
        (zero? (vector-length _vec2118_)))))
  (define std/srfi/133#vector=
    (lambda (_elt=?2101_ . _vectors2102_)
      (let ((_elt=?2104_
             (std/srfi/133#check-type
              procedure?
              _elt=?2101_
              std/srfi/133#vector=)))
        (if (null? _vectors2102_)
            '#t
            (if (null? (cdr _vectors2102_))
                (begin
                  (std/srfi/133#check-type
                   vector?
                   (car _vectors2102_)
                   std/srfi/133#vector=)
                  '#t)
                (let _loop2106_ ((_vecs2108_ _vectors2102_))
                  (let ((_vec12110_
                         (std/srfi/133#check-type
                          vector?
                          (car _vecs2108_)
                          std/srfi/133#vector=))
                        (_vec2+2111_ (cdr _vecs2108_)))
                    (let ((_$e2113_ (null? _vec2+2111_)))
                      (if _$e2113_
                          _$e2113_
                          (if (std/srfi/133#binary-vector=
                               _elt=?2104_
                               _vec12110_
                               (car _vec2+2111_))
                              (_loop2106_ _vec2+2111_)
                              '#f))))))))))
  (define std/srfi/133#binary-vector=
    (lambda (_elt=?2090_ _vector-a2091_ _vector-b2092_)
      (let ((_length-a2094_ (vector-length _vector-a2091_))
            (_length-b2095_ (vector-length _vector-b2092_)))
        (if (= _length-a2094_ _length-b2095_)
            (let _loop2097_ ((_i2099_ '0))
              (if (= _i2099_ _length-a2094_)
                  '#t
                  (if (_elt=?2090_
                       (vector-ref _vector-a2091_ _i2099_)
                       (vector-ref _vector-b2092_ _i2099_))
                      (_loop2097_ (+ _i2099_ '1))
                      '#f)))
            '#f))))
  (define std/srfi/133#vector-fold
    (lambda (_kons2082_ _knil2083_ _vec2084_ . _vectors2085_)
      (let ((_kons2087_
             (std/srfi/133#check-type
              procedure?
              _kons2082_
              std/srfi/133#vector-fold))
            (_vec2088_
             (std/srfi/133#check-type
              vector?
              _vec2084_
              std/srfi/133#vector-fold)))
        (if (null? _vectors2085_)
            (std/srfi/133#%vector-fold1
             _kons2087_
             _knil2083_
             (vector-length _vec2088_)
             _vec2088_)
            (std/srfi/133#%vector-fold2+
             _kons2087_
             _knil2083_
             (std/srfi/133#%smallest-length
              _vectors2085_
              (vector-length _vec2088_)
              std/srfi/133#vector-fold)
             (cons _vec2088_ _vectors2085_))))))
  (define std/srfi/133#vector-fold-right
    (letrec ((_loop12061_
              (lambda (_kons2064_ _knil2065_ _vec2066_ _i2067_)
                (if (negative? _i2067_)
                    _knil2065_
                    (_loop12061_
                     _kons2064_
                     (_kons2064_ _knil2065_ (vector-ref _vec2066_ _i2067_))
                     _vec2066_
                     (- _i2067_ '1)))))
             (_loop2+2062_
              (lambda (_kons2069_ _knil2070_ _vectors2071_ _i2072_)
                (if (negative? _i2072_)
                    _knil2070_
                    (_loop2+2062_
                     _kons2069_
                     (apply _kons2069_
                            _knil2070_
                            (std/srfi/133#vectors-ref _vectors2071_ _i2072_))
                     _vectors2071_
                     (- _i2072_ '1))))))
      (lambda (_kons2074_ _knil2075_ _vec2076_ . _vectors2077_)
        (let ((_kons2079_
               (std/srfi/133#check-type
                procedure?
                _kons2074_
                std/srfi/133#vector-fold-right))
              (_vec2080_
               (std/srfi/133#check-type
                vector?
                _vec2076_
                std/srfi/133#vector-fold-right)))
          (if (null? _vectors2077_)
              (_loop12061_
               _kons2079_
               _knil2075_
               _vec2080_
               (- (vector-length _vec2080_) '1))
              (_loop2+2062_
               _kons2079_
               _knil2075_
               (cons _vec2080_ _vectors2077_)
               (- (std/srfi/133#%smallest-length
                   _vectors2077_
                   (vector-length _vec2080_)
                   std/srfi/133#vector-fold-right)
                  '1)))))))
  (define std/srfi/133#vector-map
    (lambda (_f2050_ _vec2051_ . _vectors2052_)
      (let ((_f2054_ (std/srfi/133#check-type
                      procedure?
                      _f2050_
                      std/srfi/133#vector-map))
            (_vec2055_
             (std/srfi/133#check-type
              vector?
              _vec2051_
              std/srfi/133#vector-map)))
        (if (null? _vectors2052_)
            (let ((_len2057_ (vector-length _vec2055_)))
              (std/srfi/133#%vector-map1!
               _f2054_
               (make-vector _len2057_)
               _vec2055_
               _len2057_))
            (let ((_len2059_
                   (std/srfi/133#%smallest-length
                    _vectors2052_
                    (vector-length _vec2055_)
                    std/srfi/133#vector-map)))
              (std/srfi/133#%vector-map2+!
               _f2054_
               (make-vector _len2059_)
               (cons _vec2055_ _vectors2052_)
               _len2059_))))))
  (define std/srfi/133#vector-map!
    (lambda (_f2043_ _vec2044_ . _vectors2045_)
      (let ((_f2047_ (std/srfi/133#check-type
                      procedure?
                      _f2043_
                      std/srfi/133#vector-map!))
            (_vec2048_
             (std/srfi/133#check-type
              vector?
              _vec2044_
              std/srfi/133#vector-map!)))
        (if (null? _vectors2045_)
            (std/srfi/133#%vector-map1!
             _f2047_
             _vec2048_
             _vec2048_
             (vector-length _vec2048_))
            (std/srfi/133#%vector-map2+!
             _f2047_
             _vec2048_
             (cons _vec2048_ _vectors2045_)
             (std/srfi/133#%smallest-length
              _vectors2045_
              (vector-length _vec2048_)
              std/srfi/133#vector-map!)))
        (std/srfi/133#unspecified-value))))
  (define std/srfi/133#vector-for-each
    (letrec ((_for-each12023_
              (lambda (_f2026_ _vec2027_ _i2028_ _len2029_)
                (if (< _i2028_ _len2029_)
                    (begin
                      (_f2026_ (vector-ref _vec2027_ _i2028_))
                      (_for-each12023_
                       _f2026_
                       _vec2027_
                       (+ _i2028_ '1)
                       _len2029_))
                    '#!void)))
             (_for-each2+2024_
              (lambda (_f2031_ _vecs2032_ _i2033_ _len2034_)
                (if (< _i2033_ _len2034_)
                    (begin
                      (apply _f2031_
                             (std/srfi/133#vectors-ref _vecs2032_ _i2033_))
                      (_for-each2+2024_
                       _f2031_
                       _vecs2032_
                       (+ _i2033_ '1)
                       _len2034_))
                    '#!void))))
      (lambda (_f2036_ _vec2037_ . _vectors2038_)
        (let ((_f2040_ (std/srfi/133#check-type
                        procedure?
                        _f2036_
                        std/srfi/133#vector-for-each))
              (_vec2041_
               (std/srfi/133#check-type
                vector?
                _vec2037_
                std/srfi/133#vector-for-each)))
          (if (null? _vectors2038_)
              (_for-each12023_ _f2040_ _vec2041_ '0 (vector-length _vec2041_))
              (_for-each2+2024_
               _f2040_
               (cons _vec2041_ _vectors2038_)
               '0
               (std/srfi/133#%smallest-length
                _vectors2038_
                (vector-length _vec2041_)
                std/srfi/133#vector-for-each)))))))
  (define std/srfi/133#vector-count
    (lambda (_pred?2010_ _vec2011_ . _vectors2012_)
      (let ((_pred?2014_
             (std/srfi/133#check-type
              procedure?
              _pred?2010_
              std/srfi/133#vector-count))
            (_vec2015_
             (std/srfi/133#check-type
              vector?
              _vec2011_
              std/srfi/133#vector-count)))
        (if (null? _vectors2012_)
            (std/srfi/133#%vector-fold1
             (lambda (_count2017_ _elt2018_)
               (if (_pred?2014_ _elt2018_) (+ _count2017_ '1) _count2017_))
             '0
             (vector-length _vec2015_)
             _vec2015_)
            (std/srfi/133#%vector-fold2+
             (lambda (_count2020_ . _elts2021_)
               (if (apply _pred?2014_ _elts2021_)
                   (+ _count2020_ '1)
                   _count2020_))
             '0
             (std/srfi/133#%smallest-length
              _vectors2012_
              (vector-length _vec2015_)
              std/srfi/133#vector-count)
             (cons _vec2015_ _vectors2012_))))))
  (define std/srfi/133#vector-cumulate
    (lambda (_f1991_ _knil1992_ _vec1993_)
      (let* ((_len1995_ (vector-length _vec1993_))
             (_result1997_ (make-vector _len1995_)))
        (let _loop2000_ ((_i2002_ '0) (_left2003_ _knil1992_))
          (if (= _i2002_ _len1995_)
              _result1997_
              (let* ((_right2005_ (vector-ref _vec1993_ _i2002_))
                     (_r2007_ (_f1991_ _left2003_ _right2005_)))
                (vector-set! _result1997_ _i2002_ _r2007_)
                (_loop2000_ (+ _i2002_ '1) _r2007_)))))))
  (define std/srfi/133#vector-index
    (lambda (_pred?1987_ _vec1988_ . _vectors1989_)
      (std/srfi/133#vector-index/skip
       _pred?1987_
       _vec1988_
       _vectors1989_
       std/srfi/133#vector-index)))
  (define std/srfi/133#vector-skip
    (lambda (_pred?1981_ _vec1982_ . _vectors1983_)
      (std/srfi/133#vector-index/skip
       (lambda _elts1985_ (not (apply _pred?1981_ _elts1985_)))
       _vec1982_
       _vectors1983_
       std/srfi/133#vector-skip)))
  (define std/srfi/133#vector-index/skip
    (letrec ((_loop11960_
              (lambda (_pred?1963_ _vec1964_ _len1965_ _i1966_)
                (if (= _i1966_ _len1965_)
                    '#f
                    (if (_pred?1963_ (vector-ref _vec1964_ _i1966_))
                        _i1966_
                        (_loop11960_
                         _pred?1963_
                         _vec1964_
                         _len1965_
                         (+ _i1966_ '1))))))
             (_loop2+1961_
              (lambda (_pred?1968_ _vectors1969_ _len1970_ _i1971_)
                (if (= _i1971_ _len1970_)
                    '#f
                    (if (apply _pred?1968_
                               (std/srfi/133#vectors-ref
                                _vectors1969_
                                _i1971_))
                        _i1971_
                        (_loop2+1961_
                         _pred?1968_
                         _vectors1969_
                         _len1970_
                         (+ _i1971_ '1)))))))
      (lambda (_pred?1973_ _vec1974_ _vectors1975_ _callee1976_)
        (let ((_pred?1978_
               (std/srfi/133#check-type procedure? _pred?1973_ _callee1976_))
              (_vec1979_
               (std/srfi/133#check-type vector? _vec1974_ _callee1976_)))
          (if (null? _vectors1975_)
              (_loop11960_ _pred?1978_ _vec1979_ (vector-length _vec1979_) '0)
              (_loop2+1961_
               _pred?1978_
               (cons _vec1979_ _vectors1975_)
               (std/srfi/133#%smallest-length
                _vectors1975_
                (vector-length _vec1979_)
                _callee1976_)
               '0))))))
  (define std/srfi/133#vector-index-right
    (lambda (_pred?1956_ _vec1957_ . _vectors1958_)
      (std/srfi/133#vector-index/skip-right
       _pred?1956_
       _vec1957_
       _vectors1958_
       std/srfi/133#vector-index-right)))
  (define std/srfi/133#vector-skip-right
    (lambda (_pred?1950_ _vec1951_ . _vectors1952_)
      (std/srfi/133#vector-index/skip-right
       (lambda _elts1954_ (not (apply _pred?1950_ _elts1954_)))
       _vec1951_
       _vectors1952_
       std/srfi/133#vector-index-right)))
  (define std/srfi/133#vector-index/skip-right
    (letrec ((_loop11931_
              (lambda (_pred?1934_ _vec1935_ _i1936_)
                (if (negative? _i1936_)
                    '#f
                    (if (_pred?1934_ (vector-ref _vec1935_ _i1936_))
                        _i1936_
                        (_loop11931_ _pred?1934_ _vec1935_ (- _i1936_ '1))))))
             (_loop2+1932_
              (lambda (_pred?1938_ _vectors1939_ _i1940_)
                (if (negative? _i1940_)
                    '#f
                    (if (apply _pred?1938_
                               (std/srfi/133#vectors-ref
                                _vectors1939_
                                _i1940_))
                        _i1940_
                        (_loop2+1932_
                         _pred?1938_
                         _vectors1939_
                         (- _i1940_ '1)))))))
      (lambda (_pred?1942_ _vec1943_ _vectors1944_ _callee1945_)
        (let ((_pred?1947_
               (std/srfi/133#check-type procedure? _pred?1942_ _callee1945_))
              (_vec1948_
               (std/srfi/133#check-type vector? _vec1943_ _callee1945_)))
          (if (null? _vectors1944_)
              (_loop11931_
               _pred?1947_
               _vec1948_
               (- (vector-length _vec1948_) '1))
              (_loop2+1932_
               _pred?1947_
               (cons _vec1948_ _vectors1944_)
               (- (std/srfi/133#%smallest-length
                   _vectors1944_
                   (vector-length _vec1948_)
                   _callee1945_)
                  '1)))))))
  (define std/srfi/133#vector-binary-search
    (lambda (_vec1906_ _value1907_ _cmp1908_ . _maybe-start+end1909_)
      (let* ((_cmp1911_
              (std/srfi/133#check-type
               procedure?
               _cmp1908_
               std/srfi/133#vector-binary-search))
             (_vec1913_
              (std/srfi/133#check-type
               vector?
               _vec1906_
               std/srfi/133#vector-binary-search))
             (_g6265_ (std/srfi/133#vector-parse-start+end
                       _vec1913_
                       _maybe-start+end1909_
                       'start
                       'end
                       std/srfi/133#vector-binary-search)))
        (begin
          (let ((_g6266_ (let ()
                           (declare (not safe))
                           (if (##values? _g6265_)
                               (##vector-length _g6265_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g6266_ 2)))
                (error "Context expects 2 values" _g6266_)))
          (let ((_start1915_
                 (let () (declare (not safe)) (##vector-ref _g6265_ 0)))
                (_end1916_
                 (let () (declare (not safe)) (##vector-ref _g6265_ 1))))
            (let _loop1918_ ((_start1920_ _start1915_)
                             (_end1921_ _end1916_)
                             (_j1922_ '#f))
              (let ((_i1924_ (quotient (+ _start1920_ _end1921_) '2)))
                (if (or (= _start1920_ _end1921_)
                        (and _j1922_ (= _i1924_ _j1922_)))
                    '#f
                    (let ((_comparison1929_
                           (std/srfi/133#check-type
                            integer?
                            (_cmp1911_
                             (vector-ref _vec1913_ _i1924_)
                             _value1907_)
                            (cons _cmp1911_
                                  (cons 'for
                                        (cons std/srfi/133#vector-binary-search
                                              '()))))))
                      (if (zero? _comparison1929_)
                          _i1924_
                          (if (positive? _comparison1929_)
                              (_loop1918_ _start1920_ _i1924_ _i1924_)
                              (_loop1918_ _i1924_ _end1921_ _i1924_))))))))))))
  (define std/srfi/133#vector-any
    (letrec ((_loop11874_
              (lambda (_pred?1877_ _vec1878_ _i1879_ _len1880_ _len-11881_)
                (if (not (= _i1879_ _len1880_))
                    (if (= _i1879_ _len-11881_)
                        (_pred?1877_ (vector-ref _vec1878_ _i1879_))
                        (let ((_$e1883_
                               (_pred?1877_ (vector-ref _vec1878_ _i1879_))))
                          (if _$e1883_
                              _$e1883_
                              (_loop11874_
                               _pred?1877_
                               _vec1878_
                               (+ _i1879_ '1)
                               _len1880_
                               _len-11881_))))
                    '#f)))
             (_loop2+1875_
              (lambda (_pred?1886_ _vectors1887_ _i1888_ _len1889_ _len-11890_)
                (if (not (= _i1888_ _len1889_))
                    (if (= _i1888_ _len-11890_)
                        (apply _pred?1886_
                               (std/srfi/133#vectors-ref
                                _vectors1887_
                                _i1888_))
                        (let ((_$e1892_
                               (apply _pred?1886_
                                      (std/srfi/133#vectors-ref
                                       _vectors1887_
                                       _i1888_))))
                          (if _$e1892_
                              _$e1892_
                              (_loop2+1875_
                               _pred?1886_
                               _vectors1887_
                               (+ _i1888_ '1)
                               _len1889_
                               _len-11890_))))
                    '#f))))
      (lambda (_pred?1895_ _vec1896_ . _vectors1897_)
        (let ((_pred?1899_
               (std/srfi/133#check-type
                procedure?
                _pred?1895_
                std/srfi/133#vector-any))
              (_vec1900_
               (std/srfi/133#check-type
                vector?
                _vec1896_
                std/srfi/133#vector-any)))
          (if (null? _vectors1897_)
              (let ((_len1902_ (vector-length _vec1900_)))
                (_loop11874_
                 _pred?1899_
                 _vec1900_
                 '0
                 _len1902_
                 (- _len1902_ '1)))
              (let ((_len1904_
                     (std/srfi/133#%smallest-length
                      _vectors1897_
                      (vector-length _vec1900_)
                      std/srfi/133#vector-any)))
                (_loop2+1875_
                 _pred?1899_
                 (cons _vec1900_ _vectors1897_)
                 '0
                 _len1904_
                 (- _len1904_ '1))))))))
  (define std/srfi/133#vector-every
    (letrec ((_loop11842_
              (lambda (_pred?1845_ _vec1846_ _i1847_ _len1848_ _len-11849_)
                (let ((_$e1851_ (= _i1847_ _len1848_)))
                  (if _$e1851_
                      _$e1851_
                      (if (= _i1847_ _len-11849_)
                          (_pred?1845_ (vector-ref _vec1846_ _i1847_))
                          (if (_pred?1845_ (vector-ref _vec1846_ _i1847_))
                              (_loop11842_
                               _pred?1845_
                               _vec1846_
                               (+ _i1847_ '1)
                               _len1848_
                               _len-11849_)
                              '#f))))))
             (_loop2+1843_
              (lambda (_pred?1854_ _vectors1855_ _i1856_ _len1857_ _len-11858_)
                (let ((_$e1860_ (= _i1856_ _len1857_)))
                  (if _$e1860_
                      _$e1860_
                      (if (= _i1856_ _len-11858_)
                          (apply _pred?1854_
                                 (std/srfi/133#vectors-ref
                                  _vectors1855_
                                  _i1856_))
                          (if (apply _pred?1854_
                                     (std/srfi/133#vectors-ref
                                      _vectors1855_
                                      _i1856_))
                              (_loop2+1843_
                               _pred?1854_
                               _vectors1855_
                               (+ _i1856_ '1)
                               _len1857_
                               _len-11858_)
                              '#f)))))))
      (lambda (_pred?1863_ _vec1864_ . _vectors1865_)
        (let ((_pred?1867_
               (std/srfi/133#check-type
                procedure?
                _pred?1863_
                std/srfi/133#vector-every))
              (_vec1868_
               (std/srfi/133#check-type
                vector?
                _vec1864_
                std/srfi/133#vector-every)))
          (if (null? _vectors1865_)
              (let ((_len1870_ (vector-length _vec1868_)))
                (_loop11842_
                 _pred?1867_
                 _vec1868_
                 '0
                 _len1870_
                 (- _len1870_ '1)))
              (let ((_len1872_
                     (std/srfi/133#%smallest-length
                      _vectors1865_
                      (vector-length _vec1868_)
                      std/srfi/133#vector-every)))
                (_loop2+1843_
                 _pred?1867_
                 (cons _vec1868_ _vectors1865_)
                 '0
                 _len1872_
                 (- _len1872_ '1))))))))
  (define std/srfi/133#vector-partition
    (lambda (_pred?1824_ _vec1825_)
      (let* ((_len1827_ (vector-length _vec1825_))
             (_cnt1829_ (std/srfi/133#vector-count _pred?1824_ _vec1825_))
             (_result1831_ (make-vector _len1827_)))
        (let _loop1834_ ((_i1836_ '0) (_yes1837_ '0) (_no1838_ _cnt1829_))
          (if (= _i1836_ _len1827_)
              (values _result1831_ _cnt1829_)
              (let ((_elem1840_ (vector-ref _vec1825_ _i1836_)))
                (if (_pred?1824_ _elem1840_)
                    (begin
                      (vector-set! _result1831_ _yes1837_ _elem1840_)
                      (_loop1834_ (+ _i1836_ '1) (+ _yes1837_ '1) _no1838_))
                    (begin
                      (vector-set! _result1831_ _no1838_ _elem1840_)
                      (_loop1834_
                       (+ _i1836_ '1)
                       _yes1837_
                       (+ _no1838_ '1))))))))))
  (define std/srfi/133#vector-swap!
    (lambda (_vec1813_ _i1814_ _j1815_)
      (let ((_vec1817_
             (std/srfi/133#check-type
              vector?
              _vec1813_
              std/srfi/133#vector-swap!)))
        (let ((_i1819_ (std/srfi/133#check-index
                        _vec1817_
                        _i1814_
                        std/srfi/133#vector-swap!))
              (_j1820_ (std/srfi/133#check-index
                        _vec1817_
                        _j1815_
                        std/srfi/133#vector-swap!)))
          (let ((_x1822_ (vector-ref _vec1817_ _i1819_)))
            (vector-set! _vec1817_ _i1819_ (vector-ref _vec1817_ _j1820_))
            (vector-set! _vec1817_ _j1820_ _x1822_))))))
  (define std/srfi/133#vector-fill!
    (lambda (_vec1799_ _value1800_ . _maybe-start+end1801_)
      (let* ((_vec1803_
              (std/srfi/133#check-type
               vector?
               _vec1799_
               std/srfi/133#vector-fill!))
             (_g6267_ (std/srfi/133#vector-parse-start+end
                       _vec1803_
                       _maybe-start+end1801_
                       'start
                       'end
                       std/srfi/133#vector-fill!)))
        (begin
          (let ((_g6268_ (let ()
                           (declare (not safe))
                           (if (##values? _g6267_)
                               (##vector-length _g6267_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g6268_ 2)))
                (error "Context expects 2 values" _g6268_)))
          (let ((_start1805_
                 (let () (declare (not safe)) (##vector-ref _g6267_ 0)))
                (_end1806_
                 (let () (declare (not safe)) (##vector-ref _g6267_ 1))))
            (let _$loop1808_ ((_i1811_ _start1805_))
              (if (= _i1811_ _end1806_)
                  '#!void
                  (begin
                    (vector-set! _vec1803_ _i1811_ _value1800_)
                    (_$loop1808_ (+ _i1811_ '1))))))))))
  (define std/srfi/133#vector-copy!
    (lambda (_target1782_ _tstart1783_ _source1784_ . _maybe-sstart+send1785_)
      (letrec ((_doit!1787_
                (lambda (_sstart1791_ _send1792_ _source-length1793_)
                  (let ((_tstart1795_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _tstart1783_
                          std/srfi/133#vector-copy!))
                        (_sstart1796_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _sstart1791_
                          std/srfi/133#vector-copy!))
                        (_send1797_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _send1792_
                          std/srfi/133#vector-copy!)))
                    (if (and (<= '0
                                 _sstart1796_
                                 _send1797_
                                 _source-length1793_)
                             (<= (+ _tstart1795_ (- _send1797_ _sstart1796_))
                                 (vector-length _target1782_)))
                        (std/srfi/133#%vector-copy!
                         _target1782_
                         _tstart1795_
                         _source1784_
                         _sstart1796_
                         _send1797_)
                        (error '"illegal arguments"
                               (cons 'while
                                     (cons 'calling
                                           (cons std/srfi/133#vector-copy!
                                                 '())))
                               (cons 'target
                                     (cons 'was (cons _target1782_ '())))
                               (cons 'target-length
                                     (cons 'was
                                           (cons (vector-length _target1782_)
                                                 '())))
                               (cons 'tstart
                                     (cons 'was (cons _tstart1795_ '())))
                               (cons 'source
                                     (cons 'was (cons _source1784_ '())))
                               (cons 'source-length
                                     (cons 'was
                                           (cons _source-length1793_ '())))
                               (cons 'sstart
                                     (cons 'was (cons _sstart1796_ '())))
                               (cons 'send
                                     (cons 'was (cons _send1797_ '())))))))))
        (let ((_n1789_ (vector-length _source1784_)))
          (if (null? _maybe-sstart+send1785_)
              (_doit!1787_ '0 _n1789_ _n1789_)
              (if (null? (cdr _maybe-sstart+send1785_))
                  (_doit!1787_ (car _maybe-sstart+send1785_) _n1789_ _n1789_)
                  (if (null? (cddr _maybe-sstart+send1785_))
                      (_doit!1787_
                       (car _maybe-sstart+send1785_)
                       (cadr _maybe-sstart+send1785_)
                       _n1789_)
                      (error '"too many arguments"
                             std/srfi/133#vector-copy!
                             (cddr _maybe-sstart+send1785_)))))))))
  (define std/srfi/133#vector-reverse-copy!
    (lambda (_target1762_ _tstart1763_ _source1764_ . _maybe-sstart+send1765_)
      (letrec ((_doit!1767_
                (lambda (_sstart1771_ _send1772_ _source-length1773_)
                  (let ((_tstart1775_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _tstart1763_
                          std/srfi/133#vector-reverse-copy!))
                        (_sstart1776_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _sstart1771_
                          std/srfi/133#vector-reverse-copy!))
                        (_send1777_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _send1772_
                          std/srfi/133#vector-reverse-copy!)))
                    (if (and (eq? _target1762_ _source1764_)
                             (or (std/srfi/133#between?
                                  _sstart1776_
                                  _tstart1775_
                                  _send1777_)
                                 (std/srfi/133#between?
                                  _tstart1775_
                                  _sstart1776_
                                  (+ _tstart1775_
                                     (- _send1777_ _sstart1776_)))))
                        (error '"vector range for self-copying overlaps"
                               std/srfi/133#vector-reverse-copy!
                               (cons 'vector
                                     (cons 'was (cons _target1762_ '())))
                               (cons 'tstart
                                     (cons 'was (cons _tstart1775_ '())))
                               (cons 'sstart
                                     (cons 'was (cons _sstart1776_ '())))
                               (cons 'send (cons 'was (cons _send1777_ '()))))
                        (if (and (<= '0
                                     _sstart1776_
                                     _send1777_
                                     _source-length1773_)
                                 (<= (+ _tstart1775_
                                        (- _send1777_ _sstart1776_))
                                     (vector-length _target1762_)))
                            (std/srfi/133#%vector-reverse-copy!
                             _target1762_
                             _tstart1775_
                             _source1764_
                             _sstart1776_
                             _send1777_)
                            (error '"illegal arguments"
                                   (cons 'while
                                         (cons 'calling
                                               (cons std/srfi/133#vector-reverse-copy!
                                                     '())))
                                   (cons 'target
                                         (cons 'was (cons _target1762_ '())))
                                   (cons 'target-length
                                         (cons 'was
                                               (cons (vector-length
                                                      _target1762_)
                                                     '())))
                                   (cons 'tstart
                                         (cons 'was (cons _tstart1775_ '())))
                                   (cons 'source
                                         (cons 'was (cons _source1764_ '())))
                                   (cons 'source-length
                                         (cons 'was
                                               (cons _source-length1773_ '())))
                                   (cons 'sstart
                                         (cons 'was (cons _sstart1776_ '())))
                                   (cons 'send
                                         (cons 'was
                                               (cons _send1777_ '()))))))))))
        (let ((_n1769_ (vector-length _source1764_)))
          (if (null? _maybe-sstart+send1765_)
              (_doit!1767_ '0 _n1769_ _n1769_)
              (if (null? (cdr _maybe-sstart+send1765_))
                  (_doit!1767_ (car _maybe-sstart+send1765_) _n1769_ _n1769_)
                  (if (null? (cddr _maybe-sstart+send1765_))
                      (_doit!1767_
                       (car _maybe-sstart+send1765_)
                       (cadr _maybe-sstart+send1765_)
                       _n1769_)
                      (error '"too many arguments"
                             std/srfi/133#vector-reverse-copy!
                             (cddr _maybe-sstart+send1765_)))))))))
  (define std/srfi/133#vector-reverse!
    (lambda (_vec1754_ . _start+end1755_)
      (let* ((_vec1757_
              (std/srfi/133#check-type
               vector?
               _vec1754_
               std/srfi/133#vector-reverse!))
             (_g6269_ (std/srfi/133#vector-parse-start+end
                       _vec1757_
                       _start+end1755_
                       'start
                       'end
                       std/srfi/133#vector-reverse!)))
        (begin
          (let ((_g6270_ (let ()
                           (declare (not safe))
                           (if (##values? _g6269_)
                               (##vector-length _g6269_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g6270_ 2)))
                (error "Context expects 2 values" _g6270_)))
          (let ((_start1759_
                 (let () (declare (not safe)) (##vector-ref _g6269_ 0)))
                (_end1760_
                 (let () (declare (not safe)) (##vector-ref _g6269_ 1))))
            (std/srfi/133#%vector-reverse!
             _vec1757_
             _start1759_
             _end1760_))))))
  (define std/srfi/133#vector->list
    (lambda (_vec1740_ . _maybe-start+end1741_)
      (let* ((_vec1743_
              (std/srfi/133#check-type
               vector?
               _vec1740_
               std/srfi/133#vector->list))
             (_g6271_ (std/srfi/133#vector-parse-start+end
                       _vec1743_
                       _maybe-start+end1741_
                       'start
                       'end
                       std/srfi/133#vector->list)))
        (begin
          (let ((_g6272_ (let ()
                           (declare (not safe))
                           (if (##values? _g6271_)
                               (##vector-length _g6271_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g6272_ 2)))
                (error "Context expects 2 values" _g6272_)))
          (let ((_start1745_
                 (let () (declare (not safe)) (##vector-ref _g6271_ 0)))
                (_end1746_
                 (let () (declare (not safe)) (##vector-ref _g6271_ 1))))
            (let _$loop1748_ ((_i1751_ (- _end1746_ '1)) (_result1752_ '()))
              (if (< _i1751_ _start1745_)
                  _result1752_
                  (_$loop1748_
                   (- _i1751_ '1)
                   (cons (vector-ref _vec1743_ _i1751_) _result1752_)))))))))
  (define std/srfi/133#reverse-vector->list
    (lambda (_vec1726_ . _maybe-start+end1727_)
      (let* ((_vec1729_
              (std/srfi/133#check-type
               vector?
               _vec1726_
               std/srfi/133#reverse-vector->list))
             (_g6273_ (std/srfi/133#vector-parse-start+end
                       _vec1729_
                       _maybe-start+end1727_
                       'start
                       'end
                       std/srfi/133#reverse-vector->list)))
        (begin
          (let ((_g6274_ (let ()
                           (declare (not safe))
                           (if (##values? _g6273_)
                               (##vector-length _g6273_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g6274_ 2)))
                (error "Context expects 2 values" _g6274_)))
          (let ((_start1731_
                 (let () (declare (not safe)) (##vector-ref _g6273_ 0)))
                (_end1732_
                 (let () (declare (not safe)) (##vector-ref _g6273_ 1))))
            (let _$loop1734_ ((_i1737_ _start1731_) (_result1738_ '()))
              (if (= _i1737_ _end1732_)
                  _result1738_
                  (_$loop1734_
                   (+ _i1737_ '1)
                   (cons (vector-ref _vec1729_ _i1737_) _result1738_)))))))))
  (define std/srfi/133#list->vector
    (lambda (_lst1682_ . _maybe-start+end1683_)
      (if (null? _maybe-start+end1683_)
          (let* ((_start1685_ '0) (_end1687_ (length _lst1682_)))
            (let ((_start1690_
                   (std/srfi/133#check-type
                    std/srfi/133#nonneg-int?
                    _start1685_
                    std/srfi/133#list->vector))
                  (_end1691_
                   (std/srfi/133#check-type
                    std/srfi/133#nonneg-int?
                    _end1687_
                    std/srfi/133#list->vector)))
              ((lambda (_f1693_)
                 (std/srfi/133#vector-unfold
                  _f1693_
                  (- _end1691_ _start1690_)
                  (list-tail _lst1682_ _start1690_)))
               (lambda (_index1695_ _l1696_)
                 (if (null? _l1696_)
                     (error '"list was too short"
                            (cons 'list (cons 'was (cons _lst1682_ '())))
                            (cons 'attempted
                                  (cons 'end (cons 'was (cons _end1691_ '()))))
                            (cons 'while
                                  (cons 'calling
                                        (cons std/srfi/133#list->vector '()))))
                     (if (pair? _l1696_)
                         (values (car _l1696_) (cdr _l1696_))
                         (error '"erroneous value"
                                (list list? _lst1682_)
                                (cons 'while
                                      (cons 'calling
                                            (cons std/srfi/133#list->vector
                                                  '()))))))))))
          (let ((_start1698_ (car _maybe-start+end1683_))
                (_new-args1699_ (cdr _maybe-start+end1683_)))
            (if (null? _new-args1699_)
                (let ((_end1702_ (length _lst1682_)))
                  (let ((_start1705_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _start1698_
                          std/srfi/133#list->vector))
                        (_end1706_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _end1702_
                          std/srfi/133#list->vector)))
                    ((lambda (_f1708_)
                       (std/srfi/133#vector-unfold
                        _f1708_
                        (- _end1706_ _start1705_)
                        (list-tail _lst1682_ _start1705_)))
                     (lambda (_index1710_ _l1711_)
                       (if (null? _l1711_)
                           (error '"list was too short"
                                  (cons 'list (cons 'was (cons _lst1682_ '())))
                                  (cons 'attempted
                                        (cons 'end
                                              (cons 'was
                                                    (cons _end1706_ '()))))
                                  (cons 'while
                                        (cons 'calling
                                              (cons std/srfi/133#list->vector
                                                    '()))))
                           (if (pair? _l1711_)
                               (values (car _l1711_) (cdr _l1711_))
                               (error '"erroneous value"
                                      (list list? _lst1682_)
                                      (cons 'while
                                            (cons 'calling
                                                  (cons std/srfi/133#list->vector
                                                        '()))))))))))
                (let ((_end1713_ (car _new-args1699_))
                      (_new-args1714_ (cdr _new-args1699_)))
                  (if (null? _new-args1714_)
                      (let ()
                        (let ((_start1718_
                               (std/srfi/133#check-type
                                std/srfi/133#nonneg-int?
                                _start1698_
                                std/srfi/133#list->vector))
                              (_end1719_
                               (std/srfi/133#check-type
                                std/srfi/133#nonneg-int?
                                _end1713_
                                std/srfi/133#list->vector)))
                          ((lambda (_f1721_)
                             (std/srfi/133#vector-unfold
                              _f1721_
                              (- _end1719_ _start1718_)
                              (list-tail _lst1682_ _start1718_)))
                           (lambda (_index1723_ _l1724_)
                             (if (null? _l1724_)
                                 (error '"list was too short"
                                        (cons 'list
                                              (cons 'was (cons _lst1682_ '())))
                                        (cons 'attempted
                                              (cons 'end
                                                    (cons 'was
                                                          (cons _end1719_
                                                                '()))))
                                        (cons 'while
                                              (cons 'calling
                                                    (cons std/srfi/133#list->vector
                                                          '()))))
                                 (if (pair? _l1724_)
                                     (values (car _l1724_) (cdr _l1724_))
                                     (error '"erroneous value"
                                            (list list? _lst1682_)
                                            (cons 'while
                                                  (cons 'calling
                                                        (cons std/srfi/133#list->vector
                                                              '()))))))))))
                      (error '"too many arguments"
                             (length _maybe-start+end1683_)
                             _maybe-start+end1683_))))))))
  (define std/srfi/133#reverse-list->vector
    (lambda (_lst1638_ . _maybe-start+end1639_)
      (if (null? _maybe-start+end1639_)
          (let* ((_start1641_ '0) (_end1643_ (length _lst1638_)))
            (let ((_start1646_
                   (std/srfi/133#check-type
                    std/srfi/133#nonneg-int?
                    _start1641_
                    std/srfi/133#reverse-list->vector))
                  (_end1647_
                   (std/srfi/133#check-type
                    std/srfi/133#nonneg-int?
                    _end1643_
                    std/srfi/133#reverse-list->vector)))
              ((lambda (_f1649_)
                 (std/srfi/133#vector-unfold-right
                  _f1649_
                  (- _end1647_ _start1646_)
                  (list-tail _lst1638_ _start1646_)))
               (lambda (_index1651_ _l1652_)
                 (if (null? _l1652_)
                     (error '"list too short"
                            (cons 'list (cons 'was (cons _lst1638_ '())))
                            (cons 'attempted
                                  (cons 'end (cons 'was (cons _end1647_ '()))))
                            (cons 'while
                                  (cons 'calling
                                        (cons std/srfi/133#reverse-list->vector
                                              '()))))
                     (if (pair? _l1652_)
                         (values (car _l1652_) (cdr _l1652_))
                         (error '"erroneous value"
                                (list list? _lst1638_)
                                (cons 'while
                                      (cons 'calling
                                            (cons std/srfi/133#reverse-list->vector
                                                  '()))))))))))
          (let ((_start1654_ (car _maybe-start+end1639_))
                (_new-args1655_ (cdr _maybe-start+end1639_)))
            (if (null? _new-args1655_)
                (let ((_end1658_ (length _lst1638_)))
                  (let ((_start1661_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _start1654_
                          std/srfi/133#reverse-list->vector))
                        (_end1662_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _end1658_
                          std/srfi/133#reverse-list->vector)))
                    ((lambda (_f1664_)
                       (std/srfi/133#vector-unfold-right
                        _f1664_
                        (- _end1662_ _start1661_)
                        (list-tail _lst1638_ _start1661_)))
                     (lambda (_index1666_ _l1667_)
                       (if (null? _l1667_)
                           (error '"list too short"
                                  (cons 'list (cons 'was (cons _lst1638_ '())))
                                  (cons 'attempted
                                        (cons 'end
                                              (cons 'was
                                                    (cons _end1662_ '()))))
                                  (cons 'while
                                        (cons 'calling
                                              (cons std/srfi/133#reverse-list->vector
                                                    '()))))
                           (if (pair? _l1667_)
                               (values (car _l1667_) (cdr _l1667_))
                               (error '"erroneous value"
                                      (list list? _lst1638_)
                                      (cons 'while
                                            (cons 'calling
                                                  (cons std/srfi/133#reverse-list->vector
                                                        '()))))))))))
                (let ((_end1669_ (car _new-args1655_))
                      (_new-args1670_ (cdr _new-args1655_)))
                  (if (null? _new-args1670_)
                      (let ()
                        (let ((_start1674_
                               (std/srfi/133#check-type
                                std/srfi/133#nonneg-int?
                                _start1654_
                                std/srfi/133#reverse-list->vector))
                              (_end1675_
                               (std/srfi/133#check-type
                                std/srfi/133#nonneg-int?
                                _end1669_
                                std/srfi/133#reverse-list->vector)))
                          ((lambda (_f1677_)
                             (std/srfi/133#vector-unfold-right
                              _f1677_
                              (- _end1675_ _start1674_)
                              (list-tail _lst1638_ _start1674_)))
                           (lambda (_index1679_ _l1680_)
                             (if (null? _l1680_)
                                 (error '"list too short"
                                        (cons 'list
                                              (cons 'was (cons _lst1638_ '())))
                                        (cons 'attempted
                                              (cons 'end
                                                    (cons 'was
                                                          (cons _end1675_
                                                                '()))))
                                        (cons 'while
                                              (cons 'calling
                                                    (cons std/srfi/133#reverse-list->vector
                                                          '()))))
                                 (if (pair? _l1680_)
                                     (values (car _l1680_) (cdr _l1680_))
                                     (error '"erroneous value"
                                            (list list? _lst1638_)
                                            (cons 'while
                                                  (cons 'calling
                                                        (cons std/srfi/133#reverse-list->vector
                                                              '()))))))))))
                      (error '"too many arguments"
                             (length _maybe-start+end1639_)
                             _maybe-start+end1639_))))))))
  (define std/srfi/133#vector->string
    (lambda (_vec1619_ . _maybe-start+end1620_)
      (let* ((_len1622_ (vector-length _vec1619_))
             (_start1624_
              (if (null? _maybe-start+end1620_)
                  '0
                  (car _maybe-start+end1620_)))
             (_end1626_
              (if (null? _maybe-start+end1620_)
                  _len1622_
                  (if (null? (cdr _maybe-start+end1620_))
                      _len1622_
                      (cadr _maybe-start+end1620_))))
             (_size1628_ (- _end1626_ _start1624_)))
        (letrec* ((_result1631_ (make-string _size1628_)))
          (let _loop1633_ ((_at1635_ '0) (_i1636_ _start1624_))
            (if (= _i1636_ _end1626_)
                _result1631_
                (begin
                  (string-set!
                   _result1631_
                   _at1635_
                   (vector-ref _vec1619_ _i1636_))
                  (_loop1633_ (+ _at1635_ '1) (+ _i1636_ '1)))))))))
  (define std/srfi/133#string->vector
    (lambda (_str1600_ . _maybe-start+end1601_)
      (let* ((_len1603_ (string-length _str1600_))
             (_start1605_
              (if (null? _maybe-start+end1601_)
                  '0
                  (car _maybe-start+end1601_)))
             (_end1607_
              (if (null? _maybe-start+end1601_)
                  _len1603_
                  (if (null? (cdr _maybe-start+end1601_))
                      _len1603_
                      (cadr _maybe-start+end1601_))))
             (_size1609_ (- _end1607_ _start1605_)))
        (letrec* ((_result1612_ (make-vector _size1609_)))
          (let _loop1614_ ((_at1616_ '0) (_i1617_ _start1605_))
            (if (= _i1617_ _end1607_)
                _result1612_
                (begin
                  (vector-set!
                   _result1612_
                   _at1616_
                   (string-ref _str1600_ _i1617_))
                  (_loop1614_ (+ _at1616_ '1) (+ _i1617_ '1))))))))))
