/*************************************************************************/
/* Copyright (c) 2004                                                    */
/* Daniel Sleator, David Temperley, and John Lafferty                    */
/* Copyright (c) 2013 Linas Vepstas                                      */
/* All rights reserved                                                   */
/*                                                                       */
/* Use of the link grammar parsing system is subject to the terms of the */
/* license set forth in the LICENSE file included with this software.    */
/* This license allows free redistribution and use in source and binary  */
/* forms, with or without modification, subject to certain conditions.   */
/*                                                                       */
/*************************************************************************/

#ifndef _DICT_DEFINES_H_
#define _DICT_DEFINES_H_

/* The following define the names of the special strings in the dictionary. */
#define LEFT_WALL_WORD   "LEFT-WALL"
#define RIGHT_WALL_WORD  "RIGHT-WALL"
#define UNKNOWN_WORD     "<UNKNOWN-WORD>"

/* The following is for using in generation-mode sentence template. */
#define WILDCARD_WORD    "\\*"    /* Any dictionary word. */

/* MAX_WORD is large, because Unicode entries can use a lot of space. */
#define MAX_WORD 1024              /* Maximum number of bytes in a word. */

/* Word subscripts come after the subscript mark (ASCII ETX)
 * In the dictionary, a dot is used; but that dot interferes with dots
 * in the input stream, and so we convert dictionary dots into the
 * subscript mark, which we don't expect to see in user input.
 */
#define SUBSCRIPT_MARK   '\3'
#define SUBSCRIPT_DOT    '.'
#endif /* _DICT_DEFINES_H_ */
