# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

from influxdb_client.domain.expression import Expression


class CallExpression(Expression):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'type': 'str',
        'callee': 'Expression',
        'arguments': 'list[Expression]'
    }

    attribute_map = {
        'type': 'type',
        'callee': 'callee',
        'arguments': 'arguments'
    }

    def __init__(self, type=None, callee=None, arguments=None):  # noqa: E501,D401,D403
        """CallExpression - a model defined in OpenAPI."""  # noqa: E501
        Expression.__init__(self)  # noqa: E501

        self._type = None
        self._callee = None
        self._arguments = None
        self.discriminator = None

        if type is not None:
            self.type = type
        if callee is not None:
            self.callee = callee
        if arguments is not None:
            self.arguments = arguments

    @property
    def type(self):
        """Get the type of this CallExpression.

        Type of AST node

        :return: The type of this CallExpression.
        :rtype: str
        """  # noqa: E501
        return self._type

    @type.setter
    def type(self, type):
        """Set the type of this CallExpression.

        Type of AST node

        :param type: The type of this CallExpression.
        :type: str
        """  # noqa: E501
        self._type = type

    @property
    def callee(self):
        """Get the callee of this CallExpression.

        :return: The callee of this CallExpression.
        :rtype: Expression
        """  # noqa: E501
        return self._callee

    @callee.setter
    def callee(self, callee):
        """Set the callee of this CallExpression.

        :param callee: The callee of this CallExpression.
        :type: Expression
        """  # noqa: E501
        self._callee = callee

    @property
    def arguments(self):
        """Get the arguments of this CallExpression.

        Function arguments

        :return: The arguments of this CallExpression.
        :rtype: list[Expression]
        """  # noqa: E501
        return self._arguments

    @arguments.setter
    def arguments(self, arguments):
        """Set the arguments of this CallExpression.

        Function arguments

        :param arguments: The arguments of this CallExpression.
        :type: list[Expression]
        """  # noqa: E501
        self._arguments = arguments

    def to_dict(self):
        """Return the model properties as a dict."""
        result = {}

        for attr, _ in self.openapi_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Return the string representation of the model."""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`."""
        return self.to_str()

    def __eq__(self, other):
        """Return true if both objects are equal."""
        if not isinstance(other, CallExpression):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Return true if both objects are not equal."""
        return not self == other
