# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx.model.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class ALGTypeNSService(VapiStruct):
    """
    An NSService element that represents an ALG protocol

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ALGTypeNSService"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    ALG_ORACLE_TNS = "ORACLE_TNS"
    """


    """
    ALG_FTP = "FTP"
    """


    """
    ALG_SUN_RPC_TCP = "SUN_RPC_TCP"
    """


    """
    ALG_SUN_RPC_UDP = "SUN_RPC_UDP"
    """


    """
    ALG_MS_RPC_TCP = "MS_RPC_TCP"
    """


    """
    ALG_MS_RPC_UDP = "MS_RPC_UDP"
    """


    """
    ALG_NBNS_BROADCAST = "NBNS_BROADCAST"
    """


    """
    ALG_NBDG_BROADCAST = "NBDG_BROADCAST"
    """


    """
    ALG_TFTP = "TFTP"
    """


    """



    _canonical_to_pep_names = {
                            'alg': 'alg',
                            'destination_ports': 'destination_ports',
                            'source_ports': 'source_ports',
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 alg=None,
                 destination_ports=None,
                 source_ports=None,
                 resource_type='ALGTypeNSService',
                ):
        """
        :type  alg: :class:`str` or ``None``
        :param alg: Possible values are: 
            
            * :attr:`ALGTypeNSService.ALG_ORACLE_TNS`
            * :attr:`ALGTypeNSService.ALG_FTP`
            * :attr:`ALGTypeNSService.ALG_SUN_RPC_TCP`
            * :attr:`ALGTypeNSService.ALG_SUN_RPC_UDP`
            * :attr:`ALGTypeNSService.ALG_MS_RPC_TCP`
            * :attr:`ALGTypeNSService.ALG_MS_RPC_UDP`
            * :attr:`ALGTypeNSService.ALG_NBNS_BROADCAST`
            * :attr:`ALGTypeNSService.ALG_NBDG_BROADCAST`
            * :attr:`ALGTypeNSService.ALG_TFTP`
            
            The Application Layer Gateway (ALG) protocol. Please note, protocol
            NBNS_BROADCAST and NBDG_BROADCAST are deprecated. Please use UDP
            protocol and create L4 Port Set type of service instead.
        :type  destination_ports: :class:`list` of :class:`str` or ``None``
        :param destination_ports: The destination_port cannot be empty and must be a single value.
            format: port-or-range
        :type  source_ports: :class:`list` of :class:`str` or ``None``
        :param source_ports: Source ports format: port-or-range
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`NSServiceElement.RESOURCE_TYPE_ETHERTYPENSSERVICE`
            * :attr:`NSServiceElement.RESOURCE_TYPE_IPPROTOCOLNSSERVICE`
            * :attr:`NSServiceElement.RESOURCE_TYPE_IGMPTYPENSSERVICE`
            * :attr:`NSServiceElement.RESOURCE_TYPE_ICMPTYPENSSERVICE`
            * :attr:`NSServiceElement.RESOURCE_TYPE_ALGTYPENSSERVICE`
            * :attr:`NSServiceElement.RESOURCE_TYPE_L4PORTSETNSSERVICE`
            
            The specific type of NSServiceElement
        """
        self.alg = alg
        self.destination_ports = destination_ports
        self.source_ports = source_ports
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ALGTypeNSService._set_binding_type(type.StructType(
    'com.vmware.nsx.model.ALG_type_NS_service', {
        'alg': type.OptionalType(type.StringType()),
        'destination_ports': type.OptionalType(type.ListType(type.StringType())),
        'source_ports': type.OptionalType(type.ListType(type.StringType())),
        'resource_type': type.StringType(),
    },
    ALGTypeNSService,
    False,
    None))



class AcceptableComponentVersion(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    COMPONENT_TYPE_HOST = "HOST"
    """


    """
    COMPONENT_TYPE_EDGE = "EDGE"
    """


    """
    COMPONENT_TYPE_CCP = "CCP"
    """


    """
    COMPONENT_TYPE_MP = "MP"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'acceptable_versions': 'acceptable_versions',
                            'component_type': 'component_type',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 acceptable_versions=None,
                 component_type=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  acceptable_versions: :class:`list` of :class:`str` or ``None``
        :param acceptable_versions: List of component versions
        :type  component_type: :class:`str` or ``None``
        :param component_type: Possible values are: 
            
            * :attr:`AcceptableComponentVersion.COMPONENT_TYPE_HOST`
            * :attr:`AcceptableComponentVersion.COMPONENT_TYPE_EDGE`
            * :attr:`AcceptableComponentVersion.COMPONENT_TYPE_CCP`
            * :attr:`AcceptableComponentVersion.COMPONENT_TYPE_MP`
            
            Node type
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.acceptable_versions = acceptable_versions
        self.component_type = component_type
        VapiStruct.__init__(self)


AcceptableComponentVersion._set_binding_type(type.StructType(
    'com.vmware.nsx.model.acceptable_component_version', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'acceptable_versions': type.OptionalType(type.ListType(type.StringType())),
        'component_type': type.OptionalType(type.StringType()),
    },
    AcceptableComponentVersion,
    False,
    None))



class AcceptableComponentVersionList(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'results': 'results',
                            }

    def __init__(self,
                 results=None,
                ):
        """
        :type  results: :class:`list` of :class:`AcceptableComponentVersion` or ``None``
        :param results: Acceptable version whitelist for different components
        """
        self.results = results
        VapiStruct.__init__(self)


AcceptableComponentVersionList._set_binding_type(type.StructType(
    'com.vmware.nsx.model.acceptable_component_version_list', {
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AcceptableComponentVersion'))),
    },
    AcceptableComponentVersionList,
    False,
    None))



class ActionableResource(VapiStruct):
    """
    Resources managed during restore process

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'ip_address': 'ip_address',
                            'ipv6_address': 'ipv6_address',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 ip_address=None,
                 ipv6_address=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  ip_address: :class:`str` or ``None``
        :param ip_address: A resource reference on which actions can be performed format:
            hostname-or-ip
        :type  ipv6_address: :class:`str` or ``None``
        :param ipv6_address: IPv6 address of the current node format: hostname-or-ip
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.ip_address = ip_address
        self.ipv6_address = ipv6_address
        VapiStruct.__init__(self)


ActionableResource._set_binding_type(type.StructType(
    'com.vmware.nsx.model.actionable_resource', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'ip_address': type.OptionalType(type.StringType()),
        'ipv6_address': type.OptionalType(type.StringType()),
    },
    ActionableResource,
    False,
    None))



class ActionableResourceListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ActionableResource` or ``None``
        :param results: List results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ActionableResourceListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.actionable_resource_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ActionableResource'))),
    },
    ActionableResourceListResult,
    False,
    None))



class ActiveStandbySyncStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_UNAVAILABLE = "UNAVAILABLE"
    """


    """
    STATUS_ERROR = "ERROR"
    """


    """
    STATUS_ONGOING = "ONGOING"
    """


    """
    STATUS_NOT_STARTED = "NOT_STARTED"
    """


    """
    SYNC_TYPE_UNAVAILABLE = "UNAVAILABLE"
    """


    """
    SYNC_TYPE_DELTA_SYNC = "DELTA_SYNC"
    """


    """
    SYNC_TYPE_FULL_SYNC = "FULL_SYNC"
    """


    """



    _canonical_to_pep_names = {
                            'description': 'description',
                            'full_sync_status': 'full_sync_status',
                            'is_data_consistent': 'is_data_consistent',
                            'percentage_completed': 'percentage_completed',
                            'remaining_entries_to_send': 'remaining_entries_to_send',
                            'standby_site': 'standby_site',
                            'status': 'status',
                            'sync_type': 'sync_type',
                            }

    def __init__(self,
                 description=None,
                 full_sync_status=None,
                 is_data_consistent=None,
                 percentage_completed=None,
                 remaining_entries_to_send=None,
                 standby_site=None,
                 status=None,
                 sync_type=None,
                ):
        """
        :type  description: :class:`str` or ``None``
        :param description: Description of the status.
        :type  full_sync_status: :class:`FullSyncStatus` or ``None``
        :param full_sync_status: 
        :type  is_data_consistent: :class:`bool` or ``None``
        :param is_data_consistent: Indicates whether the data is consistent. Always returned as true
            when queried on an active Global Manager node.
        :type  percentage_completed: :class:`long` or ``None``
        :param percentage_completed: Percentage estimate of synchronization progress. Ranges from 0 to
            100. This value is only returned when queried on an active Global
            Manager node. format: int64
        :type  remaining_entries_to_send: :class:`long` or ``None``
        :param remaining_entries_to_send: Number of entries pending synchronization. This value is only
            returned when queried on an active Global Manager node. format:
            int64
        :type  standby_site: :class:`str` or ``None``
        :param standby_site: Name of standby site.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ActiveStandbySyncStatus.STATUS_UNAVAILABLE`
            * :attr:`ActiveStandbySyncStatus.STATUS_ERROR`
            * :attr:`ActiveStandbySyncStatus.STATUS_ONGOING`
            * :attr:`ActiveStandbySyncStatus.STATUS_NOT_STARTED`
            
            Status of synchronization between active and standby Global Manager
            nodes.
        :type  sync_type: :class:`str` or ``None``
        :param sync_type: Possible values are: 
            
            * :attr:`ActiveStandbySyncStatus.SYNC_TYPE_UNAVAILABLE`
            * :attr:`ActiveStandbySyncStatus.SYNC_TYPE_DELTA_SYNC`
            * :attr:`ActiveStandbySyncStatus.SYNC_TYPE_FULL_SYNC`
            
            Type of synchronization currently in effect between active and
            standby Global Manager nodes.
        """
        self.description = description
        self.full_sync_status = full_sync_status
        self.is_data_consistent = is_data_consistent
        self.percentage_completed = percentage_completed
        self.remaining_entries_to_send = remaining_entries_to_send
        self.standby_site = standby_site
        self.status = status
        self.sync_type = sync_type
        VapiStruct.__init__(self)


ActiveStandbySyncStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.active_standby_sync_status', {
        'description': type.OptionalType(type.StringType()),
        'full_sync_status': type.OptionalType(type.ReferenceType(__name__, 'FullSyncStatus')),
        'is_data_consistent': type.OptionalType(type.BooleanType()),
        'percentage_completed': type.OptionalType(type.IntegerType()),
        'remaining_entries_to_send': type.OptionalType(type.IntegerType()),
        'standby_site': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
        'sync_type': type.OptionalType(type.StringType()),
    },
    ActiveStandbySyncStatus,
    False,
    None))



class AddClusterNodeSpec(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'controller_role_config': 'controller_role_config',
                            'display_name': 'display_name',
                            'external_id': 'external_id',
                            'mgr_role_config': 'mgr_role_config',
                            }

    def __init__(self,
                 controller_role_config=None,
                 display_name=None,
                 external_id=None,
                 mgr_role_config=None,
                ):
        """
        :type  controller_role_config: :class:`AddControllerNodeSpec` or ``None``
        :param controller_role_config: 
        :type  display_name: :class:`str` or ``None``
        :param display_name: Display name for the node
        :type  external_id: :class:`str` or ``None``
        :param external_id: External identifier of the node
        :type  mgr_role_config: :class:`AddManagementNodeSpec` or ``None``
        :param mgr_role_config: 
        """
        self.controller_role_config = controller_role_config
        self.display_name = display_name
        self.external_id = external_id
        self.mgr_role_config = mgr_role_config
        VapiStruct.__init__(self)


AddClusterNodeSpec._set_binding_type(type.StructType(
    'com.vmware.nsx.model.add_cluster_node_spec', {
        'controller_role_config': type.OptionalType(type.ReferenceType(__name__, 'AddControllerNodeSpec')),
        'display_name': type.OptionalType(type.StringType()),
        'external_id': type.OptionalType(type.StringType()),
        'mgr_role_config': type.OptionalType(type.ReferenceType(__name__, 'AddManagementNodeSpec')),
    },
    AddClusterNodeSpec,
    False,
    None))



class AddClusterNodeVMInfo(VapiStruct):
    """
    Contains a list of cluster node VM deployment requests and optionally a
    clustering configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'clustering_config': 'clustering_config',
                            'deployment_requests': 'deployment_requests',
                            }

    def __init__(self,
                 clustering_config=None,
                 deployment_requests=None,
                ):
        """
        :type  clustering_config: :class:`ClusteringConfig` or ``None``
        :param clustering_config: 
        :type  deployment_requests: :class:`list` of :class:`ClusterNodeVMDeploymentRequest` or ``None``
        :param deployment_requests: Cluster node VM deployment requests to be deployed by the Manager.
        """
        self.clustering_config = clustering_config
        self.deployment_requests = deployment_requests
        VapiStruct.__init__(self)


AddClusterNodeVMInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.add_cluster_node_VM_info', {
        'clustering_config': type.OptionalType(type.ReferenceType(__name__, 'ClusteringConfig')),
        'deployment_requests': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterNodeVMDeploymentRequest'))),
    },
    AddClusterNodeVMInfo,
    False,
    None))



class AddControllerNodeSpec(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_ADDCONTROLLERNODESPEC = "AddControllerNodeSpec"
    """


    """



    _canonical_to_pep_names = {
                            'clustering_params': 'clustering_params',
                            'control_plane_server_certificate': 'control_plane_server_certificate',
                            'host_msg_client_info': 'host_msg_client_info',
                            'mpa_msg_client_info': 'mpa_msg_client_info',
                            'node_id': 'node_id',
                            'type': 'type',
                            }

    def __init__(self,
                 clustering_params=None,
                 control_plane_server_certificate=None,
                 host_msg_client_info=None,
                 mpa_msg_client_info=None,
                 node_id=None,
                 type=None,
                ):
        """
        :type  clustering_params: :class:`ClusteringInfo` or ``None``
        :param clustering_params: 
        :type  control_plane_server_certificate: :class:`str` or ``None``
        :param control_plane_server_certificate: Deprecated. Do not supply a value for this property.

            .. deprecated:: unknown
        :type  host_msg_client_info: :class:`MsgClientInfo` or ``None``
        :param host_msg_client_info: 
        :type  mpa_msg_client_info: :class:`MsgClientInfo` or ``None``
        :param mpa_msg_client_info: 
        :type  node_id: :class:`str` or ``None``
        :param node_id: Only use this if an id for the node already exists with MP. If not
            specified, then the node_id will be set to a random id.
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`AddControllerNodeSpec.TYPE_ADDCONTROLLERNODESPEC`
            
            must be set to AddControllerNodeSpec
        """
        self.clustering_params = clustering_params
        self.control_plane_server_certificate = control_plane_server_certificate
        self.host_msg_client_info = host_msg_client_info
        self.mpa_msg_client_info = mpa_msg_client_info
        self.node_id = node_id
        self.type = type
        VapiStruct.__init__(self)


AddControllerNodeSpec._set_binding_type(type.StructType(
    'com.vmware.nsx.model.add_controller_node_spec', {
        'clustering_params': type.OptionalType(type.ReferenceType(__name__, 'ClusteringInfo')),
        'control_plane_server_certificate': type.OptionalType(type.StringType()),
        'host_msg_client_info': type.OptionalType(type.ReferenceType(__name__, 'MsgClientInfo')),
        'mpa_msg_client_info': type.OptionalType(type.ReferenceType(__name__, 'MsgClientInfo')),
        'node_id': type.OptionalType(type.StringType()),
        'type': type.OptionalType(type.StringType()),
    },
    AddControllerNodeSpec,
    False,
    None))



class AddManagementNodeSpec(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_ADDMANAGEMENTNODESPEC = "AddManagementNodeSpec"
    """


    """



    _canonical_to_pep_names = {
                            'cert_thumbprint': 'cert_thumbprint',
                            'mpa_msg_client_info': 'mpa_msg_client_info',
                            'password': 'password',
                            'remote_address': 'remote_address',
                            'type': 'type',
                            'user_name': 'user_name',
                            }

    def __init__(self,
                 cert_thumbprint=None,
                 mpa_msg_client_info=None,
                 password=None,
                 remote_address=None,
                 type=None,
                 user_name=None,
                ):
        """
        :type  cert_thumbprint: :class:`str` or ``None``
        :param cert_thumbprint: The certificate thumbprint of the remote node.
        :type  mpa_msg_client_info: :class:`MsgClientInfo` or ``None``
        :param mpa_msg_client_info: 
        :type  password: :class:`str` or ``None``
        :param password: The password to be used to authenticate with the remote node.
        :type  remote_address: :class:`str` or ``None``
        :param remote_address: The host address of the remote node to which to send this join
            request. format: ip
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`AddManagementNodeSpec.TYPE_ADDMANAGEMENTNODESPEC`
            
            must be set to AddManagementNodeSpec
        :type  user_name: :class:`str` or ``None``
        :param user_name: The username to be used to authenticate with the remote node.
        """
        self.cert_thumbprint = cert_thumbprint
        self.mpa_msg_client_info = mpa_msg_client_info
        self.password = password
        self.remote_address = remote_address
        self.type = type
        self.user_name = user_name
        VapiStruct.__init__(self)


AddManagementNodeSpec._set_binding_type(type.StructType(
    'com.vmware.nsx.model.add_management_node_spec', {
        'cert_thumbprint': type.OptionalType(type.StringType()),
        'mpa_msg_client_info': type.OptionalType(type.ReferenceType(__name__, 'MsgClientInfo')),
        'password': type.OptionalType(type.StringType()),
        'remote_address': type.OptionalType(type.StringType()),
        'type': type.OptionalType(type.StringType()),
        'user_name': type.OptionalType(type.StringType()),
    },
    AddManagementNodeSpec,
    False,
    None))



class AddressBindingEntry(VapiStruct):
    """
    An address binding entry is a combination of the IP-MAC-VLAN binding for a
    logical port. The address bindings can be obtained via various methods like
    ARP snooping, DHCP snooping etc. or by user configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    SOURCE_INVALID = "INVALID"
    """


    """
    SOURCE_UNKNOWN = "UNKNOWN"
    """


    """
    SOURCE_USER_DEFINED = "USER_DEFINED"
    """


    """
    SOURCE_ARP_SNOOPING = "ARP_SNOOPING"
    """


    """
    SOURCE_DHCP_SNOOPING = "DHCP_SNOOPING"
    """


    """
    SOURCE_VM_TOOLS = "VM_TOOLS"
    """


    """
    SOURCE_ND_SNOOPING = "ND_SNOOPING"
    """


    """
    SOURCE_DHCPV6_SNOOPING = "DHCPV6_SNOOPING"
    """


    """
    SOURCE_VM_TOOLS_V6 = "VM_TOOLS_V6"
    """


    """



    _canonical_to_pep_names = {
                            'binding': 'binding',
                            'binding_timestamp': 'binding_timestamp',
                            'source': 'source',
                            }

    def __init__(self,
                 binding=None,
                 binding_timestamp=None,
                 source=None,
                ):
        """
        :type  binding: :class:`PacketAddressClassifier` or ``None``
        :param binding: 
        :type  binding_timestamp: :class:`long` or ``None``
        :param binding_timestamp: Timestamp at which the binding was discovered via snooping or
            manually specified by the user format: int64
        :type  source: :class:`str` or ``None``
        :param source: Possible values are: 
            
            * :attr:`AddressBindingEntry.SOURCE_INVALID`
            * :attr:`AddressBindingEntry.SOURCE_UNKNOWN`
            * :attr:`AddressBindingEntry.SOURCE_USER_DEFINED`
            * :attr:`AddressBindingEntry.SOURCE_ARP_SNOOPING`
            * :attr:`AddressBindingEntry.SOURCE_DHCP_SNOOPING`
            * :attr:`AddressBindingEntry.SOURCE_VM_TOOLS`
            * :attr:`AddressBindingEntry.SOURCE_ND_SNOOPING`
            * :attr:`AddressBindingEntry.SOURCE_DHCPV6_SNOOPING`
            * :attr:`AddressBindingEntry.SOURCE_VM_TOOLS_V6`
            
            Source from which the address binding entry was obtained
        """
        self.binding = binding
        self.binding_timestamp = binding_timestamp
        self.source = source
        VapiStruct.__init__(self)


AddressBindingEntry._set_binding_type(type.StructType(
    'com.vmware.nsx.model.address_binding_entry', {
        'binding': type.OptionalType(type.ReferenceType(__name__, 'PacketAddressClassifier')),
        'binding_timestamp': type.OptionalType(type.IntegerType()),
        'source': type.OptionalType(type.StringType()),
    },
    AddressBindingEntry,
    False,
    None))



class AdvanceClusterRestoreInput(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'id': 'id',
                            'resources': 'resources',
                            }

    def __init__(self,
                 id=None,
                 resources=None,
                ):
        """
        :type  id: :class:`str` or ``None``
        :param id: Unique id of an instruction (as returned by the GET /restore/status
            call) for which input is to be provided
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  resources: :class:`list` of :class:`SelectableResourceReference` or ``None``
        :param resources: List of resources for which the instruction is applicable.
        """
        self.id = id
        self.resources = resources
        VapiStruct.__init__(self)


AdvanceClusterRestoreInput._set_binding_type(type.StructType(
    'com.vmware.nsx.model.advance_cluster_restore_input', {
        'id': type.OptionalType(type.StringType()),
        'resources': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'SelectableResourceReference'))),
    },
    AdvanceClusterRestoreInput,
    False,
    None))



class AdvanceClusterRestoreRequest(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'data': 'data',
                            }

    def __init__(self,
                 data=None,
                ):
        """
        :type  data: :class:`list` of :class:`AdvanceClusterRestoreInput` or ``None``
        :param data: List of instructions and their associated data
        """
        self.data = data
        VapiStruct.__init__(self)


AdvanceClusterRestoreRequest._set_binding_type(type.StructType(
    'com.vmware.nsx.model.advance_cluster_restore_request', {
        'data': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AdvanceClusterRestoreInput'))),
    },
    AdvanceClusterRestoreRequest,
    False,
    None))



class AdvertiseRule(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ACTION_DENY = "DENY"
    """


    """
    ACTION_ALLOW = "ALLOW"
    """


    """



    _canonical_to_pep_names = {
                            'action': 'action',
                            'description': 'description',
                            'display_name': 'display_name',
                            'networks': 'networks',
                            'rule_filter': 'rule_filter',
                            }

    def __init__(self,
                 action=None,
                 description=None,
                 display_name=None,
                 networks=None,
                 rule_filter=None,
                ):
        """
        :type  action: :class:`str` or ``None``
        :param action: Possible values are: 
            
            * :attr:`AdvertiseRule.ACTION_DENY`
            * :attr:`AdvertiseRule.ACTION_ALLOW`
            
            ALLOW action enables the advertisment and DENY action disables the
            advertisement of a filtered routes to the connected TIER0 router.
        :type  description: :class:`str` or ``None``
        :param description: Description
        :type  display_name: :class:`str` or ``None``
        :param display_name: Display name
        :type  networks: :class:`list` of :class:`str` or ``None``
        :param networks: network(CIDR) to be routed format: ip-cidr-block
        :type  rule_filter: :class:`AdvertisementRuleFilter` or ``None``
        :param rule_filter: 
        """
        self.action = action
        self.description = description
        self.display_name = display_name
        self.networks = networks
        self.rule_filter = rule_filter
        VapiStruct.__init__(self)


AdvertiseRule._set_binding_type(type.StructType(
    'com.vmware.nsx.model.advertise_rule', {
        'action': type.OptionalType(type.StringType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'networks': type.OptionalType(type.ListType(type.StringType())),
        'rule_filter': type.OptionalType(type.ReferenceType(__name__, 'AdvertisementRuleFilter')),
    },
    AdvertiseRule,
    False,
    None))



class AdvertiseRuleList(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'logical_router_id': 'logical_router_id',
                            'rules': 'rules',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 logical_router_id=None,
                 rules=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  logical_router_id: :class:`str` or ``None``
        :param logical_router_id: Logical router id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  rules: :class:`list` of :class:`AdvertiseRule` or ``None``
        :param rules: List of advertisement rules
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.logical_router_id = logical_router_id
        self.rules = rules
        VapiStruct.__init__(self)


AdvertiseRuleList._set_binding_type(type.StructType(
    'com.vmware.nsx.model.advertise_rule_list', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'logical_router_id': type.OptionalType(type.StringType()),
        'rules': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AdvertiseRule'))),
    },
    AdvertiseRuleList,
    False,
    None))



class AdvertisementConfig(VapiStruct):
    """
    Advertisement config for different types of routes which need to be
    advertised from TIER1 logical router to the linked TIER0 logical router

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'advertise_dns_forwarder': 'advertise_dns_forwarder',
                            'advertise_ipsec_local_ip': 'advertise_ipsec_local_ip',
                            'advertise_lb_snat_ip': 'advertise_lb_snat_ip',
                            'advertise_lb_vip': 'advertise_lb_vip',
                            'advertise_nat_routes': 'advertise_nat_routes',
                            'advertise_nsx_connected_routes': 'advertise_nsx_connected_routes',
                            'advertise_static_routes': 'advertise_static_routes',
                            'enabled': 'enabled',
                            'logical_router_id': 'logical_router_id',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 advertise_dns_forwarder=None,
                 advertise_ipsec_local_ip=None,
                 advertise_lb_snat_ip=None,
                 advertise_lb_vip=None,
                 advertise_nat_routes=None,
                 advertise_nsx_connected_routes=None,
                 advertise_static_routes=None,
                 enabled=None,
                 logical_router_id=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  advertise_dns_forwarder: :class:`bool` or ``None``
        :param advertise_dns_forwarder: Flag to advertise all routes of dns forwarder listener ips and
            source ips
        :type  advertise_ipsec_local_ip: :class:`bool` or ``None``
        :param advertise_ipsec_local_ip: Flag to advertise all IPSec VPN local endpoint ips to linked TIER0
            logical router
        :type  advertise_lb_snat_ip: :class:`bool` or ``None``
        :param advertise_lb_snat_ip: Flag to advertise all lb SNAT ips
        :type  advertise_lb_vip: :class:`bool` or ``None``
        :param advertise_lb_vip: Flag to advertise lb vip ips
        :type  advertise_nat_routes: :class:`bool` or ``None``
        :param advertise_nat_routes: Flag to advertise all routes of nat
        :type  advertise_nsx_connected_routes: :class:`bool` or ``None``
        :param advertise_nsx_connected_routes: Flag to advertise all connected routes
        :type  advertise_static_routes: :class:`bool` or ``None``
        :param advertise_static_routes: Flag to advertise all static routes
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Flag to enable this configuration
        :type  logical_router_id: :class:`str` or ``None``
        :param logical_router_id: TIER1 logical router id on which to enable this configuration
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.advertise_dns_forwarder = advertise_dns_forwarder
        self.advertise_ipsec_local_ip = advertise_ipsec_local_ip
        self.advertise_lb_snat_ip = advertise_lb_snat_ip
        self.advertise_lb_vip = advertise_lb_vip
        self.advertise_nat_routes = advertise_nat_routes
        self.advertise_nsx_connected_routes = advertise_nsx_connected_routes
        self.advertise_static_routes = advertise_static_routes
        self.enabled = enabled
        self.logical_router_id = logical_router_id
        VapiStruct.__init__(self)


AdvertisementConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.advertisement_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'advertise_dns_forwarder': type.OptionalType(type.BooleanType()),
        'advertise_ipsec_local_ip': type.OptionalType(type.BooleanType()),
        'advertise_lb_snat_ip': type.OptionalType(type.BooleanType()),
        'advertise_lb_vip': type.OptionalType(type.BooleanType()),
        'advertise_nat_routes': type.OptionalType(type.BooleanType()),
        'advertise_nsx_connected_routes': type.OptionalType(type.BooleanType()),
        'advertise_static_routes': type.OptionalType(type.BooleanType()),
        'enabled': type.OptionalType(type.BooleanType()),
        'logical_router_id': type.OptionalType(type.StringType()),
    },
    AdvertisementConfig,
    False,
    None))



class AdvertisementRuleFilter(VapiStruct):
    """
    To filter the routes advertised by the TIER1 LR to TIER0 LR. Filtering will
    be based on the type of route and the prefix operator configured.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MATCH_ROUTE_TYPES_ANY = "ANY"
    """


    """
    MATCH_ROUTE_TYPES_STATIC = "STATIC"
    """


    """
    MATCH_ROUTE_TYPES_T1_STATIC = "T1_STATIC"
    """


    """
    MATCH_ROUTE_TYPES_NSX_CONNECTED = "NSX_CONNECTED"
    """


    """
    MATCH_ROUTE_TYPES_T1_CONNECTED = "T1_CONNECTED"
    """


    """
    MATCH_ROUTE_TYPES_T1_NAT = "T1_NAT"
    """


    """
    MATCH_ROUTE_TYPES_T1_LB_VIP = "T1_LB_VIP"
    """


    """
    MATCH_ROUTE_TYPES_T1_LB_SNAT = "T1_LB_SNAT"
    """


    """
    MATCH_ROUTE_TYPES_T1_DNSFORWARDER = "T1_DNSFORWARDER"
    """


    """
    MATCH_ROUTE_TYPES_T1_IPSEC_LOCAL_IP = "T1_IPSEC_LOCAL_IP"
    """


    """
    PREFIX_OPERATOR_GE = "GE"
    """


    """
    PREFIX_OPERATOR_EQ = "EQ"
    """


    """



    _canonical_to_pep_names = {
                            'match_route_types': 'match_route_types',
                            'prefix_operator': 'prefix_operator',
                            }

    def __init__(self,
                 match_route_types=None,
                 prefix_operator=None,
                ):
        """
        :type  match_route_types: :class:`list` of :class:`str` or ``None``
        :param match_route_types: Possible values are: 
            
            * :attr:`AdvertisementRuleFilter.MATCH_ROUTE_TYPES_ANY`
            * :attr:`AdvertisementRuleFilter.MATCH_ROUTE_TYPES_STATIC`
            * :attr:`AdvertisementRuleFilter.MATCH_ROUTE_TYPES_T1_STATIC`
            * :attr:`AdvertisementRuleFilter.MATCH_ROUTE_TYPES_NSX_CONNECTED`
            * :attr:`AdvertisementRuleFilter.MATCH_ROUTE_TYPES_T1_CONNECTED`
            * :attr:`AdvertisementRuleFilter.MATCH_ROUTE_TYPES_T1_NAT`
            * :attr:`AdvertisementRuleFilter.MATCH_ROUTE_TYPES_T1_LB_VIP`
            * :attr:`AdvertisementRuleFilter.MATCH_ROUTE_TYPES_T1_LB_SNAT`
            * :attr:`AdvertisementRuleFilter.MATCH_ROUTE_TYPES_T1_DNSFORWARDER`
            *
              :attr:`AdvertisementRuleFilter.MATCH_ROUTE_TYPES_T1_IPSEC_LOCAL_IP`
            
            Array of route types to filter routes
        :type  prefix_operator: :class:`str` or ``None``
        :param prefix_operator: Possible values are: 
            
            * :attr:`AdvertisementRuleFilter.PREFIX_OPERATOR_GE`
            * :attr:`AdvertisementRuleFilter.PREFIX_OPERATOR_EQ`
            
            GE prefix operator filters all the routes having network subset of
            any of the networks configured in Advertise rule. EQ prefix
            operator filter all the routes having network equal to any of the
            network configured in Advertise rule.
        """
        self.match_route_types = match_route_types
        self.prefix_operator = prefix_operator
        VapiStruct.__init__(self)


AdvertisementRuleFilter._set_binding_type(type.StructType(
    'com.vmware.nsx.model.advertisement_rule_filter', {
        'match_route_types': type.OptionalType(type.ListType(type.StringType())),
        'prefix_operator': type.OptionalType(type.StringType()),
    },
    AdvertisementRuleFilter,
    False,
    None))



class AgentStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    NAME_AGENT = "NSX_AGENT"
    """


    """
    NAME_OPSAGENT = "NSX_OPSAGENT"
    """


    """
    NAME_CFGAGENT = "NSX_CFGAGENT"
    """


    """
    NAME_NESTDB = "NSX_NESTDB"
    """


    """
    STATUS_UP = "UP"
    """


    """
    STATUS_DOWN = "DOWN"
    """


    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """
    STATUS_DEGRADED = "DEGRADED"
    """


    """



    _canonical_to_pep_names = {
                            'components': 'components',
                            'last_status_changed_time': 'last_status_changed_time',
                            'name': 'name',
                            'status': 'status',
                            'status_description': 'status_description',
                            }

    def __init__(self,
                 components=None,
                 last_status_changed_time=None,
                 name=None,
                 status=None,
                 status_description=None,
                ):
        """
        :type  components: :class:`list` of :class:`AgentSubStatus` or ``None``
        :param components: List of agent subcomponent statuses
        :type  last_status_changed_time: :class:`long` or ``None``
        :param last_status_changed_time: Timestamp of the last status change, in epoch milliseconds format:
            int64
        :type  name: :class:`str` or ``None``
        :param name: Possible values are: 
            
            * :attr:`AgentStatus.NAME_AGENT`
            * :attr:`AgentStatus.NAME_OPSAGENT`
            * :attr:`AgentStatus.NAME_CFGAGENT`
            * :attr:`AgentStatus.NAME_NESTDB`
            
            Agent name
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`AgentStatus.STATUS_UP`
            * :attr:`AgentStatus.STATUS_DOWN`
            * :attr:`AgentStatus.STATUS_UNKNOWN`
            * :attr:`AgentStatus.STATUS_DEGRADED`
            
            Agent status
        :type  status_description: :class:`str` or ``None``
        :param status_description: Describe what makes the status not UP
        """
        self.components = components
        self.last_status_changed_time = last_status_changed_time
        self.name = name
        self.status = status
        self.status_description = status_description
        VapiStruct.__init__(self)


AgentStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.agent_status', {
        'components': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AgentSubStatus'))),
        'last_status_changed_time': type.OptionalType(type.IntegerType()),
        'name': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
        'status_description': type.OptionalType(type.StringType()),
    },
    AgentStatus,
    False,
    None))



class AgentStatusCount(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_UP = "UP"
    """


    """
    STATUS_DOWN = "DOWN"
    """


    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """
    STATUS_DEGRADED = "DEGRADED"
    """


    """



    _canonical_to_pep_names = {
                            'agents': 'agents',
                            'degraded_count': 'degraded_count',
                            'down_count': 'down_count',
                            'last_status_changed_time': 'last_status_changed_time',
                            'smartnic_agents': 'smartnic_agents',
                            'status': 'status',
                            'up_count': 'up_count',
                            }

    def __init__(self,
                 agents=None,
                 degraded_count=None,
                 down_count=None,
                 last_status_changed_time=None,
                 smartnic_agents=None,
                 status=None,
                 up_count=None,
                ):
        """
        :type  agents: :class:`list` of :class:`AgentStatus` or ``None``
        :param agents: List of agent statuses belonging to the transport node
        :type  degraded_count: :class:`long` or ``None``
        :param degraded_count: Degraded count format: int32
        :type  down_count: :class:`long` or ``None``
        :param down_count: Down count format: int32
        :type  last_status_changed_time: :class:`long` or ``None``
        :param last_status_changed_time: Timestamp of the last status change, in epoch milliseconds format:
            int64
        :type  smartnic_agents: :class:`list` of :class:`SmartnicAgentStatus` or ``None``
        :param smartnic_agents: List of Smartnic agent statuses
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`AgentStatusCount.STATUS_UP`
            * :attr:`AgentStatusCount.STATUS_DOWN`
            * :attr:`AgentStatusCount.STATUS_UNKNOWN`
            * :attr:`AgentStatusCount.STATUS_DEGRADED`
            
            Roll-up agent status
        :type  up_count: :class:`long` or ``None``
        :param up_count: Up count format: int32
        """
        self.agents = agents
        self.degraded_count = degraded_count
        self.down_count = down_count
        self.last_status_changed_time = last_status_changed_time
        self.smartnic_agents = smartnic_agents
        self.status = status
        self.up_count = up_count
        VapiStruct.__init__(self)


AgentStatusCount._set_binding_type(type.StructType(
    'com.vmware.nsx.model.agent_status_count', {
        'agents': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AgentStatus'))),
        'degraded_count': type.OptionalType(type.IntegerType()),
        'down_count': type.OptionalType(type.IntegerType()),
        'last_status_changed_time': type.OptionalType(type.IntegerType()),
        'smartnic_agents': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'SmartnicAgentStatus'))),
        'status': type.OptionalType(type.StringType()),
        'up_count': type.OptionalType(type.IntegerType()),
    },
    AgentStatusCount,
    False,
    None))



class AgentSubStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_UP = "UP"
    """


    """
    STATUS_DOWN = "DOWN"
    """


    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'name': 'name',
                            'status': 'status',
                            'status_description': 'status_description',
                            }

    def __init__(self,
                 name=None,
                 status=None,
                 status_description=None,
                ):
        """
        :type  name: :class:`str` or ``None``
        :param name: Agent subcomponent name
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`AgentSubStatus.STATUS_UP`
            * :attr:`AgentSubStatus.STATUS_DOWN`
            * :attr:`AgentSubStatus.STATUS_UNKNOWN`
            
            Agent subcomponent status
        :type  status_description: :class:`str` or ``None``
        :param status_description: Describe what makes the status not UP
        """
        self.name = name
        self.status = status
        self.status_description = status_description
        VapiStruct.__init__(self)


AgentSubStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.agent_sub_status', {
        'name': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
        'status_description': type.OptionalType(type.StringType()),
    },
    AgentSubStatus,
    False,
    None))



class AggregatedDataCounter(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'rx_bytes': 'rx_bytes',
                            'rx_packets': 'rx_packets',
                            'tx_bytes': 'tx_bytes',
                            'tx_packets': 'tx_packets',
                            }

    def __init__(self,
                 rx_bytes=None,
                 rx_packets=None,
                 tx_bytes=None,
                 tx_packets=None,
                ):
        """
        :type  rx_bytes: :class:`DataCounter` or ``None``
        :param rx_bytes: 
        :type  rx_packets: :class:`DataCounter` or ``None``
        :param rx_packets: 
        :type  tx_bytes: :class:`DataCounter` or ``None``
        :param tx_bytes: 
        :type  tx_packets: :class:`DataCounter` or ``None``
        :param tx_packets: 
        """
        self.rx_bytes = rx_bytes
        self.rx_packets = rx_packets
        self.tx_bytes = tx_bytes
        self.tx_packets = tx_packets
        VapiStruct.__init__(self)


AggregatedDataCounter._set_binding_type(type.StructType(
    'com.vmware.nsx.model.aggregated_data_counter', {
        'rx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'rx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
    },
    AggregatedDataCounter,
    False,
    None))



class AggregatedDataCounterEx(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'rx_bytes': 'rx_bytes',
                            'rx_packets': 'rx_packets',
                            'tx_bytes': 'tx_bytes',
                            'tx_packets': 'tx_packets',
                            'dropped_by_firewall_packets': 'dropped_by_firewall_packets',
                            'dropped_by_security_packets': 'dropped_by_security_packets',
                            'mac_learning': 'mac_learning',
                            }

    def __init__(self,
                 rx_bytes=None,
                 rx_packets=None,
                 tx_bytes=None,
                 tx_packets=None,
                 dropped_by_firewall_packets=None,
                 dropped_by_security_packets=None,
                 mac_learning=None,
                ):
        """
        :type  rx_bytes: :class:`DataCounter` or ``None``
        :param rx_bytes: 
        :type  rx_packets: :class:`DataCounter` or ``None``
        :param rx_packets: 
        :type  tx_bytes: :class:`DataCounter` or ``None``
        :param tx_bytes: 
        :type  tx_packets: :class:`DataCounter` or ``None``
        :param tx_packets: 
        :type  dropped_by_firewall_packets: :class:`DfwDropCounters` or ``None``
        :param dropped_by_firewall_packets: 
        :type  dropped_by_security_packets: :class:`PacketsDroppedBySecurity` or ``None``
        :param dropped_by_security_packets: 
        :type  mac_learning: :class:`MacLearningCounters` or ``None``
        :param mac_learning: 
        """
        self.rx_bytes = rx_bytes
        self.rx_packets = rx_packets
        self.tx_bytes = tx_bytes
        self.tx_packets = tx_packets
        self.dropped_by_firewall_packets = dropped_by_firewall_packets
        self.dropped_by_security_packets = dropped_by_security_packets
        self.mac_learning = mac_learning
        VapiStruct.__init__(self)


AggregatedDataCounterEx._set_binding_type(type.StructType(
    'com.vmware.nsx.model.aggregated_data_counter_ex', {
        'rx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'rx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'dropped_by_firewall_packets': type.OptionalType(type.ReferenceType(__name__, 'DfwDropCounters')),
        'dropped_by_security_packets': type.OptionalType(type.ReferenceType(__name__, 'PacketsDroppedBySecurity')),
        'mac_learning': type.OptionalType(type.ReferenceType(__name__, 'MacLearningCounters')),
    },
    AggregatedDataCounterEx,
    False,
    None))



class AggregatedLogicalRouterPortCounters(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'last_update_timestamp': 'last_update_timestamp',
                            'rx': 'rx',
                            'tx': 'tx',
                            }

    def __init__(self,
                 last_update_timestamp=None,
                 rx=None,
                 tx=None,
                ):
        """
        :type  last_update_timestamp: :class:`long` or ``None``
        :param last_update_timestamp: Timestamp when the data was last updated; unset if data source has
            never updated the data. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  rx: :class:`LogicalRouterPortCounters` or ``None``
        :param rx: 
        :type  tx: :class:`LogicalRouterPortCounters` or ``None``
        :param tx: 
        """
        self.last_update_timestamp = last_update_timestamp
        self.rx = rx
        self.tx = tx
        VapiStruct.__init__(self)


AggregatedLogicalRouterPortCounters._set_binding_type(type.StructType(
    'com.vmware.nsx.model.aggregated_logical_router_port_counters', {
        'last_update_timestamp': type.OptionalType(type.IntegerType()),
        'rx': type.OptionalType(type.ReferenceType(__name__, 'LogicalRouterPortCounters')),
        'tx': type.OptionalType(type.ReferenceType(__name__, 'LogicalRouterPortCounters')),
    },
    AggregatedLogicalRouterPortCounters,
    False,
    None))



class Alarm(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ALARM_SOURCE_TYPE_INTENT_PATH = "INTENT_PATH"
    """


    """
    ALARM_SOURCE_TYPE_ENTITY_ID = "ENTITY_ID"
    """


    """
    ALARM_SOURCE_TYPE_SYSTEM_ID = "SYSTEM_ID"
    """


    """
    SEVERITY_CRITICAL = "CRITICAL"
    """


    """
    SEVERITY_HIGH = "HIGH"
    """


    """
    SEVERITY_MEDIUM = "MEDIUM"
    """


    """
    SEVERITY_LOW = "LOW"
    """


    """
    STATUS_OPEN = "OPEN"
    """


    """
    STATUS_ACKNOWLEDGED = "ACKNOWLEDGED"
    """


    """
    STATUS_SUPPRESSED = "SUPPRESSED"
    """


    """
    STATUS_RESOLVED = "RESOLVED"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'alarm_source': 'alarm_source',
                            'alarm_source_type': 'alarm_source_type',
                            'entity_id': 'entity_id',
                            'entity_resource_type': 'entity_resource_type',
                            'event_tags': 'event_tags',
                            'event_type': 'event_type',
                            'event_type_display_name': 'event_type_display_name',
                            'feature_display_name': 'feature_display_name',
                            'feature_name': 'feature_name',
                            'kb_article': 'kb_article',
                            'last_reported_time': 'last_reported_time',
                            'node_display_name': 'node_display_name',
                            'node_id': 'node_id',
                            'node_ip_addresses': 'node_ip_addresses',
                            'node_resource_type': 'node_resource_type',
                            'recommended_action': 'recommended_action',
                            'reoccurrences_while_suppressed': 'reoccurrences_while_suppressed',
                            'resolved_by': 'resolved_by',
                            'resolved_time': 'resolved_time',
                            'runtime_data': 'runtime_data',
                            'severity': 'severity',
                            'status': 'status',
                            'summary': 'summary',
                            'suppress_duration': 'suppress_duration',
                            'suppress_start_time': 'suppress_start_time',
                            'suppressed_by': 'suppressed_by',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 alarm_source=None,
                 alarm_source_type=None,
                 entity_id=None,
                 entity_resource_type=None,
                 event_tags=None,
                 event_type=None,
                 event_type_display_name=None,
                 feature_display_name=None,
                 feature_name=None,
                 kb_article=None,
                 last_reported_time=None,
                 node_display_name=None,
                 node_id=None,
                 node_ip_addresses=None,
                 node_resource_type=None,
                 recommended_action=None,
                 reoccurrences_while_suppressed=None,
                 resolved_by=None,
                 resolved_time=None,
                 runtime_data=None,
                 severity=None,
                 status=None,
                 summary=None,
                 suppress_duration=None,
                 suppress_start_time=None,
                 suppressed_by=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Detailed description of Alarm. This is the same detailed
            description as the corresponding Event identified by
            feature_name.event_type.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: ID that uniquely identifies an Alarm.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  alarm_source: :class:`list` of :class:`str` or ``None``
        :param alarm_source: If alarm_source_type = INTENT_PATH, this field will contain a list
            of intent paths for the entity that the event instance applies to.
            If alarm_source_type = ENTITY_ID, this field will contain a list
            with a single item identifying the entity id that the event
            instance applies to.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  alarm_source_type: :class:`str` or ``None``
        :param alarm_source_type: Possible values are: 
            
            * :attr:`Alarm.ALARM_SOURCE_TYPE_INTENT_PATH`
            * :attr:`Alarm.ALARM_SOURCE_TYPE_ENTITY_ID`
            * :attr:`Alarm.ALARM_SOURCE_TYPE_SYSTEM_ID`
            
            Type of alarm source of the Event instance. Can be one of -
            INTENT_PATH, ENTITY_ID.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  entity_id: :class:`str` or ``None``
        :param entity_id: The entity that the Event instance applies to. Note entity_id may
            not be included in a response body. For example, the cpu_high Event
            may not return an entity_id.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  entity_resource_type: :class:`str` or ``None``
        :param entity_resource_type: The entity type that the Event instance applies to.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  event_tags: :class:`list` of :class:`str` or ``None``
        :param event_tags: Tags applicable to event, for example, INFRASTRUCTURE or
            INTELLIGENCE.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  event_type: :class:`str` or ``None``
        :param event_type: Name of Event, e.g. manager_cpu_usage_high, certificate_expired.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  event_type_display_name: :class:`str` or ``None``
        :param event_type_display_name: Display name of Event type.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  feature_display_name: :class:`str` or ``None``
        :param feature_display_name: Display name of feature defining this Event.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  feature_name: :class:`str` or ``None``
        :param feature_name: Feature defining this Event, e.g. manager_health, certificates.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  kb_article: :class:`str` or ``None``
        :param kb_article: KB article link that contains more information on this alarm and
            recommended actions. Users can refer to the specified link if
            needed.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_reported_time: :class:`long` or ``None``
        :param last_reported_time: Indicates when the corresponding Event instance was last reported
            in milliseconds since epoch. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_display_name: :class:`str` or ``None``
        :param node_display_name: Display name of node that the event instance applies to.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_id: :class:`str` or ``None``
        :param node_id: The UUID of the node that the Event instance applies to.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_ip_addresses: :class:`list` of :class:`str` or ``None``
        :param node_ip_addresses: IP addresses of node that the event instance applies to.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_resource_type: :class:`str` or ``None``
        :param node_resource_type: The resource type of node that the Event instance applies to eg.
            ClusterNodeConfig, TransportNode.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  recommended_action: :class:`str` or ``None``
        :param recommended_action: Recommended action for Alarm. This is the same action as the
            corresponding Event identified by feature_name.event_type.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  reoccurrences_while_suppressed: :class:`long` or ``None``
        :param reoccurrences_while_suppressed: The number of reoccurrences since this alarm has been SUPPRESSED.
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  resolved_by: :class:`str` or ``None``
        :param resolved_by: User ID of the user that set the status value to RESOLVED. This
            value can be SYSTEM to indicate that the system resolved the Alarm,
            for example when the system determines CPU usage is no longer high
            and the cpu_high Alarm is no longer applicable. This property is
            only returned when the status value is RESOLVED.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  resolved_time: :class:`long` or ``None``
        :param resolved_time: Indicates when the Alarm was resolved in milliseconds since epoch.
            This property is only returned when the status value is RESOLVED.
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  runtime_data: :class:`str` or ``None``
        :param runtime_data: Runtime data for Alarm. When an alarming condition occurs, there
            may be additional data of interest when triaging the underlying
            issue, for example, output from system commands captured at the
            time of the error. Note, the contents of this property are not
            localized.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  severity: :class:`str` or ``None``
        :param severity: Possible values are: 
            
            * :attr:`Alarm.SEVERITY_CRITICAL`
            * :attr:`Alarm.SEVERITY_HIGH`
            * :attr:`Alarm.SEVERITY_MEDIUM`
            * :attr:`Alarm.SEVERITY_LOW`
            
            Severity of the Alarm.Can be one of - CRITICAL, HIGH, MEDIUM, LOW.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`Alarm.STATUS_OPEN`
            * :attr:`Alarm.STATUS_ACKNOWLEDGED`
            * :attr:`Alarm.STATUS_SUPPRESSED`
            * :attr:`Alarm.STATUS_RESOLVED`
            
            Indicate the status which the Alarm is in.
        :type  summary: :class:`str` or ``None``
        :param summary: Summary description of Alarm. This is the same summary description
            as the corresponding Event identified by feature_name.event_type.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  suppress_duration: :class:`long` or ``None``
        :param suppress_duration: The time period between suppress_start_time and suppress_start_time
            + suppress_duration (specified in hours) an Alarm is SUPPRESSED.
            This property is only returned when the status value is SUPPRESSED.
            format: int64
        :type  suppress_start_time: :class:`long` or ``None``
        :param suppress_start_time: Indicates when the Alarm was suppressed in milliseconds since
            epoch. This property is only returned when the status value is
            SUPPRESSED. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  suppressed_by: :class:`str` or ``None``
        :param suppressed_by: User ID of the user that set the status value to SUPPRESSED. This
            property is only returned when the status value is SUPPRESSED.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.alarm_source = alarm_source
        self.alarm_source_type = alarm_source_type
        self.entity_id = entity_id
        self.entity_resource_type = entity_resource_type
        self.event_tags = event_tags
        self.event_type = event_type
        self.event_type_display_name = event_type_display_name
        self.feature_display_name = feature_display_name
        self.feature_name = feature_name
        self.kb_article = kb_article
        self.last_reported_time = last_reported_time
        self.node_display_name = node_display_name
        self.node_id = node_id
        self.node_ip_addresses = node_ip_addresses
        self.node_resource_type = node_resource_type
        self.recommended_action = recommended_action
        self.reoccurrences_while_suppressed = reoccurrences_while_suppressed
        self.resolved_by = resolved_by
        self.resolved_time = resolved_time
        self.runtime_data = runtime_data
        self.severity = severity
        self.status = status
        self.summary = summary
        self.suppress_duration = suppress_duration
        self.suppress_start_time = suppress_start_time
        self.suppressed_by = suppressed_by
        VapiStruct.__init__(self)


Alarm._set_binding_type(type.StructType(
    'com.vmware.nsx.model.alarm', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'alarm_source': type.OptionalType(type.ListType(type.StringType())),
        'alarm_source_type': type.OptionalType(type.StringType()),
        'entity_id': type.OptionalType(type.StringType()),
        'entity_resource_type': type.OptionalType(type.StringType()),
        'event_tags': type.OptionalType(type.ListType(type.StringType())),
        'event_type': type.OptionalType(type.StringType()),
        'event_type_display_name': type.OptionalType(type.StringType()),
        'feature_display_name': type.OptionalType(type.StringType()),
        'feature_name': type.OptionalType(type.StringType()),
        'kb_article': type.OptionalType(type.StringType()),
        'last_reported_time': type.OptionalType(type.IntegerType()),
        'node_display_name': type.OptionalType(type.StringType()),
        'node_id': type.OptionalType(type.StringType()),
        'node_ip_addresses': type.OptionalType(type.ListType(type.StringType())),
        'node_resource_type': type.OptionalType(type.StringType()),
        'recommended_action': type.OptionalType(type.StringType()),
        'reoccurrences_while_suppressed': type.OptionalType(type.IntegerType()),
        'resolved_by': type.OptionalType(type.StringType()),
        'resolved_time': type.OptionalType(type.IntegerType()),
        'runtime_data': type.OptionalType(type.StringType()),
        'severity': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
        'summary': type.OptionalType(type.StringType()),
        'suppress_duration': type.OptionalType(type.IntegerType()),
        'suppress_start_time': type.OptionalType(type.IntegerType()),
        'suppressed_by': type.OptionalType(type.StringType()),
    },
    Alarm,
    False,
    None))



class AlarmsListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`Alarm` or ``None``
        :param results: List of alarms known to the system
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


AlarmsListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.alarms_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Alarm'))),
    },
    AlarmsListResult,
    False,
    None))



class AllClusterGroupStatus(VapiStruct):
    """
    A list of the statuses of all the groups in the cluster.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    OVERALL_STATUS_STABLE = "STABLE"
    """


    """
    OVERALL_STATUS_DEGRADED = "DEGRADED"
    """


    """
    OVERALL_STATUS_UNAVAILABLE = "UNAVAILABLE"
    """


    """



    _canonical_to_pep_names = {
                            'cluster_id': 'cluster_id',
                            'groups': 'groups',
                            'overall_status': 'overall_status',
                            }

    def __init__(self,
                 cluster_id=None,
                 groups=None,
                 overall_status=None,
                ):
        """
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: UUID of the cluster
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  groups: :class:`list` of :class:`ClusterGroupStatus` or ``None``
        :param groups: Array of groups and their statuses
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overall_status: :class:`str` or ``None``
        :param overall_status: Possible values are: 
            
            * :attr:`AllClusterGroupStatus.OVERALL_STATUS_STABLE`
            * :attr:`AllClusterGroupStatus.OVERALL_STATUS_DEGRADED`
            * :attr:`AllClusterGroupStatus.OVERALL_STATUS_UNAVAILABLE`
            
            Overall status of the cluster
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.cluster_id = cluster_id
        self.groups = groups
        self.overall_status = overall_status
        VapiStruct.__init__(self)


AllClusterGroupStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.all_cluster_group_status', {
        'cluster_id': type.OptionalType(type.StringType()),
        'groups': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterGroupStatus'))),
        'overall_status': type.OptionalType(type.StringType()),
    },
    AllClusterGroupStatus,
    False,
    None))



class AllocatedService(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    HIGH_AVAILABILITY_STATUS_ACTIVE = "ACTIVE"
    """


    """
    HIGH_AVAILABILITY_STATUS_STANDBY = "STANDBY"
    """


    """
    HIGH_AVAILABILITY_STATUS_DOWN = "DOWN"
    """


    """
    HIGH_AVAILABILITY_STATUS_SYNC = "SYNC"
    """


    """
    HIGH_AVAILABILITY_STATUS_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'allocation_details': 'allocation_details',
                            'high_availability_status': 'high_availability_status',
                            'service_reference': 'service_reference',
                            }

    def __init__(self,
                 allocation_details=None,
                 high_availability_status=None,
                 service_reference=None,
                ):
        """
        :type  allocation_details: :class:`list` of :class:`KeyValuePair` or ``None``
        :param allocation_details: Additional properties of a service, say the sub_pool_size and
            sub_pool_type for a LoadBalancer.
        :type  high_availability_status: :class:`str` or ``None``
        :param high_availability_status: Possible values are: 
            
            * :attr:`AllocatedService.HIGH_AVAILABILITY_STATUS_ACTIVE`
            * :attr:`AllocatedService.HIGH_AVAILABILITY_STATUS_STANDBY`
            * :attr:`AllocatedService.HIGH_AVAILABILITY_STATUS_DOWN`
            * :attr:`AllocatedService.HIGH_AVAILABILITY_STATUS_SYNC`
            * :attr:`AllocatedService.HIGH_AVAILABILITY_STATUS_UNKNOWN`
            
            Represents the active or the standby state of the service.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  service_reference: :class:`ResourceReference` or ``None``
        :param service_reference: 
        """
        self.allocation_details = allocation_details
        self.high_availability_status = high_availability_status
        self.service_reference = service_reference
        VapiStruct.__init__(self)


AllocatedService._set_binding_type(type.StructType(
    'com.vmware.nsx.model.allocated_service', {
        'allocation_details': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'KeyValuePair'))),
        'high_availability_status': type.OptionalType(type.StringType()),
        'service_reference': type.OptionalType(type.ReferenceType(__name__, 'ResourceReference')),
    },
    AllocatedService,
    False,
    None))



class AllocationBasedOnFailureDomain(VapiStruct):
    """
    Auto place TIER1 logical routers, DHCP and MDProxy contexts on two edge
    nodes (active and standby) from different failure domains.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AllocationBasedOnFailureDomain"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'enabled': 'enabled',
                            'action_type': 'action_type',
                            }

    def __init__(self,
                 enabled=None,
                 action_type='AllocationBasedOnFailureDomain',
                ):
        """
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Enable placement algorithm to consider failure domain of edge
            transport nodes and place active and standby contexts in different
            failure domains.
        :type  action_type: :class:`str`
        :param action_type: Possible values are: 
            
            *
              :attr:`AllocationRuleAction.ACTION_TYPE_ALLOCATIONBASEDONFAILUREDOMAIN`
            
            Set action for each allocation rule on edge cluster which will help
            in auto placement.
        """
        self.enabled = enabled
        self._action_type = action_type
        VapiStruct.__init__(self)

    @property
    def action_type(self):
        """
        Return the discriminator value
        """
        return self._action_type

AllocationBasedOnFailureDomain._set_binding_type(type.StructType(
    'com.vmware.nsx.model.allocation_based_on_failure_domain', {
        'enabled': type.OptionalType(type.BooleanType()),
        'action_type': type.StringType(),
    },
    AllocationBasedOnFailureDomain,
    False,
    None))



class AllocationIpAddress(VapiStruct):
    """
    Allocation parameters for the IP address (e.g. specific IP address) can be
    specified. Tags, display_name and description attributes are not supported
    in this release.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'allocation_id': 'allocation_id',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 allocation_id=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  allocation_id: :class:`str` or ``None``
        :param allocation_id: Address that is allocated from pool format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.allocation_id = allocation_id
        VapiStruct.__init__(self)


AllocationIpAddress._set_binding_type(type.StructType(
    'com.vmware.nsx.model.allocation_ip_address', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'allocation_id': type.OptionalType(type.StringType()),
    },
    AllocationIpAddress,
    False,
    None))



class AllocationIpAddressListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`AllocationIpAddress` or ``None``
        :param results: Pool allocation list results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


AllocationIpAddressListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.allocation_ip_address_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AllocationIpAddress'))),
    },
    AllocationIpAddressListResult,
    False,
    None))



class AllocationPool(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'active_service_count': 'active_service_count',
                            'standby_service_count': 'standby_service_count',
                            'sub_pools': 'sub_pools',
                            }

    def __init__(self,
                 active_service_count=None,
                 standby_service_count=None,
                 sub_pools=None,
                ):
        """
        :type  active_service_count: :class:`long` or ``None``
        :param active_service_count: Represents the number of acitve services running on the edge node.
            format: int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  standby_service_count: :class:`long` or ``None``
        :param standby_service_count: Represents the number of standby services running on the edge node.
            format: int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sub_pools: :class:`list` of :class:`SubPool` or ``None``
        :param sub_pools: Allocation details of sub-pools configured on edge node.
        """
        self.active_service_count = active_service_count
        self.standby_service_count = standby_service_count
        self.sub_pools = sub_pools
        VapiStruct.__init__(self)


AllocationPool._set_binding_type(type.StructType(
    'com.vmware.nsx.model.allocation_pool', {
        'active_service_count': type.OptionalType(type.IntegerType()),
        'standby_service_count': type.OptionalType(type.IntegerType()),
        'sub_pools': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'SubPool'))),
    },
    AllocationPool,
    False,
    None))



class AllocationRule(VapiStruct):
    """
    Allocation rule on edge cluster which will be considered in auto placement
    of TIER1 logical routers, DHCP and MDProxy.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'action': 'action',
                            }

    def __init__(self,
                 action=None,
                ):
        """
        :type  action: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param action: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`AllocationRuleAction`. When methods return a value of this
            class as a return value, the attribute will contain all the
            attributes defined in :class:`AllocationRuleAction`.
        """
        self.action = action
        VapiStruct.__init__(self)


AllocationRule._set_binding_type(type.StructType(
    'com.vmware.nsx.model.allocation_rule', {
        'action': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'AllocationRuleAction')])),
    },
    AllocationRule,
    False,
    None))



class AllocationRuleAction(VapiStruct):
    """
    Define action for each allocation rule which added on edge cluster.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AllocationRuleAction"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    ACTION_TYPE_ALLOCATIONBASEDONFAILUREDOMAIN = "AllocationBasedOnFailureDomain"
    """


    """



    _canonical_to_pep_names = {
                            'action_type': 'action_type',
                            }

    def __init__(self,
                 action_type='AllocationRuleAction',
                ):
        """
        :type  action_type: :class:`str`
        :param action_type: Possible values are: 
            
            *
              :attr:`AllocationRuleAction.ACTION_TYPE_ALLOCATIONBASEDONFAILUREDOMAIN`
            
            Set action for each allocation rule on edge cluster which will help
            in auto placement.
        """
        self._action_type = action_type
        VapiStruct.__init__(self)

    @property
    def action_type(self):
        """
        Return the discriminator value
        """
        return self._action_type

AllocationRuleAction._set_binding_type(type.StructType(
    'com.vmware.nsx.model.allocation_rule_action', {
        'action_type': type.StringType(),
    },
    AllocationRuleAction,
    False,
    None))



class AntreaContainerClusterNode(VapiStruct):
    """
    Antrea container cluster and its nodes requiring a support bundle

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'cluster_id': 'cluster_id',
                            'nodes': 'nodes',
                            }

    def __init__(self,
                 cluster_id=None,
                 nodes=None,
                ):
        """
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: The UUID of the container cluster
        :type  nodes: :class:`list` of :class:`str` or ``None``
        :param nodes: List of at most 200 container node UUIDs requiring a support bundle
        """
        self.cluster_id = cluster_id
        self.nodes = nodes
        VapiStruct.__init__(self)


AntreaContainerClusterNode._set_binding_type(type.StructType(
    'com.vmware.nsx.model.antrea_container_cluster_node', {
        'cluster_id': type.OptionalType(type.StringType()),
        'nodes': type.OptionalType(type.ListType(type.StringType())),
    },
    AntreaContainerClusterNode,
    False,
    None))



class AntreaSupportBundleContainerNode(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AntreaSupportBundleContainerNode"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'clusters': 'clusters',
                            'container_type': 'container_type',
                            }

    def __init__(self,
                 clusters=None,
                 container_type='AntreaSupportBundleContainerNode',
                ):
        """
        :type  clusters: :class:`list` of :class:`AntreaContainerClusterNode` or ``None``
        :param clusters: List of AntreaContainerClusterNodes identifying container clusters
            and their nodes
        :type  container_type: :class:`str`
        :param container_type: Possible values are: 
            
            * :attr:`SupportBundleContainerNode.CONTAINER_TYPE_ANTREA`
            
            Support bundle container type
        """
        self.clusters = clusters
        self._container_type = container_type
        VapiStruct.__init__(self)

    @property
    def container_type(self):
        """
        Return the discriminator value
        """
        return self._container_type

AntreaSupportBundleContainerNode._set_binding_type(type.StructType(
    'com.vmware.nsx.model.antrea_support_bundle_container_node', {
        'clusters': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AntreaContainerClusterNode'))),
        'container_type': type.StringType(),
    },
    AntreaSupportBundleContainerNode,
    False,
    None))



class AphInfo(VapiStruct):
    """
    APH information.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'address': 'address',
                            'certificate': 'certificate',
                            'fqdn': 'fqdn',
                            'node_id': 'node_id',
                            'port': 'port',
                            'use_fqdn': 'use_fqdn',
                            'uuid': 'uuid',
                            }

    def __init__(self,
                 address=None,
                 certificate=None,
                 fqdn=None,
                 node_id=None,
                 port=None,
                 use_fqdn=None,
                 uuid=None,
                ):
        """
        :type  address: :class:`str` or ``None``
        :param address: IP address of APH service
        :type  certificate: :class:`str` or ``None``
        :param certificate: PEM Certificate of APH service
        :type  fqdn: :class:`str` or ``None``
        :param fqdn: FQDN, only returned by GET /sites and GET /sites/self
        :type  node_id: :class:`str` or ``None``
        :param node_id: Node ID of the APH service
        :type  port: :class:`long` or ``None``
        :param port: Port of APH service format: int64
        :type  use_fqdn: :class:`bool` or ``None``
        :param use_fqdn: whether or not fqdn flag is on
        :type  uuid: :class:`str` or ``None``
        :param uuid: ID of the APH service
        """
        self.address = address
        self.certificate = certificate
        self.fqdn = fqdn
        self.node_id = node_id
        self.port = port
        self.use_fqdn = use_fqdn
        self.uuid = uuid
        VapiStruct.__init__(self)


AphInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.aph_info', {
        'address': type.OptionalType(type.StringType()),
        'certificate': type.OptionalType(type.StringType()),
        'fqdn': type.OptionalType(type.StringType()),
        'node_id': type.OptionalType(type.StringType()),
        'port': type.OptionalType(type.IntegerType()),
        'use_fqdn': type.OptionalType(type.BooleanType()),
        'uuid': type.OptionalType(type.StringType()),
    },
    AphInfo,
    False,
    None))



class ApiError(VapiStruct):
    """
    Detailed information about an API Error

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'details': 'details',
                            'error_code': 'error_code',
                            'error_data': 'error_data',
                            'error_message': 'error_message',
                            'module_name': 'module_name',
                            'related_errors': 'related_errors',
                            }

    def __init__(self,
                 details=None,
                 error_code=None,
                 error_data=None,
                 error_message=None,
                 module_name=None,
                 related_errors=None,
                ):
        """
        :type  details: :class:`str` or ``None``
        :param details: Further details about the error
        :type  error_code: :class:`long` or ``None``
        :param error_code: A numeric error code format: int64
        :type  error_data: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param error_data: Additional data about the error
        :type  error_message: :class:`str` or ``None``
        :param error_message: A description of the error
        :type  module_name: :class:`str` or ``None``
        :param module_name: The module name where the error occurred
        :type  related_errors: :class:`list` of :class:`RelatedApiError` or ``None``
        :param related_errors: Other errors related to this error
        """
        self.details = details
        self.error_code = error_code
        self.error_data = error_data
        self.error_message = error_message
        self.module_name = module_name
        self.related_errors = related_errors
        VapiStruct.__init__(self)


ApiError._set_binding_type(type.StructType(
    'com.vmware.nsx.model.api_error', {
        'details': type.OptionalType(type.StringType()),
        'error_code': type.OptionalType(type.IntegerType()),
        'error_data': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
        'error_message': type.OptionalType(type.StringType()),
        'module_name': type.OptionalType(type.StringType()),
        'related_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'RelatedApiError'))),
    },
    ApiError,
    False,
    None))



class ApiServiceConfig(VapiStruct):
    """
    Properties that affect the configuration of the NSX API service.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'basic_authentication_enabled': 'basic_authentication_enabled',
                            'cipher_suites': 'cipher_suites',
                            'client_api_concurrency_limit': 'client_api_concurrency_limit',
                            'client_api_rate_limit': 'client_api_rate_limit',
                            'connection_timeout': 'connection_timeout',
                            'cookie_based_authentication_enabled': 'cookie_based_authentication_enabled',
                            'global_api_concurrency_limit': 'global_api_concurrency_limit',
                            'lockout_immune_addresses': 'lockout_immune_addresses',
                            'protocol_versions': 'protocol_versions',
                            'redirect_host': 'redirect_host',
                            'session_timeout': 'session_timeout',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 basic_authentication_enabled=None,
                 cipher_suites=None,
                 client_api_concurrency_limit=None,
                 client_api_rate_limit=None,
                 connection_timeout=None,
                 cookie_based_authentication_enabled=None,
                 global_api_concurrency_limit=None,
                 lockout_immune_addresses=None,
                 protocol_versions=None,
                 redirect_host=None,
                 session_timeout=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  basic_authentication_enabled: :class:`bool` or ``None``
        :param basic_authentication_enabled: Identifies whether basic authentication is enabled or disabled in
            API calls.
        :type  cipher_suites: :class:`list` of :class:`CipherSuite` or ``None``
        :param cipher_suites: The TLS cipher suites that the API service will negotiate.
        :type  client_api_concurrency_limit: :class:`long` or ``None``
        :param client_api_concurrency_limit: The maximum number of concurrent API requests that will be serviced
            for a given authenticated client. If the number of API requests
            being processed exceeds this limit, new API requests will be
            refused and a 503 Service Unavailable response will be returned to
            the client. To disable API concurrency limiting, set this value to
            0. format: int64
        :type  client_api_rate_limit: :class:`long` or ``None``
        :param client_api_rate_limit: The maximum number of API requests that will be serviced per second
            for a given authenticated client. If more API requests are received
            than can be serviced, a 429 Too Many Requests HTTP response will be
            returned. To disable API rate limiting, set this value to 0.
            format: int64
        :type  connection_timeout: :class:`long` or ``None``
        :param connection_timeout: NSX connection timeout, in seconds. To disable timeout, set to 0.
            format: int64
        :type  cookie_based_authentication_enabled: :class:`bool` or ``None``
        :param cookie_based_authentication_enabled: Identifies whether cookie-based authentication is enabled or
            disabled in API calls. When cookie-based authentication is
            disabled, new sessions cannot be created via /api/session/create.
        :type  global_api_concurrency_limit: :class:`long` or ``None``
        :param global_api_concurrency_limit: The maximum number of concurrent API requests that will be
            serviced. If the number of API requests being processed exceeds
            this limit, new API requests will be refused and a 503 Service
            Unavailable response will be returned to the client. To disable API
            concurrency limiting, set this value to 0. format: int64
        :type  lockout_immune_addresses: :class:`list` of :class:`str` or ``None``
        :param lockout_immune_addresses: The list of IP addresses which are not subjected to a lockout on
            failed login attempts. format: ip
        :type  protocol_versions: :class:`list` of :class:`ProtocolVersion` or ``None``
        :param protocol_versions: The TLS protocol versions that the API service will negotiate.
        :type  redirect_host: :class:`str` or ``None``
        :param redirect_host: Host name or IP address to use for redirect location headers, or
            empty string to derive from current request. To disable, set
            redirect_host to the empty string (\"\").
        :type  session_timeout: :class:`long` or ``None``
        :param session_timeout: NSX session inactivity timeout format: int64
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.basic_authentication_enabled = basic_authentication_enabled
        self.cipher_suites = cipher_suites
        self.client_api_concurrency_limit = client_api_concurrency_limit
        self.client_api_rate_limit = client_api_rate_limit
        self.connection_timeout = connection_timeout
        self.cookie_based_authentication_enabled = cookie_based_authentication_enabled
        self.global_api_concurrency_limit = global_api_concurrency_limit
        self.lockout_immune_addresses = lockout_immune_addresses
        self.protocol_versions = protocol_versions
        self.redirect_host = redirect_host
        self.session_timeout = session_timeout
        VapiStruct.__init__(self)


ApiServiceConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.api_service_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'basic_authentication_enabled': type.OptionalType(type.BooleanType()),
        'cipher_suites': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CipherSuite'))),
        'client_api_concurrency_limit': type.OptionalType(type.IntegerType()),
        'client_api_rate_limit': type.OptionalType(type.IntegerType()),
        'connection_timeout': type.OptionalType(type.IntegerType()),
        'cookie_based_authentication_enabled': type.OptionalType(type.BooleanType()),
        'global_api_concurrency_limit': type.OptionalType(type.IntegerType()),
        'lockout_immune_addresses': type.OptionalType(type.ListType(type.StringType())),
        'protocol_versions': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ProtocolVersion'))),
        'redirect_host': type.OptionalType(type.StringType()),
        'session_timeout': type.OptionalType(type.IntegerType()),
    },
    ApiServiceConfig,
    False,
    None))



class ApplianceLatencyData(VapiStruct):
    """
    Display the latency data by given appliance node

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'id': 'id',
                            'latency_data': 'latency_data',
                            'name': 'name',
                            'timestamp': 'timestamp',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 id=None,
                 latency_data=None,
                 name=None,
                 timestamp=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  id: :class:`str` or ``None``
        :param id: Display the Appliance id.
        :type  latency_data: :class:`list` of :class:`ApplianceLatencyDataItem` or ``None``
        :param latency_data: Latency Data list.
        :type  name: :class:`str` or ``None``
        :param name: Display the appliance name.
        :type  timestamp: :class:`long` or ``None``
        :param timestamp: Timestamp of last modification. format: int64
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.id = id
        self.latency_data = latency_data
        self.name = name
        self.timestamp = timestamp
        VapiStruct.__init__(self)


ApplianceLatencyData._set_binding_type(type.StructType(
    'com.vmware.nsx.model.appliance_latency_data', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'id': type.OptionalType(type.StringType()),
        'latency_data': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ApplianceLatencyDataItem'))),
        'name': type.OptionalType(type.StringType()),
        'timestamp': type.OptionalType(type.IntegerType()),
    },
    ApplianceLatencyData,
    False,
    None))



class ApplianceLatencyDataItem(VapiStruct):
    """
    Describes appliance latency data in detail.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_UP = "UP"
    """


    """
    STATUS_DOWN = "DOWN"
    """


    """



    _canonical_to_pep_names = {
                            'destination_node_id': 'destination_node_id',
                            'destination_node_ip': 'destination_node_ip',
                            'destination_node_name': 'destination_node_name',
                            'packet_loss_percent': 'packet_loss_percent',
                            'packet_received': 'packet_received',
                            'packet_transmitted': 'packet_transmitted',
                            'rtt_avg': 'rtt_avg',
                            'rtt_max': 'rtt_max',
                            'rtt_mdev': 'rtt_mdev',
                            'rtt_min': 'rtt_min',
                            'source_node_ip': 'source_node_ip',
                            'status': 'status',
                            'total_time': 'total_time',
                            }

    def __init__(self,
                 destination_node_id=None,
                 destination_node_ip=None,
                 destination_node_name=None,
                 packet_loss_percent=None,
                 packet_received=None,
                 packet_transmitted=None,
                 rtt_avg=None,
                 rtt_max=None,
                 rtt_mdev=None,
                 rtt_min=None,
                 source_node_ip=None,
                 status=None,
                 total_time=None,
                ):
        """
        :type  destination_node_id: :class:`str` or ``None``
        :param destination_node_id: Display the appliance node id.
        :type  destination_node_ip: :class:`str` or ``None``
        :param destination_node_ip: Display the appliance node ip.
        :type  destination_node_name: :class:`str` or ``None``
        :param destination_node_name: Display the appliance node name.
        :type  packet_loss_percent: :class:`str` or ``None``
        :param packet_loss_percent: Display the percentage of lost packet.
        :type  packet_received: :class:`long` or ``None``
        :param packet_received: Display the received packets. format: int64
        :type  packet_transmitted: :class:`long` or ``None``
        :param packet_transmitted: Display the transmitted packets in Ping format: int64
        :type  rtt_avg: :class:`float` or ``None``
        :param rtt_avg: Display the average Round Trip Time in milliseconds.
        :type  rtt_max: :class:`float` or ``None``
        :param rtt_max: Display the max Round Trip Time in milliseconds.
        :type  rtt_mdev: :class:`float` or ``None``
        :param rtt_mdev: Display the mean Round Trip Time in milliseconds.
        :type  rtt_min: :class:`float` or ``None``
        :param rtt_min: Display the min Round Trip Time in milliseconds.
        :type  source_node_ip: :class:`str` or ``None``
        :param source_node_ip: Display the appliance node ip.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ApplianceLatencyDataItem.STATUS_UP`
            * :attr:`ApplianceLatencyDataItem.STATUS_DOWN`
            
            Display the connection status between source node and destination
            node.
        :type  total_time: :class:`long` or ``None``
        :param total_time: Display the total time of sending and receiving packets in
            milliseconds. format: int64
        """
        self.destination_node_id = destination_node_id
        self.destination_node_ip = destination_node_ip
        self.destination_node_name = destination_node_name
        self.packet_loss_percent = packet_loss_percent
        self.packet_received = packet_received
        self.packet_transmitted = packet_transmitted
        self.rtt_avg = rtt_avg
        self.rtt_max = rtt_max
        self.rtt_mdev = rtt_mdev
        self.rtt_min = rtt_min
        self.source_node_ip = source_node_ip
        self.status = status
        self.total_time = total_time
        VapiStruct.__init__(self)


ApplianceLatencyDataItem._set_binding_type(type.StructType(
    'com.vmware.nsx.model.appliance_latency_data_item', {
        'destination_node_id': type.OptionalType(type.StringType()),
        'destination_node_ip': type.OptionalType(type.StringType()),
        'destination_node_name': type.OptionalType(type.StringType()),
        'packet_loss_percent': type.OptionalType(type.StringType()),
        'packet_received': type.OptionalType(type.IntegerType()),
        'packet_transmitted': type.OptionalType(type.IntegerType()),
        'rtt_avg': type.OptionalType(type.DoubleType()),
        'rtt_max': type.OptionalType(type.DoubleType()),
        'rtt_mdev': type.OptionalType(type.DoubleType()),
        'rtt_min': type.OptionalType(type.DoubleType()),
        'source_node_ip': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
        'total_time': type.OptionalType(type.IntegerType()),
    },
    ApplianceLatencyDataItem,
    False,
    None))



class ApplianceLatencyListResult(VapiStruct):
    """
    List of process data

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Total appliance latency count format: int64
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ApplianceLatencyData` or ``None``
        :param results: Display the appliance latency data list.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ApplianceLatencyListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.appliance_latency_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ApplianceLatencyData'))),
    },
    ApplianceLatencyListResult,
    False,
    None))



class ApplianceManagementTaskListResult(VapiStruct):
    """
    Appliance management task query results

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ApplianceManagementTaskProperties` or ``None``
        :param results: Task property results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ApplianceManagementTaskListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.appliance_management_task_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ApplianceManagementTaskProperties'))),
    },
    ApplianceManagementTaskListResult,
    False,
    None))



class ApplianceManagementTaskProperties(VapiStruct):
    """
    Appliance management task properties

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_RUNNING = "running"
    """


    """
    STATUS_ERROR = "error"
    """


    """
    STATUS_SUCCESS = "success"
    """


    """
    STATUS_CANCELING = "canceling"
    """


    """
    STATUS_CANCELED = "canceled"
    """


    """
    STATUS_KILLED = "killed"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'async_response_available': 'async_response_available',
                            'cancelable': 'cancelable',
                            'description': 'description',
                            'details': 'details',
                            'end_time': 'end_time',
                            'id': 'id',
                            'message': 'message',
                            'progress': 'progress',
                            'request_method': 'request_method',
                            'request_uri': 'request_uri',
                            'start_time': 'start_time',
                            'status': 'status',
                            'user': 'user',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 async_response_available=None,
                 cancelable=None,
                 description=None,
                 details=None,
                 end_time=None,
                 id=None,
                 message=None,
                 progress=None,
                 request_method=None,
                 request_uri=None,
                 start_time=None,
                 status=None,
                 user=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  async_response_available: :class:`bool` or ``None``
        :param async_response_available: True if response for asynchronous request is available
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  cancelable: :class:`bool` or ``None``
        :param cancelable: True if this task can be canceled
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of the task
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  details: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param details: Details about the task if known
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  end_time: :class:`long` or ``None``
        :param end_time: The end time of the task in epoch milliseconds format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  id: :class:`str` or ``None``
        :param id: Identifier for this task
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  message: :class:`str` or ``None``
        :param message: A message describing the disposition of the task
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  progress: :class:`long` or ``None``
        :param progress: Task progress if known, from 0 to 100 format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  request_method: :class:`str` or ``None``
        :param request_method: HTTP request method
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  request_uri: :class:`str` or ``None``
        :param request_uri: URI of the method invocation that spawned this task
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  start_time: :class:`long` or ``None``
        :param start_time: The start time of the task in epoch milliseconds format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ApplianceManagementTaskProperties.STATUS_RUNNING`
            * :attr:`ApplianceManagementTaskProperties.STATUS_ERROR`
            * :attr:`ApplianceManagementTaskProperties.STATUS_SUCCESS`
            * :attr:`ApplianceManagementTaskProperties.STATUS_CANCELING`
            * :attr:`ApplianceManagementTaskProperties.STATUS_CANCELED`
            * :attr:`ApplianceManagementTaskProperties.STATUS_KILLED`
            
            Current status of the task
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  user: :class:`str` or ``None``
        :param user: Name of the user who created this task
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.async_response_available = async_response_available
        self.cancelable = cancelable
        self.description = description
        self.details = details
        self.end_time = end_time
        self.id = id
        self.message = message
        self.progress = progress
        self.request_method = request_method
        self.request_uri = request_uri
        self.start_time = start_time
        self.status = status
        self.user = user
        VapiStruct.__init__(self)


ApplianceManagementTaskProperties._set_binding_type(type.StructType(
    'com.vmware.nsx.model.appliance_management_task_properties', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'async_response_available': type.OptionalType(type.BooleanType()),
        'cancelable': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'details': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
        'end_time': type.OptionalType(type.IntegerType()),
        'id': type.OptionalType(type.StringType()),
        'message': type.OptionalType(type.StringType()),
        'progress': type.OptionalType(type.IntegerType()),
        'request_method': type.OptionalType(type.StringType()),
        'request_uri': type.OptionalType(type.StringType()),
        'start_time': type.OptionalType(type.IntegerType()),
        'status': type.OptionalType(type.StringType()),
        'user': type.OptionalType(type.StringType()),
    },
    ApplianceManagementTaskProperties,
    False,
    None))



class ApplianceProcessData(VapiStruct):
    """
    List of process data in given appliance node

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'id': 'id',
                            'name': 'name',
                            'timestamp': 'timestamp',
                            'top_process_by_cpu_count': 'top_process_by_cpu_count',
                            'top_process_by_cpu_list': 'top_process_by_cpu_list',
                            'top_process_by_mem_count': 'top_process_by_mem_count',
                            'top_process_by_mem_list': 'top_process_by_mem_list',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 id=None,
                 name=None,
                 timestamp=None,
                 top_process_by_cpu_count=None,
                 top_process_by_cpu_list=None,
                 top_process_by_mem_count=None,
                 top_process_by_mem_list=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  id: :class:`str` or ``None``
        :param id: Display the Appliance id.
        :type  name: :class:`str` or ``None``
        :param name: Display the appliance name.
        :type  timestamp: :class:`long` or ``None``
        :param timestamp: Timestamp of last modification. format: int64
        :type  top_process_by_cpu_count: :class:`long` or ``None``
        :param top_process_by_cpu_count: Display the total count of process. format: int64
        :type  top_process_by_cpu_list: :class:`list` of :class:`ProcessInformation` or ``None``
        :param top_process_by_cpu_list: Display the top process list by CPU.
        :type  top_process_by_mem_count: :class:`long` or ``None``
        :param top_process_by_mem_count: Display the total count of process. format: int64
        :type  top_process_by_mem_list: :class:`list` of :class:`ProcessInformation` or ``None``
        :param top_process_by_mem_list: Display the top process list by memory.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.id = id
        self.name = name
        self.timestamp = timestamp
        self.top_process_by_cpu_count = top_process_by_cpu_count
        self.top_process_by_cpu_list = top_process_by_cpu_list
        self.top_process_by_mem_count = top_process_by_mem_count
        self.top_process_by_mem_list = top_process_by_mem_list
        VapiStruct.__init__(self)


ApplianceProcessData._set_binding_type(type.StructType(
    'com.vmware.nsx.model.appliance_process_data', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'id': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
        'timestamp': type.OptionalType(type.IntegerType()),
        'top_process_by_cpu_count': type.OptionalType(type.IntegerType()),
        'top_process_by_cpu_list': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ProcessInformation'))),
        'top_process_by_mem_count': type.OptionalType(type.IntegerType()),
        'top_process_by_mem_list': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ProcessInformation'))),
    },
    ApplianceProcessData,
    False,
    None))



class ApplianceProcessListResult(VapiStruct):
    """
    List of process data

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ApplianceProcessData` or ``None``
        :param results: Display the appliance process list.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ApplianceProcessListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.appliance_process_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ApplianceProcessData'))),
    },
    ApplianceProcessListResult,
    False,
    None))



class AppliedTos(VapiStruct):
    """
    Entity lists where the profile will be enabled on.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'logical_ports': 'logical_ports',
                            'logical_switches': 'logical_switches',
                            'nsgroups': 'nsgroups',
                            }

    def __init__(self,
                 logical_ports=None,
                 logical_switches=None,
                 nsgroups=None,
                ):
        """
        :type  logical_ports: :class:`list` of :class:`ResourceReference` or ``None``
        :param logical_ports: Logical Port List
        :type  logical_switches: :class:`list` of :class:`ResourceReference` or ``None``
        :param logical_switches: Logical Switch List
        :type  nsgroups: :class:`list` of :class:`ResourceReference` or ``None``
        :param nsgroups: NSGroup List
        """
        self.logical_ports = logical_ports
        self.logical_switches = logical_switches
        self.nsgroups = nsgroups
        VapiStruct.__init__(self)


AppliedTos._set_binding_type(type.StructType(
    'com.vmware.nsx.model.applied_tos', {
        'logical_ports': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceReference'))),
        'logical_switches': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceReference'))),
        'nsgroups': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceReference'))),
    },
    AppliedTos,
    False,
    None))



class ArpHeader(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    OP_CODE_REQUEST = "ARP_REQUEST"
    """


    """
    OP_CODE_REPLY = "ARP_REPLY"
    """


    """



    _canonical_to_pep_names = {
                            'dst_ip': 'dst_ip',
                            'op_code': 'op_code',
                            'src_ip': 'src_ip',
                            }

    def __init__(self,
                 dst_ip=None,
                 op_code=None,
                 src_ip=None,
                ):
        """
        :type  dst_ip: :class:`str` or ``None``
        :param dst_ip: The destination IP address format: ipv4
        :type  op_code: :class:`str` or ``None``
        :param op_code: Possible values are: 
            
            * :attr:`ArpHeader.OP_CODE_REQUEST`
            * :attr:`ArpHeader.OP_CODE_REPLY`
            
            This field specifies the nature of the Arp message being sent.
        :type  src_ip: :class:`str` or ``None``
        :param src_ip: This field specifies the IP address of the sender. If omitted, the
            src_ip is set to 0.0.0.0. format: ipv4
        """
        self.dst_ip = dst_ip
        self.op_code = op_code
        self.src_ip = src_ip
        VapiStruct.__init__(self)


ArpHeader._set_binding_type(type.StructType(
    'com.vmware.nsx.model.arp_header', {
        'dst_ip': type.OptionalType(type.StringType()),
        'op_code': type.OptionalType(type.StringType()),
        'src_ip': type.OptionalType(type.StringType()),
    },
    ArpHeader,
    False,
    None))



class AssignedByAutoConf(VapiStruct):
    """
    This type can be specified in ipv6 assignment spec of host switch if
    auto-conf based IPv6 assignment is desired for host switch virtual tunnel
    endpoints.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AssignedByAutoConf"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 resource_type='AssignedByAutoConf',
                ):
        """
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_STATICIPV6POOLSPEC`
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_STATICIPV6LISTSPEC`
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_ASSIGNEDBYDHCPV6`
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_STATICIPV6MACLISTSPEC`
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_ASSIGNEDBYAUTOCONF`
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_NOIPV6`
        """
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

AssignedByAutoConf._set_binding_type(type.StructType(
    'com.vmware.nsx.model.assigned_by_auto_conf', {
        'resource_type': type.StringType(),
    },
    AssignedByAutoConf,
    False,
    None))



class AssignedByDhcp(VapiStruct):
    """
    This type can be specified in ip assignment spec of host switch if DHCP
    based IP assignment is desired for host switch virtual tunnel endpoints.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AssignedByDhcp"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 resource_type='AssignedByDhcp',
                ):
        """
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`IpAssignmentSpec.RESOURCE_TYPE_STATICIPPOOLSPEC`
            * :attr:`IpAssignmentSpec.RESOURCE_TYPE_STATICIPLISTSPEC`
            * :attr:`IpAssignmentSpec.RESOURCE_TYPE_ASSIGNEDBYDHCP`
            * :attr:`IpAssignmentSpec.RESOURCE_TYPE_STATICIPMACLISTSPEC`
            * :attr:`IpAssignmentSpec.RESOURCE_TYPE_NOIPV4`
        """
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

AssignedByDhcp._set_binding_type(type.StructType(
    'com.vmware.nsx.model.assigned_by_dhcp', {
        'resource_type': type.StringType(),
    },
    AssignedByDhcp,
    False,
    None))



class AssignedByDhcpv6(VapiStruct):
    """
    This type can be specified in ip assignment spec of host switch if DHCP
    based IP assignment is desired for host switch virtual tunnel endpoints.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AssignedByDhcpv6"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 resource_type='AssignedByDhcpv6',
                ):
        """
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_STATICIPV6POOLSPEC`
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_STATICIPV6LISTSPEC`
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_ASSIGNEDBYDHCPV6`
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_STATICIPV6MACLISTSPEC`
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_ASSIGNEDBYAUTOCONF`
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_NOIPV6`
        """
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

AssignedByDhcpv6._set_binding_type(type.StructType(
    'com.vmware.nsx.model.assigned_by_dhcpv6', {
        'resource_type': type.StringType(),
    },
    AssignedByDhcpv6,
    False,
    None))



class AssociationListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ResourceReference` or ``None``
        :param results: Paged Collection of ResourceReference
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


AssociationListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.association_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceReference'))),
    },
    AssociationListResult,
    False,
    None))



class AttachedInterface(VapiStruct):
    """
    The Attached interface is only effective for the port on Bare metal server.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'app_intf_name': 'app_intf_name',
                            'default_gateway': 'default_gateway',
                            'migrate_intf': 'migrate_intf',
                            'routing_table': 'routing_table',
                            }

    def __init__(self,
                 app_intf_name=None,
                 default_gateway=None,
                 migrate_intf=None,
                 routing_table=None,
                ):
        """
        :type  app_intf_name: :class:`str` or ``None``
        :param app_intf_name: The name of application interface
        :type  default_gateway: :class:`str` or ``None``
        :param default_gateway: Gateway IP format: ip
        :type  migrate_intf: :class:`str` or ``None``
        :param migrate_intf: IP configuration on migrate_intf will migrate to app_intf_name. It
            is used for Management and Application sharing the same IP.
        :type  routing_table: :class:`list` of :class:`str` or ``None``
        :param routing_table: Routing rules
        """
        self.app_intf_name = app_intf_name
        self.default_gateway = default_gateway
        self.migrate_intf = migrate_intf
        self.routing_table = routing_table
        VapiStruct.__init__(self)


AttachedInterface._set_binding_type(type.StructType(
    'com.vmware.nsx.model.attached_interface', {
        'app_intf_name': type.OptionalType(type.StringType()),
        'default_gateway': type.OptionalType(type.StringType()),
        'migrate_intf': type.OptionalType(type.StringType()),
        'routing_table': type.OptionalType(type.ListType(type.StringType())),
    },
    AttachedInterface,
    False,
    None))



class AttachmentContext(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AttachmentContext"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    ALLOCATE_ADDRESSES_IPPOOL = "IpPool"
    """


    """
    ALLOCATE_ADDRESSES_MACPOOL = "MacPool"
    """


    """
    ALLOCATE_ADDRESSES_BOTH = "Both"
    """


    """
    ALLOCATE_ADDRESSES_NONE = "None"
    """


    """
    ALLOCATE_ADDRESSES_DHCP = "Dhcp"
    """


    """
    ALLOCATE_ADDRESSES_DHCPV6 = "DhcpV6"
    """


    """
    ALLOCATE_ADDRESSES_SLAAC = "SLAAC"
    """


    """



    _canonical_to_pep_names = {
                            'allocate_addresses': 'allocate_addresses',
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 allocate_addresses=None,
                 resource_type='AttachmentContext',
                ):
        """
        :type  allocate_addresses: :class:`str` or ``None``
        :param allocate_addresses: Possible values are: 
            
            * :attr:`AttachmentContext.ALLOCATE_ADDRESSES_IPPOOL`
            * :attr:`AttachmentContext.ALLOCATE_ADDRESSES_MACPOOL`
            * :attr:`AttachmentContext.ALLOCATE_ADDRESSES_BOTH`
            * :attr:`AttachmentContext.ALLOCATE_ADDRESSES_NONE`
            * :attr:`AttachmentContext.ALLOCATE_ADDRESSES_DHCP`
            * :attr:`AttachmentContext.ALLOCATE_ADDRESSES_DHCPV6`
            * :attr:`AttachmentContext.ALLOCATE_ADDRESSES_SLAAC`
            
            A flag to indicate whether to allocate addresses from allocation
            pools bound to the parent logical switch.
        :type  resource_type: :class:`str`
        :param resource_type: Used to identify which concrete class it is
        """
        self.allocate_addresses = allocate_addresses
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

AttachmentContext._set_binding_type(type.StructType(
    'com.vmware.nsx.model.attachment_context', {
        'allocate_addresses': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
    },
    AttachmentContext,
    False,
    None))



class Attribute(VapiStruct):
    """
    Attribute specific to a partner. There attributes are passed on to the
    partner appliance and is opaque to the NSX Manager. The Attributes used by
    the partner applicance.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ATTRIBUTE_TYPE_IP_ADDRESS = "IP_ADDRESS"
    """


    """
    ATTRIBUTE_TYPE_PORT = "PORT"
    """


    """
    ATTRIBUTE_TYPE_PASSWORD = "PASSWORD"
    """


    """
    ATTRIBUTE_TYPE_STRING = "STRING"
    """


    """
    ATTRIBUTE_TYPE_LONG = "LONG"
    """


    """
    ATTRIBUTE_TYPE_BOOLEAN = "BOOLEAN"
    """


    """



    _canonical_to_pep_names = {
                            'attribute_type': 'attribute_type',
                            'display_name': 'display_name',
                            'key': 'key',
                            'read_only': 'read_only',
                            'value': 'value',
                            }

    def __init__(self,
                 attribute_type=None,
                 display_name=None,
                 key=None,
                 read_only=None,
                 value=None,
                ):
        """
        :type  attribute_type: :class:`str` or ``None``
        :param attribute_type: Possible values are: 
            
            * :attr:`Attribute.ATTRIBUTE_TYPE_IP_ADDRESS`
            * :attr:`Attribute.ATTRIBUTE_TYPE_PORT`
            * :attr:`Attribute.ATTRIBUTE_TYPE_PASSWORD`
            * :attr:`Attribute.ATTRIBUTE_TYPE_STRING`
            * :attr:`Attribute.ATTRIBUTE_TYPE_LONG`
            * :attr:`Attribute.ATTRIBUTE_TYPE_BOOLEAN`
            
            Attribute Type can be of any of the allowed enum type.
        :type  display_name: :class:`str` or ``None``
        :param display_name: Attribute display name string value.
        :type  key: :class:`str` or ``None``
        :param key: Attribute key string value.
        :type  read_only: :class:`bool` or ``None``
        :param read_only: Read only Attribute cannot be overdidden by service
            instance/deployment.
        :type  value: :class:`str` or ``None``
        :param value: Attribute value string value.
        """
        self.attribute_type = attribute_type
        self.display_name = display_name
        self.key = key
        self.read_only = read_only
        self.value = value
        VapiStruct.__init__(self)


Attribute._set_binding_type(type.StructType(
    'com.vmware.nsx.model.attribute', {
        'attribute_type': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'key': type.OptionalType(type.StringType()),
        'read_only': type.OptionalType(type.BooleanType()),
        'value': type.OptionalType(type.StringType()),
    },
    Attribute,
    False,
    None))



class AuditLog(VapiStruct):
    """
    Audit log in RFC5424 format

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'appname': 'appname',
                            'facility': 'facility',
                            'full_log': 'full_log',
                            'hostname': 'hostname',
                            'message': 'message',
                            'msgid': 'msgid',
                            'priority': 'priority',
                            'procid': 'procid',
                            'struct_data': 'struct_data',
                            'timestamp': 'timestamp',
                            }

    def __init__(self,
                 appname=None,
                 facility=None,
                 full_log=None,
                 hostname=None,
                 message=None,
                 msgid=None,
                 priority=None,
                 procid=None,
                 struct_data=None,
                 timestamp=None,
                ):
        """
        :type  appname: :class:`str` or ``None``
        :param appname: Application name field of the log
        :type  facility: :class:`long` or ``None``
        :param facility: Facility field of the log format: int64
        :type  full_log: :class:`str` or ``None``
        :param full_log: Full log with both header and message
        :type  hostname: :class:`str` or ``None``
        :param hostname: Hostname field of the log
        :type  message: :class:`str` or ``None``
        :param message: Message field of the log
        :type  msgid: :class:`str` or ``None``
        :param msgid: Message ID field of the log
        :type  priority: :class:`long` or ``None``
        :param priority: Priority field of the log format: int64
        :type  procid: :class:`long` or ``None``
        :param procid: Process ID field of the log format: int64
        :type  struct_data: :class:`StructuredData` or ``None``
        :param struct_data: 
        :type  timestamp: :class:`str` or ``None``
        :param timestamp: Date and time in UTC of the log
        """
        self.appname = appname
        self.facility = facility
        self.full_log = full_log
        self.hostname = hostname
        self.message = message
        self.msgid = msgid
        self.priority = priority
        self.procid = procid
        self.struct_data = struct_data
        self.timestamp = timestamp
        VapiStruct.__init__(self)


AuditLog._set_binding_type(type.StructType(
    'com.vmware.nsx.model.audit_log', {
        'appname': type.OptionalType(type.StringType()),
        'facility': type.OptionalType(type.IntegerType()),
        'full_log': type.OptionalType(type.StringType()),
        'hostname': type.OptionalType(type.StringType()),
        'message': type.OptionalType(type.StringType()),
        'msgid': type.OptionalType(type.StringType()),
        'priority': type.OptionalType(type.IntegerType()),
        'procid': type.OptionalType(type.IntegerType()),
        'struct_data': type.OptionalType(type.ReferenceType(__name__, 'StructuredData')),
        'timestamp': type.OptionalType(type.StringType()),
    },
    AuditLog,
    False,
    None))



class AuditLogListResult(VapiStruct):
    """
    Audit log collection results

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'last_full_sync_timestamp': 'last_full_sync_timestamp',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 last_full_sync_timestamp=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_full_sync_timestamp: :class:`str` or ``None``
        :param last_full_sync_timestamp: Timestamp of the last full audit log collection
        :type  results: :class:`list` of :class:`AuditLog` or ``None``
        :param results: Audit log results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.last_full_sync_timestamp = last_full_sync_timestamp
        self.results = results
        VapiStruct.__init__(self)


AuditLogListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.audit_log_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'last_full_sync_timestamp': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AuditLog'))),
    },
    AuditLogListResult,
    False,
    None))



class AuditLogRequest(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    LOG_FILTER_TYPE_TEXT = "TEXT"
    """


    """
    LOG_FILTER_TYPE_REGEX = "REGEX"
    """


    """



    _canonical_to_pep_names = {
                            'log_age_limit': 'log_age_limit',
                            'log_filter': 'log_filter',
                            'log_filter_type': 'log_filter_type',
                            }

    def __init__(self,
                 log_age_limit=None,
                 log_filter=None,
                 log_filter_type=None,
                ):
        """
        :type  log_age_limit: :class:`long` or ``None``
        :param log_age_limit: Include logs with timstamps not past the age limit in days format:
            int64
        :type  log_filter: :class:`str` or ``None``
        :param log_filter: Audit logs should meet the filter condition
        :type  log_filter_type: :class:`str` or ``None``
        :param log_filter_type: Possible values are: 
            
            * :attr:`AuditLogRequest.LOG_FILTER_TYPE_TEXT`
            * :attr:`AuditLogRequest.LOG_FILTER_TYPE_REGEX`
            
            Type of log filter
        """
        self.log_age_limit = log_age_limit
        self.log_filter = log_filter
        self.log_filter_type = log_filter_type
        VapiStruct.__init__(self)


AuditLogRequest._set_binding_type(type.StructType(
    'com.vmware.nsx.model.audit_log_request', {
        'log_age_limit': type.OptionalType(type.IntegerType()),
        'log_filter': type.OptionalType(type.StringType()),
        'log_filter_type': type.OptionalType(type.StringType()),
    },
    AuditLogRequest,
    False,
    None))



class AuthServiceProperties(VapiStruct):
    """
    Auth Service properties

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    LOGGING_LEVEL_OFF = "OFF"
    """


    """
    LOGGING_LEVEL_FATAL = "FATAL"
    """


    """
    LOGGING_LEVEL_ERROR = "ERROR"
    """


    """
    LOGGING_LEVEL_WARN = "WARN"
    """


    """
    LOGGING_LEVEL_INFO = "INFO"
    """


    """
    LOGGING_LEVEL_DEBUG = "DEBUG"
    """


    """
    LOGGING_LEVEL_TRACE = "TRACE"
    """


    """



    _canonical_to_pep_names = {
                            'logging_level': 'logging_level',
                            }

    def __init__(self,
                 logging_level=None,
                ):
        """
        :type  logging_level: :class:`str` or ``None``
        :param logging_level: Possible values are: 
            
            * :attr:`AuthServiceProperties.LOGGING_LEVEL_OFF`
            * :attr:`AuthServiceProperties.LOGGING_LEVEL_FATAL`
            * :attr:`AuthServiceProperties.LOGGING_LEVEL_ERROR`
            * :attr:`AuthServiceProperties.LOGGING_LEVEL_WARN`
            * :attr:`AuthServiceProperties.LOGGING_LEVEL_INFO`
            * :attr:`AuthServiceProperties.LOGGING_LEVEL_DEBUG`
            * :attr:`AuthServiceProperties.LOGGING_LEVEL_TRACE`
            
            Service logging level
        """
        self.logging_level = logging_level
        VapiStruct.__init__(self)


AuthServiceProperties._set_binding_type(type.StructType(
    'com.vmware.nsx.model.auth_service_properties', {
        'logging_level': type.OptionalType(type.StringType()),
    },
    AuthServiceProperties,
    False,
    None))



class AuthenticationPolicyProperties(VapiStruct):
    """
    Configuration of authentication and password policies for the NSX node

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    HASH_ALGORITHM_SHA512 = "sha512"
    """


    """
    HASH_ALGORITHM_SHA256 = "sha256"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_retry_prompt': 'retry_prompt',
                            'digits': 'digits',
                            'hash_algorithm': 'hash_algorithm',
                            'lower_chars': 'lower_chars',
                            'max_repeats': 'max_repeats',
                            'max_sequence': 'max_sequence',
                            'maximum_password_length': 'maximum_password_length',
                            'minimum_password_length': 'minimum_password_length',
                            'minimum_unique_chars': 'minimum_unique_chars',
                            'password_remembrance': 'password_remembrance',
                            'special_chars': 'special_chars',
                            'upper_chars': 'upper_chars',
                            'api_failed_auth_lockout_period': 'api_failed_auth_lockout_period',
                            'api_failed_auth_reset_period': 'api_failed_auth_reset_period',
                            'api_max_auth_failures': 'api_max_auth_failures',
                            'cli_failed_auth_lockout_period': 'cli_failed_auth_lockout_period',
                            'cli_max_auth_failures': 'cli_max_auth_failures',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 retry_prompt=None,
                 digits=None,
                 hash_algorithm=None,
                 lower_chars=None,
                 max_repeats=None,
                 max_sequence=None,
                 maximum_password_length=None,
                 minimum_password_length=None,
                 minimum_unique_chars=None,
                 password_remembrance=None,
                 special_chars=None,
                 upper_chars=None,
                 api_failed_auth_lockout_period=None,
                 api_failed_auth_reset_period=None,
                 api_max_auth_failures=None,
                 cli_failed_auth_lockout_period=None,
                 cli_max_auth_failures=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  retry_prompt: :class:`long` or ``None``
        :param retry_prompt: Prompt user at most N times before returning with error. format:
            int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  digits: :class:`long` or ``None``
        :param digits: Number of digits (0..9) expected in user password. 
            
            N < 0, to set minimum credit for having digits in the new password,
            i.e. this is the minimum number of digits that must be met for a
            new password. 
            
            N > 0, to set maximum credit for having digits in the new password,
            i.e. per occurrence of digit in password will attribute additional
            credit of +1 towards meeting the current
            **minimum_password_length** value upto **N** digits. 
            
            N = 0, policy will be not applicable. By default minimum 1 digit is
            required for a new password. format: int64
        :type  hash_algorithm: :class:`str` or ``None``
        :param hash_algorithm: Possible values are: 
            
            * :attr:`AuthenticationPolicyProperties.HASH_ALGORITHM_SHA512`
            * :attr:`AuthenticationPolicyProperties.HASH_ALGORITHM_SHA256`
            
            Sets hash/cryptographic algorithm type for new passwords.
        :type  lower_chars: :class:`long` or ``None``
        :param lower_chars: Number of lower case characters (a..z) expected in user password. 
            
            N < 0, to set minimum credit for having lower case characters in
            the new password, i.e. this is the minimum number of lower case
            characters that must be met for a new password. 
            
            N > 0, to set maximum credit for having lower case characters in
            the new password, i.e. per occurrence of lower case character in
            password will attribute additional credit of +1 towards meeting the
            current **minimum_password_length** value upto **N** lower case
            characters. 
            
            N = 0, policy will be not applicable. By default minimum 1 lower
            case character is required for a new password. format: int64
        :type  max_repeats: :class:`long` or ``None``
        :param max_repeats: Reject passwords which contain more than N same consecutive
            characters, like aaa or 7777. To disable the check, value should be
            set to 0. format: int64
        :type  max_sequence: :class:`long` or ``None``
        :param max_sequence: Reject passwords which contain more than N monotonic character
            sequences. Monotonic sequences can be '12345' or 'fedcb'. To
            disable the check, value should be set to 0. format: int64
        :type  maximum_password_length: :class:`long` or ``None``
        :param maximum_password_length: Maximum number of characters allowed in password; user can not set
            their password of length greater than this parameter. By default
            maximum length of password is 128 characters. format: int64
        :type  minimum_password_length: :class:`long` or ``None``
        :param minimum_password_length: Minimum number of characters expected in password; user can not set
            their password of length less than this parameter.
            NOTE, for existing users upgrading to NSX-T datacenter version 4.0
            or above - 
            
            if existing appliance is configured with
            ``minimum_password_length`` less than current default value, then
            upgraded appliance will reset the configured setting back to
            recommended default; which can be explicitly modified back to
            original value or any other integer greater than or equal to
            supported minimum value. 
            
            VMware recommends to set strong passwords for systems and
            appliances, further suggests to maintain strong
            ``minimum_password_length`` value. NSX resets this value to default
            and recommends to maintain upgraded default value or above for
            password complexity requirement. 
            
            If any existing user passwords are set with length of less than
            newly configured ``minimum_password_length``, then its recommended
            to reset the user passwords as per newly configured password
            complexity compliance. 
            
            If existing ``minimum_password_length`` is greater than or equal to
            default value, which shall be retained as it is in newly upgraded
            appliance. By default minimum length of password is 12 characters
            and passwords less than 8 characters are never allowed. format:
            int64
        :type  minimum_unique_chars: :class:`long` or ``None``
        :param minimum_unique_chars: Number of character changes in the new password that differentiate
            it from the old password. To disable the check, value should be set
            to 0. format: int64
        :type  password_remembrance: :class:`long` or ``None``
        :param password_remembrance: Limit using a password that was used in past; users can not set the
            same password within the N generations. To disable the check, value
            should be set to 0. format: int64
        :type  special_chars: :class:`long` or ``None``
        :param special_chars: Number of special characters (!\\\\@#$&\*..) expected in user
            password. 
            
            N < 0, to set minimum credit for having special characters in the
            new password, i.e. this is the minimum number of special characters
            that must be met for a new password. 
            
            N > 0, to set maximum credit for having special characters in the
            new password, i.e. per occurrence of special case character in
            password will attribute additional credit of +1 towards meeting the
            current **minimum_password_length** value upto **N** special case
            characters. 
            
            N = 0, policy will be not applicable. By default minimum 1 special
            character is required for a new password. format: int64
        :type  upper_chars: :class:`long` or ``None``
        :param upper_chars: Number of upper case characters (A..Z) expected in user password. 
            
            N < 0, to set minimum credit for having upper case characters in
            the new password, i.e. this is the minimum number of lower case
            characters that must be met for a new password. 
            
            N > 0, to set maximum credit for having upper case characters in
            the new password, i.e. per occurrence of upper case character in
            password will attribute additional credit of +1 towards meeting the
            current **minimum_password_length** value upto **N** upper case
            characters. 
            
            N = 0, policy will be not applicable. By default minimum 1 upper
            case character is required for a new password. format: int64
        :type  api_failed_auth_lockout_period: :class:`long` or ``None``
        :param api_failed_auth_lockout_period: Once a lockout occurs, the account remains locked out of the API
            for this time period. Only applies to NSX Manager nodes. Ignored on
            other node types. format: int64
        :type  api_failed_auth_reset_period: :class:`long` or ``None``
        :param api_failed_auth_reset_period: In order to trigger an account lockout, all authentication failures
            must occur in this time window. If the reset period expires, the
            failed login count is reset to zero. Only applies to NSX Manager
            nodes. Ignored on other node types. format: int64
        :type  api_max_auth_failures: :class:`long` or ``None``
        :param api_max_auth_failures: Only applies to NSX Manager nodes. Ignored on other node types.
            format: int64
        :type  cli_failed_auth_lockout_period: :class:`long` or ``None``
        :param cli_failed_auth_lockout_period: Once a lockout occurs, the account remains locked out of the CLI
            for this time period. While the lockout period is in effect,
            additional authentication attempts restart the lockout period, even
            if a valid password is specified. format: int64
        :type  cli_max_auth_failures: :class:`long` or ``None``
        :param cli_max_auth_failures: Number of authentication failures that trigger CLI lockout format:
            int64
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.retry_prompt = retry_prompt
        self.digits = digits
        self.hash_algorithm = hash_algorithm
        self.lower_chars = lower_chars
        self.max_repeats = max_repeats
        self.max_sequence = max_sequence
        self.maximum_password_length = maximum_password_length
        self.minimum_password_length = minimum_password_length
        self.minimum_unique_chars = minimum_unique_chars
        self.password_remembrance = password_remembrance
        self.special_chars = special_chars
        self.upper_chars = upper_chars
        self.api_failed_auth_lockout_period = api_failed_auth_lockout_period
        self.api_failed_auth_reset_period = api_failed_auth_reset_period
        self.api_max_auth_failures = api_max_auth_failures
        self.cli_failed_auth_lockout_period = cli_failed_auth_lockout_period
        self.cli_max_auth_failures = cli_max_auth_failures
        VapiStruct.__init__(self)


AuthenticationPolicyProperties._set_binding_type(type.StructType(
    'com.vmware.nsx.model.authentication_policy_properties', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_retry_prompt': type.OptionalType(type.IntegerType()),
        'digits': type.OptionalType(type.IntegerType()),
        'hash_algorithm': type.OptionalType(type.StringType()),
        'lower_chars': type.OptionalType(type.IntegerType()),
        'max_repeats': type.OptionalType(type.IntegerType()),
        'max_sequence': type.OptionalType(type.IntegerType()),
        'maximum_password_length': type.OptionalType(type.IntegerType()),
        'minimum_password_length': type.OptionalType(type.IntegerType()),
        'minimum_unique_chars': type.OptionalType(type.IntegerType()),
        'password_remembrance': type.OptionalType(type.IntegerType()),
        'special_chars': type.OptionalType(type.IntegerType()),
        'upper_chars': type.OptionalType(type.IntegerType()),
        'api_failed_auth_lockout_period': type.OptionalType(type.IntegerType()),
        'api_failed_auth_reset_period': type.OptionalType(type.IntegerType()),
        'api_max_auth_failures': type.OptionalType(type.IntegerType()),
        'cli_failed_auth_lockout_period': type.OptionalType(type.IntegerType()),
        'cli_max_auth_failures': type.OptionalType(type.IntegerType()),
    },
    AuthenticationPolicyProperties,
    False,
    None))



class AuthenticationScheme(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'scheme_name': 'scheme_name',
                            }

    def __init__(self,
                 scheme_name=None,
                ):
        """
        :type  scheme_name: :class:`str` or ``None``
        :param scheme_name: Authentication scheme name
        """
        self.scheme_name = scheme_name
        VapiStruct.__init__(self)


AuthenticationScheme._set_binding_type(type.StructType(
    'com.vmware.nsx.model.authentication_scheme', {
        'scheme_name': type.OptionalType(type.StringType()),
    },
    AuthenticationScheme,
    False,
    None))



class AutomaticHealthCheck(VapiStruct):
    """
    Health check performed by system automatically on a specific transport
    zone. For overlay based zone, health check is performed on corresponding
    N-VDS of each transport node with the VLAN and MTU specified by uplink
    profile of N-VDS for the node. For VLAN based zone, health check is
    performed on corresponding N-VDS of each transport node with MTU specified
    by uplink profile of N-VDS for the node and VLAN specified by all logical
    switches in this zone.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'result': 'result',
                            'transport_zone_id': 'transport_zone_id',
                            }

    def __init__(self,
                 result=None,
                 transport_zone_id=None,
                ):
        """
        :type  result: :class:`HealthCheckResult` or ``None``
        :param result: 
        :type  transport_zone_id: :class:`str` or ``None``
        :param transport_zone_id: ID of the transport zone where this automatic health check is
            performed.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.result = result
        self.transport_zone_id = transport_zone_id
        VapiStruct.__init__(self)


AutomaticHealthCheck._set_binding_type(type.StructType(
    'com.vmware.nsx.model.automatic_health_check', {
        'result': type.OptionalType(type.ReferenceType(__name__, 'HealthCheckResult')),
        'transport_zone_id': type.OptionalType(type.StringType()),
    },
    AutomaticHealthCheck,
    False,
    None))



class AutomaticHealthCheckListResult(VapiStruct):
    """
    Automatic health check list result for query with list parameters.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`AutomaticHealthCheck` or ``None``
        :param results: Automatic Health Check List
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


AutomaticHealthCheckListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.automatic_health_check_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AutomaticHealthCheck'))),
    },
    AutomaticHealthCheckListResult,
    False,
    None))



class AutomaticHealthCheckToggle(VapiStruct):
    """
    Toggle to enable/disable automatic health check.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'enabled': 'enabled',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 enabled=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Status of automatic health check
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.enabled = enabled
        VapiStruct.__init__(self)


AutomaticHealthCheckToggle._set_binding_type(type.StructType(
    'com.vmware.nsx.model.automatic_health_check_toggle', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'enabled': type.OptionalType(type.BooleanType()),
    },
    AutomaticHealthCheckToggle,
    False,
    None))



class AviEndPoint(VapiStruct):
    """
    Details about the AVI LB endpoint

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'avi_endpoint_ip': 'avi_endpoint_ip',
                            'avi_endpoint_password': 'avi_endpoint_password',
                            'avi_endpoint_port': 'avi_endpoint_port',
                            'avi_endpoint_username': 'avi_endpoint_username',
                            }

    def __init__(self,
                 avi_endpoint_ip=None,
                 avi_endpoint_password=None,
                 avi_endpoint_port=None,
                 avi_endpoint_username=None,
                ):
        """
        :type  avi_endpoint_ip: :class:`str` or ``None``
        :param avi_endpoint_ip: IP address of the AVI LB endpoint. format: hostname-or-ip
        :type  avi_endpoint_password: :class:`str` or ``None``
        :param avi_endpoint_password: Password for AVI LB endpoint.
        :type  avi_endpoint_port: :class:`long` or ``None``
        :param avi_endpoint_port: AVI LB endpoint port. format: int32
        :type  avi_endpoint_username: :class:`str` or ``None``
        :param avi_endpoint_username: Username for AVI LB endpoint.
        """
        self.avi_endpoint_ip = avi_endpoint_ip
        self.avi_endpoint_password = avi_endpoint_password
        self.avi_endpoint_port = avi_endpoint_port
        self.avi_endpoint_username = avi_endpoint_username
        VapiStruct.__init__(self)


AviEndPoint._set_binding_type(type.StructType(
    'com.vmware.nsx.model.avi_end_point', {
        'avi_endpoint_ip': type.OptionalType(type.StringType()),
        'avi_endpoint_password': type.OptionalType(type.StringType()),
        'avi_endpoint_port': type.OptionalType(type.IntegerType()),
        'avi_endpoint_username': type.OptionalType(type.StringType()),
    },
    AviEndPoint,
    False,
    None))



class Axes(VapiStruct):
    """
    Represents X and Y axes of a graph. For a multi-graph, the same axes are
    shared by all the graphs.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'x_label': 'x_label',
                            'x_labels': 'x_labels',
                            'y_axis_unit_labels': 'y_axis_unit_labels',
                            'y_axis_units': 'y_axis_units',
                            'y_label': 'y_label',
                            'y_labels': 'y_labels',
                            }

    def __init__(self,
                 x_label=None,
                 x_labels=None,
                 y_axis_unit_labels=None,
                 y_axis_units=None,
                 y_label=None,
                 y_labels=None,
                ):
        """
        :type  x_label: :class:`Label` or ``None``
        :param x_label: 
        :type  x_labels: :class:`list` of :class:`Label` or ``None``
        :param x_labels: A list of X-Axis Labels with condition support. If needed, this
            property can be used to provide a list of x-axis label with
            condition support. For a label with single condition,'x-label'
            property can be used.
        :type  y_axis_unit_labels: :class:`list` of :class:`Label` or ``None``
        :param y_axis_unit_labels: A list of Y-Axis unit Labels with condition support. If needed,
            this property can be used to provide a list of y-axis unit label
            with condition support. This unit label can be used to display the
            point value along with units like percentage, milliseconds etc.
        :type  y_axis_units: :class:`list` of :class:`AxisUnit` or ``None``
        :param y_axis_units: A list of Y-Axis unit with condition support. If needed, this
            property can be used to provide a list of y-axis unit with
            condition support. This unit could be like percentage, seconds,
            milliseconds etc.
        :type  y_label: :class:`Label` or ``None``
        :param y_label: 
        :type  y_labels: :class:`list` of :class:`Label` or ``None``
        :param y_labels: A list of Y-Axis Labels with condition support. If needed, this
            property can be used to provide a list of y-axis label with
            condition support. For a label with single condition,'y-label'
            property can be used.
        """
        self.x_label = x_label
        self.x_labels = x_labels
        self.y_axis_unit_labels = y_axis_unit_labels
        self.y_axis_units = y_axis_units
        self.y_label = y_label
        self.y_labels = y_labels
        VapiStruct.__init__(self)


Axes._set_binding_type(type.StructType(
    'com.vmware.nsx.model.axes', {
        'x_label': type.OptionalType(type.ReferenceType(__name__, 'Label')),
        'x_labels': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Label'))),
        'y_axis_unit_labels': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Label'))),
        'y_axis_units': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AxisUnit'))),
        'y_label': type.OptionalType(type.ReferenceType(__name__, 'Label')),
        'y_labels': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Label'))),
    },
    Axes,
    False,
    None))



class AxisUnit(VapiStruct):
    """
    Represents X and Y axis unit of a graph.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    UNIT_COUNT = "COUNT"
    """


    """
    UNIT_PERCENT = "PERCENT"
    """


    """
    UNIT_BYTES = "BYTES"
    """


    """
    UNIT_MILLISECONDS = "MILLISECONDS"
    """


    """
    UNIT_SECONDS = "SECONDS"
    """


    """
    UNIT_MINUTE = "MINUTE"
    """


    """
    UNIT_HOUR = "HOUR"
    """


    """
    UNIT_DAY = "DAY"
    """


    """
    UNIT_KILO_BYTES = "KILO_BYTES"
    """


    """
    UNIT_MEGA_BYTES = "MEGA_BYTES"
    """


    """
    UNIT_GIGA_BYTES = "GIGA_BYTES"
    """


    """



    _canonical_to_pep_names = {
                            'condition': 'condition',
                            'unit': 'unit',
                            }

    def __init__(self,
                 condition=None,
                 unit=None,
                ):
        """
        :type  condition: :class:`str` or ``None``
        :param condition: If the condition is met then the above unit will be displayed. to
            UI. If no condition is provided, then the unit will be displayed
            unconditionally.
        :type  unit: :class:`str` or ``None``
        :param unit: Possible values are: 
            
            * :attr:`AxisUnit.UNIT_COUNT`
            * :attr:`AxisUnit.UNIT_PERCENT`
            * :attr:`AxisUnit.UNIT_BYTES`
            * :attr:`AxisUnit.UNIT_MILLISECONDS`
            * :attr:`AxisUnit.UNIT_SECONDS`
            * :attr:`AxisUnit.UNIT_MINUTE`
            * :attr:`AxisUnit.UNIT_HOUR`
            * :attr:`AxisUnit.UNIT_DAY`
            * :attr:`AxisUnit.UNIT_KILO_BYTES`
            * :attr:`AxisUnit.UNIT_MEGA_BYTES`
            * :attr:`AxisUnit.UNIT_GIGA_BYTES`
            
            An Axis unit.
        """
        self.condition = condition
        self.unit = unit
        VapiStruct.__init__(self)


AxisUnit._set_binding_type(type.StructType(
    'com.vmware.nsx.model.axis_unit', {
        'condition': type.OptionalType(type.StringType()),
        'unit': type.OptionalType(type.StringType()),
    },
    AxisUnit,
    False,
    None))



class BFDDiagnosticCount(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'administratively_down_count': 'administratively_down_count',
                            'concatenated_path_down_count': 'concatenated_path_down_count',
                            'control_detection_time_expired_count': 'control_detection_time_expired_count',
                            'echo_function_failed_count': 'echo_function_failed_count',
                            'forwarding_plane_reset_count': 'forwarding_plane_reset_count',
                            'neighbor_signaled_session_down_count': 'neighbor_signaled_session_down_count',
                            'no_diagnostic_count': 'no_diagnostic_count',
                            'path_down_count': 'path_down_count',
                            'reverse_concatenated_path_down_count': 'reverse_concatenated_path_down_count',
                            }

    def __init__(self,
                 administratively_down_count=None,
                 concatenated_path_down_count=None,
                 control_detection_time_expired_count=None,
                 echo_function_failed_count=None,
                 forwarding_plane_reset_count=None,
                 neighbor_signaled_session_down_count=None,
                 no_diagnostic_count=None,
                 path_down_count=None,
                 reverse_concatenated_path_down_count=None,
                ):
        """
        :type  administratively_down_count: :class:`long` or ``None``
        :param administratively_down_count: Number of tunnels with administratively down diagnostic message
            format: int64
        :type  concatenated_path_down_count: :class:`long` or ``None``
        :param concatenated_path_down_count: Number of tunnels with concatenated path down diagnostic message
            format: int64
        :type  control_detection_time_expired_count: :class:`long` or ``None``
        :param control_detection_time_expired_count: Number of tunnels with control detection time expired diagnostic
            message format: int64
        :type  echo_function_failed_count: :class:`long` or ``None``
        :param echo_function_failed_count: Number of tunnels with echo function failed diagnostic message
            format: int64
        :type  forwarding_plane_reset_count: :class:`long` or ``None``
        :param forwarding_plane_reset_count: Number of tunnels with forwarding plane reset diagnostic message
            format: int64
        :type  neighbor_signaled_session_down_count: :class:`long` or ``None``
        :param neighbor_signaled_session_down_count: Number of tunnels neighbor signaled session down format: int64
        :type  no_diagnostic_count: :class:`long` or ``None``
        :param no_diagnostic_count: Number of tunnels with no diagnostic format: int64
        :type  path_down_count: :class:`long` or ``None``
        :param path_down_count: Number of tunnels with path down diagnostic message format: int64
        :type  reverse_concatenated_path_down_count: :class:`long` or ``None``
        :param reverse_concatenated_path_down_count: Number of tunnels with reverse concatenated path down diagnostic
            message format: int64
        """
        self.administratively_down_count = administratively_down_count
        self.concatenated_path_down_count = concatenated_path_down_count
        self.control_detection_time_expired_count = control_detection_time_expired_count
        self.echo_function_failed_count = echo_function_failed_count
        self.forwarding_plane_reset_count = forwarding_plane_reset_count
        self.neighbor_signaled_session_down_count = neighbor_signaled_session_down_count
        self.no_diagnostic_count = no_diagnostic_count
        self.path_down_count = path_down_count
        self.reverse_concatenated_path_down_count = reverse_concatenated_path_down_count
        VapiStruct.__init__(self)


BFDDiagnosticCount._set_binding_type(type.StructType(
    'com.vmware.nsx.model.BFD_diagnostic_count', {
        'administratively_down_count': type.OptionalType(type.IntegerType()),
        'concatenated_path_down_count': type.OptionalType(type.IntegerType()),
        'control_detection_time_expired_count': type.OptionalType(type.IntegerType()),
        'echo_function_failed_count': type.OptionalType(type.IntegerType()),
        'forwarding_plane_reset_count': type.OptionalType(type.IntegerType()),
        'neighbor_signaled_session_down_count': type.OptionalType(type.IntegerType()),
        'no_diagnostic_count': type.OptionalType(type.IntegerType()),
        'path_down_count': type.OptionalType(type.IntegerType()),
        'reverse_concatenated_path_down_count': type.OptionalType(type.IntegerType()),
    },
    BFDDiagnosticCount,
    False,
    None))



class BFDProperties(VapiStruct):
    """
    BFD information

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    BFD_ENCAP_GENEVE = "GENEVE"
    """


    """
    BFD_ENCAP_NONE = "NONE"
    """


    """
    BFD_ENCAP_UNKNOWN_ENCAP = "UNKNOWN_ENCAP"
    """


    """
    REMOTE_STATE_UNKNOWN_STATE = "UNKNOWN_STATE"
    """


    """
    REMOTE_STATE_ADMIN_DOWN = "ADMIN_DOWN"
    """


    """
    REMOTE_STATE_DOWN = "DOWN"
    """


    """
    REMOTE_STATE_INIT = "INIT"
    """


    """
    REMOTE_STATE_UP = "UP"
    """


    """
    STATE_UNKNOWN_STATE = "UNKNOWN_STATE"
    """


    """
    STATE_ADMIN_DOWN = "ADMIN_DOWN"
    """


    """
    STATE_DOWN = "DOWN"
    """


    """
    STATE_INIT = "INIT"
    """


    """
    STATE_UP = "UP"
    """


    """



    _canonical_to_pep_names = {
                            'active': 'active',
                            'bfd_encap': 'bfd_encap',
                            'diagnostic': 'diagnostic',
                            'forwarding': 'forwarding',
                            'remote_diagnostic': 'remote_diagnostic',
                            'remote_state': 'remote_state',
                            'state': 'state',
                            }

    def __init__(self,
                 active=None,
                 bfd_encap=None,
                 diagnostic=None,
                 forwarding=None,
                 remote_diagnostic=None,
                 remote_state=None,
                 state=None,
                ):
        """
        :type  active: :class:`bool` or ``None``
        :param active: True if tunnel is active in a gateway HA setup
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  bfd_encap: :class:`str` or ``None``
        :param bfd_encap: Possible values are: 
            
            * :attr:`BFDProperties.BFD_ENCAP_GENEVE`
            * :attr:`BFDProperties.BFD_ENCAP_NONE`
            * :attr:`BFDProperties.BFD_ENCAP_UNKNOWN_ENCAP`
            
            The encapsulation type of BFD. GENEVE - BFD with GENEVE
            encapsulation NONE - BFD with no encapsulation UNKNOWN_ENCAP - BFD
            with unknown encapsulation
        :type  diagnostic: :class:`str` or ``None``
        :param diagnostic: A short message indicating what the BFD session thinks is wrong in
            case of a problem
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  forwarding: :class:`bool` or ``None``
        :param forwarding: True if the BFD session believes this interface may be used to
            forward traffic
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_diagnostic: :class:`str` or ``None``
        :param remote_diagnostic: A short message indicating what the remote interface's BFD session
            thinks is wrong in case of a problem
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_state: :class:`str` or ``None``
        :param remote_state: Possible values are: 
            
            * :attr:`BFDProperties.REMOTE_STATE_UNKNOWN_STATE`
            * :attr:`BFDProperties.REMOTE_STATE_ADMIN_DOWN`
            * :attr:`BFDProperties.REMOTE_STATE_DOWN`
            * :attr:`BFDProperties.REMOTE_STATE_INIT`
            * :attr:`BFDProperties.REMOTE_STATE_UP`
            
            State of the remote interface's BFD session
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  state: :class:`str` or ``None``
        :param state: Possible values are: 
            
            * :attr:`BFDProperties.STATE_UNKNOWN_STATE`
            * :attr:`BFDProperties.STATE_ADMIN_DOWN`
            * :attr:`BFDProperties.STATE_DOWN`
            * :attr:`BFDProperties.STATE_INIT`
            * :attr:`BFDProperties.STATE_UP`
            
            State of the BFD session
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.active = active
        self.bfd_encap = bfd_encap
        self.diagnostic = diagnostic
        self.forwarding = forwarding
        self.remote_diagnostic = remote_diagnostic
        self.remote_state = remote_state
        self.state = state
        VapiStruct.__init__(self)


BFDProperties._set_binding_type(type.StructType(
    'com.vmware.nsx.model.BFD_properties', {
        'active': type.OptionalType(type.BooleanType()),
        'bfd_encap': type.OptionalType(type.StringType()),
        'diagnostic': type.OptionalType(type.StringType()),
        'forwarding': type.OptionalType(type.BooleanType()),
        'remote_diagnostic': type.OptionalType(type.StringType()),
        'remote_state': type.OptionalType(type.StringType()),
        'state': type.OptionalType(type.StringType()),
    },
    BFDProperties,
    False,
    None))



class BFDStatusCount(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'bfd_admin_down_count': 'bfd_admin_down_count',
                            'bfd_down_count': 'bfd_down_count',
                            'bfd_init_count': 'bfd_init_count',
                            'bfd_up_count': 'bfd_up_count',
                            }

    def __init__(self,
                 bfd_admin_down_count=None,
                 bfd_down_count=None,
                 bfd_init_count=None,
                 bfd_up_count=None,
                ):
        """
        :type  bfd_admin_down_count: :class:`long` or ``None``
        :param bfd_admin_down_count: Number of tunnels in BFD admin down state format: int32
        :type  bfd_down_count: :class:`long` or ``None``
        :param bfd_down_count: Number of tunnels in BFD down state format: int32
        :type  bfd_init_count: :class:`long` or ``None``
        :param bfd_init_count: Number of tunnels in BFD init state format: int32
        :type  bfd_up_count: :class:`long` or ``None``
        :param bfd_up_count: Number of tunnels in BFD up state format: int32
        """
        self.bfd_admin_down_count = bfd_admin_down_count
        self.bfd_down_count = bfd_down_count
        self.bfd_init_count = bfd_init_count
        self.bfd_up_count = bfd_up_count
        VapiStruct.__init__(self)


BFDStatusCount._set_binding_type(type.StructType(
    'com.vmware.nsx.model.BFD_status_count', {
        'bfd_admin_down_count': type.OptionalType(type.IntegerType()),
        'bfd_down_count': type.OptionalType(type.IntegerType()),
        'bfd_init_count': type.OptionalType(type.IntegerType()),
        'bfd_up_count': type.OptionalType(type.IntegerType()),
    },
    BFDStatusCount,
    False,
    None))



class BGPCommunityList(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    COMMUNITY_TYPE_NORMALBGPCOMMUNITY = "NormalBGPCommunity"
    """


    """
    COMMUNITY_TYPE_LARGEBGPCOMMUNITY = "LargeBGPCommunity"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'communities': 'communities',
                            'community_type': 'community_type',
                            'logical_router_id': 'logical_router_id',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 communities=None,
                 community_type=None,
                 logical_router_id=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  communities: :class:`list` of :class:`str` or ``None``
        :param communities: Array of BGP communities
        :type  community_type: :class:`str` or ``None``
        :param community_type: Possible values are: 
            
            * :attr:`BGPCommunityList.COMMUNITY_TYPE_NORMALBGPCOMMUNITY`
            * :attr:`BGPCommunityList.COMMUNITY_TYPE_LARGEBGPCOMMUNITY`
            
            BGP community type. It has two types as NormalBGPCommunity BGP
            normal community which includes well-known community name as well
            as community value in range from [1-4294967295] or value in aa:nn
            format(aa/nn range from 1-65535). LargeBGPCommunity BGP large
            community which includes community value in aa:bb:nn format where
            aa, bb, nn are unsigned integers in the range [1-4294967295].
        :type  logical_router_id: :class:`str` or ``None``
        :param logical_router_id: Logical router id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.communities = communities
        self.community_type = community_type
        self.logical_router_id = logical_router_id
        VapiStruct.__init__(self)


BGPCommunityList._set_binding_type(type.StructType(
    'com.vmware.nsx.model.BGP_community_list', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'communities': type.OptionalType(type.ListType(type.StringType())),
        'community_type': type.OptionalType(type.StringType()),
        'logical_router_id': type.OptionalType(type.StringType()),
    },
    BGPCommunityList,
    False,
    None))



class BGPCommunityListListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`BGPCommunityList` or ``None``
        :param results: Paginated list of bgp community lists
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


BGPCommunityListListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.BGP_community_list_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BGPCommunityList'))),
    },
    BGPCommunityListListResult,
    False,
    None))



class BackupConfiguration(VapiStruct):
    """
    Configuration for taking manual/automated backup

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'after_inventory_update_interval': 'after_inventory_update_interval',
                            'backup_enabled': 'backup_enabled',
                            'backup_schedule': 'backup_schedule',
                            'inventory_summary_interval': 'inventory_summary_interval',
                            'passphrase': 'passphrase',
                            'remote_file_server': 'remote_file_server',
                            }

    def __init__(self,
                 after_inventory_update_interval=None,
                 backup_enabled=None,
                 backup_schedule=None,
                 inventory_summary_interval=None,
                 passphrase=None,
                 remote_file_server=None,
                ):
        """
        :type  after_inventory_update_interval: :class:`long` or ``None``
        :param after_inventory_update_interval: A number of seconds after a last backup, that needs to pass, before
            a topology change will trigger a generation of a new cluster/node
            backups. If parameter is not provided, then changes in a topology
            will not trigger a generation of cluster/node backups. format:
            int64
        :type  backup_enabled: :class:`bool` or ``None``
        :param backup_enabled: true if automated backup is enabled
        :type  backup_schedule: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param backup_schedule: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`BackupSchedule`. When methods return a value of this class
            as a return value, the attribute will contain all the attributes
            defined in :class:`BackupSchedule`.
        :type  inventory_summary_interval: :class:`long` or ``None``
        :param inventory_summary_interval: The minimum number of seconds between each upload of the inventory
            summary to backup server. format: int64
        :type  passphrase: :class:`str` or ``None``
        :param passphrase: Passphrase used to encrypt backup files. The passphrase specified
            must be at least 8 characters in length and must contain at least
            one lowercase, one uppercase, one numeric character and one special
            character (any other non-space character).
        :type  remote_file_server: :class:`RemoteFileServer` or ``None``
        :param remote_file_server: 
        """
        self.after_inventory_update_interval = after_inventory_update_interval
        self.backup_enabled = backup_enabled
        self.backup_schedule = backup_schedule
        self.inventory_summary_interval = inventory_summary_interval
        self.passphrase = passphrase
        self.remote_file_server = remote_file_server
        VapiStruct.__init__(self)


BackupConfiguration._set_binding_type(type.StructType(
    'com.vmware.nsx.model.backup_configuration', {
        'after_inventory_update_interval': type.OptionalType(type.IntegerType()),
        'backup_enabled': type.OptionalType(type.BooleanType()),
        'backup_schedule': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'BackupSchedule')])),
        'inventory_summary_interval': type.OptionalType(type.IntegerType()),
        'passphrase': type.OptionalType(type.StringType()),
        'remote_file_server': type.OptionalType(type.ReferenceType(__name__, 'RemoteFileServer')),
    },
    BackupConfiguration,
    False,
    None))



class BackupOperationHistory(VapiStruct):
    """
    Past backup operation details

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    OVERALL_BACKUP_STATUS_NOT_AVAILABLE = "NOT_AVAILABLE"
    """


    """
    OVERALL_BACKUP_STATUS_IN_PROGRESS = "IN_PROGRESS"
    """


    """
    OVERALL_BACKUP_STATUS_SUCCESS = "SUCCESS"
    """


    """
    OVERALL_BACKUP_STATUS_FAILED = "FAILED"
    """


    """



    _canonical_to_pep_names = {
                            'cluster_backup_statuses': 'cluster_backup_statuses',
                            'inventory_backup_statuses': 'inventory_backup_statuses',
                            'node_backup_statuses': 'node_backup_statuses',
                            'overall_backup_status': 'overall_backup_status',
                            }

    def __init__(self,
                 cluster_backup_statuses=None,
                 inventory_backup_statuses=None,
                 node_backup_statuses=None,
                 overall_backup_status=None,
                ):
        """
        :type  cluster_backup_statuses: :class:`list` of :class:`BackupOperationStatus` or ``None``
        :param cluster_backup_statuses: Statuses of previous cluster backups
        :type  inventory_backup_statuses: :class:`list` of :class:`BackupOperationStatus` or ``None``
        :param inventory_backup_statuses: Statuses of previous inventory backups
        :type  node_backup_statuses: :class:`list` of :class:`BackupOperationStatus` or ``None``
        :param node_backup_statuses: Statuses of previous node backups
        :type  overall_backup_status: :class:`str` or ``None``
        :param overall_backup_status: Possible values are: 
            
            *
              :attr:`BackupOperationHistory.OVERALL_BACKUP_STATUS_NOT_AVAILABLE`
            * :attr:`BackupOperationHistory.OVERALL_BACKUP_STATUS_IN_PROGRESS`
            * :attr:`BackupOperationHistory.OVERALL_BACKUP_STATUS_SUCCESS`
            * :attr:`BackupOperationHistory.OVERALL_BACKUP_STATUS_FAILED`
            
            This attribute is used to indicate the overall backup status
        """
        self.cluster_backup_statuses = cluster_backup_statuses
        self.inventory_backup_statuses = inventory_backup_statuses
        self.node_backup_statuses = node_backup_statuses
        self.overall_backup_status = overall_backup_status
        VapiStruct.__init__(self)


BackupOperationHistory._set_binding_type(type.StructType(
    'com.vmware.nsx.model.backup_operation_history', {
        'cluster_backup_statuses': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BackupOperationStatus'))),
        'inventory_backup_statuses': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BackupOperationStatus'))),
        'node_backup_statuses': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BackupOperationStatus'))),
        'overall_backup_status': type.OptionalType(type.StringType()),
    },
    BackupOperationHistory,
    False,
    None))



class BackupOperationStatus(VapiStruct):
    """
    Backup operation status

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ERROR_CODE_BACKUP_NOT_RUN_ON_MASTER = "BACKUP_NOT_RUN_ON_MASTER"
    """


    """
    ERROR_CODE_BACKUP_SERVER_UNREACHABLE = "BACKUP_SERVER_UNREACHABLE"
    """


    """
    ERROR_CODE_BACKUP_AUTHENTICATION_FAILURE = "BACKUP_AUTHENTICATION_FAILURE"
    """


    """
    ERROR_CODE_BACKUP_PERMISSION_ERROR = "BACKUP_PERMISSION_ERROR"
    """


    """
    ERROR_CODE_BACKUP_TIMEOUT = "BACKUP_TIMEOUT"
    """


    """
    ERROR_CODE_BACKUP_BAD_FINGERPRINT = "BACKUP_BAD_FINGERPRINT"
    """


    """
    ERROR_CODE_BACKUP_GENERIC_ERROR = "BACKUP_GENERIC_ERROR"
    """


    """
    ERROR_CODE_UPGRADE_IN_PROGRESS = "UPGRADE_IN_PROGRESS"
    """


    """



    _canonical_to_pep_names = {
                            'backup_id': 'backup_id',
                            'end_time': 'end_time',
                            'error_code': 'error_code',
                            'error_message': 'error_message',
                            'start_time': 'start_time',
                            'success': 'success',
                            }

    def __init__(self,
                 backup_id=None,
                 end_time=None,
                 error_code=None,
                 error_message=None,
                 start_time=None,
                 success=None,
                ):
        """
        :type  backup_id: :class:`str` or ``None``
        :param backup_id: Unique identifier of a backup
        :type  end_time: :class:`long` or ``None``
        :param end_time: Time when operation was ended format: int64
        :type  error_code: :class:`str` or ``None``
        :param error_code: Possible values are: 
            
            * :attr:`BackupOperationStatus.ERROR_CODE_BACKUP_NOT_RUN_ON_MASTER`
            *
              :attr:`BackupOperationStatus.ERROR_CODE_BACKUP_SERVER_UNREACHABLE`
            *
              :attr:`BackupOperationStatus.ERROR_CODE_BACKUP_AUTHENTICATION_FAILURE`
            * :attr:`BackupOperationStatus.ERROR_CODE_BACKUP_PERMISSION_ERROR`
            * :attr:`BackupOperationStatus.ERROR_CODE_BACKUP_TIMEOUT`
            * :attr:`BackupOperationStatus.ERROR_CODE_BACKUP_BAD_FINGERPRINT`
            * :attr:`BackupOperationStatus.ERROR_CODE_BACKUP_GENERIC_ERROR`
            * :attr:`BackupOperationStatus.ERROR_CODE_UPGRADE_IN_PROGRESS`
            
            Error code
        :type  error_message: :class:`str` or ``None``
        :param error_message: Error code details
        :type  start_time: :class:`long` or ``None``
        :param start_time: Time when operation was started format: int64
        :type  success: :class:`bool` or ``None``
        :param success: True if backup is successfully completed, else false
        """
        self.backup_id = backup_id
        self.end_time = end_time
        self.error_code = error_code
        self.error_message = error_message
        self.start_time = start_time
        self.success = success
        VapiStruct.__init__(self)


BackupOperationStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.backup_operation_status', {
        'backup_id': type.OptionalType(type.StringType()),
        'end_time': type.OptionalType(type.IntegerType()),
        'error_code': type.OptionalType(type.StringType()),
        'error_message': type.OptionalType(type.StringType()),
        'start_time': type.OptionalType(type.IntegerType()),
        'success': type.OptionalType(type.BooleanType()),
    },
    BackupOperationStatus,
    False,
    None))



class BackupOverview(VapiStruct):
    """
    Data for a single backup/restore card

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            'backup_config': 'backup_config',
                            'backup_operation_history': 'backup_operation_history',
                            'current_backup_operation_status': 'current_backup_operation_status',
                            'restore_status': 'restore_status',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                 backup_config=None,
                 backup_operation_history=None,
                 current_backup_operation_status=None,
                 restore_status=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ClusterBackupInfo` or ``None``
        :param results: List of timestamps of backed-up cluster files
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  backup_config: :class:`BackupConfiguration` or ``None``
        :param backup_config: 
        :type  backup_operation_history: :class:`BackupOperationHistory` or ``None``
        :param backup_operation_history: 
        :type  current_backup_operation_status: :class:`CurrentBackupOperationStatus` or ``None``
        :param current_backup_operation_status: 
        :type  restore_status: :class:`ClusterRestoreStatus` or ``None``
        :param restore_status: 
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        self.backup_config = backup_config
        self.backup_operation_history = backup_operation_history
        self.current_backup_operation_status = current_backup_operation_status
        self.restore_status = restore_status
        VapiStruct.__init__(self)


BackupOverview._set_binding_type(type.StructType(
    'com.vmware.nsx.model.backup_overview', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterBackupInfo'))),
        'backup_config': type.OptionalType(type.ReferenceType(__name__, 'BackupConfiguration')),
        'backup_operation_history': type.OptionalType(type.ReferenceType(__name__, 'BackupOperationHistory')),
        'current_backup_operation_status': type.OptionalType(type.ReferenceType(__name__, 'CurrentBackupOperationStatus')),
        'restore_status': type.OptionalType(type.ReferenceType(__name__, 'ClusterRestoreStatus')),
    },
    BackupOverview,
    False,
    None))



class BackupSchedule(VapiStruct):
    """
    Abstract base type for Weekly or Interval Backup Schedule

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BackupSchedule"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    RESOURCE_TYPE_WEEKLYBACKUPSCHEDULE = "WeeklyBackupSchedule"
    """


    """
    RESOURCE_TYPE_INTERVALBACKUPSCHEDULE = "IntervalBackupSchedule"
    """


    """



    _canonical_to_pep_names = {
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 resource_type='BackupSchedule',
                ):
        """
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`BackupSchedule.RESOURCE_TYPE_WEEKLYBACKUPSCHEDULE`
            * :attr:`BackupSchedule.RESOURCE_TYPE_INTERVALBACKUPSCHEDULE`
            
            Schedule type
        """
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BackupSchedule._set_binding_type(type.StructType(
    'com.vmware.nsx.model.backup_schedule', {
        'resource_type': type.StringType(),
    },
    BackupSchedule,
    False,
    None))



class BackupUiFramesInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ACTIVE_GM_ACTIVE = "ACTIVE"
    """


    """
    ACTIVE_GM_STANDBY = "STANDBY"
    """


    """
    ACTIVE_GM_NONE = "NONE"
    """


    """
    ACTIVE_GM_INVALID = "INVALID"
    """


    """
    API_ENDPOINT_GLOBAL_MANAGER = "global-manager"
    """


    """
    API_ENDPOINT_NSXAPI = "nsxapi"
    """


    """
    API_ENDPOINT_ICA = "ica"
    """


    """
    FRAME_TYPE_GLOBAL_MANAGER = "GLOBAL_MANAGER"
    """


    """
    FRAME_TYPE_LOCAL_MANAGER = "LOCAL_MANAGER"
    """


    """
    FRAME_TYPE_LOCAL_LOCAL_MANAGER = "LOCAL_LOCAL_MANAGER"
    """


    """
    FRAME_TYPE_NSX_INTELLIGENCE = "NSX_INTELLIGENCE"
    """


    """



    _canonical_to_pep_names = {
                            'active_gm': 'active_gm',
                            'api_endpoint': 'api_endpoint',
                            'frame_type': 'frame_type',
                            'site_id': 'site_id',
                            'site_version': 'site_version',
                            }

    def __init__(self,
                 active_gm=None,
                 api_endpoint=None,
                 frame_type=None,
                 site_id=None,
                 site_version=None,
                ):
        """
        :type  active_gm: :class:`str` or ``None``
        :param active_gm: Possible values are: 
            
            * :attr:`BackupUiFramesInfo.ACTIVE_GM_ACTIVE`
            * :attr:`BackupUiFramesInfo.ACTIVE_GM_STANDBY`
            * :attr:`BackupUiFramesInfo.ACTIVE_GM_NONE`
            * :attr:`BackupUiFramesInfo.ACTIVE_GM_INVALID`
            
            Does site have active GM
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  api_endpoint: :class:`str` or ``None``
        :param api_endpoint: Possible values are: 
            
            * :attr:`BackupUiFramesInfo.API_ENDPOINT_GLOBAL_MANAGER`
            * :attr:`BackupUiFramesInfo.API_ENDPOINT_NSXAPI`
            * :attr:`BackupUiFramesInfo.API_ENDPOINT_ICA`
            
            prefix to be used for api call
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  frame_type: :class:`str` or ``None``
        :param frame_type: Possible values are: 
            
            * :attr:`BackupUiFramesInfo.FRAME_TYPE_GLOBAL_MANAGER`
            * :attr:`BackupUiFramesInfo.FRAME_TYPE_LOCAL_MANAGER`
            * :attr:`BackupUiFramesInfo.FRAME_TYPE_LOCAL_LOCAL_MANAGER`
            * :attr:`BackupUiFramesInfo.FRAME_TYPE_NSX_INTELLIGENCE`
            
            Type of service, for which backup is handled
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  site_id: :class:`str` or ``None``
        :param site_id: Id of the site
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  site_version: :class:`str` or ``None``
        :param site_version: Version of the site
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.active_gm = active_gm
        self.api_endpoint = api_endpoint
        self.frame_type = frame_type
        self.site_id = site_id
        self.site_version = site_version
        VapiStruct.__init__(self)


BackupUiFramesInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.backup_ui_frames_info', {
        'active_gm': type.OptionalType(type.StringType()),
        'api_endpoint': type.OptionalType(type.StringType()),
        'frame_type': type.OptionalType(type.StringType()),
        'site_id': type.OptionalType(type.StringType()),
        'site_version': type.OptionalType(type.StringType()),
    },
    BackupUiFramesInfo,
    False,
    None))



class BackupUiFramesInfoList(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'backup_frames_list': 'backup_frames_list',
                            }

    def __init__(self,
                 backup_frames_list=None,
                ):
        """
        :type  backup_frames_list: :class:`list` of :class:`BackupUiFramesInfo` or ``None``
        :param backup_frames_list: List of backup frames(and metadata) to be displayed in UI
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.backup_frames_list = backup_frames_list
        VapiStruct.__init__(self)


BackupUiFramesInfoList._set_binding_type(type.StructType(
    'com.vmware.nsx.model.backup_ui_frames_info_list', {
        'backup_frames_list': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BackupUiFramesInfo'))),
    },
    BackupUiFramesInfoList,
    False,
    None))



class BaseCountObservation(VapiStruct):
    """
    The count action results from aggregating checkpoints per port.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'checkpoints': 'checkpoints',
                            'port_id': 'port_id',
                            'port_name': 'port_name',
                            'transport_node_id': 'transport_node_id',
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 checkpoints=None,
                 port_id=None,
                 port_name=None,
                 transport_node_id=None,
                 resource_type=None,
                ):
        """
        :type  checkpoints: :class:`CheckpointCounterResult` or ``None``
        :param checkpoints: 
        :type  port_id: :class:`str` or ``None``
        :param port_id: The port identifier in UUID format. This field won't appear
            together with port_name.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  port_name: :class:`str` or ``None``
        :param port_name: The port name for a port. It applies to ports like the uplink port.
            This field won't appear together with port_id.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  transport_node_id: :class:`str` or ``None``
        :param transport_node_id: This field tells which transport node the checkpoints are reported
            from.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  resource_type: :class:`str`
        :param resource_type: Type of count observation
        """
        self.checkpoints = checkpoints
        self.port_id = port_id
        self.port_name = port_name
        self.transport_node_id = transport_node_id
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BaseCountObservation._set_binding_type(type.StructType(
    'com.vmware.nsx.model.base_count_observation', {
        'checkpoints': type.OptionalType(type.ReferenceType(__name__, 'CheckpointCounterResult')),
        'port_id': type.OptionalType(type.StringType()),
        'port_name': type.OptionalType(type.StringType()),
        'transport_node_id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
    },
    BaseCountObservation,
    False,
    None))



class BaseFirewallProfile(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BaseFirewallProfile"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    RESOURCE_TYPE_FIREWALLSESSIONTIMERPROFILE = "FirewallSessionTimerProfile"
    """


    """
    RESOURCE_TYPE_FIREWALLCPUMEMTHRESHOLDSPROFILE = "FirewallCpuMemThresholdsProfile"
    """


    """
    RESOURCE_TYPE_FIREWALLFLOODPROTECTIONPROFILE = "FirewallFloodProtectionProfile"
    """


    """
    RESOURCE_TYPE_FIREWALLDNSPROFILE = "FirewallDnsProfile"
    """


    """
    RESOURCE_TYPE_GENERALSECURITYSETTINGSPROFILE = "GeneralSecuritySettingsProfile"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='BaseFirewallProfile',
                 tags=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            *
              :attr:`BaseFirewallProfile.RESOURCE_TYPE_FIREWALLSESSIONTIMERPROFILE`
            *
              :attr:`BaseFirewallProfile.RESOURCE_TYPE_FIREWALLCPUMEMTHRESHOLDSPROFILE`
            *
              :attr:`BaseFirewallProfile.RESOURCE_TYPE_FIREWALLFLOODPROTECTIONPROFILE`
            * :attr:`BaseFirewallProfile.RESOURCE_TYPE_FIREWALLDNSPROFILE`
            *
              :attr:`BaseFirewallProfile.RESOURCE_TYPE_GENERALSECURITYSETTINGSPROFILE`
            
            Resource type to use as profile type
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BaseFirewallProfile._set_binding_type(type.StructType(
    'com.vmware.nsx.model.base_firewall_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
    },
    BaseFirewallProfile,
    False,
    None))



class BaseHostSwitchProfile(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BaseHostSwitchProfile"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    RESOURCE_TYPE_UPLINKHOSTSWITCHPROFILE = "UplinkHostSwitchProfile"
    """


    """
    RESOURCE_TYPE_LLDPHOSTSWITCHPROFILE = "LldpHostSwitchProfile"
    """


    """
    RESOURCE_TYPE_NIOCPROFILE = "NiocProfile"
    """


    """
    RESOURCE_TYPE_EXTRACONFIGHOSTSWITCHPROFILE = "ExtraConfigHostSwitchProfile"
    """


    """
    RESOURCE_TYPE_VTEPHAHOSTSWITCHPROFILE = "VtepHAHostSwitchProfile"
    """


    """
    RESOURCE_TYPE_HIGHPERFORMANCEHOSTSWITCHPROFILE = "HighPerformanceHostSwitchProfile"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'required_capabilities': 'required_capabilities',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='BaseHostSwitchProfile',
                 tags=None,
                 required_capabilities=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            *
              :attr:`BaseHostSwitchProfile.RESOURCE_TYPE_UPLINKHOSTSWITCHPROFILE`
            * :attr:`BaseHostSwitchProfile.RESOURCE_TYPE_LLDPHOSTSWITCHPROFILE`
            * :attr:`BaseHostSwitchProfile.RESOURCE_TYPE_NIOCPROFILE`
            *
              :attr:`BaseHostSwitchProfile.RESOURCE_TYPE_EXTRACONFIGHOSTSWITCHPROFILE`
            *
              :attr:`BaseHostSwitchProfile.RESOURCE_TYPE_VTEPHAHOSTSWITCHPROFILE`
            *
              :attr:`BaseHostSwitchProfile.RESOURCE_TYPE_HIGHPERFORMANCEHOSTSWITCHPROFILE`
            
            Supported HostSwitch profiles.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  required_capabilities: :class:`list` of :class:`str` or ``None``
        :param required_capabilities: 
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.required_capabilities = required_capabilities
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BaseHostSwitchProfile._set_binding_type(type.StructType(
    'com.vmware.nsx.model.base_host_switch_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'required_capabilities': type.OptionalType(type.ListType(type.StringType())),
    },
    BaseHostSwitchProfile,
    False,
    None))



class BaseNodeAggregateInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'display_name': 'display_name',
                            'id': 'id',
                            'node_interface_properties': 'node_interface_properties',
                            'node_interface_statistics': 'node_interface_statistics',
                            'node_status': 'node_status',
                            'node_status_properties': 'node_status_properties',
                            }

    def __init__(self,
                 display_name=None,
                 id=None,
                 node_interface_properties=None,
                 node_interface_statistics=None,
                 node_status=None,
                 node_status_properties=None,
                ):
        """
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_interface_properties: :class:`list` of :class:`NodeInterfaceProperties` or ``None``
        :param node_interface_properties: Array of Node interface statistic properties
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_interface_statistics: :class:`list` of :class:`NodeInterfaceStatisticsProperties` or ``None``
        :param node_interface_statistics: Array of Node network interface statistic properties
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_status: :class:`ClusterNodeStatus` or ``None``
        :param node_status: 
        :type  node_status_properties: :class:`list` of :class:`NodeStatusProperties` or ``None``
        :param node_status_properties: Time series of the node's system properties
        """
        self.display_name = display_name
        self.id = id
        self.node_interface_properties = node_interface_properties
        self.node_interface_statistics = node_interface_statistics
        self.node_status = node_status
        self.node_status_properties = node_status_properties
        VapiStruct.__init__(self)


BaseNodeAggregateInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.base_node_aggregate_info', {
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'node_interface_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NodeInterfaceProperties'))),
        'node_interface_statistics': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NodeInterfaceStatisticsProperties'))),
        'node_status': type.OptionalType(type.ReferenceType(__name__, 'ClusterNodeStatus')),
        'node_status_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NodeStatusProperties'))),
    },
    BaseNodeAggregateInfo,
    False,
    None))



class BasePktCapResource(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BasePktCapResource"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 resource_type='BasePktCapResource',
                ):
        """
        :type  resource_type: :class:`str`
        :param resource_type: Type of packet capture resource
        """
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BasePktCapResource._set_binding_type(type.StructType(
    'com.vmware.nsx.model.base_pkt_cap_resource', {
        'resource_type': type.StringType(),
    },
    BasePktCapResource,
    False,
    None))



class BaseServiceInstance(VapiStruct):
    """
    The deployment of a registered service. service instance is instantiation
    of service.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BaseServiceInstance"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    RESOURCE_TYPE_SERVICEINSTANCE = "ServiceInstance"
    """


    """
    RESOURCE_TYPE_BYODSERVICEINSTANCE = "ByodServiceInstance"
    """


    """
    RESOURCE_TYPE_VIRTUALSERVICEINSTANCE = "VirtualServiceInstance"
    """


    """
    ON_FAILURE_POLICY_ALLOW = "ALLOW"
    """


    """
    ON_FAILURE_POLICY_BLOCK = "BLOCK"
    """


    """
    TRANSPORT_TYPE_L2_BRIDGE = "L2_BRIDGE"
    """


    """
    TRANSPORT_TYPE_L3_ROUTED = "L3_ROUTED"
    """


    """
    TRANSPORT_TYPE_NSH = "NSH"
    """


    """
    TRANSPORT_TYPE_NA = "NA"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'on_failure_policy': 'on_failure_policy',
                            'service_id': 'service_id',
                            'transport_type': 'transport_type',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='BaseServiceInstance',
                 tags=None,
                 on_failure_policy=None,
                 service_id=None,
                 transport_type=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`BaseServiceInstance.RESOURCE_TYPE_SERVICEINSTANCE`
            * :attr:`BaseServiceInstance.RESOURCE_TYPE_BYODSERVICEINSTANCE`
            * :attr:`BaseServiceInstance.RESOURCE_TYPE_VIRTUALSERVICEINSTANCE`
            
            ServiceInstance is used when NSX handles the lifecyle of appliance.
            Deployment and appliance related all the information is necessary.
            ByodServiceInstance is a custom instance to be used when NSX is not
            handling the lifecycles of appliance/s. User will manage their own
            appliance (BYOD) to connect with NSX. VirtualServiceInstance is a a
            custom instance to be used when NSX is not handling the lifecycle
            of an appliance and when the user is not bringing their own
            appliance.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  on_failure_policy: :class:`str` or ``None``
        :param on_failure_policy: Possible values are: 
            
            * :attr:`BaseServiceInstance.ON_FAILURE_POLICY_ALLOW`
            * :attr:`BaseServiceInstance.ON_FAILURE_POLICY_BLOCK`
            
            Failure policy of the service instance - if it has to be different
            from the service. By default the service instance inherits the
            FailurePolicy of the service it belongs to.
        :type  service_id: :class:`str` or ``None``
        :param service_id: The Service to which the service instance is associated.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  transport_type: :class:`str` or ``None``
        :param transport_type: Possible values are: 
            
            * :attr:`BaseServiceInstance.TRANSPORT_TYPE_L2_BRIDGE`
            * :attr:`BaseServiceInstance.TRANSPORT_TYPE_L3_ROUTED`
            * :attr:`BaseServiceInstance.TRANSPORT_TYPE_NSH`
            * :attr:`BaseServiceInstance.TRANSPORT_TYPE_NA`
            
            Transport to be used by this service instance for deploying the
            Service-VM. This field is to be set Not Applicable(NA) if the
            service only caters to functionality EPP(Endpoint Protection) and
            MPS.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.on_failure_policy = on_failure_policy
        self.service_id = service_id
        self.transport_type = transport_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BaseServiceInstance._set_binding_type(type.StructType(
    'com.vmware.nsx.model.base_service_instance', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'on_failure_policy': type.OptionalType(type.StringType()),
        'service_id': type.OptionalType(type.StringType()),
        'transport_type': type.OptionalType(type.StringType()),
    },
    BaseServiceInstance,
    False,
    None))



class BaseServiceProfile(VapiStruct):
    """
    Base Service Profile

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BaseServiceProfile"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='BaseServiceProfile',
                 tags=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Service Profile type, for example 'GiServiceProfile',
            'ServiceInsertionServiceProfile'
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BaseServiceProfile._set_binding_type(type.StructType(
    'com.vmware.nsx.model.base_service_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
    },
    BaseServiceProfile,
    False,
    None))



class BaseSwitchingProfile(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BaseSwitchingProfile"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'required_capabilities': 'required_capabilities',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='BaseSwitchingProfile',
                 tags=None,
                 required_capabilities=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  required_capabilities: :class:`list` of :class:`str` or ``None``
        :param required_capabilities: 
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.required_capabilities = required_capabilities
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BaseSwitchingProfile._set_binding_type(type.StructType(
    'com.vmware.nsx.model.base_switching_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'required_capabilities': type.OptionalType(type.ListType(type.StringType())),
    },
    BaseSwitchingProfile,
    False,
    None))



class BasicAuthenticationScheme(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    SCHEME_NAME_BASIC = "basic"
    """


    """



    _canonical_to_pep_names = {
                            'scheme_name': 'scheme_name',
                            'password': 'password',
                            'username': 'username',
                            }

    def __init__(self,
                 scheme_name=None,
                 password=None,
                 username=None,
                ):
        """
        :type  scheme_name: :class:`str` or ``None``
        :param scheme_name: Possible values are: 
            
            * :attr:`BasicAuthenticationScheme.SCHEME_NAME_BASIC`
            
            Authentication scheme name
        :type  password: :class:`str` or ``None``
        :param password: Password to authenticate with
        :type  username: :class:`str` or ``None``
        :param username: User name to authenticate with
        """
        self.scheme_name = scheme_name
        self.password = password
        self.username = username
        VapiStruct.__init__(self)


BasicAuthenticationScheme._set_binding_type(type.StructType(
    'com.vmware.nsx.model.basic_authentication_scheme', {
        'scheme_name': type.OptionalType(type.StringType()),
        'password': type.OptionalType(type.StringType()),
        'username': type.OptionalType(type.StringType()),
    },
    BasicAuthenticationScheme,
    False,
    None))



class BatchRequest(VapiStruct):
    """
    A set of operations to be performed in a single batch

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'continue_on_error': 'continue_on_error',
                            'requests': 'requests',
                            }

    def __init__(self,
                 continue_on_error=None,
                 requests=None,
                ):
        """
        :type  continue_on_error: :class:`bool` or ``None``
        :param continue_on_error: Continue even if an error is encountered.
        :type  requests: :class:`list` of :class:`BatchRequestItem` or ``None``
        :param requests: 
        """
        self.continue_on_error = continue_on_error
        self.requests = requests
        VapiStruct.__init__(self)


BatchRequest._set_binding_type(type.StructType(
    'com.vmware.nsx.model.batch_request', {
        'continue_on_error': type.OptionalType(type.BooleanType()),
        'requests': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BatchRequestItem'))),
    },
    BatchRequest,
    False,
    None))



class BatchRequestItem(VapiStruct):
    """
    A single request within a batch of operations

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    METHOD_GET = "GET"
    """


    """
    METHOD_POST = "POST"
    """


    """
    METHOD_PUT = "PUT"
    """


    """
    METHOD_DELETE = "DELETE"
    """


    """
    METHOD_PATCH = "PATCH"
    """


    """



    _canonical_to_pep_names = {
                            'body': 'body',
                            'method': 'method',
                            'uri': 'uri',
                            }

    def __init__(self,
                 body=None,
                 method=None,
                 uri=None,
                ):
        """
        :type  body: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param body: 
        :type  method: :class:`str` or ``None``
        :param method: Possible values are: 
            
            * :attr:`BatchRequestItem.METHOD_GET`
            * :attr:`BatchRequestItem.METHOD_POST`
            * :attr:`BatchRequestItem.METHOD_PUT`
            * :attr:`BatchRequestItem.METHOD_DELETE`
            * :attr:`BatchRequestItem.METHOD_PATCH`
            
            http method type
        :type  uri: :class:`str` or ``None``
        :param uri: relative uri (path and args), of the call including resource id (if
            this is a POST/DELETE), exclude hostname and port and prefix,
            exploded form of parameters
        """
        self.body = body
        self.method = method
        self.uri = uri
        VapiStruct.__init__(self)


BatchRequestItem._set_binding_type(type.StructType(
    'com.vmware.nsx.model.batch_request_item', {
        'body': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
        'method': type.OptionalType(type.StringType()),
        'uri': type.OptionalType(type.StringType()),
    },
    BatchRequestItem,
    False,
    None))



class BatchResponse(VapiStruct):
    """
    The reponse to a batch operation

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'has_errors': 'has_errors',
                            'results': 'results',
                            'rolled_back': 'rolled_back',
                            }

    def __init__(self,
                 has_errors=None,
                 results=None,
                 rolled_back=None,
                ):
        """
        :type  has_errors: :class:`bool` or ``None``
        :param has_errors: Indicates if any of the APIs failed
        :type  results: :class:`list` of :class:`BatchResponseItem` or ``None``
        :param results: Bulk list results
        :type  rolled_back: :class:`bool` or ``None``
        :param rolled_back: Optional flag indicating that all items were rolled back even if
            succeeded initially
        """
        self.has_errors = has_errors
        self.results = results
        self.rolled_back = rolled_back
        VapiStruct.__init__(self)


BatchResponse._set_binding_type(type.StructType(
    'com.vmware.nsx.model.batch_response', {
        'has_errors': type.OptionalType(type.BooleanType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BatchResponseItem'))),
        'rolled_back': type.OptionalType(type.BooleanType()),
    },
    BatchResponse,
    False,
    None))



class BatchResponseItem(VapiStruct):
    """
    A single respose in a list of batched responses

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'body': 'body',
                            'code': 'code',
                            'headers': 'headers',
                            }

    def __init__(self,
                 body=None,
                 code=None,
                 headers=None,
                ):
        """
        :type  body: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param body: object returned by api
        :type  code: :class:`long` or ``None``
        :param code: http status code format: int64
        :type  headers: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param headers: The headers returned by the API call
        """
        self.body = body
        self.code = code
        self.headers = headers
        VapiStruct.__init__(self)


BatchResponseItem._set_binding_type(type.StructType(
    'com.vmware.nsx.model.batch_response_item', {
        'body': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
        'code': type.OptionalType(type.IntegerType()),
        'headers': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
    },
    BatchResponseItem,
    False,
    None))



class BfdConfig(VapiStruct):
    """
    BFD configuration for LogicalRouter

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'declare_dead_multiple': 'declare_dead_multiple',
                            'enabled': 'enabled',
                            'logical_router_id': 'logical_router_id',
                            'receive_interval': 'receive_interval',
                            'transmit_interval': 'transmit_interval',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 declare_dead_multiple=None,
                 enabled=None,
                 logical_router_id=None,
                 receive_interval=None,
                 transmit_interval=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  declare_dead_multiple: :class:`long` or ``None``
        :param declare_dead_multiple: Number of times a packet is missed before BFD declares the neighbor
            down. format: int64
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Flag to enable BFD for this LogicalRouter
        :type  logical_router_id: :class:`str` or ``None``
        :param logical_router_id: Logical router id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  receive_interval: :class:`long` or ``None``
        :param receive_interval: the time interval (in milliseconds) between heartbeat packets for
            BFD when receiving heartbeats. format: int64
        :type  transmit_interval: :class:`long` or ``None``
        :param transmit_interval: the time interval (in milliseconds) between heartbeat packets for
            BFD when sending heartbeats. format: int64
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.declare_dead_multiple = declare_dead_multiple
        self.enabled = enabled
        self.logical_router_id = logical_router_id
        self.receive_interval = receive_interval
        self.transmit_interval = transmit_interval
        VapiStruct.__init__(self)


BfdConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bfd_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'declare_dead_multiple': type.OptionalType(type.IntegerType()),
        'enabled': type.OptionalType(type.BooleanType()),
        'logical_router_id': type.OptionalType(type.StringType()),
        'receive_interval': type.OptionalType(type.IntegerType()),
        'transmit_interval': type.OptionalType(type.IntegerType()),
    },
    BfdConfig,
    False,
    None))



class BfdConfigParameters(VapiStruct):
    """
    BFD configuration for the given Peer.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'declare_dead_multiple': 'declare_dead_multiple',
                            'receive_interval': 'receive_interval',
                            'transmit_interval': 'transmit_interval',
                            }

    def __init__(self,
                 declare_dead_multiple=None,
                 receive_interval=None,
                 transmit_interval=None,
                ):
        """
        :type  declare_dead_multiple: :class:`long` or ``None``
        :param declare_dead_multiple: Number of times a packet is missed before BFD declares the neighbor
            down. format: int64
        :type  receive_interval: :class:`long` or ``None``
        :param receive_interval: The time interval (in milliseconds) between heartbeat packets for
            BFD when receiving heartbeats.| For edge cluster type of bare
            metal, this value should be >= 50ms.| For edge cluster type of
            virtual machine or hybrid, this value should be >= 500ms. format:
            int64
        :type  transmit_interval: :class:`long` or ``None``
        :param transmit_interval: The time interval (in milliseconds) between heartbeat packets for
            BFD when sending heartbeats.| For edge cluster type of bare metal,
            this value should be >= 300ms.| For edge cluster type of virtual
            machine or hybrid, this value should be >= 1000ms. format: int64
        """
        self.declare_dead_multiple = declare_dead_multiple
        self.receive_interval = receive_interval
        self.transmit_interval = transmit_interval
        VapiStruct.__init__(self)


BfdConfigParameters._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bfd_config_parameters', {
        'declare_dead_multiple': type.OptionalType(type.IntegerType()),
        'receive_interval': type.OptionalType(type.IntegerType()),
        'transmit_interval': type.OptionalType(type.IntegerType()),
    },
    BfdConfigParameters,
    False,
    None))



class BfdHealthMonitoringProfile(VapiStruct):
    """
    Profile for BFD health monitoring

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BfdHealthMonitoringProfile"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'enabled': 'enabled',
                            'latency_enabled': 'latency_enabled',
                            'probe_interval': 'probe_interval',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            }

    def __init__(self,
                 enabled=None,
                 latency_enabled=None,
                 probe_interval=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='BfdHealthMonitoringProfile',
                 tags=None,
                ):
        """
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Whether the heartbeat is enabled. A POST or PUT request with
            \"enabled\" false (with no probe intervals) will set (POST) or
            reset (PUT) the probe_interval to their default value.
        :type  latency_enabled: :class:`bool` or ``None``
        :param latency_enabled: The flag is to turn on/off latency. A POST or PUT request with
            \"latency_enabled\" true will enable NSX to send the networking
            latency data to thrid-party monitoring tools like vRNI.
        :type  probe_interval: :class:`long` or ``None``
        :param probe_interval: The time interval (in millisec) between probe packets for tunnels
            between transport nodes. format: int64
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            *
              :attr:`TransportZoneProfile.RESOURCE_TYPE_BFDHEALTHMONITORINGPROFILE`
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        """
        self.enabled = enabled
        self.latency_enabled = latency_enabled
        self.probe_interval = probe_interval
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BfdHealthMonitoringProfile._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bfd_health_monitoring_profile', {
        'enabled': type.OptionalType(type.BooleanType()),
        'latency_enabled': type.OptionalType(type.BooleanType()),
        'probe_interval': type.OptionalType(type.IntegerType()),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
    },
    BfdHealthMonitoringProfile,
    False,
    None))



class BgpAddressFamily(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_IPV4_UNICAST = "IPV4_UNICAST"
    """


    """
    TYPE_VPNV4_UNICAST = "VPNV4_UNICAST"
    """


    """
    TYPE_IPV6_UNICAST = "IPV6_UNICAST"
    """


    """
    TYPE_L2VPN_EVPN = "L2VPN_EVPN"
    """


    """



    _canonical_to_pep_names = {
                            'in_prefix_count': 'in_prefix_count',
                            'out_prefix_count': 'out_prefix_count',
                            'type': 'type',
                            }

    def __init__(self,
                 in_prefix_count=None,
                 out_prefix_count=None,
                 type=None,
                ):
        """
        :type  in_prefix_count: :class:`long` or ``None``
        :param in_prefix_count: Count of in prefixes format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  out_prefix_count: :class:`long` or ``None``
        :param out_prefix_count: Count of out prefixes format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`BgpAddressFamily.TYPE_IPV4_UNICAST`
            * :attr:`BgpAddressFamily.TYPE_VPNV4_UNICAST`
            * :attr:`BgpAddressFamily.TYPE_IPV6_UNICAST`
            * :attr:`BgpAddressFamily.TYPE_L2VPN_EVPN`
            
            BGP address family type
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.in_prefix_count = in_prefix_count
        self.out_prefix_count = out_prefix_count
        self.type = type
        VapiStruct.__init__(self)


BgpAddressFamily._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_address_family', {
        'in_prefix_count': type.OptionalType(type.IntegerType()),
        'out_prefix_count': type.OptionalType(type.IntegerType()),
        'type': type.OptionalType(type.StringType()),
    },
    BgpAddressFamily,
    False,
    None))



class BgpConfig(VapiStruct):
    """
    BGP configuration for Tier0 logical router. We create BGP configuration
    while creation of Tier0 logical router.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'as_num': 'as_num',
                            'as_number': 'as_number',
                            'ecmp': 'ecmp',
                            'enabled': 'enabled',
                            'graceful_restart': 'graceful_restart',
                            'graceful_restart_config': 'graceful_restart_config',
                            'inter_sr_ibgp': 'inter_sr_ibgp',
                            'logical_router_id': 'logical_router_id',
                            'multipath_relax': 'multipath_relax',
                            'route_aggregation': 'route_aggregation',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 as_num=None,
                 as_number=None,
                 ecmp=None,
                 enabled=None,
                 graceful_restart=None,
                 graceful_restart_config=None,
                 inter_sr_ibgp=None,
                 logical_router_id=None,
                 multipath_relax=None,
                 route_aggregation=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  as_num: :class:`str` or ``None``
        :param as_num: For VRF logical router, the as_num from parent logical router will
            be effective.
        :type  as_number: :class:`long` or ``None``
        :param as_number: This is a deprecated property, Please use 'as_num' instead. For VRF
            logical router, the as_number from parent logical router will be
            effective. format: int64

            .. deprecated:: unknown
        :type  ecmp: :class:`bool` or ``None``
        :param ecmp: While creation of BGP config this flag will be set to true User can
            change this value while updating BGP config. If this property is
            not specified in the payload, the default value will be considered
            as true.
        :type  enabled: :class:`bool` or ``None``
        :param enabled: While creation of BGP config this flag will be set to - true for
            Tier0 logical router with Active-Active high-availability mode -
            false for Tier0 logical router with Active-Standby
            high-availanility mode. User can change this value while updating
            the config. If this property is not specified in the payload, the
            default value will be considered as false irrespective of the
            high-availability mode.
        :type  graceful_restart: :class:`bool` or ``None``
        :param graceful_restart: Flag to enable graceful restart. This field is deprecated, kindly
            use graceful_restart_config parameter for graceful restart
            configuration. If both parameters are set and consistent with each
            other [i.e. graceful_restart=false and
            graceful_restart_mode=HELPER_ONLY OR graceful_restart=true and
            graceful_restart_mode=GR_AND_HELPER] then this is allowed, but if
            inconsistent with each other then this is not allowed and
            validation error will be thrown. For VRF logical router, the
            settings from parent logical router will be effective.

            .. deprecated:: unknown
        :type  graceful_restart_config: :class:`GracefulRestartConfig` or ``None``
        :param graceful_restart_config: 
        :type  inter_sr_ibgp: :class:`InterSRRoutingConfig` or ``None``
        :param inter_sr_ibgp: 
        :type  logical_router_id: :class:`str` or ``None``
        :param logical_router_id: Logical router id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  multipath_relax: :class:`bool` or ``None``
        :param multipath_relax: For TIER0 logical router, default is true. For VRF logical router,
            the settings from parent logical router will be effective.
        :type  route_aggregation: :class:`list` of :class:`BgpRouteAggregation` or ``None``
        :param route_aggregation: List of routes to be aggregated
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.as_num = as_num
        self.as_number = as_number
        self.ecmp = ecmp
        self.enabled = enabled
        self.graceful_restart = graceful_restart
        self.graceful_restart_config = graceful_restart_config
        self.inter_sr_ibgp = inter_sr_ibgp
        self.logical_router_id = logical_router_id
        self.multipath_relax = multipath_relax
        self.route_aggregation = route_aggregation
        VapiStruct.__init__(self)


BgpConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'as_num': type.OptionalType(type.StringType()),
        'as_number': type.OptionalType(type.IntegerType()),
        'ecmp': type.OptionalType(type.BooleanType()),
        'enabled': type.OptionalType(type.BooleanType()),
        'graceful_restart': type.OptionalType(type.BooleanType()),
        'graceful_restart_config': type.OptionalType(type.ReferenceType(__name__, 'GracefulRestartConfig')),
        'inter_sr_ibgp': type.OptionalType(type.ReferenceType(__name__, 'InterSRRoutingConfig')),
        'logical_router_id': type.OptionalType(type.StringType()),
        'multipath_relax': type.OptionalType(type.BooleanType()),
        'route_aggregation': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BgpRouteAggregation'))),
    },
    BgpConfig,
    False,
    None))



class BgpNeighbor(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    GRACEFUL_RESTART_MODE_DISABLE = "DISABLE"
    """


    """
    GRACEFUL_RESTART_MODE_HELPER_ONLY = "HELPER_ONLY"
    """


    """
    GRACEFUL_RESTART_MODE_GR_AND_HELPER = "GR_AND_HELPER"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'address_families': 'address_families',
                            'allow_as_in': 'allow_as_in',
                            'bfd_config': 'bfd_config',
                            'enable_bfd': 'enable_bfd',
                            'enabled': 'enabled',
                            'filter_in_ipprefixlist_id': 'filter_in_ipprefixlist_id',
                            'filter_in_routemap_id': 'filter_in_routemap_id',
                            'filter_out_ipprefixlist_id': 'filter_out_ipprefixlist_id',
                            'filter_out_routemap_id': 'filter_out_routemap_id',
                            'graceful_restart_mode': 'graceful_restart_mode',
                            'hold_down_timer': 'hold_down_timer',
                            'keep_alive_timer': 'keep_alive_timer',
                            'logical_router_id': 'logical_router_id',
                            'maximum_hop_limit': 'maximum_hop_limit',
                            'neighbor_address': 'neighbor_address',
                            'password': 'password',
                            'remote_as': 'remote_as',
                            'remote_as_num': 'remote_as_num',
                            'source_address': 'source_address',
                            'source_addresses': 'source_addresses',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 address_families=None,
                 allow_as_in=None,
                 bfd_config=None,
                 enable_bfd=None,
                 enabled=None,
                 filter_in_ipprefixlist_id=None,
                 filter_in_routemap_id=None,
                 filter_out_ipprefixlist_id=None,
                 filter_out_routemap_id=None,
                 graceful_restart_mode=None,
                 hold_down_timer=None,
                 keep_alive_timer=None,
                 logical_router_id=None,
                 maximum_hop_limit=None,
                 neighbor_address=None,
                 password=None,
                 remote_as=None,
                 remote_as_num=None,
                 source_address=None,
                 source_addresses=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  address_families: :class:`list` of :class:`BgpNeighborAddressFamily` or ``None``
        :param address_families: User can enable the neighbor for the specific address families and
            also define filters per address family. When the neighbor is
            created, it is default enabled for IPV4_UNICAST address family for
            backward compatibility reasons. User can change that if required,
            by defining the address family configuration.
        :type  allow_as_in: :class:`bool` or ``None``
        :param allow_as_in: Flag to enable allowas_in option for BGP neighbor
        :type  bfd_config: :class:`BfdConfigParameters` or ``None``
        :param bfd_config: 
        :type  enable_bfd: :class:`bool` or ``None``
        :param enable_bfd: Flag to enable BFD for this BGP Neighbor. Enable this if the
            neighbor supports BFD as this will lead to faster convergence.
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Flag to enable this BGP Neighbor
        :type  filter_in_ipprefixlist_id: :class:`str` or ``None``
        :param filter_in_ipprefixlist_id: This is a deprecated property, Please use 'address_family' instead.

            .. deprecated:: unknown
        :type  filter_in_routemap_id: :class:`str` or ``None``
        :param filter_in_routemap_id: This is a deprecated property, Please use 'address_family' instead.

            .. deprecated:: unknown
        :type  filter_out_ipprefixlist_id: :class:`str` or ``None``
        :param filter_out_ipprefixlist_id: This is a deprecated property, Please use 'address_family' instead.

            .. deprecated:: unknown
        :type  filter_out_routemap_id: :class:`str` or ``None``
        :param filter_out_routemap_id: This is a deprecated property, Please use 'address_family' instead.

            .. deprecated:: unknown
        :type  graceful_restart_mode: :class:`str` or ``None``
        :param graceful_restart_mode: Possible values are: 
            
            * :attr:`BgpNeighbor.GRACEFUL_RESTART_MODE_DISABLE`
            * :attr:`BgpNeighbor.GRACEFUL_RESTART_MODE_HELPER_ONLY`
            * :attr:`BgpNeighbor.GRACEFUL_RESTART_MODE_GR_AND_HELPER`
            
            BGP Graceful Restart mode. If specified, then it will take
            precedence over global Graceful Restart mode configured in logical
            router BgpConfig otherwise BgpConfig level Graceful Restart mode
            will be applicable for peer.
        :type  hold_down_timer: :class:`long` or ``None``
        :param hold_down_timer: Wait period (seconds) before declaring peer dead format: int64
        :type  keep_alive_timer: :class:`long` or ``None``
        :param keep_alive_timer: Frequency (seconds) with which keep alive messages are sent to
            peers format: int64
        :type  logical_router_id: :class:`str` or ``None``
        :param logical_router_id: Logical router id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  maximum_hop_limit: :class:`long` or ``None``
        :param maximum_hop_limit: This value is set on TTL(time to live) of BGP header. When router
            receives the BGP packet, it decrements the TTL. The default value
            of TTL is one when BPG request is initiated.So in the case of a BGP
            peer multiple hops away and and value of TTL is one, then next
            router in the path will decrement the TTL to 0, realize it cant
            forward the packet and will drop it. If the hop count value to
            reach neighbor is equal to or less than the maximum_hop_limit value
            then intermediate router decrements the TTL count by one and
            forwards the request to BGP neighour. If the hop count value is
            greater than the maximum_hop_limit value then intermediate router
            discards the request when TTL becomes 0. format: int32
        :type  neighbor_address: :class:`str` or ``None``
        :param neighbor_address: Neighbor IP Address format: ip
        :type  password: :class:`str` or ``None``
        :param password: User can create (POST) the neighbor with or without the password.
            The view (GET) on the neighbor, would never reveal if the password
            is set or not. The password can be set later using edit neighbor
            workFlow (PUT) On the edit neighbor (PUT), if the user does not
            specify the password property, the older value is retained. Maximum
            length of this field is 32 characters.
        :type  remote_as: :class:`long` or ``None``
        :param remote_as: This is a deprecated property, Please use 'remote_as_num' instead.
            format: int64

            .. deprecated:: unknown
        :type  remote_as_num: :class:`str` or ``None``
        :param remote_as_num: 4 Byte ASN of the neighbor in ASPLAIN/ASDOT Format
        :type  source_address: :class:`str` or ``None``
        :param source_address: Deprecated - do not provide a value for this field. Use
            source_addresses instead. format: ip

            .. deprecated:: unknown
        :type  source_addresses: :class:`list` of :class:`str` or ``None``
        :param source_addresses: BGP neighborship will be formed from all these source addresses to
            this neighbour. format: ip
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.address_families = address_families
        self.allow_as_in = allow_as_in
        self.bfd_config = bfd_config
        self.enable_bfd = enable_bfd
        self.enabled = enabled
        self.filter_in_ipprefixlist_id = filter_in_ipprefixlist_id
        self.filter_in_routemap_id = filter_in_routemap_id
        self.filter_out_ipprefixlist_id = filter_out_ipprefixlist_id
        self.filter_out_routemap_id = filter_out_routemap_id
        self.graceful_restart_mode = graceful_restart_mode
        self.hold_down_timer = hold_down_timer
        self.keep_alive_timer = keep_alive_timer
        self.logical_router_id = logical_router_id
        self.maximum_hop_limit = maximum_hop_limit
        self.neighbor_address = neighbor_address
        self.password = password
        self.remote_as = remote_as
        self.remote_as_num = remote_as_num
        self.source_address = source_address
        self.source_addresses = source_addresses
        VapiStruct.__init__(self)


BgpNeighbor._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_neighbor', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'address_families': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BgpNeighborAddressFamily'))),
        'allow_as_in': type.OptionalType(type.BooleanType()),
        'bfd_config': type.OptionalType(type.ReferenceType(__name__, 'BfdConfigParameters')),
        'enable_bfd': type.OptionalType(type.BooleanType()),
        'enabled': type.OptionalType(type.BooleanType()),
        'filter_in_ipprefixlist_id': type.OptionalType(type.StringType()),
        'filter_in_routemap_id': type.OptionalType(type.StringType()),
        'filter_out_ipprefixlist_id': type.OptionalType(type.StringType()),
        'filter_out_routemap_id': type.OptionalType(type.StringType()),
        'graceful_restart_mode': type.OptionalType(type.StringType()),
        'hold_down_timer': type.OptionalType(type.IntegerType()),
        'keep_alive_timer': type.OptionalType(type.IntegerType()),
        'logical_router_id': type.OptionalType(type.StringType()),
        'maximum_hop_limit': type.OptionalType(type.IntegerType()),
        'neighbor_address': type.OptionalType(type.StringType()),
        'password': type.OptionalType(type.StringType()),
        'remote_as': type.OptionalType(type.IntegerType()),
        'remote_as_num': type.OptionalType(type.StringType()),
        'source_address': type.OptionalType(type.StringType()),
        'source_addresses': type.OptionalType(type.ListType(type.StringType())),
    },
    BgpNeighbor,
    False,
    None))



class BgpNeighborAddressFamily(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_IPV4_UNICAST = "IPV4_UNICAST"
    """


    """
    TYPE_VPNV4_UNICAST = "VPNV4_UNICAST"
    """


    """
    TYPE_IPV6_UNICAST = "IPV6_UNICAST"
    """


    """
    TYPE_L2VPN_EVPN = "L2VPN_EVPN"
    """


    """



    _canonical_to_pep_names = {
                            'enabled': 'enabled',
                            'in_filter_ipprefixlist_id': 'in_filter_ipprefixlist_id',
                            'in_filter_routemap_id': 'in_filter_routemap_id',
                            'maximum_routes': 'maximum_routes',
                            'out_filter_ipprefixlist_id': 'out_filter_ipprefixlist_id',
                            'out_filter_routemap_id': 'out_filter_routemap_id',
                            'type': 'type',
                            }

    def __init__(self,
                 enabled=None,
                 in_filter_ipprefixlist_id=None,
                 in_filter_routemap_id=None,
                 maximum_routes=None,
                 out_filter_ipprefixlist_id=None,
                 out_filter_routemap_id=None,
                 type=None,
                ):
        """
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Enable this address family
        :type  in_filter_ipprefixlist_id: :class:`str` or ``None``
        :param in_filter_ipprefixlist_id: Id of the IPPrefix List to be used for IN direction filter
        :type  in_filter_routemap_id: :class:`str` or ``None``
        :param in_filter_routemap_id: Id of the RouteMap to be used for IN direction filter
        :type  maximum_routes: :class:`long` or ``None``
        :param maximum_routes: Maximum number of routes supported on the address family format:
            int64
        :type  out_filter_ipprefixlist_id: :class:`str` or ``None``
        :param out_filter_ipprefixlist_id: Id of the IPPrefixList to be used for OUT direction filter
        :type  out_filter_routemap_id: :class:`str` or ``None``
        :param out_filter_routemap_id: Id of the RouteMap to be used for OUT direction filter
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`BgpNeighborAddressFamily.TYPE_IPV4_UNICAST`
            * :attr:`BgpNeighborAddressFamily.TYPE_VPNV4_UNICAST`
            * :attr:`BgpNeighborAddressFamily.TYPE_IPV6_UNICAST`
            * :attr:`BgpNeighborAddressFamily.TYPE_L2VPN_EVPN`
            
            Address family type
        """
        self.enabled = enabled
        self.in_filter_ipprefixlist_id = in_filter_ipprefixlist_id
        self.in_filter_routemap_id = in_filter_routemap_id
        self.maximum_routes = maximum_routes
        self.out_filter_ipprefixlist_id = out_filter_ipprefixlist_id
        self.out_filter_routemap_id = out_filter_routemap_id
        self.type = type
        VapiStruct.__init__(self)


BgpNeighborAddressFamily._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_neighbor_address_family', {
        'enabled': type.OptionalType(type.BooleanType()),
        'in_filter_ipprefixlist_id': type.OptionalType(type.StringType()),
        'in_filter_routemap_id': type.OptionalType(type.StringType()),
        'maximum_routes': type.OptionalType(type.IntegerType()),
        'out_filter_ipprefixlist_id': type.OptionalType(type.StringType()),
        'out_filter_routemap_id': type.OptionalType(type.StringType()),
        'type': type.OptionalType(type.StringType()),
    },
    BgpNeighborAddressFamily,
    False,
    None))



class BgpNeighborListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`BgpNeighbor` or ``None``
        :param results: Paginated list of bgp neighbors
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


BgpNeighborListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_neighbor_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BgpNeighbor'))),
    },
    BgpNeighborListResult,
    False,
    None))



class BgpNeighborRouteDetails(VapiStruct):
    """
    BGP neighbor learned/advertised route details.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'logical_router_id': 'logical_router_id',
                            'neighbor_address': 'neighbor_address',
                            'neighbor_id': 'neighbor_id',
                            'per_transport_node_routes': 'per_transport_node_routes',
                            }

    def __init__(self,
                 logical_router_id=None,
                 neighbor_address=None,
                 neighbor_id=None,
                 per_transport_node_routes=None,
                ):
        """
        :type  logical_router_id: :class:`str` or ``None``
        :param logical_router_id: Logical router id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  neighbor_address: :class:`str` or ``None``
        :param neighbor_address: BGP neighbor peer IP address. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  neighbor_id: :class:`str` or ``None``
        :param neighbor_id: BGP neighbor id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  per_transport_node_routes: :class:`list` of :class:`RoutesPerTransportNode` or ``None``
        :param per_transport_node_routes: Array of BGP neighbor route details per transport node.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.logical_router_id = logical_router_id
        self.neighbor_address = neighbor_address
        self.neighbor_id = neighbor_id
        self.per_transport_node_routes = per_transport_node_routes
        VapiStruct.__init__(self)


BgpNeighborRouteDetails._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_neighbor_route_details', {
        'logical_router_id': type.OptionalType(type.StringType()),
        'neighbor_address': type.OptionalType(type.StringType()),
        'neighbor_id': type.OptionalType(type.StringType()),
        'per_transport_node_routes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'RoutesPerTransportNode'))),
    },
    BgpNeighborRouteDetails,
    False,
    None))



class BgpNeighborRouteDetailsCsvRecord(VapiStruct):
    """
    BGP neighbor learned/advertised route details.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'as_path': 'as_path',
                            'local_pref': 'local_pref',
                            'logical_router_id': 'logical_router_id',
                            'med': 'med',
                            'neighbor_address': 'neighbor_address',
                            'neighbor_id': 'neighbor_id',
                            'network': 'network',
                            'next_hop': 'next_hop',
                            'source_address': 'source_address',
                            'transport_node_id': 'transport_node_id',
                            'weight': 'weight',
                            }

    def __init__(self,
                 as_path=None,
                 local_pref=None,
                 logical_router_id=None,
                 med=None,
                 neighbor_address=None,
                 neighbor_id=None,
                 network=None,
                 next_hop=None,
                 source_address=None,
                 transport_node_id=None,
                 weight=None,
                ):
        """
        :type  as_path: :class:`str` or ``None``
        :param as_path: BGP AS path attribute.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  local_pref: :class:`long` or ``None``
        :param local_pref: BGP Local Preference attribute. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  logical_router_id: :class:`str` or ``None``
        :param logical_router_id: Logical router id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  med: :class:`long` or ``None``
        :param med: BGP Multi Exit Discriminator attribute. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  neighbor_address: :class:`str` or ``None``
        :param neighbor_address: BGP neighbor peer IP address. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  neighbor_id: :class:`str` or ``None``
        :param neighbor_id: BGP neighbor id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  network: :class:`str` or ``None``
        :param network: CIDR network address. format: ip-cidr-block
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  next_hop: :class:`str` or ``None``
        :param next_hop: Next hop IP address. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  source_address: :class:`str` or ``None``
        :param source_address: BGP neighbor source address. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  transport_node_id: :class:`str` or ``None``
        :param transport_node_id: Transport node id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  weight: :class:`long` or ``None``
        :param weight: BGP Weight attribute. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.as_path = as_path
        self.local_pref = local_pref
        self.logical_router_id = logical_router_id
        self.med = med
        self.neighbor_address = neighbor_address
        self.neighbor_id = neighbor_id
        self.network = network
        self.next_hop = next_hop
        self.source_address = source_address
        self.transport_node_id = transport_node_id
        self.weight = weight
        VapiStruct.__init__(self)


BgpNeighborRouteDetailsCsvRecord._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_neighbor_route_details_csv_record', {
        'as_path': type.OptionalType(type.StringType()),
        'local_pref': type.OptionalType(type.IntegerType()),
        'logical_router_id': type.OptionalType(type.StringType()),
        'med': type.OptionalType(type.IntegerType()),
        'neighbor_address': type.OptionalType(type.StringType()),
        'neighbor_id': type.OptionalType(type.StringType()),
        'network': type.OptionalType(type.StringType()),
        'next_hop': type.OptionalType(type.StringType()),
        'source_address': type.OptionalType(type.StringType()),
        'transport_node_id': type.OptionalType(type.StringType()),
        'weight': type.OptionalType(type.IntegerType()),
    },
    BgpNeighborRouteDetailsCsvRecord,
    False,
    None))



class BgpNeighborRouteDetailsInCsvFormat(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'file_name': 'file_name',
                            'results': 'results',
                            }

    def __init__(self,
                 file_name=None,
                 results=None,
                ):
        """
        :type  file_name: :class:`str` or ``None``
        :param file_name: File name set by HTTP server if API returns CSV result as a file.
        :type  results: :class:`list` of :class:`BgpNeighborRouteDetailsCsvRecord` or ``None``
        :param results: 
        """
        self.file_name = file_name
        self.results = results
        VapiStruct.__init__(self)


BgpNeighborRouteDetailsInCsvFormat._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_neighbor_route_details_in_csv_format', {
        'file_name': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BgpNeighborRouteDetailsCsvRecord'))),
    },
    BgpNeighborRouteDetailsInCsvFormat,
    False,
    None))



class BgpNeighborStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CONNECTION_STATE_INVALID = "INVALID"
    """


    """
    CONNECTION_STATE_IDLE = "IDLE"
    """


    """
    CONNECTION_STATE_CONNECT = "CONNECT"
    """


    """
    CONNECTION_STATE_ACTIVE = "ACTIVE"
    """


    """
    CONNECTION_STATE_OPEN_SENT = "OPEN_SENT"
    """


    """
    CONNECTION_STATE_OPEN_CONFIRM = "OPEN_CONFIRM"
    """


    """
    CONNECTION_STATE_ESTABLISHED = "ESTABLISHED"
    """


    """
    CONNECTION_STATE_UNKNOWN = "UNKNOWN"
    """


    """
    TYPE_INTER_SR = "INTER_SR"
    """


    """
    TYPE_USER = "USER"
    """


    """



    _canonical_to_pep_names = {
                            'address_families': 'address_families',
                            'announced_capabilities': 'announced_capabilities',
                            'connection_drop_count': 'connection_drop_count',
                            'connection_state': 'connection_state',
                            'established_connection_count': 'established_connection_count',
                            'graceful_restart': 'graceful_restart',
                            'graceful_restart_mode': 'graceful_restart_mode',
                            'hold_time': 'hold_time',
                            'keep_alive_interval': 'keep_alive_interval',
                            'local_port': 'local_port',
                            'lr_component_id': 'lr_component_id',
                            'messages_received': 'messages_received',
                            'messages_sent': 'messages_sent',
                            'negotiated_capability': 'negotiated_capability',
                            'neighbor_address': 'neighbor_address',
                            'neighbor_router_id': 'neighbor_router_id',
                            'remote_as_number': 'remote_as_number',
                            'remote_port': 'remote_port',
                            'remote_site': 'remote_site',
                            'source_address': 'source_address',
                            'time_since_established': 'time_since_established',
                            'total_in_prefix_count': 'total_in_prefix_count',
                            'total_out_prefix_count': 'total_out_prefix_count',
                            'transport_node': 'transport_node',
                            'type': 'type',
                            }

    def __init__(self,
                 address_families=None,
                 announced_capabilities=None,
                 connection_drop_count=None,
                 connection_state=None,
                 established_connection_count=None,
                 graceful_restart=None,
                 graceful_restart_mode=None,
                 hold_time=None,
                 keep_alive_interval=None,
                 local_port=None,
                 lr_component_id=None,
                 messages_received=None,
                 messages_sent=None,
                 negotiated_capability=None,
                 neighbor_address=None,
                 neighbor_router_id=None,
                 remote_as_number=None,
                 remote_port=None,
                 remote_site=None,
                 source_address=None,
                 time_since_established=None,
                 total_in_prefix_count=None,
                 total_out_prefix_count=None,
                 transport_node=None,
                 type=None,
                ):
        """
        :type  address_families: :class:`list` of :class:`BgpAddressFamily` or ``None``
        :param address_families: Address families of BGP neighbor
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  announced_capabilities: :class:`list` of :class:`str` or ``None``
        :param announced_capabilities: BGP capabilities sent to BGP neighbor.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  connection_drop_count: :class:`long` or ``None``
        :param connection_drop_count: Count of connection drop format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  connection_state: :class:`str` or ``None``
        :param connection_state: Possible values are: 
            
            * :attr:`BgpNeighborStatus.CONNECTION_STATE_INVALID`
            * :attr:`BgpNeighborStatus.CONNECTION_STATE_IDLE`
            * :attr:`BgpNeighborStatus.CONNECTION_STATE_CONNECT`
            * :attr:`BgpNeighborStatus.CONNECTION_STATE_ACTIVE`
            * :attr:`BgpNeighborStatus.CONNECTION_STATE_OPEN_SENT`
            * :attr:`BgpNeighborStatus.CONNECTION_STATE_OPEN_CONFIRM`
            * :attr:`BgpNeighborStatus.CONNECTION_STATE_ESTABLISHED`
            * :attr:`BgpNeighborStatus.CONNECTION_STATE_UNKNOWN`
            
            Current state of the BGP session.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  established_connection_count: :class:`long` or ``None``
        :param established_connection_count: Count of connections established format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  graceful_restart: :class:`bool` or ``None``
        :param graceful_restart: Current state of graceful restart where graceful_restart = true
            indicates graceful restart is enabled and graceful_restart = false
            indicates graceful restart is disabled. This is deprecated field,
            use graceful_restart_mode instead.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.

            .. deprecated:: unknown
        :type  graceful_restart_mode: :class:`str` or ``None``
        :param graceful_restart_mode: Current state of graceful restart of BGP neighbor. Possible values
            are - 1. GR_AND_HELPER - Graceful restart with Helper 2.
            HELPER_ONLY - Helper only 3. DISABLE - Disabled
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  hold_time: :class:`long` or ``None``
        :param hold_time: Time in ms to wait for HELLO from BGP peer. If a HELLO packet is
            not seen from BGP Peer withing hold_time then BGP neighbor will be
            marked as down. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  keep_alive_interval: :class:`long` or ``None``
        :param keep_alive_interval: Time in ms to wait for HELLO packet from BGP peer format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  local_port: :class:`long` or ``None``
        :param local_port: TCP port number of Local BGP connection format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  lr_component_id: :class:`str` or ``None``
        :param lr_component_id: Logical router component(Service Router/Distributed Router) id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  messages_received: :class:`long` or ``None``
        :param messages_received: Count of messages received from the neighbor format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  messages_sent: :class:`long` or ``None``
        :param messages_sent: Count of messages sent to the neighbor format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  negotiated_capability: :class:`list` of :class:`str` or ``None``
        :param negotiated_capability: BGP capabilities negotiated with BGP neighbor.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  neighbor_address: :class:`str` or ``None``
        :param neighbor_address: The IP of the BGP neighbor format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  neighbor_router_id: :class:`str` or ``None``
        :param neighbor_router_id: Router ID of the BGP neighbor. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_as_number: :class:`str` or ``None``
        :param remote_as_number: AS number of the BGP neighbor
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_port: :class:`long` or ``None``
        :param remote_port: TCP port number of remote BGP Connection format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_site: :class:`ResourceReference` or ``None``
        :param remote_site: 
        :type  source_address: :class:`str` or ``None``
        :param source_address: The Ip address of logical port format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  time_since_established: :class:`long` or ``None``
        :param time_since_established: Time(in seconds) since connection was established. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  total_in_prefix_count: :class:`long` or ``None``
        :param total_in_prefix_count: Sum of in prefixes counts across all address families. format:
            int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  total_out_prefix_count: :class:`long` or ``None``
        :param total_out_prefix_count: Sum of out prefixes counts across all address families. format:
            int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  transport_node: :class:`ResourceReference` or ``None``
        :param transport_node: 
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`BgpNeighborStatus.TYPE_INTER_SR`
            * :attr:`BgpNeighborStatus.TYPE_USER`
            
            BGP neighbor type
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.address_families = address_families
        self.announced_capabilities = announced_capabilities
        self.connection_drop_count = connection_drop_count
        self.connection_state = connection_state
        self.established_connection_count = established_connection_count
        self.graceful_restart = graceful_restart
        self.graceful_restart_mode = graceful_restart_mode
        self.hold_time = hold_time
        self.keep_alive_interval = keep_alive_interval
        self.local_port = local_port
        self.lr_component_id = lr_component_id
        self.messages_received = messages_received
        self.messages_sent = messages_sent
        self.negotiated_capability = negotiated_capability
        self.neighbor_address = neighbor_address
        self.neighbor_router_id = neighbor_router_id
        self.remote_as_number = remote_as_number
        self.remote_port = remote_port
        self.remote_site = remote_site
        self.source_address = source_address
        self.time_since_established = time_since_established
        self.total_in_prefix_count = total_in_prefix_count
        self.total_out_prefix_count = total_out_prefix_count
        self.transport_node = transport_node
        self.type = type
        VapiStruct.__init__(self)


BgpNeighborStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_neighbor_status', {
        'address_families': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BgpAddressFamily'))),
        'announced_capabilities': type.OptionalType(type.ListType(type.StringType())),
        'connection_drop_count': type.OptionalType(type.IntegerType()),
        'connection_state': type.OptionalType(type.StringType()),
        'established_connection_count': type.OptionalType(type.IntegerType()),
        'graceful_restart': type.OptionalType(type.BooleanType()),
        'graceful_restart_mode': type.OptionalType(type.StringType()),
        'hold_time': type.OptionalType(type.IntegerType()),
        'keep_alive_interval': type.OptionalType(type.IntegerType()),
        'local_port': type.OptionalType(type.IntegerType()),
        'lr_component_id': type.OptionalType(type.StringType()),
        'messages_received': type.OptionalType(type.IntegerType()),
        'messages_sent': type.OptionalType(type.IntegerType()),
        'negotiated_capability': type.OptionalType(type.ListType(type.StringType())),
        'neighbor_address': type.OptionalType(type.StringType()),
        'neighbor_router_id': type.OptionalType(type.StringType()),
        'remote_as_number': type.OptionalType(type.StringType()),
        'remote_port': type.OptionalType(type.IntegerType()),
        'remote_site': type.OptionalType(type.ReferenceType(__name__, 'ResourceReference')),
        'source_address': type.OptionalType(type.StringType()),
        'time_since_established': type.OptionalType(type.IntegerType()),
        'total_in_prefix_count': type.OptionalType(type.IntegerType()),
        'total_out_prefix_count': type.OptionalType(type.IntegerType()),
        'transport_node': type.OptionalType(type.ReferenceType(__name__, 'ResourceReference')),
        'type': type.OptionalType(type.StringType()),
    },
    BgpNeighborStatus,
    False,
    None))



class BgpNeighborStatusLiteDto(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CONNECTION_STATE_INVALID = "INVALID"
    """


    """
    CONNECTION_STATE_IDLE = "IDLE"
    """


    """
    CONNECTION_STATE_CONNECT = "CONNECT"
    """


    """
    CONNECTION_STATE_ACTIVE = "ACTIVE"
    """


    """
    CONNECTION_STATE_OPEN_SENT = "OPEN_SENT"
    """


    """
    CONNECTION_STATE_OPEN_CONFIRM = "OPEN_CONFIRM"
    """


    """
    CONNECTION_STATE_ESTABLISHED = "ESTABLISHED"
    """


    """
    CONNECTION_STATE_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'connection_state': 'connection_state',
                            'neighbor_address': 'neighbor_address',
                            'remote_site': 'remote_site',
                            'source_address': 'source_address',
                            }

    def __init__(self,
                 connection_state=None,
                 neighbor_address=None,
                 remote_site=None,
                 source_address=None,
                ):
        """
        :type  connection_state: :class:`str` or ``None``
        :param connection_state: Possible values are: 
            
            * :attr:`BgpNeighborStatusLiteDto.CONNECTION_STATE_INVALID`
            * :attr:`BgpNeighborStatusLiteDto.CONNECTION_STATE_IDLE`
            * :attr:`BgpNeighborStatusLiteDto.CONNECTION_STATE_CONNECT`
            * :attr:`BgpNeighborStatusLiteDto.CONNECTION_STATE_ACTIVE`
            * :attr:`BgpNeighborStatusLiteDto.CONNECTION_STATE_OPEN_SENT`
            * :attr:`BgpNeighborStatusLiteDto.CONNECTION_STATE_OPEN_CONFIRM`
            * :attr:`BgpNeighborStatusLiteDto.CONNECTION_STATE_ESTABLISHED`
            * :attr:`BgpNeighborStatusLiteDto.CONNECTION_STATE_UNKNOWN`
            
            Current state of the BGP session.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  neighbor_address: :class:`str` or ``None``
        :param neighbor_address: Ip address of BGP neighbor. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_site: :class:`ResourceReference` or ``None``
        :param remote_site: 
        :type  source_address: :class:`str` or ``None``
        :param source_address: Source Ip address. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.connection_state = connection_state
        self.neighbor_address = neighbor_address
        self.remote_site = remote_site
        self.source_address = source_address
        VapiStruct.__init__(self)


BgpNeighborStatusLiteDto._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_neighbor_status_lite_dto', {
        'connection_state': type.OptionalType(type.StringType()),
        'neighbor_address': type.OptionalType(type.StringType()),
        'remote_site': type.OptionalType(type.ReferenceType(__name__, 'ResourceReference')),
        'source_address': type.OptionalType(type.StringType()),
    },
    BgpNeighborStatusLiteDto,
    False,
    None))



class BgpNeighborsStatusListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'last_update_timestamp': 'last_update_timestamp',
                            'logical_router_id': 'logical_router_id',
                            'logical_router_name': 'logical_router_name',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 last_update_timestamp=None,
                 logical_router_id=None,
                 logical_router_name=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_update_timestamp: :class:`long` or ``None``
        :param last_update_timestamp: Timestamp when the data was last updated, unset if data source has
            never updated the data. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  logical_router_id: :class:`str` or ``None``
        :param logical_router_id: Logical router id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  logical_router_name: :class:`str` or ``None``
        :param logical_router_name: Name of the logical router
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`BgpNeighborStatus` or ``None``
        :param results: Status of BGP neighbors of the logical router
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.last_update_timestamp = last_update_timestamp
        self.logical_router_id = logical_router_id
        self.logical_router_name = logical_router_name
        self.results = results
        VapiStruct.__init__(self)


BgpNeighborsStatusListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_neighbors_status_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'last_update_timestamp': type.OptionalType(type.IntegerType()),
        'logical_router_id': type.OptionalType(type.StringType()),
        'logical_router_name': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BgpNeighborStatus'))),
    },
    BgpNeighborsStatusListResult,
    False,
    None))



class BgpRouteAggregation(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'prefix': 'prefix',
                            'summary_only': 'summary_only',
                            }

    def __init__(self,
                 prefix=None,
                 summary_only=None,
                ):
        """
        :type  prefix: :class:`str` or ``None``
        :param prefix: cidr of the aggregate address format: ip-cidr-block
        :type  summary_only: :class:`bool` or ``None``
        :param summary_only: Flag to send only summarized route
        """
        self.prefix = prefix
        self.summary_only = summary_only
        VapiStruct.__init__(self)


BgpRouteAggregation._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bgp_route_aggregation', {
        'prefix': type.OptionalType(type.StringType()),
        'summary_only': type.OptionalType(type.BooleanType()),
    },
    BgpRouteAggregation,
    False,
    None))



class BinaryPacketData(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BinaryPacketData"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'payload': 'payload',
                            'frame_size': 'frame_size',
                            'resource_type': 'resource_type',
                            'routed': 'routed',
                            'transport_type': 'transport_type',
                            }

    def __init__(self,
                 payload=None,
                 frame_size=None,
                 resource_type='BinaryPacketData',
                 routed=None,
                 transport_type=None,
                ):
        """
        :type  payload: :class:`str` or ``None``
        :param payload: Up to 1000 bytes of payload may be supplied (with a base64-encoded
            length of 1336 bytes.) Additional bytes of traceflow metadata will
            be appended to the payload. The payload must contain all headers
            (Ethernet, IP, etc). Note that VLAN is not supported in the logical
            space. Hence, payload must not contain 802.1Q headers.
        :type  frame_size: :class:`long` or ``None``
        :param frame_size: If the requested frame_size is too small (given the payload and
            traceflow metadata requirement of 16 bytes), the traceflow request
            will fail with an appropriate message. The frame will be zero
            padded to the requested size. format: int64
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`PacketData.RESOURCE_TYPE_BINARYPACKETDATA`
            * :attr:`PacketData.RESOURCE_TYPE_FIELDSPACKETDATA`
            
            Packet configuration
        :type  routed: :class:`bool` or ``None``
        :param routed: When this flag is set, traceflow packet will have its destination
            overwritten as the gateway address of the logical router to which
            the source logical switch is connected. More specifically: - For
            ARP request, the target IP will be overwritten as gateway IP if the
            target IP is not in the same subnet of gateway. - For ARP response,
            the target IP and destination MAC will be overwritten as gateway
            IP/MAC respectively, if the target IP is not in the same subnet of
            gateway. - For IP packet, the destination MAC will be overwritten
            as gateway MAC. However, this flag will not be effective when
            injecting the traceflow packet to a VLAN backed port. This is
            because the gateway in this case is a physical gateway that is
            outside the scope of NSX. Therefore, users need to manually
            populate the gateway MAC address. If the user still sets this flag
            in this case, a validation error will be thrown.
        :type  transport_type: :class:`str` or ``None``
        :param transport_type: Possible values are: 
            
            * :attr:`PacketData.TRANSPORT_TYPE_BROADCAST`
            * :attr:`PacketData.TRANSPORT_TYPE_UNICAST`
            * :attr:`PacketData.TRANSPORT_TYPE_MULTICAST`
            * :attr:`PacketData.TRANSPORT_TYPE_UNKNOWN`
            
            This type takes effect only for IP packet.
        """
        self.payload = payload
        self.frame_size = frame_size
        self._resource_type = resource_type
        self.routed = routed
        self.transport_type = transport_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BinaryPacketData._set_binding_type(type.StructType(
    'com.vmware.nsx.model.binary_packet_data', {
        'payload': type.OptionalType(type.StringType()),
        'frame_size': type.OptionalType(type.IntegerType()),
        'resource_type': type.StringType(),
        'routed': type.OptionalType(type.BooleanType()),
        'transport_type': type.OptionalType(type.StringType()),
    },
    BinaryPacketData,
    False,
    None))



class BondPnicStatus(VapiStruct):
    """
    pNIC/bond statuses

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """
    STATUS_UP = "UP"
    """


    """
    STATUS_DOWN = "DOWN"
    """


    """
    STATUS_DEGRADED = "DEGRADED"
    """


    """
    TYPE_UNKNOWN_TYPE = "UNKNOWN_TYPE"
    """


    """
    TYPE_PNIC = "PNIC"
    """


    """
    TYPE_BOND = "BOND"
    """


    """



    _canonical_to_pep_names = {
                            'name': 'name',
                            'status': 'status',
                            'type': 'type',
                            }

    def __init__(self,
                 name=None,
                 status=None,
                 type=None,
                ):
        """
        :type  name: :class:`str` or ``None``
        :param name: Name of the pNIC/bond
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`BondPnicStatus.STATUS_UNKNOWN`
            * :attr:`BondPnicStatus.STATUS_UP`
            * :attr:`BondPnicStatus.STATUS_DOWN`
            * :attr:`BondPnicStatus.STATUS_DEGRADED`
            
            Status of pNIC/bond
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`BondPnicStatus.TYPE_UNKNOWN_TYPE`
            * :attr:`BondPnicStatus.TYPE_PNIC`
            * :attr:`BondPnicStatus.TYPE_BOND`
            
            Type, whether the object is a pNIC or a bond
        """
        self.name = name
        self.status = status
        self.type = type
        VapiStruct.__init__(self)


BondPnicStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bond_pnic_status', {
        'name': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
        'type': type.OptionalType(type.StringType()),
    },
    BondPnicStatus,
    False,
    None))



class BpduFilter(VapiStruct):
    """
    BPDU filter configuration

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'enabled': 'enabled',
                            'white_list': 'white_list',
                            }

    def __init__(self,
                 enabled=None,
                 white_list=None,
                ):
        """
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Indicates whether BPDU filter is enabled
        :type  white_list: :class:`list` of :class:`str` or ``None``
        :param white_list: Pre-defined list of allowed MAC addresses to be excluded from BPDU
            filtering
        """
        self.enabled = enabled
        self.white_list = white_list
        VapiStruct.__init__(self)


BpduFilter._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bpdu_filter', {
        'enabled': type.OptionalType(type.BooleanType()),
        'white_list': type.OptionalType(type.ListType(type.StringType())),
    },
    BpduFilter,
    False,
    None))



class BridgeEndpoint(VapiStruct):
    """
    A bridge endpoint can be created on a bridge cluster or on an edge cluster.
    Few of the properties of this class will not be used depending on the type
    of bridge endpoint being created. When creating a bridge endpoint on a
    bridge cluster, following propeties will be used: vlan, bridge_cluster_id
    and ha_enable. Similarly, for creating a bridge endpoint on an edge cluster
    following properties will be used: vlan, bridge_endpoint_profile_id and
    vlan_transport_zone_id.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'bridge_cluster_id': 'bridge_cluster_id',
                            'bridge_endpoint_profile_id': 'bridge_endpoint_profile_id',
                            'ha_enable': 'ha_enable',
                            'uplink_teaming_policy_name': 'uplink_teaming_policy_name',
                            'vlan': 'vlan',
                            'vlan_transport_zone_id': 'vlan_transport_zone_id',
                            'vlan_trunk_spec': 'vlan_trunk_spec',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 bridge_cluster_id=None,
                 bridge_endpoint_profile_id=None,
                 ha_enable=None,
                 uplink_teaming_policy_name=None,
                 vlan=None,
                 vlan_transport_zone_id=None,
                 vlan_trunk_spec=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  bridge_cluster_id: :class:`str` or ``None``
        :param bridge_cluster_id: This field will not be used if an edge cluster is being used for
            the bridge endpoint
        :type  bridge_endpoint_profile_id: :class:`str` or ``None``
        :param bridge_endpoint_profile_id: This field will not be used if a bridge cluster is being used for
            the bridge endpoint
        :type  ha_enable: :class:`bool` or ``None``
        :param ha_enable: This field will not be used if an edge cluster is being used for
            the bridge endpoint
        :type  uplink_teaming_policy_name: :class:`str` or ``None``
        :param uplink_teaming_policy_name: This name has to be one of the switching uplink teaming policy
            names listed inside the TransportZone. If this field is not
            specified, bridge will use the first pnic in host-switch config.
            This field will not be used if a bridge cluster is being used for
            the bridge endpoint
        :type  vlan: :class:`long` or ``None``
        :param vlan: This property is used for VLAN specification of bridge endpoint.
            It's mutually exclusive with 'vlan_trunk_spec', either 'vlan' or
            'vlan_trunk_spec' should be specified. format: int64
        :type  vlan_transport_zone_id: :class:`str` or ``None``
        :param vlan_transport_zone_id: This field will not be used if a bridge cluster is being used for
            the bridge endpoint
        :type  vlan_trunk_spec: :class:`VlanTrunkSpec` or ``None``
        :param vlan_trunk_spec: 
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.bridge_cluster_id = bridge_cluster_id
        self.bridge_endpoint_profile_id = bridge_endpoint_profile_id
        self.ha_enable = ha_enable
        self.uplink_teaming_policy_name = uplink_teaming_policy_name
        self.vlan = vlan
        self.vlan_transport_zone_id = vlan_transport_zone_id
        self.vlan_trunk_spec = vlan_trunk_spec
        VapiStruct.__init__(self)


BridgeEndpoint._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bridge_endpoint', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'bridge_cluster_id': type.OptionalType(type.StringType()),
        'bridge_endpoint_profile_id': type.OptionalType(type.StringType()),
        'ha_enable': type.OptionalType(type.BooleanType()),
        'uplink_teaming_policy_name': type.OptionalType(type.StringType()),
        'vlan': type.OptionalType(type.IntegerType()),
        'vlan_transport_zone_id': type.OptionalType(type.StringType()),
        'vlan_trunk_spec': type.OptionalType(type.ReferenceType(__name__, 'VlanTrunkSpec')),
    },
    BridgeEndpoint,
    False,
    None))



class BridgeEndpointListResult(VapiStruct):
    """
    Bridge Endpoint queries result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`BridgeEndpoint` or ``None``
        :param results: BridgeEndpoint Results
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


BridgeEndpointListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bridge_endpoint_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BridgeEndpoint'))),
    },
    BridgeEndpointListResult,
    False,
    None))



class BridgeEndpointProfile(VapiStruct):
    """
    Bridge Endpoint Profile

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    FAILOVER_MODE_PREEMPTIVE = "PREEMPTIVE"
    """


    """
    FAILOVER_MODE_NON_PREEMPTIVE = "NON_PREEMPTIVE"
    """


    """
    HIGH_AVAILABILITY_MODE_STANDBY = "ACTIVE_STANDBY"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'edge_cluster_id': 'edge_cluster_id',
                            'edge_cluster_member_indexes': 'edge_cluster_member_indexes',
                            'failover_mode': 'failover_mode',
                            'high_availability_mode': 'high_availability_mode',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 edge_cluster_id=None,
                 edge_cluster_member_indexes=None,
                 failover_mode=None,
                 high_availability_mode=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  edge_cluster_id: :class:`str` or ``None``
        :param edge_cluster_id: UUID of the edge cluster for this bridge endpoint
        :type  edge_cluster_member_indexes: :class:`list` of :class:`long` or ``None``
        :param edge_cluster_member_indexes: First index will be used as the preferred member format: int32
        :type  failover_mode: :class:`str` or ``None``
        :param failover_mode: Possible values are: 
            
            * :attr:`BridgeEndpointProfile.FAILOVER_MODE_PREEMPTIVE`
            * :attr:`BridgeEndpointProfile.FAILOVER_MODE_NON_PREEMPTIVE`
            
            Faileover mode can be preemmptive or non-preemptive
        :type  high_availability_mode: :class:`str` or ``None``
        :param high_availability_mode: Possible values are: 
            
            * :attr:`BridgeEndpointProfile.HIGH_AVAILABILITY_MODE_STANDBY`
            
            High avaialability mode can be active-active or active-standby
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.edge_cluster_id = edge_cluster_id
        self.edge_cluster_member_indexes = edge_cluster_member_indexes
        self.failover_mode = failover_mode
        self.high_availability_mode = high_availability_mode
        VapiStruct.__init__(self)


BridgeEndpointProfile._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bridge_endpoint_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'edge_cluster_id': type.OptionalType(type.StringType()),
        'edge_cluster_member_indexes': type.OptionalType(type.ListType(type.IntegerType())),
        'failover_mode': type.OptionalType(type.StringType()),
        'high_availability_mode': type.OptionalType(type.StringType()),
    },
    BridgeEndpointProfile,
    False,
    None))



class BridgeEndpointProfileListResult(VapiStruct):
    """
    Bridge Endpoint Profile queries result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`BridgeEndpointProfile` or ``None``
        :param results: BridgeEndpointProfile Results
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


BridgeEndpointProfileListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bridge_endpoint_profile_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BridgeEndpointProfile'))),
    },
    BridgeEndpointProfileListResult,
    False,
    None))



class BridgeEndpointStatistics(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'rx_bytes': 'rx_bytes',
                            'rx_packets': 'rx_packets',
                            'tx_bytes': 'tx_bytes',
                            'tx_packets': 'tx_packets',
                            'endpoint_id': 'endpoint_id',
                            'last_update_timestamp': 'last_update_timestamp',
                            }

    def __init__(self,
                 rx_bytes=None,
                 rx_packets=None,
                 tx_bytes=None,
                 tx_packets=None,
                 endpoint_id=None,
                 last_update_timestamp=None,
                ):
        """
        :type  rx_bytes: :class:`DataCounter` or ``None``
        :param rx_bytes: 
        :type  rx_packets: :class:`DataCounter` or ``None``
        :param rx_packets: 
        :type  tx_bytes: :class:`DataCounter` or ``None``
        :param tx_bytes: 
        :type  tx_packets: :class:`DataCounter` or ``None``
        :param tx_packets: 
        :type  endpoint_id: :class:`str` or ``None``
        :param endpoint_id: The id of the bridge endpoint
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_update_timestamp: :class:`long` or ``None``
        :param last_update_timestamp: Timestamp when the data was last updated; unset if data source has
            never updated the data. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.rx_bytes = rx_bytes
        self.rx_packets = rx_packets
        self.tx_bytes = tx_bytes
        self.tx_packets = tx_packets
        self.endpoint_id = endpoint_id
        self.last_update_timestamp = last_update_timestamp
        VapiStruct.__init__(self)


BridgeEndpointStatistics._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bridge_endpoint_statistics', {
        'rx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'rx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'endpoint_id': type.OptionalType(type.StringType()),
        'last_update_timestamp': type.OptionalType(type.IntegerType()),
    },
    BridgeEndpointStatistics,
    False,
    None))



class BridgeEndpointStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'active_nodes': 'active_nodes',
                            'endpoint_id': 'endpoint_id',
                            'last_update_timestamp': 'last_update_timestamp',
                            }

    def __init__(self,
                 active_nodes=None,
                 endpoint_id=None,
                 last_update_timestamp=None,
                ):
        """
        :type  active_nodes: :class:`list` of :class:`str` or ``None``
        :param active_nodes: The Ids of the transport nodes which actively serve the endpoint.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  endpoint_id: :class:`str` or ``None``
        :param endpoint_id: The id of the bridge endpoint
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_update_timestamp: :class:`long` or ``None``
        :param last_update_timestamp: Timestamp when the data was last updated; unset if data source has
            never updated the data. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.active_nodes = active_nodes
        self.endpoint_id = endpoint_id
        self.last_update_timestamp = last_update_timestamp
        VapiStruct.__init__(self)


BridgeEndpointStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bridge_endpoint_status', {
        'active_nodes': type.OptionalType(type.ListType(type.StringType())),
        'endpoint_id': type.OptionalType(type.StringType()),
        'last_update_timestamp': type.OptionalType(type.IntegerType()),
    },
    BridgeEndpointStatus,
    False,
    None))



class BridgeHighAvailabilityClusterProfile(VapiStruct):
    """
    Profile for BFD HA cluster setting

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BridgeHighAvailabilityClusterProfile"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'bfd_probe_interval': 'bfd_probe_interval',
                            'enable': 'enable',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            }

    def __init__(self,
                 bfd_probe_interval=None,
                 enable=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='BridgeHighAvailabilityClusterProfile',
                 tags=None,
                ):
        """
        :type  bfd_probe_interval: :class:`long` or ``None``
        :param bfd_probe_interval: the time interval (in millisec) between probe packets for heartbeat
            purpose format: int64
        :type  enable: :class:`bool` or ``None``
        :param enable: whether the heartbeat is enabled
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`ClusterProfile.RESOURCE_TYPE_EDGEHIGHAVAILABILITYPROFILE`
            *
              :attr:`ClusterProfile.RESOURCE_TYPE_BRIDGEHIGHAVAILABILITYCLUSTERPROFILE`
            
            Supported cluster profiles.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        """
        self.bfd_probe_interval = bfd_probe_interval
        self.enable = enable
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BridgeHighAvailabilityClusterProfile._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bridge_high_availability_cluster_profile', {
        'bfd_probe_interval': type.OptionalType(type.IntegerType()),
        'enable': type.OptionalType(type.BooleanType()),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
    },
    BridgeHighAvailabilityClusterProfile,
    False,
    None))



class BrokerProperties(VapiStruct):
    """
    Information about a management plane node this transport node is configured
    to communicate with

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'BrokerFqdn': 'broker_fqdn',
                            'BrokerIpAddress': 'broker_ip_address',
                            'BrokerIsMaster': 'broker_is_master',
                            'BrokerPort': 'broker_port',
                            'BrokerSslCertThumbprint': 'broker_ssl_cert_thumbprint',
                            'BrokerVirtualHost': 'broker_virtual_host',
                            }

    def __init__(self,
                 broker_fqdn=None,
                 broker_ip_address=None,
                 broker_is_master=None,
                 broker_port=None,
                 broker_ssl_cert_thumbprint=None,
                 broker_virtual_host=None,
                ):
        """
        :type  broker_fqdn: :class:`str` or ``None``
        :param broker_fqdn: Fully qualified domain name of the message bus broker on the
            management plane node.
        :type  broker_ip_address: :class:`str` or ``None``
        :param broker_ip_address: IP address or hostname of the message bus broker on the management
            plane node. format: hostname-or-ipv4
        :type  broker_is_master: :class:`str` or ``None``
        :param broker_is_master: Indicates whether this broker is the master.
        :type  broker_port: :class:`str` or ``None``
        :param broker_port: Port number of the message bus broker on the management plane node.
        :type  broker_ssl_cert_thumbprint: :class:`str` or ``None``
        :param broker_ssl_cert_thumbprint: Certificate thumbprint of the message bus broker on the management
            plane node.
        :type  broker_virtual_host: :class:`str` or ``None``
        :param broker_virtual_host: Type of host running the broker.
        """
        self.broker_fqdn = broker_fqdn
        self.broker_ip_address = broker_ip_address
        self.broker_is_master = broker_is_master
        self.broker_port = broker_port
        self.broker_ssl_cert_thumbprint = broker_ssl_cert_thumbprint
        self.broker_virtual_host = broker_virtual_host
        VapiStruct.__init__(self)


BrokerProperties._set_binding_type(type.StructType(
    'com.vmware.nsx.model.broker_properties', {
        'BrokerFqdn': type.OptionalType(type.StringType()),
        'BrokerIpAddress': type.OptionalType(type.StringType()),
        'BrokerIsMaster': type.OptionalType(type.StringType()),
        'BrokerPort': type.OptionalType(type.StringType()),
        'BrokerSslCertThumbprint': type.OptionalType(type.StringType()),
        'BrokerVirtualHost': type.OptionalType(type.StringType()),
    },
    BrokerProperties,
    False,
    None))



class BundleId(VapiStruct):
    """
    Identifier of the bundle.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'bundle_id': 'bundle_id',
                            }

    def __init__(self,
                 bundle_id=None,
                ):
        """
        :type  bundle_id: :class:`str` or ``None``
        :param bundle_id: Identifier of bundle upload
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.bundle_id = bundle_id
        VapiStruct.__init__(self)


BundleId._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bundle_id', {
        'bundle_id': type.OptionalType(type.StringType()),
    },
    BundleId,
    False,
    None))



class BundleIds(VapiStruct):
    """
    Contains a list of bundle-ids.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'failed': 'failed',
                            'in_progress': 'in_progress',
                            'successful': 'successful',
                            }

    def __init__(self,
                 failed=None,
                 in_progress=None,
                 successful=None,
                ):
        """
        :type  failed: :class:`str` or ``None``
        :param failed: Id of a bundle whose upload was failed.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  in_progress: :class:`str` or ``None``
        :param in_progress: Id of a bundle whose upload is in-progress.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  successful: :class:`str` or ``None``
        :param successful: Id of a bundle whose upload is successful.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.failed = failed
        self.in_progress = in_progress
        self.successful = successful
        VapiStruct.__init__(self)


BundleIds._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bundle_ids', {
        'failed': type.OptionalType(type.StringType()),
        'in_progress': type.OptionalType(type.StringType()),
        'successful': type.OptionalType(type.StringType()),
    },
    BundleIds,
    False,
    None))



class BundleUploadPermission(VapiStruct):
    """
    Describes whether bundle upload is allowed or not.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'reason': 'reason',
                            'upload_allowed': 'upload_allowed',
                            }

    def __init__(self,
                 reason=None,
                 upload_allowed=None,
                ):
        """
        :type  reason: :class:`str` or ``None``
        :param reason: Reason for not allowing upload.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  upload_allowed: :class:`bool` or ``None``
        :param upload_allowed: Flag indication whether upload is allowed or not.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.reason = reason
        self.upload_allowed = upload_allowed
        VapiStruct.__init__(self)


BundleUploadPermission._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bundle_upload_permission', {
        'reason': type.OptionalType(type.StringType()),
        'upload_allowed': type.OptionalType(type.BooleanType()),
    },
    BundleUploadPermission,
    False,
    None))



class BundleUploadStatus(VapiStruct):
    """
    Upload status of bundle uploaded from local or remote location.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_UPLOADING = "UPLOADING"
    """


    """
    STATUS_VERIFYING = "VERIFYING"
    """


    """
    STATUS_SUCCESS = "SUCCESS"
    """


    """
    STATUS_FAILED = "FAILED"
    """


    """



    _canonical_to_pep_names = {
                            'bundle_name': 'bundle_name',
                            'detailed_status': 'detailed_status',
                            'percent': 'percent',
                            'status': 'status',
                            'url': 'url',
                            }

    def __init__(self,
                 bundle_name=None,
                 detailed_status=None,
                 percent=None,
                 status=None,
                 url=None,
                ):
        """
        :type  bundle_name: :class:`str` or ``None``
        :param bundle_name: Name of the uploaded bundle.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  detailed_status: :class:`str` or ``None``
        :param detailed_status: Detailed status of bundle upload.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  percent: :class:`float` or ``None``
        :param percent: Percent of bundle uploaded from remote location.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`BundleUploadStatus.STATUS_UPLOADING`
            * :attr:`BundleUploadStatus.STATUS_VERIFYING`
            * :attr:`BundleUploadStatus.STATUS_SUCCESS`
            * :attr:`BundleUploadStatus.STATUS_FAILED`
            
            Current status of bundle upload.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  url: :class:`str` or ``None``
        :param url: URL for uploading bundle.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.bundle_name = bundle_name
        self.detailed_status = detailed_status
        self.percent = percent
        self.status = status
        self.url = url
        VapiStruct.__init__(self)


BundleUploadStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.bundle_upload_status', {
        'bundle_name': type.OptionalType(type.StringType()),
        'detailed_status': type.OptionalType(type.StringType()),
        'percent': type.OptionalType(type.DoubleType()),
        'status': type.OptionalType(type.StringType()),
        'url': type.OptionalType(type.StringType()),
    },
    BundleUploadStatus,
    False,
    None))



class ByodServiceInstance(VapiStruct):
    """
    ByodServiceInstance is a custom instance to be used when NSX is not
    handling the lifecycles of appliance/s. User will manage their own
    appliance (BYOD) to connect with NSX.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ByodServiceInstance"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    DEPLOYMENT_MODE_STAND_ALONE = "STAND_ALONE"
    """


    """
    DEPLOYMENT_MODE_ACTIVE_STANDBY = "ACTIVE_STANDBY"
    """


    """



    _canonical_to_pep_names = {
                            'deployment_mode': 'deployment_mode',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'on_failure_policy': 'on_failure_policy',
                            'service_id': 'service_id',
                            'transport_type': 'transport_type',
                            }

    def __init__(self,
                 deployment_mode=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='ByodServiceInstance',
                 tags=None,
                 on_failure_policy=None,
                 service_id=None,
                 transport_type=None,
                ):
        """
        :type  deployment_mode: :class:`str` or ``None``
        :param deployment_mode: Possible values are: 
            
            * :attr:`ByodServiceInstance.DEPLOYMENT_MODE_STAND_ALONE`
            * :attr:`ByodServiceInstance.DEPLOYMENT_MODE_ACTIVE_STANDBY`
            
            Deployment mode specifies where the partner appliance will be
            deployed in HA or non-HA i.e standalone mode.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`BaseServiceInstance.RESOURCE_TYPE_SERVICEINSTANCE`
            * :attr:`BaseServiceInstance.RESOURCE_TYPE_BYODSERVICEINSTANCE`
            * :attr:`BaseServiceInstance.RESOURCE_TYPE_VIRTUALSERVICEINSTANCE`
            
            ServiceInstance is used when NSX handles the lifecyle of appliance.
            Deployment and appliance related all the information is necessary.
            ByodServiceInstance is a custom instance to be used when NSX is not
            handling the lifecycles of appliance/s. User will manage their own
            appliance (BYOD) to connect with NSX. VirtualServiceInstance is a a
            custom instance to be used when NSX is not handling the lifecycle
            of an appliance and when the user is not bringing their own
            appliance.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  on_failure_policy: :class:`str` or ``None``
        :param on_failure_policy: Possible values are: 
            
            * :attr:`BaseServiceInstance.ON_FAILURE_POLICY_ALLOW`
            * :attr:`BaseServiceInstance.ON_FAILURE_POLICY_BLOCK`
            
            Failure policy of the service instance - if it has to be different
            from the service. By default the service instance inherits the
            FailurePolicy of the service it belongs to.
        :type  service_id: :class:`str` or ``None``
        :param service_id: The Service to which the service instance is associated.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  transport_type: :class:`str` or ``None``
        :param transport_type: Possible values are: 
            
            * :attr:`BaseServiceInstance.TRANSPORT_TYPE_L2_BRIDGE`
            * :attr:`BaseServiceInstance.TRANSPORT_TYPE_L3_ROUTED`
            * :attr:`BaseServiceInstance.TRANSPORT_TYPE_NSH`
            * :attr:`BaseServiceInstance.TRANSPORT_TYPE_NA`
            
            Transport to be used by this service instance for deploying the
            Service-VM. This field is to be set Not Applicable(NA) if the
            service only caters to functionality EPP(Endpoint Protection) and
            MPS.
        """
        self.deployment_mode = deployment_mode
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.on_failure_policy = on_failure_policy
        self.service_id = service_id
        self.transport_type = transport_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ByodServiceInstance._set_binding_type(type.StructType(
    'com.vmware.nsx.model.byod_service_instance', {
        'deployment_mode': type.OptionalType(type.StringType()),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'on_failure_policy': type.OptionalType(type.StringType()),
        'service_id': type.OptionalType(type.StringType()),
        'transport_type': type.OptionalType(type.StringType()),
    },
    ByodServiceInstance,
    False,
    None))



class CCPUpgradeStatus(VapiStruct):
    """
    Status of CCP upgrade

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_SUCCESS = "SUCCESS"
    """


    """
    STATUS_FAILED = "FAILED"
    """


    """
    STATUS_IN_PROGRESS = "IN_PROGRESS"
    """


    """
    STATUS_NOT_STARTED = "NOT_STARTED"
    """


    """
    STATUS_PAUSING = "PAUSING"
    """


    """
    STATUS_PAUSED = "PAUSED"
    """


    """



    _canonical_to_pep_names = {
                            'can_rollback': 'can_rollback',
                            'can_skip': 'can_skip',
                            'component_type': 'component_type',
                            'current_version_node_summary': 'current_version_node_summary',
                            'details': 'details',
                            'node_count_at_target_version': 'node_count_at_target_version',
                            'percent_complete': 'percent_complete',
                            'pre_upgrade_status': 'pre_upgrade_status',
                            'status': 'status',
                            'target_component_version': 'target_component_version',
                            }

    def __init__(self,
                 can_rollback=None,
                 can_skip=None,
                 component_type=None,
                 current_version_node_summary=None,
                 details=None,
                 node_count_at_target_version=None,
                 percent_complete=None,
                 pre_upgrade_status=None,
                 status=None,
                 target_component_version=None,
                ):
        """
        :type  can_rollback: :class:`bool` or ``None``
        :param can_rollback: This field indicates whether we can perform upgrade rollback.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  can_skip: :class:`bool` or ``None``
        :param can_skip: Can the upgrade of the remaining units in this component be skipped
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  component_type: :class:`str` or ``None``
        :param component_type: Component type for the upgrade status
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  current_version_node_summary: :class:`NodeSummaryList` or ``None``
        :param current_version_node_summary: 
        :type  details: :class:`str` or ``None``
        :param details: Details about the upgrade status
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_count_at_target_version: :class:`long` or ``None``
        :param node_count_at_target_version: Number of nodes of the type and at the component version format:
            int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  percent_complete: :class:`float` or ``None``
        :param percent_complete: Indicator of upgrade progress in percentage
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  pre_upgrade_status: :class:`UpgradeChecksExecutionStatus` or ``None``
        :param pre_upgrade_status: 
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`CCPUpgradeStatus.STATUS_SUCCESS`
            * :attr:`CCPUpgradeStatus.STATUS_FAILED`
            * :attr:`CCPUpgradeStatus.STATUS_IN_PROGRESS`
            * :attr:`CCPUpgradeStatus.STATUS_NOT_STARTED`
            * :attr:`CCPUpgradeStatus.STATUS_PAUSING`
            * :attr:`CCPUpgradeStatus.STATUS_PAUSED`
            
            Upgrade status of component
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  target_component_version: :class:`str` or ``None``
        :param target_component_version: Target component version
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.can_rollback = can_rollback
        self.can_skip = can_skip
        self.component_type = component_type
        self.current_version_node_summary = current_version_node_summary
        self.details = details
        self.node_count_at_target_version = node_count_at_target_version
        self.percent_complete = percent_complete
        self.pre_upgrade_status = pre_upgrade_status
        self.status = status
        self.target_component_version = target_component_version
        VapiStruct.__init__(self)


CCPUpgradeStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.CCP_upgrade_status', {
        'can_rollback': type.OptionalType(type.BooleanType()),
        'can_skip': type.OptionalType(type.BooleanType()),
        'component_type': type.OptionalType(type.StringType()),
        'current_version_node_summary': type.OptionalType(type.ReferenceType(__name__, 'NodeSummaryList')),
        'details': type.OptionalType(type.StringType()),
        'node_count_at_target_version': type.OptionalType(type.IntegerType()),
        'percent_complete': type.OptionalType(type.DoubleType()),
        'pre_upgrade_status': type.OptionalType(type.ReferenceType(__name__, 'UpgradeChecksExecutionStatus')),
        'status': type.OptionalType(type.StringType()),
        'target_component_version': type.OptionalType(type.StringType()),
    },
    CCPUpgradeStatus,
    False,
    None))



class CCSnmpV3User(VapiStruct):
    """
    This object contains properties for a SNMP V3 user that can be used to
    receive SNMP traps/notifications from NSX and/or poll NSX nodes over SNMP.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ACCESS_ONLY = "READ_ONLY"
    """


    """
    SECURITY_LEVEL_PRIV = "AUTH_PRIV"
    """


    """



    _canonical_to_pep_names = {
                            'access': 'access',
                            'auth_password': 'auth_password',
                            'priv_password': 'priv_password',
                            'security_level': 'security_level',
                            'user_id': 'user_id',
                            }

    def __init__(self,
                 access=None,
                 auth_password=None,
                 priv_password=None,
                 security_level=None,
                 user_id=None,
                ):
        """
        :type  access: :class:`str` or ``None``
        :param access: Possible values are: 
            
            * :attr:`CCSnmpV3User.ACCESS_ONLY`
            
            Access permissions for polling NSX nodes over SNMP V3.
        :type  auth_password: :class:`str` or ``None``
        :param auth_password: Authentication password used for SNMP V3 communication. This field
            is required when adding a user. When updating a user, do not
            include this field in the request. If this field is present in an
            update request, it will be considered as a new value for
            authentication password.
        :type  priv_password: :class:`str` or ``None``
        :param priv_password: Privacy password used for SNMP V3 communication. This field is
            required when adding a user. When updating a user, do not include
            this field in the request. If this field is present in an update
            request, it will be considered as a new value for privacy password.
        :type  security_level: :class:`str` or ``None``
        :param security_level: Possible values are: 
            
            * :attr:`CCSnmpV3User.SECURITY_LEVEL_PRIV`
            
            Security level indicates whether SNMP communication involves
            authentication and privacy protocols for this user. Value
            \"AUTH_PRIV\" indicates both authentication and privacy protocols
            will be used for SNMP communication.
        :type  user_id: :class:`str` or ``None``
        :param user_id: Unique SNMP V3 user id.
        """
        self.access = access
        self.auth_password = auth_password
        self.priv_password = priv_password
        self.security_level = security_level
        self.user_id = user_id
        VapiStruct.__init__(self)


CCSnmpV3User._set_binding_type(type.StructType(
    'com.vmware.nsx.model.CC_snmp_v3_user', {
        'access': type.OptionalType(type.StringType()),
        'auth_password': type.OptionalType(type.StringType()),
        'priv_password': type.OptionalType(type.StringType()),
        'security_level': type.OptionalType(type.StringType()),
        'user_id': type.OptionalType(type.StringType()),
    },
    CCSnmpV3User,
    False,
    None))



class CPUReservation(VapiStruct):
    """
    Relative to the form factor pre-defined reservation value. We recommended
    that you use the predefined measures of CPU reservation shares to reduce
    the CPU reservation of a VM. Reservation shares are relative to the default
    form-factor value. Though absolute values for CPU reservation is supported,
    we advise to use this option with caution as incorrect or high reservation
    values could lead to deployment failure or lead to resource starvation for
    other VMs running on the same host.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    RESERVATION_IN_SHARES_EXTRA_HIGH_PRIORITY = "EXTRA_HIGH_PRIORITY"
    """


    """
    RESERVATION_IN_SHARES_HIGH_PRIORITY = "HIGH_PRIORITY"
    """


    """
    RESERVATION_IN_SHARES_NORMAL_PRIORITY = "NORMAL_PRIORITY"
    """


    """
    RESERVATION_IN_SHARES_LOW_PRIORITY = "LOW_PRIORITY"
    """


    """



    _canonical_to_pep_names = {
                            'reservation_in_mhz': 'reservation_in_mhz',
                            'reservation_in_shares': 'reservation_in_shares',
                            }

    def __init__(self,
                 reservation_in_mhz=None,
                 reservation_in_shares=None,
                ):
        """
        :type  reservation_in_mhz: :class:`long` or ``None``
        :param reservation_in_mhz: The CPU reservation in MHz is the guaranteed minimum amount of
            clock cycles that the vmkernel CPU scheduler will give the Edge VM
            in case of contention. If an Edge VM is not using its reserved
            resources, then other machines can use them thus preventing waste
            of CPU cycles on the physical host. Note: We recommend use of
            reservation_in_shares instead of this absolute configuration. When
            you specify this value, set reservation_in_shares to LOW_PRIORITY.
            format: int32
        :type  reservation_in_shares: :class:`str` or ``None``
        :param reservation_in_shares: Possible values are: 
            
            * :attr:`CPUReservation.RESERVATION_IN_SHARES_EXTRA_HIGH_PRIORITY`
            * :attr:`CPUReservation.RESERVATION_IN_SHARES_HIGH_PRIORITY`
            * :attr:`CPUReservation.RESERVATION_IN_SHARES_NORMAL_PRIORITY`
            * :attr:`CPUReservation.RESERVATION_IN_SHARES_LOW_PRIORITY`
            
            Shares specify the relative importance of a virtual machine on a
            given host. When you assign shares to a virtual machine, you always
            specify the priority for that virtual machine relative to other
            powered-on virtual machines on the same host. The default priority
            for shares is HIGH_PRIORITY.
        """
        self.reservation_in_mhz = reservation_in_mhz
        self.reservation_in_shares = reservation_in_shares
        VapiStruct.__init__(self)


CPUReservation._set_binding_type(type.StructType(
    'com.vmware.nsx.model.CPU_reservation', {
        'reservation_in_mhz': type.OptionalType(type.IntegerType()),
        'reservation_in_shares': type.OptionalType(type.StringType()),
    },
    CPUReservation,
    False,
    None))



class CallbackAuthenticationScheme(VapiStruct):
    """
    CallbackAuthenticationScheme describes how notification requests should
    authenticate to the server.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    SCHEME_NAME_BASIC_AUTH = "BASIC_AUTH"
    """


    """
    SCHEME_NAME_CERTIFICATE = "CERTIFICATE"
    """


    """



    _canonical_to_pep_names = {
                            'certificate_id': 'certificate_id',
                            'password': 'password',
                            'scheme_name': 'scheme_name',
                            'username': 'username',
                            }

    def __init__(self,
                 certificate_id=None,
                 password=None,
                 scheme_name=None,
                 username=None,
                ):
        """
        :type  certificate_id: :class:`str` or ``None``
        :param certificate_id: Certificate ID with a valid certificate and private key, procured
            from trust-management API.
        :type  password: :class:`str` or ``None``
        :param password: Password to use if scheme_name is BASIC_AUTH.
        :type  scheme_name: :class:`str` or ``None``
        :param scheme_name: Possible values are: 
            
            * :attr:`CallbackAuthenticationScheme.SCHEME_NAME_BASIC_AUTH`
            * :attr:`CallbackAuthenticationScheme.SCHEME_NAME_CERTIFICATE`
            
            Authentication scheme to use when making notification requests to
            the partner console. Specify one of BASIC_AUTH or CERTIFICATE.
        :type  username: :class:`str` or ``None``
        :param username: Username to use if scheme_name is BASIC_AUTH.
        """
        self.certificate_id = certificate_id
        self.password = password
        self.scheme_name = scheme_name
        self.username = username
        VapiStruct.__init__(self)


CallbackAuthenticationScheme._set_binding_type(type.StructType(
    'com.vmware.nsx.model.callback_authentication_scheme', {
        'certificate_id': type.OptionalType(type.StringType()),
        'password': type.OptionalType(type.StringType()),
        'scheme_name': type.OptionalType(type.StringType()),
        'username': type.OptionalType(type.StringType()),
    },
    CallbackAuthenticationScheme,
    False,
    None))



class CapacityDashboardUsage(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    SEVERITY_INFO = "INFO"
    """


    """
    SEVERITY_WARNING = "WARNING"
    """


    """
    SEVERITY_CRITICAL = "CRITICAL"
    """


    """
    SEVERITY_ERROR = "ERROR"
    """


    """



    _canonical_to_pep_names = {
                            'current_usage_count': 'current_usage_count',
                            'current_usage_percentage': 'current_usage_percentage',
                            'display_name': 'display_name',
                            'max_supported_count': 'max_supported_count',
                            'max_threshold_percentage': 'max_threshold_percentage',
                            'min_threshold_percentage': 'min_threshold_percentage',
                            'severity': 'severity',
                            'usage_type': 'usage_type',
                            }

    def __init__(self,
                 current_usage_count=None,
                 current_usage_percentage=None,
                 display_name=None,
                 max_supported_count=None,
                 max_threshold_percentage=None,
                 min_threshold_percentage=None,
                 severity=None,
                 usage_type=None,
                ):
        """
        :type  current_usage_count: :class:`long` or ``None``
        :param current_usage_count: Indicate the current usage count of object type. format: int64
        :type  current_usage_percentage: :class:`float` or ``None``
        :param current_usage_percentage: Current usage percentage for object type
        :type  display_name: :class:`str` or ``None``
        :param display_name: Display name for NSX object type.
        :type  max_supported_count: :class:`long` or ``None``
        :param max_supported_count: This is the maximum supported count for object type in
            consideration. format: int64
        :type  max_threshold_percentage: :class:`float` or ``None``
        :param max_threshold_percentage: This indicates the maximum threshold percentage for object type.
        :type  min_threshold_percentage: :class:`float` or ``None``
        :param min_threshold_percentage: This indicates the minimum threshold percentage for object type.
        :type  severity: :class:`str` or ``None``
        :param severity: Possible values are: 
            
            * :attr:`CapacityDashboardUsage.SEVERITY_INFO`
            * :attr:`CapacityDashboardUsage.SEVERITY_WARNING`
            * :attr:`CapacityDashboardUsage.SEVERITY_CRITICAL`
            * :attr:`CapacityDashboardUsage.SEVERITY_ERROR`
            
            Severity calculated from percentage usage
        :type  usage_type: :class:`str` or ``None``
        :param usage_type: Indicate the object type for which usage is calculated.
        """
        self.current_usage_count = current_usage_count
        self.current_usage_percentage = current_usage_percentage
        self.display_name = display_name
        self.max_supported_count = max_supported_count
        self.max_threshold_percentage = max_threshold_percentage
        self.min_threshold_percentage = min_threshold_percentage
        self.severity = severity
        self.usage_type = usage_type
        VapiStruct.__init__(self)


CapacityDashboardUsage._set_binding_type(type.StructType(
    'com.vmware.nsx.model.capacity_dashboard_usage', {
        'current_usage_count': type.OptionalType(type.IntegerType()),
        'current_usage_percentage': type.OptionalType(type.DoubleType()),
        'display_name': type.OptionalType(type.StringType()),
        'max_supported_count': type.OptionalType(type.IntegerType()),
        'max_threshold_percentage': type.OptionalType(type.DoubleType()),
        'min_threshold_percentage': type.OptionalType(type.DoubleType()),
        'severity': type.OptionalType(type.StringType()),
        'usage_type': type.OptionalType(type.StringType()),
    },
    CapacityDashboardUsage,
    False,
    None))



class CapacityThreshold(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'max_threshold_percentage': 'max_threshold_percentage',
                            'min_threshold_percentage': 'min_threshold_percentage',
                            'threshold_type': 'threshold_type',
                            }

    def __init__(self,
                 max_threshold_percentage=None,
                 min_threshold_percentage=None,
                 threshold_type=None,
                ):
        """
        :type  max_threshold_percentage: :class:`float` or ``None``
        :param max_threshold_percentage: Set the maximum threshold percentage. Specify a value between 0 and
            100. Usage percentage above this value is tagged as critical.
        :type  min_threshold_percentage: :class:`float` or ``None``
        :param min_threshold_percentage: Set the minimum threshold percentage. Specify a value between 0 and
            100. Usage percentage above this value is tagged as warning.
        :type  threshold_type: :class:`str` or ``None``
        :param threshold_type: Indicate the object type for which threshold is to be set.
        """
        self.max_threshold_percentage = max_threshold_percentage
        self.min_threshold_percentage = min_threshold_percentage
        self.threshold_type = threshold_type
        VapiStruct.__init__(self)


CapacityThreshold._set_binding_type(type.StructType(
    'com.vmware.nsx.model.capacity_threshold', {
        'max_threshold_percentage': type.OptionalType(type.DoubleType()),
        'min_threshold_percentage': type.OptionalType(type.DoubleType()),
        'threshold_type': type.OptionalType(type.StringType()),
    },
    CapacityThreshold,
    False,
    None))



class CapacityThresholdList(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'capacity_thresholds': 'capacity_thresholds',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 capacity_thresholds=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  capacity_thresholds: :class:`list` of :class:`CapacityThreshold` or ``None``
        :param capacity_thresholds: List of capacity thresholds for NSX Objects
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.capacity_thresholds = capacity_thresholds
        VapiStruct.__init__(self)


CapacityThresholdList._set_binding_type(type.StructType(
    'com.vmware.nsx.model.capacity_threshold_list', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'capacity_thresholds': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CapacityThreshold'))),
    },
    CapacityThresholdList,
    False,
    None))



class CapacityUsage(VapiStruct):
    """
    usage of each capacity type ex. vm, cpu

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'capacity_type': 'capacity_type',
                            'usage_count': 'usage_count',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 capacity_type=None,
                 usage_count=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  capacity_type: :class:`str` or ``None``
        :param capacity_type: type of the capacity field
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  usage_count: :class:`long` or ``None``
        :param usage_count: count of number of items of capacity_type format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.capacity_type = capacity_type
        self.usage_count = usage_count
        VapiStruct.__init__(self)


CapacityUsage._set_binding_type(type.StructType(
    'com.vmware.nsx.model.capacity_usage', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'capacity_type': type.OptionalType(type.StringType()),
        'usage_count': type.OptionalType(type.IntegerType()),
    },
    CapacityUsage,
    False,
    None))



class CapacityUsageMetaInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'last_updated_timestamp': 'last_updated_timestamp',
                            'max_global_threshold_percentage': 'max_global_threshold_percentage',
                            'min_global_threshold_percentage': 'min_global_threshold_percentage',
                            }

    def __init__(self,
                 last_updated_timestamp=None,
                 max_global_threshold_percentage=None,
                 min_global_threshold_percentage=None,
                ):
        """
        :type  last_updated_timestamp: :class:`long` or ``None``
        :param last_updated_timestamp: Timestamp at which capacity usage was last calculated format: int64
        :type  max_global_threshold_percentage: :class:`float` or ``None``
        :param max_global_threshold_percentage: Indicates the maximum global threshold percentage
        :type  min_global_threshold_percentage: :class:`float` or ``None``
        :param min_global_threshold_percentage: Indicates the minimum global threshold percentage
        """
        self.last_updated_timestamp = last_updated_timestamp
        self.max_global_threshold_percentage = max_global_threshold_percentage
        self.min_global_threshold_percentage = min_global_threshold_percentage
        VapiStruct.__init__(self)


CapacityUsageMetaInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.capacity_usage_meta_info', {
        'last_updated_timestamp': type.OptionalType(type.IntegerType()),
        'max_global_threshold_percentage': type.OptionalType(type.DoubleType()),
        'min_global_threshold_percentage': type.OptionalType(type.DoubleType()),
    },
    CapacityUsageMetaInfo,
    False,
    None))



class CapacityUsageResponse(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'capacity_usage': 'capacity_usage',
                            'meta_info': 'meta_info',
                            'unreported_usage_types': 'unreported_usage_types',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 capacity_usage=None,
                 meta_info=None,
                 unreported_usage_types=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  capacity_usage: :class:`list` of :class:`CapacityDashboardUsage` or ``None``
        :param capacity_usage: List of capacity usage for NSX Objects
        :type  meta_info: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param meta_info: Meta data for capacity usage statistics
        :type  unreported_usage_types: :class:`list` of :class:`str` or ``None``
        :param unreported_usage_types: Types for which usage data was not reported
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.capacity_usage = capacity_usage
        self.meta_info = meta_info
        self.unreported_usage_types = unreported_usage_types
        VapiStruct.__init__(self)


CapacityUsageResponse._set_binding_type(type.StructType(
    'com.vmware.nsx.model.capacity_usage_response', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'capacity_usage': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CapacityDashboardUsage'))),
        'meta_info': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
        'unreported_usage_types': type.OptionalType(type.ListType(type.StringType())),
    },
    CapacityUsageResponse,
    False,
    None))



class CbmClusterNode(VapiStruct):
    """
    This type contains attributes of a cluster node that are relevant to the
    Cluster Boot Manager.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_JOINING = "JOINING"
    """


    """
    STATUS_JOINED = "JOINED"
    """


    """
    STATUS_REMOVING = "REMOVING"
    """


    """
    STATUS_REMOVED = "REMOVED"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'entities': 'entities',
                            'node_uuid': 'node_uuid',
                            'status': 'status',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 entities=None,
                 node_uuid=None,
                 status=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  entities: :class:`list` of :class:`CbmClusterNodeEntity` or ``None``
        :param entities: Entities on the node.
        :type  node_uuid: :class:`str` or ``None``
        :param node_uuid: UUID of the node.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`CbmClusterNode.STATUS_JOINING`
            * :attr:`CbmClusterNode.STATUS_JOINED`
            * :attr:`CbmClusterNode.STATUS_REMOVING`
            * :attr:`CbmClusterNode.STATUS_REMOVED`
            
            Current clustering status of the node.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.entities = entities
        self.node_uuid = node_uuid
        self.status = status
        VapiStruct.__init__(self)


CbmClusterNode._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cbm_cluster_node', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'entities': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CbmClusterNodeEntity'))),
        'node_uuid': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
    },
    CbmClusterNode,
    False,
    None))



class CbmClusterNodeEntity(VapiStruct):
    """
    NSX Cluster is made up of multiple cluster nodes. Each node can perform
    multiple functions, commonly referred to as roles. Cluster node entities
    are processes running in a cluster node that assist in the performance of a
    role. Cluster Boot Manager is a daemon that securely bootstraps and
    configures the entities. This type contains attributes of a cluster node
    entity that are relevant to the Cluster Boot Manager.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ENTITY_TYPE_MANAGER = "MANAGER"
    """


    """
    ENTITY_TYPE_CONTROLLER = "CONTROLLER"
    """


    """
    ENTITY_TYPE_POLICY = "POLICY"
    """


    """
    ENTITY_TYPE_HTTPS = "HTTPS"
    """


    """
    ENTITY_TYPE_CLUSTER_BOOT_MANAGER = "CLUSTER_BOOT_MANAGER"
    """


    """
    ENTITY_TYPE_DATASTORE = "DATASTORE"
    """


    """
    ENTITY_TYPE_GLOBAL_MANAGER = "GLOBAL_MANAGER"
    """


    """
    ENTITY_TYPE_ASYNC_REPLICATOR = "ASYNC_REPLICATOR"
    """


    """
    ENTITY_TYPE_MONITORING = "MONITORING"
    """


    """
    ENTITY_TYPE_IDPS_REPORTING = "IDPS_REPORTING"
    """


    """
    ENTITY_TYPE_CORFU_NONCONFIG = "CORFU_NONCONFIG"
    """


    """



    _canonical_to_pep_names = {
                            'certificate': 'certificate',
                            'entity_type': 'entity_type',
                            'entity_uuid': 'entity_uuid',
                            'fqdn': 'fqdn',
                            'ip_address': 'ip_address',
                            'ipv6_address': 'ipv6_address',
                            'ipv6_subnet_prefix_length': 'ipv6_subnet_prefix_length',
                            'port': 'port',
                            'subnet_prefix_length': 'subnet_prefix_length',
                            }

    def __init__(self,
                 certificate=None,
                 entity_type=None,
                 entity_uuid=None,
                 fqdn=None,
                 ip_address=None,
                 ipv6_address=None,
                 ipv6_subnet_prefix_length=None,
                 port=None,
                 subnet_prefix_length=None,
                ):
        """
        :type  certificate: :class:`str` or ``None``
        :param certificate: Public certificate of the entity in PEM format.
        :type  entity_type: :class:`str` or ``None``
        :param entity_type: Possible values are: 
            
            * :attr:`CbmClusterNodeEntity.ENTITY_TYPE_MANAGER`
            * :attr:`CbmClusterNodeEntity.ENTITY_TYPE_CONTROLLER`
            * :attr:`CbmClusterNodeEntity.ENTITY_TYPE_POLICY`
            * :attr:`CbmClusterNodeEntity.ENTITY_TYPE_HTTPS`
            * :attr:`CbmClusterNodeEntity.ENTITY_TYPE_CLUSTER_BOOT_MANAGER`
            * :attr:`CbmClusterNodeEntity.ENTITY_TYPE_DATASTORE`
            * :attr:`CbmClusterNodeEntity.ENTITY_TYPE_GLOBAL_MANAGER`
            * :attr:`CbmClusterNodeEntity.ENTITY_TYPE_ASYNC_REPLICATOR`
            * :attr:`CbmClusterNodeEntity.ENTITY_TYPE_MONITORING`
            * :attr:`CbmClusterNodeEntity.ENTITY_TYPE_IDPS_REPORTING`
            * :attr:`CbmClusterNodeEntity.ENTITY_TYPE_CORFU_NONCONFIG`
            
            Type of the entity.
        :type  entity_uuid: :class:`str` or ``None``
        :param entity_uuid: UUID of the entity.
        :type  fqdn: :class:`str` or ``None``
        :param fqdn: Domain name the entity binds to. format: hostname
        :type  ip_address: :class:`str` or ``None``
        :param ip_address: IP address the entity binds to.
        :type  ipv6_address: :class:`str` or ``None``
        :param ipv6_address: IPv6 address the entity binds to.
        :type  ipv6_subnet_prefix_length: :class:`long` or ``None``
        :param ipv6_subnet_prefix_length: IPv6 subnet mask prefix length of the entity binds to. format:
            int64
        :type  port: :class:`long` or ``None``
        :param port: Port the entity binds to. format: int64
        :type  subnet_prefix_length: :class:`long` or ``None``
        :param subnet_prefix_length: IPv4 subnet mask prefix length of the entity binds to. format:
            int64
        """
        self.certificate = certificate
        self.entity_type = entity_type
        self.entity_uuid = entity_uuid
        self.fqdn = fqdn
        self.ip_address = ip_address
        self.ipv6_address = ipv6_address
        self.ipv6_subnet_prefix_length = ipv6_subnet_prefix_length
        self.port = port
        self.subnet_prefix_length = subnet_prefix_length
        VapiStruct.__init__(self)


CbmClusterNodeEntity._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cbm_cluster_node_entity', {
        'certificate': type.OptionalType(type.StringType()),
        'entity_type': type.OptionalType(type.StringType()),
        'entity_uuid': type.OptionalType(type.StringType()),
        'fqdn': type.OptionalType(type.StringType()),
        'ip_address': type.OptionalType(type.StringType()),
        'ipv6_address': type.OptionalType(type.StringType()),
        'ipv6_subnet_prefix_length': type.OptionalType(type.IntegerType()),
        'port': type.OptionalType(type.IntegerType()),
        'subnet_prefix_length': type.OptionalType(type.IntegerType()),
    },
    CbmClusterNodeEntity,
    False,
    None))



class CentralConfigProperties(VapiStruct):
    """
    Central Config properties

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'local_override': 'local_override',
                            }

    def __init__(self,
                 local_override=None,
                ):
        """
        :type  local_override: :class:`bool` or ``None``
        :param local_override: Override Central Config
        """
        self.local_override = local_override
        VapiStruct.__init__(self)


CentralConfigProperties._set_binding_type(type.StructType(
    'com.vmware.nsx.model.central_config_properties', {
        'local_override': type.OptionalType(type.BooleanType()),
    },
    CentralConfigProperties,
    False,
    None))



class CentralNodeConfigProfile(VapiStruct):
    """
    Central Node Config profile for NSX nodes. This set of properties will be
    pushed to NSX Manager and Edge nodes. SNMP properties will be pushed to KVM
    Hypervisors in addition to Manager and Edge nodes.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'ntp': 'ntp',
                            'snmp': 'snmp',
                            'syslog': 'syslog',
                            'timezone': 'timezone',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 ntp=None,
                 snmp=None,
                 syslog=None,
                 timezone=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  ntp: :class:`NtpProperties` or ``None``
        :param ntp: 
        :type  snmp: :class:`SnmpProperties` or ``None``
        :param snmp: 
        :type  syslog: :class:`SyslogProperties` or ``None``
        :param syslog: 
        :type  timezone: :class:`str` or ``None``
        :param timezone: Timezone to be set for NSX nodes. Only timezone strings listed in
            the Time Zone database (https://www.iana.org/time-zones) are
            allowed.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.ntp = ntp
        self.snmp = snmp
        self.syslog = syslog
        self.timezone = timezone
        VapiStruct.__init__(self)


CentralNodeConfigProfile._set_binding_type(type.StructType(
    'com.vmware.nsx.model.central_node_config_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'ntp': type.OptionalType(type.ReferenceType(__name__, 'NtpProperties')),
        'snmp': type.OptionalType(type.ReferenceType(__name__, 'SnmpProperties')),
        'syslog': type.OptionalType(type.ReferenceType(__name__, 'SyslogProperties')),
        'timezone': type.OptionalType(type.StringType()),
    },
    CentralNodeConfigProfile,
    False,
    None))



class CentralNodeConfigProfileListResult(VapiStruct):
    """
    Paged collection of Central Node Config profiles.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`CentralNodeConfigProfile` or ``None``
        :param results: Central Node Config profiles
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


CentralNodeConfigProfileListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.central_node_config_profile_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CentralNodeConfigProfile'))),
    },
    CentralNodeConfigProfileListResult,
    False,
    None))



class Certificate(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    PURPOSE_CA = "signing-ca"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'details': 'details',
                            'has_private_key': 'has_private_key',
                            'leaf_certificate_sha_256_thumbprint': 'leaf_certificate_sha256_thumbprint',
                            'pem_encoded': 'pem_encoded',
                            'purpose': 'purpose',
                            'used_by': 'used_by',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 details=None,
                 has_private_key=None,
                 leaf_certificate_sha256_thumbprint=None,
                 pem_encoded=None,
                 purpose=None,
                 used_by=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  details: :class:`list` of :class:`X509Certificate` or ``None``
        :param details: List of X509Certificates.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  has_private_key: :class:`bool` or ``None``
        :param has_private_key: Whether we have the private key for this certificate.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  leaf_certificate_sha256_thumbprint: :class:`str` or ``None``
        :param leaf_certificate_sha256_thumbprint: Unique SHA-256 thumbprint of the leaf node certificate.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  pem_encoded: :class:`str` or ``None``
        :param pem_encoded: PEM encoded certificate data.
        :type  purpose: :class:`str` or ``None``
        :param purpose: Possible values are: 
            
            * :attr:`Certificate.PURPOSE_CA`
            
            Purpose of this certificate. Can be empty or set to \"signing-ca\".
        :type  used_by: :class:`list` of :class:`NodeIdServicesMap` or ``None``
        :param used_by: List of node IDs with services, that are using this certificate.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.details = details
        self.has_private_key = has_private_key
        self.leaf_certificate_sha256_thumbprint = leaf_certificate_sha256_thumbprint
        self.pem_encoded = pem_encoded
        self.purpose = purpose
        self.used_by = used_by
        VapiStruct.__init__(self)


Certificate._set_binding_type(type.StructType(
    'com.vmware.nsx.model.certificate', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'details': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'X509Certificate'))),
        'has_private_key': type.OptionalType(type.BooleanType()),
        'leaf_certificate_sha_256_thumbprint': type.OptionalType(type.StringType()),
        'pem_encoded': type.OptionalType(type.StringType()),
        'purpose': type.OptionalType(type.StringType()),
        'used_by': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NodeIdServicesMap'))),
    },
    Certificate,
    False,
    None))



class CertificateCheckingStatus(VapiStruct):
    """
    Result of checking a certificate

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_OK = "OK"
    """


    """
    STATUS_CRL_NOT_READY = "CRL_NOT_READY"
    """


    """
    STATUS_REJECTED = "REJECTED"
    """


    """
    STATUS_ERROR = "ERROR"
    """


    """



    _canonical_to_pep_names = {
                            'error_message': 'error_message',
                            'status': 'status',
                            }

    def __init__(self,
                 error_message=None,
                 status=None,
                ):
        """
        :type  error_message: :class:`str` or ``None``
        :param error_message: Error message when checking the certificate.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`CertificateCheckingStatus.STATUS_OK`
            * :attr:`CertificateCheckingStatus.STATUS_CRL_NOT_READY`
            * :attr:`CertificateCheckingStatus.STATUS_REJECTED`
            * :attr:`CertificateCheckingStatus.STATUS_ERROR`
            
            Status of the checked certificate.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.error_message = error_message
        self.status = status
        VapiStruct.__init__(self)


CertificateCheckingStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.certificate_checking_status', {
        'error_message': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
    },
    CertificateCheckingStatus,
    False,
    None))



class CertificateData(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'pem_encoded': 'pem_encoded',
                            'private_key': 'private_key',
                            }

    def __init__(self,
                 pem_encoded=None,
                 private_key=None,
                ):
        """
        :type  pem_encoded: :class:`str` or ``None``
        :param pem_encoded: PEM encoded certificate data.
        :type  private_key: :class:`str` or ``None``
        :param private_key: Private key of certificate.
        """
        self.pem_encoded = pem_encoded
        self.private_key = private_key
        VapiStruct.__init__(self)


CertificateData._set_binding_type(type.StructType(
    'com.vmware.nsx.model.certificate_data', {
        'pem_encoded': type.OptionalType(type.StringType()),
        'private_key': type.OptionalType(type.StringType()),
    },
    CertificateData,
    False,
    None))



class CertificateKeyPair(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'certificate': 'certificate',
                            'rsa_private_key': 'rsa_private_key',
                            }

    def __init__(self,
                 certificate=None,
                 rsa_private_key=None,
                ):
        """
        :type  certificate: :class:`SecurityCertificate` or ``None``
        :param certificate: 
        :type  rsa_private_key: :class:`str` or ``None``
        :param rsa_private_key: The private key must include the enclosing \"-----BEGIN RSA PRIVATE
            KEY-----\" and \"-----END RSA PRIVATE KEY-----\". An empty string
            is returned in read responses.
        """
        self.certificate = certificate
        self.rsa_private_key = rsa_private_key
        VapiStruct.__init__(self)


CertificateKeyPair._set_binding_type(type.StructType(
    'com.vmware.nsx.model.certificate_key_pair', {
        'certificate': type.OptionalType(type.ReferenceType(__name__, 'SecurityCertificate')),
        'rsa_private_key': type.OptionalType(type.StringType()),
    },
    CertificateKeyPair,
    False,
    None))



class CertificateList(VapiStruct):
    """
    Certificate queries result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`Certificate` or ``None``
        :param results: Certificate list.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


CertificateList._set_binding_type(type.StructType(
    'com.vmware.nsx.model.certificate_list', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Certificate'))),
    },
    CertificateList,
    False,
    None))



class CertificateProfile(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    EXTENDED_KEY_USAGE_SERVER = "SERVER"
    """


    """
    EXTENDED_KEY_USAGE_CLIENT = "CLIENT"
    """


    """
    SERVICE_TYPE_MGMT_CLUSTER = "MGMT_CLUSTER"
    """


    """
    SERVICE_TYPE_MGMT_PLANE = "MGMT_PLANE"
    """


    """
    SERVICE_TYPE_API = "API"
    """


    """
    SERVICE_TYPE_NOTIFICATION_COLLECTOR = "NOTIFICATION_COLLECTOR"
    """


    """
    SERVICE_TYPE_SYSLOG_SERVER = "SYSLOG_SERVER"
    """


    """
    SERVICE_TYPE_RSYSLOG_CLIENT = "RSYSLOG_CLIENT"
    """


    """
    SERVICE_TYPE_APH = "APH"
    """


    """
    SERVICE_TYPE_APH_TN = "APH_TN"
    """


    """
    SERVICE_TYPE_GLOBAL_MANAGER = "GLOBAL_MANAGER"
    """


    """
    SERVICE_TYPE_LOCAL_MANAGER = "LOCAL_MANAGER"
    """


    """
    SERVICE_TYPE_CLIENT_AUTH = "CLIENT_AUTH"
    """


    """
    SERVICE_TYPE_RMQ = "RMQ"
    """


    """
    SERVICE_TYPE_K8S_MSG_CLIENT = "K8S_MSG_CLIENT"
    """


    """
    SERVICE_TYPE_WEB_PROXY = "WEB_PROXY"
    """


    """
    SERVICE_TYPE_CBM_API = "CBM_API"
    """


    """
    SERVICE_TYPE_CBM_CCP = "CBM_CCP"
    """


    """
    SERVICE_TYPE_CBM_CSM = "CBM_CSM"
    """


    """
    SERVICE_TYPE_CBM_MP = "CBM_MP"
    """


    """
    SERVICE_TYPE_CBM_GM = "CBM_GM"
    """


    """
    SERVICE_TYPE_CBM_AR = "CBM_AR"
    """


    """
    SERVICE_TYPE_CBM_MONITORING = "CBM_MONITORING"
    """


    """
    SERVICE_TYPE_CBM_IDPS_REPORTING = "CBM_IDPS_REPORTING"
    """


    """
    SERVICE_TYPE_CBM_CM_INVENTORY = "CBM_CM_INVENTORY"
    """


    """
    SERVICE_TYPE_CBM_MESSAGING_MANAGER = "CBM_MESSAGING_MANAGER"
    """


    """
    SERVICE_TYPE_CBM_UPGRADE_COORDINATOR = "CBM_UPGRADE_COORDINATOR"
    """


    """
    SERVICE_TYPE_CBM_SITE_MANAGER = "CBM_SITE_MANAGER"
    """


    """
    SERVICE_TYPE_CBM_CLUSTER_MANAGER = "CBM_CLUSTER_MANAGER"
    """


    """
    SERVICE_TYPE_CBM_CORFU = "CBM_CORFU"
    """


    """
    SERVICE_TYPE_CBM_SITE_PROXY_CLIENT = "CBM_SITE_PROXY_CLIENT"
    """


    """
    SERVICE_TYPE_COMPUTE_MANAGER = "COMPUTE_MANAGER"
    """


    """
    SERVICE_TYPE_CCP = "CCP"
    """


    """
    SERVICE_TYPE_ANALYTICS_AGENT = "ANALYTICS_AGENT"
    """


    """
    SERVICE_TYPE_ANALYTICS_KAFKA = "ANALYTICS_KAFKA"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cluster_certificate': 'cluster_certificate',
                            'extended_key_usage': 'extended_key_usage',
                            'node_type': 'node_type',
                            'profile_name': 'profile_name',
                            'requires_private_key': 'requires_private_key',
                            'service_type': 'service_type',
                            'unique_use': 'unique_use',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cluster_certificate=None,
                 extended_key_usage=None,
                 node_type=None,
                 profile_name=None,
                 requires_private_key=None,
                 service_type=None,
                 unique_use=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cluster_certificate: :class:`bool` or ``None``
        :param cluster_certificate: True if this is for a cluster certificate
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  extended_key_usage: :class:`list` of :class:`str` or ``None``
        :param extended_key_usage: Possible values are: 
            
            * :attr:`CertificateProfile.EXTENDED_KEY_USAGE_SERVER`
            * :attr:`CertificateProfile.EXTENDED_KEY_USAGE_CLIENT`
            
            Indicating whether this certificate is used for server-auth,
            client-auth or both.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_type: :class:`list` of :class:`str` or ``None``
        :param node_type: List of types of node this certificate applies to.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  profile_name: :class:`str` or ``None``
        :param profile_name: Certificate Profile Name
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  requires_private_key: :class:`bool` or ``None``
        :param requires_private_key: True if this certificate needs a private key.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  service_type: :class:`str` or ``None``
        :param service_type: Possible values are: 
            
            * :attr:`CertificateProfile.SERVICE_TYPE_MGMT_CLUSTER`
            * :attr:`CertificateProfile.SERVICE_TYPE_MGMT_PLANE`
            * :attr:`CertificateProfile.SERVICE_TYPE_API`
            * :attr:`CertificateProfile.SERVICE_TYPE_NOTIFICATION_COLLECTOR`
            * :attr:`CertificateProfile.SERVICE_TYPE_SYSLOG_SERVER`
            * :attr:`CertificateProfile.SERVICE_TYPE_RSYSLOG_CLIENT`
            * :attr:`CertificateProfile.SERVICE_TYPE_APH`
            * :attr:`CertificateProfile.SERVICE_TYPE_APH_TN`
            * :attr:`CertificateProfile.SERVICE_TYPE_GLOBAL_MANAGER`
            * :attr:`CertificateProfile.SERVICE_TYPE_LOCAL_MANAGER`
            * :attr:`CertificateProfile.SERVICE_TYPE_CLIENT_AUTH`
            * :attr:`CertificateProfile.SERVICE_TYPE_RMQ`
            * :attr:`CertificateProfile.SERVICE_TYPE_K8S_MSG_CLIENT`
            * :attr:`CertificateProfile.SERVICE_TYPE_WEB_PROXY`
            * :attr:`CertificateProfile.SERVICE_TYPE_CBM_API`
            * :attr:`CertificateProfile.SERVICE_TYPE_CBM_CCP`
            * :attr:`CertificateProfile.SERVICE_TYPE_CBM_CSM`
            * :attr:`CertificateProfile.SERVICE_TYPE_CBM_MP`
            * :attr:`CertificateProfile.SERVICE_TYPE_CBM_GM`
            * :attr:`CertificateProfile.SERVICE_TYPE_CBM_AR`
            * :attr:`CertificateProfile.SERVICE_TYPE_CBM_MONITORING`
            * :attr:`CertificateProfile.SERVICE_TYPE_CBM_IDPS_REPORTING`
            * :attr:`CertificateProfile.SERVICE_TYPE_CBM_CM_INVENTORY`
            * :attr:`CertificateProfile.SERVICE_TYPE_CBM_MESSAGING_MANAGER`
            * :attr:`CertificateProfile.SERVICE_TYPE_CBM_UPGRADE_COORDINATOR`
            * :attr:`CertificateProfile.SERVICE_TYPE_CBM_SITE_MANAGER`
            * :attr:`CertificateProfile.SERVICE_TYPE_CBM_CLUSTER_MANAGER`
            * :attr:`CertificateProfile.SERVICE_TYPE_CBM_CORFU`
            * :attr:`CertificateProfile.SERVICE_TYPE_CBM_SITE_PROXY_CLIENT`
            * :attr:`CertificateProfile.SERVICE_TYPE_COMPUTE_MANAGER`
            * :attr:`CertificateProfile.SERVICE_TYPE_CCP`
            * :attr:`CertificateProfile.SERVICE_TYPE_ANALYTICS_AGENT`
            * :attr:`CertificateProfile.SERVICE_TYPE_ANALYTICS_KAFKA`
            
            Unique Service Type
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_use: :class:`bool` or ``None``
        :param unique_use: True if the certificate used for this service-type cannot be used
            anywhere else.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cluster_certificate = cluster_certificate
        self.extended_key_usage = extended_key_usage
        self.node_type = node_type
        self.profile_name = profile_name
        self.requires_private_key = requires_private_key
        self.service_type = service_type
        self.unique_use = unique_use
        VapiStruct.__init__(self)


CertificateProfile._set_binding_type(type.StructType(
    'com.vmware.nsx.model.certificate_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cluster_certificate': type.OptionalType(type.BooleanType()),
        'extended_key_usage': type.OptionalType(type.ListType(type.StringType())),
        'node_type': type.OptionalType(type.ListType(type.StringType())),
        'profile_name': type.OptionalType(type.StringType()),
        'requires_private_key': type.OptionalType(type.BooleanType()),
        'service_type': type.OptionalType(type.StringType()),
        'unique_use': type.OptionalType(type.BooleanType()),
    },
    CertificateProfile,
    False,
    None))



class CertificateProfileListResult(VapiStruct):
    """
    CertificateProfile query result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`CertificateProfile` or ``None``
        :param results: CertificateProfile list.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


CertificateProfileListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.certificate_profile_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CertificateProfile'))),
    },
    CertificateProfileListResult,
    False,
    None))



class CheckpointCounter(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CHECKPOINT_TYPE_UNKNOWN = "UNKNOWN"
    """


    """
    CHECKPOINT_TYPE_PORT_INPUT = "PORT_INPUT"
    """


    """
    CHECKPOINT_TYPE_PORT_OUTPUT = "PORT_OUTPUT"
    """


    """
    CHECKPOINT_TYPE_SPOOFGUARD_INPUT = "SPOOFGUARD_INPUT"
    """


    """
    CHECKPOINT_TYPE_SPOOFGUARD_OUTPUT = "SPOOFGUARD_OUTPUT"
    """


    """
    CHECKPOINT_TYPE_SPOOFGUARD_DROP = "SPOOFGUARD_DROP"
    """


    """
    CHECKPOINT_TYPE_DFW_INPUT = "DFW_INPUT"
    """


    """
    CHECKPOINT_TYPE_DFW_OUTPUT = "DFW_OUTPUT"
    """


    """
    CHECKPOINT_TYPE_DFW_DROP = "DFW_DROP"
    """


    """
    CHECKPOINT_TYPE_UPLINK_INPUT = "UPLINK_INPUT"
    """


    """
    CHECKPOINT_TYPE_UPLINK_OUTPUT = "UPLINK_OUTPUT"
    """


    """
    CHECKPOINT_TYPE_ENS_PORT_INPUT = "ENS_PORT_INPUT"
    """


    """
    CHECKPOINT_TYPE_ENS_PORT_OUTPUT = "ENS_PORT_OUTPUT"
    """


    """
    CHECKPOINT_TYPE_ENS_UPLINK_INPUT = "ENS_UPLINK_INPUT"
    """


    """
    CHECKPOINT_TYPE_ENS_UPLINK_OUTPUT = "ENS_UPLINK_OUTPUT"
    """


    """
    CHECKPOINT_TYPE_ENS_DFW_INPUT = "ENS_DFW_INPUT"
    """


    """
    CHECKPOINT_TYPE_ENS_DFW_OUTPUT = "ENS_DFW_OUTPUT"
    """


    """
    CHECKPOINT_TYPE_ENS_DFW_DROP = "ENS_DFW_DROP"
    """


    """
    CHECKPOINT_TYPE_ROUTER_DROP = "ROUTER_DROP"
    """


    """



    _canonical_to_pep_names = {
                            'checkpoint_type': 'checkpoint_type',
                            'count': 'count',
                            }

    def __init__(self,
                 checkpoint_type=None,
                 count=None,
                ):
        """
        :type  checkpoint_type: :class:`str` or ``None``
        :param checkpoint_type: Possible values are: 
            
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_UNKNOWN`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_PORT_INPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_PORT_OUTPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_SPOOFGUARD_INPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_SPOOFGUARD_OUTPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_SPOOFGUARD_DROP`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_DFW_INPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_DFW_OUTPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_DFW_DROP`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_UPLINK_INPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_UPLINK_OUTPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_ENS_PORT_INPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_ENS_PORT_OUTPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_ENS_UPLINK_INPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_ENS_UPLINK_OUTPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_ENS_DFW_INPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_ENS_DFW_OUTPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_ENS_DFW_DROP`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_ROUTER_DROP`
            
            Type of Livetrace checkpoint. UNKNOWN - Unknown checkpoint.
            PORT_INPUT - Received by a port on slowpath. The first slowpath
            checkpoint is encountered when the packet enters a certain port.
            For a certain port, a series of subsequent checkpoints is usually
            encountered after the packet traverses through PORT_INPUT.
            PORT_OUTPUT - Forwarded to a port on slowpath. The last slowpath
            checkpoint is encountered when the packet left a certain port. For
            a certain port, a series of checkpoints is usually encountered
            before the packet traverses through PORT_OUTPUT. SPOOFGUARD_INPUT -
            Received by slowpath Spoofguard service. This checkpoint should be
            encountered either after the packet encounters PORT_INPUT or before
            the packet encounters PORT_OUTPUT. SPOOFGUARD_OUTPUT - Forwarded
            from slowpath Spoofguard service. This checkpoint should be
            encountered after SPOOFGUARD_INPUT. SPOOFUGARD_DROP - Dropped by
            slowpath Spoofguard service. This checkpoint should be encountered
            after SPOOFGUARD_INPUT. DFW_INPUT - Received by slowpath DFW
            service. This checkpoint should be encountered encountered either
            after the packet encounters PORT_INPUT or before the packet
            encounters PORT_OUTPUT. This checkpoint should after SPOOFGUARD
            related checkpoints, if they exist. DFW_OUTPUT - Forwarded from
            slowpath DFW service. This checkpoint should be encountered after
            DFW_INPUT. DFW_DROP - Dropped by slowpath DFW service.This
            checkpoint should be encountered after DFW_INPUT. UPLINK_INPUT -
            Ingressed via an uplink port on slowpath. The first slowpath
            checkpoint is encountered when the packet ingress from external
            network via an uplink. UPLINK_OUTPUT - Egressed via an uplink port
            on slowpath. The last slowpath checkpoint is encountered when the
            packet egress to external network via an uplink. ENS_PORT_INPUT -
            Received by a port on ENS fastpath. The first ENS fastpath
            checkpoint is encountered when the packet enters a certain port.
            ENS_PORT_OUTPUT - Forwarded to a port on ENS fastpath. The last ENS
            fastpath checkpoint is encountered when the packet left a certain
            port. ENS_UPLINK_INPUT - Ingressed via an uplink port on ENS
            fastpath. The first ENS fastpath checkpoint is encountered when the
            packet ingress from external network via an uplink.
            ENS_UPLINK_OUTPUT - Egressed via an uplink port on ENS fastpath.
            The last ENS fastpath checkpoint is encountered when the packet
            egress to external network via an uplink. ENS_DFW_INPUT - Received
            by ENS fastpath DFW service. This checkpoint should be encountered
            after ENS_PORT_INPUT. ENS_DFW_OUTPUT - Forwarded from ENS fastpath
            DFW service. This checkpoint should be encountered after
            ENS_DFW_INPUT. ENS_DFW_DROP - Dropped by ENS fastpath DFW service.
            This checkpoint should be encountered after ENS_DFW_INPUT.
            ROUTER_DROP - Dropped by slowpath router service. This checkpoint
            should be encountered after PORT_INPUT.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  count: :class:`long` or ``None``
        :param count: The number of packets traversed by this checkpoint. The packet
            connectivity issue can be discovered by comparing the count value
            of different checkpoints. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.checkpoint_type = checkpoint_type
        self.count = count
        VapiStruct.__init__(self)


CheckpointCounter._set_binding_type(type.StructType(
    'com.vmware.nsx.model.checkpoint_counter', {
        'checkpoint_type': type.OptionalType(type.StringType()),
        'count': type.OptionalType(type.IntegerType()),
    },
    CheckpointCounter,
    False,
    None))



class CheckpointCounterResult(VapiStruct):
    """
    The packets that only have the count action (other permutations such as
    trace + pktcap or count + trace/pktcap cannot) can traverse through the ENS
    fastpath. Therefore, two checkpoint results from ENS fastpath and slowpath
    are listed below.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ens_checkpoints_result': 'ens_checkpoints_result',
                            'non_ens_checkpoints_result': 'non_ens_checkpoints_result',
                            }

    def __init__(self,
                 ens_checkpoints_result=None,
                 non_ens_checkpoints_result=None,
                ):
        """
        :type  ens_checkpoints_result: :class:`list` of :class:`CheckpointCounter` or ``None``
        :param ens_checkpoints_result: The counter result from ENS checkpoints
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  non_ens_checkpoints_result: :class:`list` of :class:`CheckpointCounter` or ``None``
        :param non_ens_checkpoints_result: The counter result from non ENS checkpoints
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.ens_checkpoints_result = ens_checkpoints_result
        self.non_ens_checkpoints_result = non_ens_checkpoints_result
        VapiStruct.__init__(self)


CheckpointCounterResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.checkpoint_counter_result', {
        'ens_checkpoints_result': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CheckpointCounter'))),
        'non_ens_checkpoints_result': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CheckpointCounter'))),
    },
    CheckpointCounterResult,
    False,
    None))



class CipherSuite(VapiStruct):
    """
    HTTP cipher suite

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'enabled': 'enabled',
                            'name': 'name',
                            }

    def __init__(self,
                 enabled=None,
                 name=None,
                ):
        """
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Enable status for this cipher suite
        :type  name: :class:`str` or ``None``
        :param name: Name of the TLS cipher suite
        """
        self.enabled = enabled
        self.name = name
        VapiStruct.__init__(self)


CipherSuite._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cipher_suite', {
        'enabled': type.OptionalType(type.BooleanType()),
        'name': type.OptionalType(type.StringType()),
    },
    CipherSuite,
    False,
    None))



class ClaimMap(VapiStruct):
    """
    Information about how to map a single OIDC ID token claim to one or more
    NSX roles.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'claim_name': 'claim_name',
                            'value_to_role_map': 'value_to_role_map',
                            }

    def __init__(self,
                 claim_name=None,
                 value_to_role_map=None,
                ):
        """
        :type  claim_name: :class:`str` or ``None``
        :param claim_name: 
        :type  value_to_role_map: :class:`list` of :class:`ClaimValueToRoleMap` or ``None``
        :param value_to_role_map: 
        """
        self.claim_name = claim_name
        self.value_to_role_map = value_to_role_map
        VapiStruct.__init__(self)


ClaimMap._set_binding_type(type.StructType(
    'com.vmware.nsx.model.claim_map', {
        'claim_name': type.OptionalType(type.StringType()),
        'value_to_role_map': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClaimValueToRoleMap'))),
    },
    ClaimMap,
    False,
    None))



class ClaimValueToRoleMap(VapiStruct):
    """
    Claim value map

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'claim_value': 'claim_value',
                            'roles': 'roles',
                            }

    def __init__(self,
                 claim_value=None,
                 roles=None,
                ):
        """
        :type  claim_value: :class:`str` or ``None``
        :param claim_value: The value of the claim to map.
        :type  roles: :class:`list` of :class:`str` or ``None``
        :param roles: The NSX roles that this particular claim value should map to.
        """
        self.claim_value = claim_value
        self.roles = roles
        VapiStruct.__init__(self)


ClaimValueToRoleMap._set_binding_type(type.StructType(
    'com.vmware.nsx.model.claim_value_to_role_map', {
        'claim_value': type.OptionalType(type.StringType()),
        'roles': type.OptionalType(type.ListType(type.StringType())),
    },
    ClaimValueToRoleMap,
    False,
    None))



class ClasslessStaticRoute(VapiStruct):
    """
    DHCP classless static route option.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'network': 'network',
                            'next_hop': 'next_hop',
                            }

    def __init__(self,
                 network=None,
                 next_hop=None,
                ):
        """
        :type  network: :class:`str` or ``None``
        :param network: Destination network in CIDR format. format:
            address-or-block-or-range
        :type  next_hop: :class:`str` or ``None``
        :param next_hop: IP address of next hop of the route. format: ip
        """
        self.network = network
        self.next_hop = next_hop
        VapiStruct.__init__(self)


ClasslessStaticRoute._set_binding_type(type.StructType(
    'com.vmware.nsx.model.classless_static_route', {
        'network': type.OptionalType(type.StringType()),
        'next_hop': type.OptionalType(type.StringType()),
    },
    ClasslessStaticRoute,
    False,
    None))



class ClientSslProfileBinding(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CLIENT_AUTH_REQUIRED = "REQUIRED"
    """


    """
    CLIENT_AUTH_IGNORE = "IGNORE"
    """


    """



    _canonical_to_pep_names = {
                            'certificate_chain_depth': 'certificate_chain_depth',
                            'client_auth': 'client_auth',
                            'client_auth_ca_ids': 'client_auth_ca_ids',
                            'client_auth_crl_ids': 'client_auth_crl_ids',
                            'default_certificate_id': 'default_certificate_id',
                            'sni_certificate_ids': 'sni_certificate_ids',
                            'ssl_profile_id': 'ssl_profile_id',
                            }

    def __init__(self,
                 certificate_chain_depth=None,
                 client_auth=None,
                 client_auth_ca_ids=None,
                 client_auth_crl_ids=None,
                 default_certificate_id=None,
                 sni_certificate_ids=None,
                 ssl_profile_id=None,
                ):
        """
        :type  certificate_chain_depth: :class:`long` or ``None``
        :param certificate_chain_depth: authentication depth is used to set the verification depth in the
            client certificates chain. format: int64
        :type  client_auth: :class:`str` or ``None``
        :param client_auth: Possible values are: 
            
            * :attr:`ClientSslProfileBinding.CLIENT_AUTH_REQUIRED`
            * :attr:`ClientSslProfileBinding.CLIENT_AUTH_IGNORE`
            
            client authentication mode
        :type  client_auth_ca_ids: :class:`list` of :class:`str` or ``None``
        :param client_auth_ca_ids: If client auth type is REQUIRED, client certificate must be signed
            by one of the trusted Certificate Authorities (CAs), also referred
            to as root CAs, whose self signed certificates are specified.
        :type  client_auth_crl_ids: :class:`list` of :class:`str` or ``None``
        :param client_auth_crl_ids: A Certificate Revocation List (CRL) can be specified in the
            client-side SSL profile binding to disallow compromised client
            certificates.
        :type  default_certificate_id: :class:`str` or ``None``
        :param default_certificate_id: A default certificate should be specified which will be used if the
            server does not host multiple hostnames on the same IP address or
            if the client does not support SNI extension.
        :type  sni_certificate_ids: :class:`list` of :class:`str` or ``None``
        :param sni_certificate_ids: Client-side SSL profile binding allows multiple certificates, for
            different hostnames, to be bound to the same virtual server.
        :type  ssl_profile_id: :class:`str` or ``None``
        :param ssl_profile_id: Client SSL profile defines reusable, application-independent client
            side SSL properties.
        """
        self.certificate_chain_depth = certificate_chain_depth
        self.client_auth = client_auth
        self.client_auth_ca_ids = client_auth_ca_ids
        self.client_auth_crl_ids = client_auth_crl_ids
        self.default_certificate_id = default_certificate_id
        self.sni_certificate_ids = sni_certificate_ids
        self.ssl_profile_id = ssl_profile_id
        VapiStruct.__init__(self)


ClientSslProfileBinding._set_binding_type(type.StructType(
    'com.vmware.nsx.model.client_ssl_profile_binding', {
        'certificate_chain_depth': type.OptionalType(type.IntegerType()),
        'client_auth': type.OptionalType(type.StringType()),
        'client_auth_ca_ids': type.OptionalType(type.ListType(type.StringType())),
        'client_auth_crl_ids': type.OptionalType(type.ListType(type.StringType())),
        'default_certificate_id': type.OptionalType(type.StringType()),
        'sni_certificate_ids': type.OptionalType(type.ListType(type.StringType())),
        'ssl_profile_id': type.OptionalType(type.StringType()),
    },
    ClientSslProfileBinding,
    False,
    None))



class ClientTypeCollectionConfiguration(VapiStruct):
    """
    HPM client data collection configuration

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CLIENT_TYPE_HYPERVISOR = "HYPERVISOR"
    """


    """
    CLIENT_TYPE_EDGE = "EDGE"
    """


    """
    CLIENT_TYPE_CONTROL_PLANE = "CONTROL_PLANE"
    """


    """
    CLIENT_TYPE_CONTROL_PLANE_PLATFORM = "CONTROL_PLANE_PLATFORM"
    """


    """
    CLIENT_TYPE_MANAGEMENT_PLANE = "MANAGEMENT_PLANE"
    """


    """
    CLIENT_TYPE_MANAGEMENT_PLANE_PLATFORM = "MANAGEMENT_PLANE_PLATFORM"
    """


    """



    _canonical_to_pep_names = {
                            'client_type': 'client_type',
                            'data_type_configurations': 'data_type_configurations',
                            }

    def __init__(self,
                 client_type=None,
                 data_type_configurations=None,
                ):
        """
        :type  client_type: :class:`str` or ``None``
        :param client_type: Possible values are: 
            
            * :attr:`ClientTypeCollectionConfiguration.CLIENT_TYPE_HYPERVISOR`
            * :attr:`ClientTypeCollectionConfiguration.CLIENT_TYPE_EDGE`
            *
              :attr:`ClientTypeCollectionConfiguration.CLIENT_TYPE_CONTROL_PLANE`
            *
              :attr:`ClientTypeCollectionConfiguration.CLIENT_TYPE_CONTROL_PLANE_PLATFORM`
            *
              :attr:`ClientTypeCollectionConfiguration.CLIENT_TYPE_MANAGEMENT_PLANE`
            *
              :attr:`ClientTypeCollectionConfiguration.CLIENT_TYPE_MANAGEMENT_PLANE_PLATFORM`
            
            The client type for which this data collection frequency setting
            applies
        :type  data_type_configurations: :class:`list` of :class:`DataTypeCollectionConfiguration` or ``None``
        :param data_type_configurations: The set of data collection type configurations, one for each data
            collection type
        """
        self.client_type = client_type
        self.data_type_configurations = data_type_configurations
        VapiStruct.__init__(self)


ClientTypeCollectionConfiguration._set_binding_type(type.StructType(
    'com.vmware.nsx.model.client_type_collection_configuration', {
        'client_type': type.OptionalType(type.StringType()),
        'data_type_configurations': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'DataTypeCollectionConfiguration'))),
    },
    ClientTypeCollectionConfiguration,
    False,
    None))



class CloudNativeServiceInstance(VapiStruct):
    """
    Stores the information about cloud native service instance.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_last_sync_time': 'last_sync_time',
                            'description': 'description',
                            'display_name': 'display_name',
                            'resource_type': 'resource_type',
                            'scope': 'scope',
                            'tags': 'tags',
                            'external_id': 'external_id',
                            'service_type': 'service_type',
                            'source': 'source',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 last_sync_time=None,
                 description=None,
                 display_name=None,
                 resource_type=None,
                 scope=None,
                 tags=None,
                 external_id=None,
                 service_type=None,
                 source=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  last_sync_time: :class:`long` or ``None``
        :param last_sync_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  scope: :class:`list` of :class:`DiscoveredResourceScope` or ``None``
        :param scope: Specifies list of scope of discovered resource. e.g. if VHC path is
            associated with principal identity, who owns the discovered
            resource, then scope id will be VHC path and scope type will be
            VHC.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  external_id: :class:`str` or ``None``
        :param external_id: Id of service instance fetched from public cloud.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  service_type: :class:`str` or ``None``
        :param service_type: Type of cloud native service.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  source: :class:`ResourceReference` or ``None``
        :param source: 
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.last_sync_time = last_sync_time
        self.description = description
        self.display_name = display_name
        self.resource_type = resource_type
        self.scope = scope
        self.tags = tags
        self.external_id = external_id
        self.service_type = service_type
        self.source = source
        VapiStruct.__init__(self)


CloudNativeServiceInstance._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cloud_native_service_instance', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_last_sync_time': type.OptionalType(type.IntegerType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'scope': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'DiscoveredResourceScope'))),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'external_id': type.OptionalType(type.StringType()),
        'service_type': type.OptionalType(type.StringType()),
        'source': type.OptionalType(type.ReferenceType(__name__, 'ResourceReference')),
    },
    CloudNativeServiceInstance,
    False,
    None))



class CloudNativeServiceInstanceListResult(VapiStruct):
    """
    Stores a list of cloud native service instances and information about them.
    NSX supported service instances are currently limited to Relational
    Database Service (RDS),Elastic Load Balancing (ELB).

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`CloudNativeServiceInstance` or ``None``
        :param results: List of cloud native service instances
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


CloudNativeServiceInstanceListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cloud_native_service_instance_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CloudNativeServiceInstance'))),
    },
    CloudNativeServiceInstanceListResult,
    False,
    None))



class ClusterBackupInfo(VapiStruct):
    """
    Cluster backup details

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    RESTORE_TYPE_REGULAR_RESTORE = "REGULAR_RESTORE"
    """


    """
    RESTORE_TYPE_POLICY_ONLY_RESTORE = "POLICY_ONLY_RESTORE"
    """


    """



    _canonical_to_pep_names = {
                            'ip_address': 'ip_address',
                            'node_id': 'node_id',
                            'restore_type': 'restore_type',
                            'timestamp': 'timestamp',
                            }

    def __init__(self,
                 ip_address=None,
                 node_id=None,
                 restore_type=None,
                 timestamp=None,
                ):
        """
        :type  ip_address: :class:`str` or ``None``
        :param ip_address: IP address or FQDN of the node from which the backup was taken
            format: hostname-or-ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_id: :class:`str` or ``None``
        :param node_id: ID of the node from which the backup was taken
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  restore_type: :class:`list` of :class:`str` or ``None``
        :param restore_type: Possible values are: 
            
            * :attr:`ClusterBackupInfo.RESTORE_TYPE_REGULAR_RESTORE`
            * :attr:`ClusterBackupInfo.RESTORE_TYPE_POLICY_ONLY_RESTORE`
            
            Type of restore allowed
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  timestamp: :class:`long` or ``None``
        :param timestamp: timestamp of the cluster backup file format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.ip_address = ip_address
        self.node_id = node_id
        self.restore_type = restore_type
        self.timestamp = timestamp
        VapiStruct.__init__(self)


ClusterBackupInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_backup_info', {
        'ip_address': type.OptionalType(type.StringType()),
        'node_id': type.OptionalType(type.StringType()),
        'restore_type': type.OptionalType(type.ListType(type.StringType())),
        'timestamp': type.OptionalType(type.IntegerType()),
    },
    ClusterBackupInfo,
    False,
    None))



class ClusterBackupInfoListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ClusterBackupInfo` or ``None``
        :param results: List of timestamps of backed-up cluster files
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ClusterBackupInfoListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_backup_info_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterBackupInfo'))),
    },
    ClusterBackupInfoListResult,
    False,
    None))



class ClusterCertificateId(VapiStruct):
    """
    Cluster Certificate ID

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'certificate_id': 'certificate_id',
                            }

    def __init__(self,
                 certificate_id=None,
                ):
        """
        :type  certificate_id: :class:`str` or ``None``
        :param certificate_id: Certificate ID
        """
        self.certificate_id = certificate_id
        VapiStruct.__init__(self)


ClusterCertificateId._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_certificate_id', {
        'certificate_id': type.OptionalType(type.StringType()),
    },
    ClusterCertificateId,
    False,
    None))



class ClusterConfig(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            'cluster_id': 'cluster_id',
                            'control_cluster_changes_allowed': 'control_cluster_changes_allowed',
                            'mgmt_cluster_changes_allowed': 'mgmt_cluster_changes_allowed',
                            'nodes': 'nodes',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 cluster_id=None,
                 control_cluster_changes_allowed=None,
                 mgmt_cluster_changes_allowed=None,
                 nodes=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: Unique identifier of this cluster
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  control_cluster_changes_allowed: :class:`bool` or ``None``
        :param control_cluster_changes_allowed: True if control cluster nodes may be added or removed
        :type  mgmt_cluster_changes_allowed: :class:`bool` or ``None``
        :param mgmt_cluster_changes_allowed: True if management cluster nodes may be added or removed
        :type  nodes: :class:`list` of :class:`ClusterNodeInfo` or ``None``
        :param nodes: Configuration of each node in cluster
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.cluster_id = cluster_id
        self.control_cluster_changes_allowed = control_cluster_changes_allowed
        self.mgmt_cluster_changes_allowed = mgmt_cluster_changes_allowed
        self.nodes = nodes
        VapiStruct.__init__(self)


ClusterConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        'cluster_id': type.OptionalType(type.StringType()),
        'control_cluster_changes_allowed': type.OptionalType(type.BooleanType()),
        'mgmt_cluster_changes_allowed': type.OptionalType(type.BooleanType()),
        'nodes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterNodeInfo'))),
    },
    ClusterConfig,
    False,
    None))



class ClusterConfiguration(VapiStruct):
    """
    The configuration of the NSX cluster. The cluster configuration consists of
    a list of cluster node attributes.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'cluster_id': 'cluster_id',
                            'config_version': 'config_version',
                            'ip6_address': 'ip6_address',
                            'ip_address': 'ip_address',
                            'nodes': 'nodes',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 cluster_id=None,
                 config_version=None,
                 ip6_address=None,
                 ip_address=None,
                 nodes=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: UUID of the cluster
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  config_version: :class:`long` or ``None``
        :param config_version: Cluster configuration version. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  ip6_address: :class:`str` or ``None``
        :param ip6_address: Virtual IPv6 address, :: if not configured
        :type  ip_address: :class:`str` or ``None``
        :param ip_address: Virtual IP address, 0.0.0.0 if not configured.
        :type  nodes: :class:`list` of :class:`CbmClusterNode` or ``None``
        :param nodes: Nodes in the cluster configuration.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.cluster_id = cluster_id
        self.config_version = config_version
        self.ip6_address = ip6_address
        self.ip_address = ip_address
        self.nodes = nodes
        VapiStruct.__init__(self)


ClusterConfiguration._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_configuration', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'cluster_id': type.OptionalType(type.StringType()),
        'config_version': type.OptionalType(type.IntegerType()),
        'ip6_address': type.OptionalType(type.StringType()),
        'ip_address': type.OptionalType(type.StringType()),
        'nodes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CbmClusterNode'))),
    },
    ClusterConfiguration,
    False,
    None))



class ClusterDpuConfig(VapiStruct):
    """
    Specifies configuration of a homogeneous cluster. If this property is set
    for a cluster, which indicate that this is a homogenous cluster consisting
    of hosts running ESXio on data processing unit (DPU) from a certain vendor.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'vendor': 'vendor',
                            }

    def __init__(self,
                 vendor=None,
                ):
        """
        :type  vendor: :class:`str` or ``None``
        :param vendor: Specifies the vendor of the data processing unit.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.vendor = vendor
        VapiStruct.__init__(self)


ClusterDpuConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_dpu_config', {
        'vendor': type.OptionalType(type.StringType()),
    },
    ClusterDpuConfig,
    False,
    None))



class ClusterGroupMemberStatus(VapiStruct):
    """
    This type contains the attributes and status of a group member.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MEMBER_STATUS_UP = "UP"
    """


    """
    MEMBER_STATUS_DOWN = "DOWN"
    """


    """
    MEMBER_STATUS_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'member_fqdn': 'member_fqdn',
                            'member_ip': 'member_ip',
                            'member_ipv6': 'member_ipv6',
                            'member_status': 'member_status',
                            'member_uuid': 'member_uuid',
                            }

    def __init__(self,
                 member_fqdn=None,
                 member_ip=None,
                 member_ipv6=None,
                 member_status=None,
                 member_uuid=None,
                ):
        """
        :type  member_fqdn: :class:`str` or ``None``
        :param member_fqdn: FQDN of the group member format: hostname
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  member_ip: :class:`str` or ``None``
        :param member_ip: IP of the group member format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  member_ipv6: :class:`str` or ``None``
        :param member_ipv6: IPv6 of the group member format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  member_status: :class:`str` or ``None``
        :param member_status: Possible values are: 
            
            * :attr:`ClusterGroupMemberStatus.MEMBER_STATUS_UP`
            * :attr:`ClusterGroupMemberStatus.MEMBER_STATUS_DOWN`
            * :attr:`ClusterGroupMemberStatus.MEMBER_STATUS_UNKNOWN`
            
            Status of the group member
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  member_uuid: :class:`str` or ``None``
        :param member_uuid: UUID of the group member
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.member_fqdn = member_fqdn
        self.member_ip = member_ip
        self.member_ipv6 = member_ipv6
        self.member_status = member_status
        self.member_uuid = member_uuid
        VapiStruct.__init__(self)


ClusterGroupMemberStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_group_member_status', {
        'member_fqdn': type.OptionalType(type.StringType()),
        'member_ip': type.OptionalType(type.StringType()),
        'member_ipv6': type.OptionalType(type.StringType()),
        'member_status': type.OptionalType(type.StringType()),
        'member_uuid': type.OptionalType(type.StringType()),
    },
    ClusterGroupMemberStatus,
    False,
    None))



class ClusterGroupServiceLeader(VapiStruct):
    """
    Each cluster node entity provides multiple services. When working in a
    group, each service can elect a cluster node entity to be the leader of the
    service. Leader election helps in coordination of the service. The leader
    holds a renewable lease on the leadership for a fixed period of time. The
    lease version is incremented every time the leadership lease is renewed.
    This type contains the attributes of a leader.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'leader_uuid': 'leader_uuid',
                            'lease_version': 'lease_version',
                            'service_name': 'service_name',
                            }

    def __init__(self,
                 leader_uuid=None,
                 lease_version=None,
                 service_name=None,
                ):
        """
        :type  leader_uuid: :class:`str` or ``None``
        :param leader_uuid: Member UUID of the leader
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  lease_version: :class:`long` or ``None``
        :param lease_version: Number of times the lease has been renewed format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  service_name: :class:`str` or ``None``
        :param service_name: Name of the service
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.leader_uuid = leader_uuid
        self.lease_version = lease_version
        self.service_name = service_name
        VapiStruct.__init__(self)


ClusterGroupServiceLeader._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_group_service_leader', {
        'leader_uuid': type.OptionalType(type.StringType()),
        'lease_version': type.OptionalType(type.IntegerType()),
        'service_name': type.OptionalType(type.StringType()),
    },
    ClusterGroupServiceLeader,
    False,
    None))



class ClusterGroupStatus(VapiStruct):
    """
    This type contains the attributes and status of a group.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    GROUP_STATUS_STABLE = "STABLE"
    """


    """
    GROUP_STATUS_DEGRADED = "DEGRADED"
    """


    """
    GROUP_STATUS_UNSTABLE = "UNSTABLE"
    """


    """
    GROUP_STATUS_UNAVAILABLE = "UNAVAILABLE"
    """


    """
    GROUP_TYPE_MANAGER = "MANAGER"
    """


    """
    GROUP_TYPE_CONTROLLER = "CONTROLLER"
    """


    """
    GROUP_TYPE_POLICY = "POLICY"
    """


    """
    GROUP_TYPE_HTTPS = "HTTPS"
    """


    """
    GROUP_TYPE_DATASTORE = "DATASTORE"
    """


    """
    GROUP_TYPE_CLUSTER_BOOT_MANAGER = "CLUSTER_BOOT_MANAGER"
    """


    """
    GROUP_TYPE_GLOBAL_MANAGER = "GLOBAL_MANAGER"
    """


    """
    GROUP_TYPE_ASYNC_REPLICATOR = "ASYNC_REPLICATOR"
    """


    """
    GROUP_TYPE_MONITORING = "MONITORING"
    """


    """
    GROUP_TYPE_IDPS_REPORTING = "IDPS_REPORTING"
    """


    """
    GROUP_TYPE_CORFU_NONCONFIG = "CORFU_NONCONFIG"
    """


    """
    GROUP_TYPE_CM_INVENTORY = "CM-INVENTORY"
    """


    """
    GROUP_TYPE_MESSAGING_MANAGER = "MESSAGING-MANAGER"
    """


    """



    _canonical_to_pep_names = {
                            'group_id': 'group_id',
                            'group_status': 'group_status',
                            'group_type': 'group_type',
                            'leaders': 'leaders',
                            'members': 'members',
                            }

    def __init__(self,
                 group_id=None,
                 group_status=None,
                 group_type=None,
                 leaders=None,
                 members=None,
                ):
        """
        :type  group_id: :class:`str` or ``None``
        :param group_id: UUID of the group
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  group_status: :class:`str` or ``None``
        :param group_status: Possible values are: 
            
            * :attr:`ClusterGroupStatus.GROUP_STATUS_STABLE`
            * :attr:`ClusterGroupStatus.GROUP_STATUS_DEGRADED`
            * :attr:`ClusterGroupStatus.GROUP_STATUS_UNSTABLE`
            * :attr:`ClusterGroupStatus.GROUP_STATUS_UNAVAILABLE`
            
            Group status
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  group_type: :class:`str` or ``None``
        :param group_type: Possible values are: 
            
            * :attr:`ClusterGroupStatus.GROUP_TYPE_MANAGER`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_CONTROLLER`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_POLICY`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_HTTPS`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_DATASTORE`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_CLUSTER_BOOT_MANAGER`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_GLOBAL_MANAGER`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_ASYNC_REPLICATOR`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_MONITORING`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_IDPS_REPORTING`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_CORFU_NONCONFIG`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_CM_INVENTORY`
            * :attr:`ClusterGroupStatus.GROUP_TYPE_MESSAGING_MANAGER`
            
            Type of the group
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  leaders: :class:`list` of :class:`ClusterGroupServiceLeader` or ``None``
        :param leaders: Array of group leaders and their attributes
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  members: :class:`list` of :class:`ClusterGroupMemberStatus` or ``None``
        :param members: Array of group members and their statuses
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.group_id = group_id
        self.group_status = group_status
        self.group_type = group_type
        self.leaders = leaders
        self.members = members
        VapiStruct.__init__(self)


ClusterGroupStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_group_status', {
        'group_id': type.OptionalType(type.StringType()),
        'group_status': type.OptionalType(type.StringType()),
        'group_type': type.OptionalType(type.StringType()),
        'leaders': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterGroupServiceLeader'))),
        'members': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterGroupMemberStatus'))),
    },
    ClusterGroupStatus,
    False,
    None))



class ClusterInitializationNodeInfo(VapiStruct):
    """
    The type provides the information of a non-running cluster node required
    for the initialization of a management cluster. The administrator needs to
    start this node for management cluster to initialize properly (or
    decommission it explicitly).

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'disk_store_id': 'disk_store_id',
                            'host_address': 'host_address',
                            }

    def __init__(self,
                 disk_store_id=None,
                 host_address=None,
                ):
        """
        :type  disk_store_id: :class:`str` or ``None``
        :param disk_store_id: The (internal) disk-store ID of the member
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  host_address: :class:`str` or ``None``
        :param host_address: The IP address (or domain name) of the cluster node
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.disk_store_id = disk_store_id
        self.host_address = host_address
        VapiStruct.__init__(self)


ClusterInitializationNodeInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_initialization_node_info', {
        'disk_store_id': type.OptionalType(type.StringType()),
        'host_address': type.OptionalType(type.StringType()),
    },
    ClusterInitializationNodeInfo,
    False,
    None))



class ClusterNodeConfig(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'appliance_mgmt_ipv6_listen_addr': 'appliance_mgmt_ipv6_listen_addr',
                            'appliance_mgmt_listen_addr': 'appliance_mgmt_listen_addr',
                            'controller_role': 'controller_role',
                            'external_id': 'external_id',
                            'manager_role': 'manager_role',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 appliance_mgmt_ipv6_listen_addr=None,
                 appliance_mgmt_listen_addr=None,
                 controller_role=None,
                 external_id=None,
                 manager_role=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  appliance_mgmt_ipv6_listen_addr: :class:`str` or ``None``
        :param appliance_mgmt_ipv6_listen_addr: The IPv6 address for the appliance management API service on this
            node
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  appliance_mgmt_listen_addr: :class:`str` or ``None``
        :param appliance_mgmt_listen_addr: The IP and port for the appliance management API service on this
            node
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  controller_role: :class:`ControllerClusterRoleConfig` or ``None``
        :param controller_role: 
        :type  external_id: :class:`str` or ``None``
        :param external_id: Internal identifier provided by the node
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  manager_role: :class:`ManagementClusterRoleConfig` or ``None``
        :param manager_role: 
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.appliance_mgmt_ipv6_listen_addr = appliance_mgmt_ipv6_listen_addr
        self.appliance_mgmt_listen_addr = appliance_mgmt_listen_addr
        self.controller_role = controller_role
        self.external_id = external_id
        self.manager_role = manager_role
        VapiStruct.__init__(self)


ClusterNodeConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_node_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'appliance_mgmt_ipv6_listen_addr': type.OptionalType(type.StringType()),
        'appliance_mgmt_listen_addr': type.OptionalType(type.StringType()),
        'controller_role': type.OptionalType(type.ReferenceType(__name__, 'ControllerClusterRoleConfig')),
        'external_id': type.OptionalType(type.StringType()),
        'manager_role': type.OptionalType(type.ReferenceType(__name__, 'ManagementClusterRoleConfig')),
    },
    ClusterNodeConfig,
    False,
    None))



class ClusterNodeConfigListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ClusterNodeConfig` or ``None``
        :param results: Cluster node configuration results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ClusterNodeConfigListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_node_config_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterNodeConfig'))),
    },
    ClusterNodeConfigListResult,
    False,
    None))



class ClusterNodeInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_JOINING = "JOINING"
    """


    """
    STATUS_JOINED = "JOINED"
    """


    """
    STATUS_REMOVING = "REMOVING"
    """


    """
    STATUS_REMOVED = "REMOVED"
    """


    """



    _canonical_to_pep_names = {
                            'api_listen_addr': 'api_listen_addr',
                            'appliance_connection_info': 'appliance_connection_info',
                            'certificates': 'certificates',
                            'control_plane_listen_addr': 'control_plane_listen_addr',
                            'display_name': 'display_name',
                            'entities': 'entities',
                            'fqdn': 'fqdn',
                            'msg_clients': 'msg_clients',
                            'node_uuid': 'node_uuid',
                            'status': 'status',
                            }

    def __init__(self,
                 api_listen_addr=None,
                 appliance_connection_info=None,
                 certificates=None,
                 control_plane_listen_addr=None,
                 display_name=None,
                 entities=None,
                 fqdn=None,
                 msg_clients=None,
                 node_uuid=None,
                 status=None,
                ):
        """
        :type  api_listen_addr: :class:`ServiceEndpoint` or ``None``
        :param api_listen_addr: 
        :type  appliance_connection_info: :class:`ServiceEndpoint` or ``None``
        :param appliance_connection_info: 
        :type  certificates: :class:`list` of :class:`NodeCertificateInfo` or ``None``
        :param certificates: Certificate and thumbprint of all entities
        :type  control_plane_listen_addr: :class:`ServiceEndpoint` or ``None``
        :param control_plane_listen_addr: 
        :type  display_name: :class:`str` or ``None``
        :param display_name: The display name of this node
        :type  entities: :class:`list` of :class:`NodeEntityInfo` or ``None``
        :param entities: Service endpoint of all entities
        :type  fqdn: :class:`str` or ``None``
        :param fqdn: The fqdn of this node
        :type  msg_clients: :class:`list` of :class:`NodeMessagingClientInfo` or ``None``
        :param msg_clients: Messaging client of all entities
        :type  node_uuid: :class:`str` or ``None``
        :param node_uuid: Unique identifier of this node
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ClusterNodeInfo.STATUS_JOINING`
            * :attr:`ClusterNodeInfo.STATUS_JOINED`
            * :attr:`ClusterNodeInfo.STATUS_REMOVING`
            * :attr:`ClusterNodeInfo.STATUS_REMOVED`
            
            Node clustering status
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.api_listen_addr = api_listen_addr
        self.appliance_connection_info = appliance_connection_info
        self.certificates = certificates
        self.control_plane_listen_addr = control_plane_listen_addr
        self.display_name = display_name
        self.entities = entities
        self.fqdn = fqdn
        self.msg_clients = msg_clients
        self.node_uuid = node_uuid
        self.status = status
        VapiStruct.__init__(self)


ClusterNodeInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_node_info', {
        'api_listen_addr': type.OptionalType(type.ReferenceType(__name__, 'ServiceEndpoint')),
        'appliance_connection_info': type.OptionalType(type.ReferenceType(__name__, 'ServiceEndpoint')),
        'certificates': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NodeCertificateInfo'))),
        'control_plane_listen_addr': type.OptionalType(type.ReferenceType(__name__, 'ServiceEndpoint')),
        'display_name': type.OptionalType(type.StringType()),
        'entities': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NodeEntityInfo'))),
        'fqdn': type.OptionalType(type.StringType()),
        'msg_clients': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NodeMessagingClientInfo'))),
        'node_uuid': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
    },
    ClusterNodeInfo,
    False,
    None))



class ClusterNodeStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'control_cluster_status': 'control_cluster_status',
                            'mgmt_cluster_status': 'mgmt_cluster_status',
                            'system_status': 'system_status',
                            'version': 'version',
                            }

    def __init__(self,
                 control_cluster_status=None,
                 mgmt_cluster_status=None,
                 system_status=None,
                 version=None,
                ):
        """
        :type  control_cluster_status: :class:`ControlClusterNodeStatus` or ``None``
        :param control_cluster_status: 
        :type  mgmt_cluster_status: :class:`ManagementClusterNodeStatus` or ``None``
        :param mgmt_cluster_status: 
        :type  system_status: :class:`NodeStatusProperties` or ``None``
        :param system_status: 
        :type  version: :class:`str` or ``None``
        :param version: Software version running on node
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.control_cluster_status = control_cluster_status
        self.mgmt_cluster_status = mgmt_cluster_status
        self.system_status = system_status
        self.version = version
        VapiStruct.__init__(self)


ClusterNodeStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_node_status', {
        'control_cluster_status': type.OptionalType(type.ReferenceType(__name__, 'ControlClusterNodeStatus')),
        'mgmt_cluster_status': type.OptionalType(type.ReferenceType(__name__, 'ManagementClusterNodeStatus')),
        'system_status': type.OptionalType(type.ReferenceType(__name__, 'NodeStatusProperties')),
        'version': type.OptionalType(type.StringType()),
    },
    ClusterNodeStatus,
    False,
    None))



class ClusterNodeVMDeploymentConfig(VapiStruct):
    """
    Contains info used to configure the VM on deployment

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ClusterNodeVMDeploymentConfig"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    PLACEMENT_TYPE_VSPHERECLUSTERNODEVMDEPLOYMENTCONFIG = "VsphereClusterNodeVMDeploymentConfig"
    """


    """



    _canonical_to_pep_names = {
                            'placement_type': 'placement_type',
                            }

    def __init__(self,
                 placement_type='ClusterNodeVMDeploymentConfig',
                ):
        """
        :type  placement_type: :class:`str`
        :param placement_type: Possible values are: 
            
            *
              :attr:`ClusterNodeVMDeploymentConfig.PLACEMENT_TYPE_VSPHERECLUSTERNODEVMDEPLOYMENTCONFIG`
            
            Specifies the config for the platform through which to deploy the
            VM
        """
        self._placement_type = placement_type
        VapiStruct.__init__(self)

    @property
    def placement_type(self):
        """
        Return the discriminator value
        """
        return self._placement_type

ClusterNodeVMDeploymentConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_node_VM_deployment_config', {
        'placement_type': type.StringType(),
    },
    ClusterNodeVMDeploymentConfig,
    False,
    None))



class ClusterNodeVMDeploymentRequest(VapiStruct):
    """
    Contains the deployment information for a cluster node VM soon to be
    deployed or already deployed by the Manager

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    FORM_FACTOR_SMALL = "SMALL"
    """


    """
    FORM_FACTOR_MEDIUM = "MEDIUM"
    """


    """
    FORM_FACTOR_LARGE = "LARGE"
    """


    """
    ROLES_CONTROLLER = "CONTROLLER"
    """


    """
    ROLES_MANAGER = "MANAGER"
    """


    """



    _canonical_to_pep_names = {
                            'deployment_config': 'deployment_config',
                            'form_factor': 'form_factor',
                            'roles': 'roles',
                            'user_settings': 'user_settings',
                            'vm_id': 'vm_id',
                            }

    def __init__(self,
                 deployment_config=None,
                 form_factor=None,
                 roles=None,
                 user_settings=None,
                 vm_id=None,
                ):
        """
        :type  deployment_config: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param deployment_config: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ClusterNodeVMDeploymentConfig`. When methods return a value
            of this class as a return value, the attribute will contain all the
            attributes defined in :class:`ClusterNodeVMDeploymentConfig`.
        :type  form_factor: :class:`str` or ``None``
        :param form_factor: Possible values are: 
            
            * :attr:`ClusterNodeVMDeploymentRequest.FORM_FACTOR_SMALL`
            * :attr:`ClusterNodeVMDeploymentRequest.FORM_FACTOR_MEDIUM`
            * :attr:`ClusterNodeVMDeploymentRequest.FORM_FACTOR_LARGE`
            
            Specifies the desired \"size\" of the VM
        :type  roles: :class:`list` of :class:`str` or ``None``
        :param roles: Possible values are: 
            
            * :attr:`ClusterNodeVMDeploymentRequest.ROLES_CONTROLLER`
            * :attr:`ClusterNodeVMDeploymentRequest.ROLES_MANAGER`
            
            List of cluster node role (or roles) which the VM should take on.
            They specify what type (or types) of cluster node which the new VM
            should act as. Currently both CONTROLLER and MANAGER must be
            provided, since this permutation is the only one supported now.
        :type  user_settings: :class:`NodeUserSettings` or ``None``
        :param user_settings: 
        :type  vm_id: :class:`str` or ``None``
        :param vm_id: ID of the VM maintained internally and used to recognize it. Note:
            This is automatically generated and cannot be modified.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.deployment_config = deployment_config
        self.form_factor = form_factor
        self.roles = roles
        self.user_settings = user_settings
        self.vm_id = vm_id
        VapiStruct.__init__(self)


ClusterNodeVMDeploymentRequest._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_node_VM_deployment_request', {
        'deployment_config': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ClusterNodeVMDeploymentConfig')])),
        'form_factor': type.OptionalType(type.StringType()),
        'roles': type.OptionalType(type.ListType(type.StringType())),
        'user_settings': type.OptionalType(type.ReferenceType(__name__, 'NodeUserSettings')),
        'vm_id': type.OptionalType(type.StringType()),
    },
    ClusterNodeVMDeploymentRequest,
    False,
    None))



class ClusterNodeVMDeploymentRequestList(VapiStruct):
    """
    List of ClusterNodeVMDeploymentRequests

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ClusterNodeVMDeploymentRequest` or ``None``
        :param results: Array of existing ClusterNodeVMDeploymentRequests
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ClusterNodeVMDeploymentRequestList._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_node_VM_deployment_request_list', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterNodeVMDeploymentRequest'))),
    },
    ClusterNodeVMDeploymentRequestList,
    False,
    None))



class ClusterNodeVMDeploymentStatusReport(VapiStruct):
    """
    Contains up-to-date information relating to an auto-deployed VM, including
    its status and (potentially) an error message.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_UNKNOWN_STATE = "UNKNOWN_STATE"
    """


    """
    STATUS_VM_DEPLOYMENT_QUEUED = "VM_DEPLOYMENT_QUEUED"
    """


    """
    STATUS_VM_DEPLOYMENT_IN_PROGRESS = "VM_DEPLOYMENT_IN_PROGRESS"
    """


    """
    STATUS_VM_DEPLOYMENT_FAILED = "VM_DEPLOYMENT_FAILED"
    """


    """
    STATUS_VM_POWER_ON_IN_PROGRESS = "VM_POWER_ON_IN_PROGRESS"
    """


    """
    STATUS_VM_POWER_ON_FAILED = "VM_POWER_ON_FAILED"
    """


    """
    STATUS_WAITING_TO_REGISTER_VM = "WAITING_TO_REGISTER_VM"
    """


    """
    STATUS_VM_REGISTRATION_FAILED = "VM_REGISTRATION_FAILED"
    """


    """
    STATUS_VM_WAITING_TO_CLUSTER = "VM_WAITING_TO_CLUSTER"
    """


    """
    STATUS_VM_WAITING_TO_COME_ONLINE = "VM_WAITING_TO_COME_ONLINE"
    """


    """
    STATUS_VM_ONLINE_FAILED = "VM_ONLINE_FAILED"
    """


    """
    STATUS_VM_CLUSTERING_IN_PROGRESS = "VM_CLUSTERING_IN_PROGRESS"
    """


    """
    STATUS_VM_CLUSTERING_FAILED = "VM_CLUSTERING_FAILED"
    """


    """
    STATUS_VM_CLUSTERING_SUCCESSFUL = "VM_CLUSTERING_SUCCESSFUL"
    """


    """
    STATUS_WAITING_TO_UNDEPLOY_VM = "WAITING_TO_UNDEPLOY_VM"
    """


    """
    STATUS_VM_DECLUSTER_IN_PROGRESS = "VM_DECLUSTER_IN_PROGRESS"
    """


    """
    STATUS_VM_DECLUSTER_FAILED = "VM_DECLUSTER_FAILED"
    """


    """
    STATUS_VM_DECLUSTER_SUCCESSFUL = "VM_DECLUSTER_SUCCESSFUL"
    """


    """
    STATUS_VM_POWER_OFF_IN_PROGRESS = "VM_POWER_OFF_IN_PROGRESS"
    """


    """
    STATUS_VM_POWER_OFF_FAILED = "VM_POWER_OFF_FAILED"
    """


    """
    STATUS_VM_UNDEPLOY_IN_PROGRESS = "VM_UNDEPLOY_IN_PROGRESS"
    """


    """
    STATUS_VM_UNDEPLOY_FAILED = "VM_UNDEPLOY_FAILED"
    """


    """
    STATUS_VM_UNDEPLOY_SUCCESSFUL = "VM_UNDEPLOY_SUCCESSFUL"
    """


    """



    _canonical_to_pep_names = {
                            'deployment_progress_state': 'deployment_progress_state',
                            'failure_code': 'failure_code',
                            'failure_message': 'failure_message',
                            'status': 'status',
                            }

    def __init__(self,
                 deployment_progress_state=None,
                 failure_code=None,
                 failure_message=None,
                 status=None,
                ):
        """
        :type  deployment_progress_state: :class:`VMDeploymentProgressState` or ``None``
        :param deployment_progress_state: 
        :type  failure_code: :class:`long` or ``None``
        :param failure_code: In case of auto-deployment-related failure, the code for the error
            will be stored here. format: int64
        :type  failure_message: :class:`str` or ``None``
        :param failure_message: In case of auto-deployment-related failure, an error message will
            be stored here.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_UNKNOWN_STATE`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_DEPLOYMENT_QUEUED`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_DEPLOYMENT_IN_PROGRESS`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_DEPLOYMENT_FAILED`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_POWER_ON_IN_PROGRESS`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_POWER_ON_FAILED`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_WAITING_TO_REGISTER_VM`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_REGISTRATION_FAILED`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_WAITING_TO_CLUSTER`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_WAITING_TO_COME_ONLINE`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_ONLINE_FAILED`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_CLUSTERING_IN_PROGRESS`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_CLUSTERING_FAILED`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_CLUSTERING_SUCCESSFUL`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_WAITING_TO_UNDEPLOY_VM`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_DECLUSTER_IN_PROGRESS`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_DECLUSTER_FAILED`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_DECLUSTER_SUCCESSFUL`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_POWER_OFF_IN_PROGRESS`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_POWER_OFF_FAILED`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_UNDEPLOY_IN_PROGRESS`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_UNDEPLOY_FAILED`
            *
              :attr:`ClusterNodeVMDeploymentStatusReport.STATUS_VM_UNDEPLOY_SUCCESSFUL`
            
            Status of the addition or deletion of an auto-deployed cluster node
            VM.
        """
        self.deployment_progress_state = deployment_progress_state
        self.failure_code = failure_code
        self.failure_message = failure_message
        self.status = status
        VapiStruct.__init__(self)


ClusterNodeVMDeploymentStatusReport._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_node_VM_deployment_status_report', {
        'deployment_progress_state': type.OptionalType(type.ReferenceType(__name__, 'VMDeploymentProgressState')),
        'failure_code': type.OptionalType(type.IntegerType()),
        'failure_message': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
    },
    ClusterNodeVMDeploymentStatusReport,
    False,
    None))



class ClusterProfile(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ClusterProfile"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    RESOURCE_TYPE_EDGEHIGHAVAILABILITYPROFILE = "EdgeHighAvailabilityProfile"
    """


    """
    RESOURCE_TYPE_BRIDGEHIGHAVAILABILITYCLUSTERPROFILE = "BridgeHighAvailabilityClusterProfile"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='ClusterProfile',
                 tags=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`ClusterProfile.RESOURCE_TYPE_EDGEHIGHAVAILABILITYPROFILE`
            *
              :attr:`ClusterProfile.RESOURCE_TYPE_BRIDGEHIGHAVAILABILITYCLUSTERPROFILE`
            
            Supported cluster profiles.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ClusterProfile._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
    },
    ClusterProfile,
    False,
    None))



class ClusterProfileListResult(VapiStruct):
    """
    Cluster Profile queries result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: Cluster Profile Results
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ClusterProfile`. When methods return a value of this class
            as a return value, the attribute will contain all the attributes
            defined in :class:`ClusterProfile`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ClusterProfileListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_profile_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ClusterProfile')]))),
    },
    ClusterProfileListResult,
    False,
    None))



class ClusterProfileTypeIdEntry(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    RESOURCE_TYPE_EDGEHIGHAVAILABILITYPROFILE = "EdgeHighAvailabilityProfile"
    """


    """
    RESOURCE_TYPE_BRIDGEHIGHAVAILABILITYCLUSTERPROFILE = "BridgeHighAvailabilityClusterProfile"
    """


    """



    _canonical_to_pep_names = {
                            'profile_id': 'profile_id',
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 profile_id=None,
                 resource_type=None,
                ):
        """
        :type  profile_id: :class:`str` or ``None``
        :param profile_id: key value
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: Possible values are: 
            
            *
              :attr:`ClusterProfileTypeIdEntry.RESOURCE_TYPE_EDGEHIGHAVAILABILITYPROFILE`
            *
              :attr:`ClusterProfileTypeIdEntry.RESOURCE_TYPE_BRIDGEHIGHAVAILABILITYCLUSTERPROFILE`
            
            Supported cluster profiles.
        """
        self.profile_id = profile_id
        self.resource_type = resource_type
        VapiStruct.__init__(self)


ClusterProfileTypeIdEntry._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_profile_type_id_entry', {
        'profile_id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
    },
    ClusterProfileTypeIdEntry,
    False,
    None))



class ClusterRestoreStatus(VapiStruct):
    """
    Cluster restore status

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    NOT_ALLOWED_ACTIONS_UPDATES = "VC_UPDATES"
    """


    """



    _canonical_to_pep_names = {
                            'allowed_actions': 'allowed_actions',
                            'backup_timestamp': 'backup_timestamp',
                            'endpoints': 'endpoints',
                            'id': 'id',
                            'instructions': 'instructions',
                            'not_allowed_actions': 'not_allowed_actions',
                            'restore_end_time': 'restore_end_time',
                            'restore_start_time': 'restore_start_time',
                            'status': 'status',
                            'step': 'step',
                            'total_steps': 'total_steps',
                            }

    def __init__(self,
                 allowed_actions=None,
                 backup_timestamp=None,
                 endpoints=None,
                 id=None,
                 instructions=None,
                 not_allowed_actions=None,
                 restore_end_time=None,
                 restore_start_time=None,
                 status=None,
                 step=None,
                 total_steps=None,
                ):
        """
        :type  allowed_actions: :class:`list` of :class:`str` or ``None``
        :param allowed_actions: List of actions that are allowed.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  backup_timestamp: :class:`long` or ``None``
        :param backup_timestamp: Timestamp when backup was initiated in epoch millisecond format:
            int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  endpoints: :class:`list` of :class:`ResourceLink` or ``None``
        :param endpoints: The list of allowed endpoints, based on the current state of the
            restore process
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  id: :class:`str` or ``None``
        :param id: Unique id for backup request
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  instructions: :class:`list` of :class:`InstructionInfo` or ``None``
        :param instructions: Instructions for users to reconcile Restore operations
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  not_allowed_actions: :class:`list` of :class:`str` or ``None``
        :param not_allowed_actions: Possible values are: 
            
            * :attr:`ClusterRestoreStatus.NOT_ALLOWED_ACTIONS_UPDATES`
            
            List of actions that are not allowed
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  restore_end_time: :class:`long` or ``None``
        :param restore_end_time: Timestamp when restore was completed in epoch millisecond format:
            int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  restore_start_time: :class:`long` or ``None``
        :param restore_start_time: Timestamp when restore was started in epoch millisecond format:
            int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`GlobalRestoreStatus` or ``None``
        :param status: 
        :type  step: :class:`RestoreStep` or ``None``
        :param step: 
        :type  total_steps: :class:`long` or ``None``
        :param total_steps: Total number of steps in the entire restore process format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.allowed_actions = allowed_actions
        self.backup_timestamp = backup_timestamp
        self.endpoints = endpoints
        self.id = id
        self.instructions = instructions
        self.not_allowed_actions = not_allowed_actions
        self.restore_end_time = restore_end_time
        self.restore_start_time = restore_start_time
        self.status = status
        self.step = step
        self.total_steps = total_steps
        VapiStruct.__init__(self)


ClusterRestoreStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_restore_status', {
        'allowed_actions': type.OptionalType(type.ListType(type.StringType())),
        'backup_timestamp': type.OptionalType(type.IntegerType()),
        'endpoints': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        'id': type.OptionalType(type.StringType()),
        'instructions': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'InstructionInfo'))),
        'not_allowed_actions': type.OptionalType(type.ListType(type.StringType())),
        'restore_end_time': type.OptionalType(type.IntegerType()),
        'restore_start_time': type.OptionalType(type.IntegerType()),
        'status': type.OptionalType(type.ReferenceType(__name__, 'GlobalRestoreStatus')),
        'step': type.OptionalType(type.ReferenceType(__name__, 'RestoreStep')),
        'total_steps': type.OptionalType(type.IntegerType()),
    },
    ClusterRestoreStatus,
    False,
    None))



class ClusterRoleConfig(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_MANAGEMENTCLUSTERROLECONFIG = "ManagementClusterRoleConfig"
    """


    """
    TYPE_CONTROLLERCLUSTERROLECONFIG = "ControllerClusterRoleConfig"
    """


    """



    _canonical_to_pep_names = {
                            'type': 'type',
                            }

    def __init__(self,
                 type=None,
                ):
        """
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ClusterRoleConfig.TYPE_MANAGEMENTCLUSTERROLECONFIG`
            * :attr:`ClusterRoleConfig.TYPE_CONTROLLERCLUSTERROLECONFIG`
            
            Type of this role configuration
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.type = type
        VapiStruct.__init__(self)


ClusterRoleConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_role_config', {
        'type': type.OptionalType(type.StringType()),
    },
    ClusterRoleConfig,
    False,
    None))



class ClusterStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'cluster_id': 'cluster_id',
                            'control_cluster_status': 'control_cluster_status',
                            'detailed_cluster_status': 'detailed_cluster_status',
                            'mgmt_cluster_status': 'mgmt_cluster_status',
                            }

    def __init__(self,
                 cluster_id=None,
                 control_cluster_status=None,
                 detailed_cluster_status=None,
                 mgmt_cluster_status=None,
                ):
        """
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: Unique identifier of this cluster
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  control_cluster_status: :class:`ControllerClusterStatus` or ``None``
        :param control_cluster_status: 
        :type  detailed_cluster_status: :class:`AllClusterGroupStatus` or ``None``
        :param detailed_cluster_status: 
        :type  mgmt_cluster_status: :class:`ManagementClusterStatus` or ``None``
        :param mgmt_cluster_status: 
        """
        self.cluster_id = cluster_id
        self.control_cluster_status = control_cluster_status
        self.detailed_cluster_status = detailed_cluster_status
        self.mgmt_cluster_status = mgmt_cluster_status
        VapiStruct.__init__(self)


ClusterStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_status', {
        'cluster_id': type.OptionalType(type.StringType()),
        'control_cluster_status': type.OptionalType(type.ReferenceType(__name__, 'ControllerClusterStatus')),
        'detailed_cluster_status': type.OptionalType(type.ReferenceType(__name__, 'AllClusterGroupStatus')),
        'mgmt_cluster_status': type.OptionalType(type.ReferenceType(__name__, 'ManagementClusterStatus')),
    },
    ClusterStatus,
    False,
    None))



class ClusterVirtualIpProperties(VapiStruct):
    """
    Cluster virtual IP properties

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    FORCE_TRUE = "true"
    """


    """
    FORCE_FALSE = "false"
    """


    """



    _canonical_to_pep_names = {
                            'force': 'force',
                            'ip6_address': 'ip6_address',
                            'ip_address': 'ip_address',
                            }

    def __init__(self,
                 force=None,
                 ip6_address=None,
                 ip_address=None,
                ):
        """
        :type  force: :class:`str` or ``None``
        :param force: Possible values are: 
            
            * :attr:`ClusterVirtualIpProperties.FORCE_TRUE`
            * :attr:`ClusterVirtualIpProperties.FORCE_FALSE`
            
            On enable it ignores duplicate address detection and DNS lookup
            validation check
        :type  ip6_address: :class:`str` or ``None``
        :param ip6_address: Virtual IPv6 address, :: if not configured
        :type  ip_address: :class:`str` or ``None``
        :param ip_address: Virtual IP address, 0.0.0.0 if not configured
        """
        self.force = force
        self.ip6_address = ip6_address
        self.ip_address = ip_address
        VapiStruct.__init__(self)


ClusterVirtualIpProperties._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cluster_virtual_ip_properties', {
        'force': type.OptionalType(type.StringType()),
        'ip6_address': type.OptionalType(type.StringType()),
        'ip_address': type.OptionalType(type.StringType()),
    },
    ClusterVirtualIpProperties,
    False,
    None))



class ClusteringConfig(VapiStruct):
    """
    Configuration for automatically joining a cluster node to the cluster after
    it is deployed. ClusteringConfig is required if any of the deployment nodes
    has CONTROLLER role.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CLUSTERING_TYPE_CONTROLCLUSTERINGCONFIG = "ControlClusteringConfig"
    """


    """



    _canonical_to_pep_names = {
                            'clustering_type': 'clustering_type',
                            }

    def __init__(self,
                 clustering_type=None,
                ):
        """
        :type  clustering_type: :class:`str` or ``None``
        :param clustering_type: Possible values are: 
            
            * :attr:`ClusteringConfig.CLUSTERING_TYPE_CONTROLCLUSTERINGCONFIG`
            
            Specifies the type of clustering config to be used.
        """
        self.clustering_type = clustering_type
        VapiStruct.__init__(self)


ClusteringConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.clustering_config', {
        'clustering_type': type.OptionalType(type.StringType()),
    },
    ClusteringConfig,
    False,
    None))



class ClusteringInfo(VapiStruct):
    """
    Clustering parameters for the controller cluster

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'join_to_existing_cluster': 'join_to_existing_cluster',
                            'shared_secret': 'shared_secret',
                            }

    def __init__(self,
                 join_to_existing_cluster=None,
                 shared_secret=None,
                ):
        """
        :type  join_to_existing_cluster: :class:`bool` or ``None``
        :param join_to_existing_cluster: Property to indicate if the node must join an existing cluster.
        :type  shared_secret: :class:`str` or ``None``
        :param shared_secret: Shared secret of the cluster.
        """
        self.join_to_existing_cluster = join_to_existing_cluster
        self.shared_secret = shared_secret
        VapiStruct.__init__(self)


ClusteringInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.clustering_info', {
        'join_to_existing_cluster': type.OptionalType(type.BooleanType()),
        'shared_secret': type.OptionalType(type.StringType()),
    },
    ClusteringInfo,
    False,
    None))



class ClustersAggregateInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'cluster_status': 'cluster_status',
                            'controller_cluster': 'controller_cluster',
                            'management_cluster': 'management_cluster',
                            }

    def __init__(self,
                 cluster_status=None,
                 controller_cluster=None,
                 management_cluster=None,
                ):
        """
        :type  cluster_status: :class:`AllClusterGroupStatus` or ``None``
        :param cluster_status: 
        :type  controller_cluster: :class:`list` of :class:`ControllerNodeAggregateInfo` or ``None``
        :param controller_cluster: Array of Controller Nodes
        :type  management_cluster: :class:`list` of :class:`ManagementNodeAggregateInfo` or ``None``
        :param management_cluster: Array of Management Nodes
        """
        self.cluster_status = cluster_status
        self.controller_cluster = controller_cluster
        self.management_cluster = management_cluster
        VapiStruct.__init__(self)


ClustersAggregateInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.clusters_aggregate_info', {
        'cluster_status': type.OptionalType(type.ReferenceType(__name__, 'AllClusterGroupStatus')),
        'controller_cluster': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ControllerNodeAggregateInfo'))),
        'management_cluster': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ManagementNodeAggregateInfo'))),
    },
    ClustersAggregateInfo,
    False,
    None))



class CmThumbprintHashingConfig(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    HASHING_ALGORITHM_TYPE_SHA1 = "SHA1"
    """


    """
    HASHING_ALGORITHM_TYPE_SHA256 = "SHA256"
    """


    """



    _canonical_to_pep_names = {
                            'hashing_algorithm_type': 'hashing_algorithm_type',
                            }

    def __init__(self,
                 hashing_algorithm_type=None,
                ):
        """
        :type  hashing_algorithm_type: :class:`str` or ``None``
        :param hashing_algorithm_type: Possible values are: 
            
            * :attr:`CmThumbprintHashingConfig.HASHING_ALGORITHM_TYPE_SHA1`
            * :attr:`CmThumbprintHashingConfig.HASHING_ALGORITHM_TYPE_SHA256`
            
            This specifies the hashing algorithm to be used for stamping NSX
            manager thumbprint in compute manager extension. e.g. When a
            vCenter is registered as compute manager, thumbprint of NSX manager
            certificate is stamped in NSXT extension on vCenter. If algorithm
            type is SHA1, then SHA1 thumbprint of NSX manager API certificate
            is stamped. If algorithm type is SHA256, then SHA256 thumbprint of
            NSX manager certificate is stamped. Changing this setting to SHA256
            will result in communication issues between WCP component in VC and
            NSX manager. Hence it is recommended not to use SHA256 if VC WCP
            feature is being used with NSX.
        """
        self.hashing_algorithm_type = hashing_algorithm_type
        VapiStruct.__init__(self)


CmThumbprintHashingConfig._set_binding_type(type.StructType(
    'com.vmware.nsx.model.cm_thumbprint_hashing_config', {
        'hashing_algorithm_type': type.OptionalType(type.StringType()),
    },
    CmThumbprintHashingConfig,
    False,
    None))



class ColumnItem(VapiStruct):
    """
    Represents a column of the Grid

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_STRING = "String"
    """


    """
    TYPE_NUMBER = "Number"
    """


    """
    TYPE_DATE = "Date"
    """


    """



    _canonical_to_pep_names = {
                            'column_identifier': 'column_identifier',
                            'drilldown_id': 'drilldown_id',
                            'field': 'field',
                            'hidden': 'hidden',
                            'label': 'label',
                            'navigation': 'navigation',
                            'render_configuration': 'render_configuration',
                            'sort_ascending': 'sort_ascending',
                            'sort_key': 'sort_key',
                            'tooltip': 'tooltip',
                            'type': 'type',
                            }

    def __init__(self,
                 column_identifier=None,
                 drilldown_id=None,
                 field=None,
                 hidden=None,
                 label=None,
                 navigation=None,
                 render_configuration=None,
                 sort_ascending=None,
                 sort_key=None,
                 tooltip=None,
                 type=None,
                ):
        """
        :type  column_identifier: :class:`str` or ``None``
        :param column_identifier: Identifies the column and used for fetching content upon an user
            click or drilldown. If column identifier is not provided, the
            column's data will not participate in searches and drilldowns.
        :type  drilldown_id: :class:`str` or ``None``
        :param drilldown_id: Id of drilldown widget, if any. Id should be a valid id of an
            existing widget.
        :type  field: :class:`str` or ``None``
        :param field: Field from which values of the column will be derived.
        :type  hidden: :class:`bool` or ``None``
        :param hidden: If set to true, hides the column
        :type  label: :class:`Label` or ``None``
        :param label: 
        :type  navigation: :class:`str` or ``None``
        :param navigation: Hyperlink of the specified UI page that provides details. If
            drilldown_id is provided, then navigation cannot be used.
        :type  render_configuration: :class:`list` of :class:`RenderConfiguration` or ``None``
        :param render_configuration: Render configuration to be applied, if any.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, the value of the column are sorted in ascending order.
            Otherwise, in descending order.
        :type  sort_key: :class:`str` or ``None``
        :param sort_key: Sorting on column is based on the sort_key. sort_key represents the
            field in the output data on which sort is requested.
        :type  tooltip: :class:`list` of :class:`Tooltip` or ``None``
        :param tooltip: Multi-line text to be shown on tooltip while hovering over a cell
            in the grid.
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ColumnItem.TYPE_STRING`
            * :attr:`ColumnItem.TYPE_NUMBER`
            * :attr:`ColumnItem.TYPE_DATE`
            
            Data type of the field.
        """
        self.column_identifier = column_identifier
        self.drilldown_id = drilldown_id
        self.field = field
        self.hidden = hidden
        self.label = label
        self.navigation = navigation
        self.render_configuration = render_configuration
        self.sort_ascending = sort_ascending
        self.sort_key = sort_key
        self.tooltip = tooltip
        self.type = type
        VapiStruct.__init__(self)


ColumnItem._set_binding_type(type.StructType(
    'com.vmware.nsx.model.column_item', {
        'column_identifier': type.OptionalType(type.StringType()),
        'drilldown_id': type.OptionalType(type.StringType()),
        'field': type.OptionalType(type.StringType()),
        'hidden': type.OptionalType(type.BooleanType()),
        'label': type.OptionalType(type.ReferenceType(__name__, 'Label')),
        'navigation': type.OptionalType(type.StringType()),
        'render_configuration': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'RenderConfiguration'))),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_key': type.OptionalType(type.StringType()),
        'tooltip': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tooltip'))),
        'type': type.OptionalType(type.StringType()),
    },
    ColumnItem,
    False,
    None))



class CommunityMatchExpression(VapiStruct):
    """
    Community match expression

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    OPERATOR_AND = "AND"
    """


    """



    _canonical_to_pep_names = {
                            'expression': 'expression',
                            'operator': 'operator',
                            }

    def __init__(self,
                 expression=None,
                 operator=None,
                ):
        """
        :type  expression: :class:`list` of :class:`CommunityMatchOperation` or ``None``
        :param expression: Array of community match operations
        :type  operator: :class:`str` or ``None``
        :param operator: Possible values are: 
            
            * :attr:`CommunityMatchExpression.OPERATOR_AND`
            
            Operator for evaluating community match expressions. AND logical
            AND operator
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.expression = expression
        self.operator = operator
        VapiStruct.__init__(self)


CommunityMatchExpression._set_binding_type(type.StructType(
    'com.vmware.nsx.model.community_match_expression', {
        'expression': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CommunityMatchOperation'))),
        'operator': type.OptionalType(type.StringType()),
    },
    CommunityMatchExpression,
    False,
    None))



class CommunityMatchOperation(VapiStruct):
    """
    Community match operation

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MATCH_OPERATOR_ANY = "MATCH_ANY"
    """


    """
    MATCH_OPERATOR_ALL = "MATCH_ALL"
    """


    """
    MATCH_OPERATOR_EXACT = "MATCH_EXACT"
    """


    """
    MATCH_OPERATOR_NONE = "MATCH_NONE"
    """


    """
    MATCH_OPERATOR_REGEX = "MATCH_REGEX"
    """


    """
    MATCH_OPERATOR_LARGE_COMMUNITY_REGEX = "MATCH_LARGE_COMMUNITY_REGEX"
    """


    """



    _canonical_to_pep_names = {
                            'community_list_id': 'community_list_id',
                            'match_operator': 'match_operator',
                            'regular_expression': 'regular_expression',
                            }

    def __init__(self,
                 community_list_id=None,
                 match_operator=None,
                 regular_expression=None,
                ):
        """
        :type  community_list_id: :class:`str` or ``None``
        :param community_list_id: ID of BGP community list. This value is not required when
            match_operator is MATCH_REGEX otherwise required.
        :type  match_operator: :class:`str` or ``None``
        :param match_operator: Possible values are: 
            
            * :attr:`CommunityMatchOperation.MATCH_OPERATOR_ANY`
            * :attr:`CommunityMatchOperation.MATCH_OPERATOR_ALL`
            * :attr:`CommunityMatchOperation.MATCH_OPERATOR_EXACT`
            * :attr:`CommunityMatchOperation.MATCH_OPERATOR_NONE`
            * :attr:`CommunityMatchOperation.MATCH_OPERATOR_REGEX`
            *
              :attr:`CommunityMatchOperation.MATCH_OPERATOR_LARGE_COMMUNITY_REGEX`
            
            Match operator for communities from provided community list id.
            MATCH_ANY will match any community MATCH_ALL will match all
            communities MATCH_EXACT will do exact match on community MATCH_NONE
            [operator not supported] will not match any community MATCH_REGEX
            will match normal communities by evaluating regular expression
            MATCH_LARGE_COMMUNITY_REGEX will match large communities by
            evaluating regular expression
        :type  regular_expression: :class:`str` or ``None``
        :param regular_expression: Regular expression to match BGP communities. If match_operator is
            MATCH_REGEX then this value must be specified.
        """
        self.community_list_id = community_list_id
        self.match_operator = match_operator
        self.regular_expression = regular_expression
        VapiStruct.__init__(self)


CommunityMatchOperation._set_binding_type(type.StructType(
    'com.vmware.nsx.model.community_match_operation', {
        'community_list_id': type.OptionalType(type.StringType()),
        'match_operator': type.OptionalType(type.StringType()),
        'regular_expression': type.OptionalType(type.StringType()),
    },
    CommunityMatchOperation,
    False,
    None))



class ComponentMigrationStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_SUCCESS = "SUCCESS"
    """


    """
    STATUS_FAILED = "FAILED"
    """


    """
    STATUS_IN_PROGRESS = "IN_PROGRESS"
    """


    """
    STATUS_NOT_STARTED = "NOT_STARTED"
    """


    """
    STATUS_PAUSING = "PAUSING"
    """


    """
    STATUS_PAUSED = "PAUSED"
    """


    """



    _canonical_to_pep_names = {
                            'can_skip': 'can_skip',
                            'component_type': 'component_type',
                            'details': 'details',
                            'percent_complete': 'percent_complete',
                            'status': 'status',
                            }

    def __init__(self,
                 can_skip=None,
                 component_type=None,
                 details=None,
                 percent_complete=None,
                 status=None,
                ):
        """
        :type  can_skip: :class:`bool` or ``None``
        :param can_skip: Can the migration of the remaining units in this component be
            skipped
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  component_type: :class:`str` or ``None``
        :param component_type: Component type for the migration status
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  details: :class:`str` or ``None``
        :param details: Details about the migration status
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  percent_complete: :class:`float` or ``None``
        :param percent_complete: Indicator of migration progress in percentage
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ComponentMigrationStatus.STATUS_SUCCESS`
            * :attr:`ComponentMigrationStatus.STATUS_FAILED`
            * :attr:`ComponentMigrationStatus.STATUS_IN_PROGRESS`
            * :attr:`ComponentMigrationStatus.STATUS_NOT_STARTED`
            * :attr:`ComponentMigrationStatus.STATUS_PAUSING`
            * :attr:`ComponentMigrationStatus.STATUS_PAUSED`
            
            Migration status of component
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.can_skip = can_skip
        self.component_type = component_type
        self.details = details
        self.percent_complete = percent_complete
        self.status = status
        VapiStruct.__init__(self)


ComponentMigrationStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.component_migration_status', {
        'can_skip': type.OptionalType(type.BooleanType()),
        'component_type': type.OptionalType(type.StringType()),
        'details': type.OptionalType(type.StringType()),
        'percent_complete': type.OptionalType(type.DoubleType()),
        'status': type.OptionalType(type.StringType()),
    },
    ComponentMigrationStatus,
    False,
    None))



class ComponentTargetVersion(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'component_type': 'component_type',
                            'target_version': 'target_version',
                            }

    def __init__(self,
                 component_type=None,
                 target_version=None,
                ):
        """
        :type  component_type: :class:`str` or ``None``
        :param component_type: 
        :type  target_version: :class:`str` or ``None``
        :param target_version: 
        """
        self.component_type = component_type
        self.target_version = target_version
        VapiStruct.__init__(self)


ComponentTargetVersion._set_binding_type(type.StructType(
    'com.vmware.nsx.model.component_target_version', {
        'component_type': type.OptionalType(type.StringType()),
        'target_version': type.OptionalType(type.StringType()),
    },
    ComponentTargetVersion,
    False,
    None))



class ComponentUpgradeChecksInfo(VapiStruct):
    """
    Meta-data of pre/post-upgrade checks for a component

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'component_type': 'component_type',
                            'post_upgrade_checks_info': 'post_upgrade_checks_info',
                            'pre_upgrade_checks_info': 'pre_upgrade_checks_info',
                            }

    def __init__(self,
                 component_type=None,
                 post_upgrade_checks_info=None,
                 pre_upgrade_checks_info=None,
                ):
        """
        :type  component_type: :class:`str` or ``None``
        :param component_type: Component type of the pre/post-upgrade checks
        :type  post_upgrade_checks_info: :class:`list` of :class:`UpgradeCheckInfo` or ``None``
        :param post_upgrade_checks_info: Collection of post-upgrade checks
        :type  pre_upgrade_checks_info: :class:`list` of :class:`UpgradeCheckInfo` or ``None``
        :param pre_upgrade_checks_info: Collection of pre-upgrade checks
        """
        self.component_type = component_type
        self.post_upgrade_checks_info = post_upgrade_checks_info
        self.pre_upgrade_checks_info = pre_upgrade_checks_info
        VapiStruct.__init__(self)


ComponentUpgradeChecksInfo._set_binding_type(type.StructType(
    'com.vmware.nsx.model.component_upgrade_checks_info', {
        'component_type': type.OptionalType(type.StringType()),
        'post_upgrade_checks_info': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'UpgradeCheckInfo'))),
        'pre_upgrade_checks_info': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'UpgradeCheckInfo'))),
    },
    ComponentUpgradeChecksInfo,
    False,
    None))



class ComponentUpgradeChecksInfoListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ComponentUpgradeChecksInfo` or ``None``
        :param results: Collection of info of pre/post-upgrade checks for components
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ComponentUpgradeChecksInfoListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.component_upgrade_checks_info_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ComponentUpgradeChecksInfo'))),
    },
    ComponentUpgradeChecksInfoListResult,
    False,
    None))



class ComponentUpgradeStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_SUCCESS = "SUCCESS"
    """


    """
    STATUS_FAILED = "FAILED"
    """


    """
    STATUS_IN_PROGRESS = "IN_PROGRESS"
    """


    """
    STATUS_NOT_STARTED = "NOT_STARTED"
    """


    """
    STATUS_PAUSING = "PAUSING"
    """


    """
    STATUS_PAUSED = "PAUSED"
    """


    """



    _canonical_to_pep_names = {
                            'can_rollback': 'can_rollback',
                            'can_skip': 'can_skip',
                            'component_type': 'component_type',
                            'current_version_node_summary': 'current_version_node_summary',
                            'details': 'details',
                            'node_count_at_target_version': 'node_count_at_target_version',
                            'percent_complete': 'percent_complete',
                            'pre_upgrade_status': 'pre_upgrade_status',
                            'status': 'status',
                            'target_component_version': 'target_component_version',
                            }

    def __init__(self,
                 can_rollback=None,
                 can_skip=None,
                 component_type=None,
                 current_version_node_summary=None,
                 details=None,
                 node_count_at_target_version=None,
                 percent_complete=None,
                 pre_upgrade_status=None,
                 status=None,
                 target_component_version=None,
                ):
        """
        :type  can_rollback: :class:`bool` or ``None``
        :param can_rollback: This field indicates whether we can perform upgrade rollback.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  can_skip: :class:`bool` or ``None``
        :param can_skip: Can the upgrade of the remaining units in this component be skipped
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  component_type: :class:`str` or ``None``
        :param component_type: Component type for the upgrade status
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  current_version_node_summary: :class:`NodeSummaryList` or ``None``
        :param current_version_node_summary: 
        :type  details: :class:`str` or ``None``
        :param details: Details about the upgrade status
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_count_at_target_version: :class:`long` or ``None``
        :param node_count_at_target_version: Number of nodes of the type and at the component version format:
            int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  percent_complete: :class:`float` or ``None``
        :param percent_complete: Indicator of upgrade progress in percentage
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  pre_upgrade_status: :class:`UpgradeChecksExecutionStatus` or ``None``
        :param pre_upgrade_status: 
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ComponentUpgradeStatus.STATUS_SUCCESS`
            * :attr:`ComponentUpgradeStatus.STATUS_FAILED`
            * :attr:`ComponentUpgradeStatus.STATUS_IN_PROGRESS`
            * :attr:`ComponentUpgradeStatus.STATUS_NOT_STARTED`
            * :attr:`ComponentUpgradeStatus.STATUS_PAUSING`
            * :attr:`ComponentUpgradeStatus.STATUS_PAUSED`
            
            Upgrade status of component
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  target_component_version: :class:`str` or ``None``
        :param target_component_version: Target component version
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.can_rollback = can_rollback
        self.can_skip = can_skip
        self.component_type = component_type
        self.current_version_node_summary = current_version_node_summary
        self.details = details
        self.node_count_at_target_version = node_count_at_target_version
        self.percent_complete = percent_complete
        self.pre_upgrade_status = pre_upgrade_status
        self.status = status
        self.target_component_version = target_component_version
        VapiStruct.__init__(self)


ComponentUpgradeStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.component_upgrade_status', {
        'can_rollback': type.OptionalType(type.BooleanType()),
        'can_skip': type.OptionalType(type.BooleanType()),
        'component_type': type.OptionalType(type.StringType()),
        'current_version_node_summary': type.OptionalType(type.ReferenceType(__name__, 'NodeSummaryList')),
        'details': type.OptionalType(type.StringType()),
        'node_count_at_target_version': type.OptionalType(type.IntegerType()),
        'percent_complete': type.OptionalType(type.DoubleType()),
        'pre_upgrade_status': type.OptionalType(type.ReferenceType(__name__, 'UpgradeChecksExecutionStatus')),
        'status': type.OptionalType(type.StringType()),
        'target_component_version': type.OptionalType(type.StringType()),
    },
    ComponentUpgradeStatus,
    False,
    None))



class ComputeCollection(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    OWNER_NSX_SELF = "SELF"
    """


    """
    OWNER_NSX_OTHER = "OTHER"
    """


    """
    OWNER_NSX_MULTIPLE = "MULTIPLE"
    """


    """
    OWNER_NSX_NONE = "NONE"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_last_sync_time': 'last_sync_time',
                            'description': 'description',
                            'display_name': 'display_name',
                            'resource_type': 'resource_type',
                            'scope': 'scope',
                            'tags': 'tags',
                            'cm_local_id': 'cm_local_id',
                            'dpu_config': 'dpu_config',
                            'external_id': 'external_id',
                            'origin_id': 'origin_id',
                            'origin_properties': 'origin_properties',
                            'origin_type': 'origin_type',
                            'owner_id': 'owner_id',
                            'owner_nsx': 'owner_nsx',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 last_sync_time=None,
                 description=None,
                 display_name=None,
                 resource_type=None,
                 scope=None,
                 tags=None,
                 cm_local_id=None,
                 dpu_config=None,
                 external_id=None,
                 origin_id=None,
                 origin_properties=None,
                 origin_type=None,
                 owner_id=None,
                 owner_nsx=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  last_sync_time: :class:`long` or ``None``
        :param last_sync_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  scope: :class:`list` of :class:`DiscoveredResourceScope` or ``None``
        :param scope: Specifies list of scope of discovered resource. e.g. if VHC path is
            associated with principal identity, who owns the discovered
            resource, then scope id will be VHC path and scope type will be
            VHC.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  cm_local_id: :class:`str` or ``None``
        :param cm_local_id: Local Id of the compute collection in the Compute Manager
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  dpu_config: :class:`ClusterDpuConfig` or ``None``
        :param dpu_config: 
        :type  external_id: :class:`str` or ``None``
        :param external_id: External ID of the ComputeCollection in the source Compute manager,
            e.g. mo-ref in VC
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  origin_id: :class:`str` or ``None``
        :param origin_id: Id of the compute manager from where this Compute Collection was
            discovered
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  origin_properties: :class:`list` of :class:`KeyValuePair` or ``None``
        :param origin_properties: Key-Value map of additional specific properties of compute
            collection in the Compute Manager
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  origin_type: :class:`str` or ``None``
        :param origin_type: ComputeCollection type like VC_Cluster. Here the Compute Manager
            type prefix would help in differentiating similar named Compute
            Collection types from different Compute Managers
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  owner_id: :class:`str` or ``None``
        :param owner_id: Id of the owner of compute collection in the Compute Manager
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  owner_nsx: :class:`str` or ``None``
        :param owner_nsx: Possible values are: 
            
            * :attr:`ComputeCollection.OWNER_NSX_SELF`
            * :attr:`ComputeCollection.OWNER_NSX_OTHER`
            * :attr:`ComputeCollection.OWNER_NSX_MULTIPLE`
            * :attr:`ComputeCollection.OWNER_NSX_NONE`
            
            Specifies owner nsx of the compute collection. Owner nsx can be
            SELF, OTHER, MULTIPLE or NONE. SELF applies to when compute
            collection prepared by that nsx. OTHER applies to when compute
            collection prepared by other nsx. MULTIPLE applies to when compute
            collection tried to prepare by multiple nsx at a time. NONE applies
            to when compute collection is not prepared by any nsx.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.last_sync_time = last_sync_time
        self.description = description
        self.display_name = display_name
        self.resource_type = resource_type
        self.scope = scope
        self.tags = tags
        self.cm_local_id = cm_local_id
        self.dpu_config = dpu_config
        self.external_id = external_id
        self.origin_id = origin_id
        self.origin_properties = origin_properties
        self.origin_type = origin_type
        self.owner_id = owner_id
        self.owner_nsx = owner_nsx
        VapiStruct.__init__(self)


ComputeCollection._set_binding_type(type.StructType(
    'com.vmware.nsx.model.compute_collection', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_last_sync_time': type.OptionalType(type.IntegerType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'scope': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'DiscoveredResourceScope'))),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'cm_local_id': type.OptionalType(type.StringType()),
        'dpu_config': type.OptionalType(type.ReferenceType(__name__, 'ClusterDpuConfig')),
        'external_id': type.OptionalType(type.StringType()),
        'origin_id': type.OptionalType(type.StringType()),
        'origin_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'KeyValuePair'))),
        'origin_type': type.OptionalType(type.StringType()),
        'owner_id': type.OptionalType(type.StringType()),
        'owner_nsx': type.OptionalType(type.StringType()),
    },
    ComputeCollection,
    False,
    None))



class ComputeCollectionListResult(VapiStruct):
    """
    Compute Collection list result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ComputeCollection` or ``None``
        :param results: Compute Collection list results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ComputeCollectionListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.compute_collection_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ComputeCollection'))),
    },
    ComputeCollectionListResult,
    False,
    None))



class ComputeCollectionNetworkInterfacesListResult(VapiStruct):
    """
    List of network interfaces for all discovered nodes in compute collection

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`DiscoveredNodeNetworkInterfaces` or ``None``
        :param results: List of discovered node with network interfaces
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ComputeCollectionNetworkInterfacesListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.compute_collection_network_interfaces_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'DiscoveredNodeNetworkInterfaces'))),
    },
    ComputeCollectionNetworkInterfacesListResult,
    False,
    None))



class ComputeManager(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ACCESS_LEVEL_FOR_OIDC_FULL = "FULL"
    """


    """
    ACCESS_LEVEL_FOR_OIDC_LIMITED = "LIMITED"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'access_level_for_oidc': 'access_level_for_oidc',
                            'create_service_account': 'create_service_account',
                            'credential': 'credential',
                            'extension_certificate': 'extension_certificate',
                            'multi_nsx': 'multi_nsx',
                            'origin_properties': 'origin_properties',
                            'origin_type': 'origin_type',
                            'reverse_proxy_https_port': 'reverse_proxy_https_port',
                            'server': 'server',
                            'set_as_oidc_provider': 'set_as_oidc_provider',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 access_level_for_oidc=None,
                 create_service_account=None,
                 credential=None,
                 extension_certificate=None,
                 multi_nsx=None,
                 origin_properties=None,
                 origin_type=None,
                 reverse_proxy_https_port=None,
                 server=None,
                 set_as_oidc_provider=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  access_level_for_oidc: :class:`str` or ``None``
        :param access_level_for_oidc: Possible values are: 
            
            * :attr:`ComputeManager.ACCESS_LEVEL_FOR_OIDC_FULL`
            * :attr:`ComputeManager.ACCESS_LEVEL_FOR_OIDC_LIMITED`
            
            Specifies the maximum access level allowed for calls from compute
            manager to NSX using the OIDC provider.
        :type  create_service_account: :class:`bool` or ``None``
        :param create_service_account: Enable this flag to create service account user on compute manager.
            This is required by features such as vSphere Lifecycle Manager for
            authentication with vAPIs from nsx.
        :type  credential: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param credential: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`LoginCredential`. When methods return a value of this class
            as a return value, the attribute will contain all the attributes
            defined in :class:`LoginCredential`.
        :type  extension_certificate: :class:`CertificateData` or ``None``
        :param extension_certificate: 
        :type  multi_nsx: :class:`bool` or ``None``
        :param multi_nsx: Enable this flag to manage same compute manager by multiple nsx.
        :type  origin_properties: :class:`list` of :class:`KeyValuePair` or ``None``
        :param origin_properties: Key-Value map of additional specific properties of compute manager
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  origin_type: :class:`str` or ``None``
        :param origin_type: Compute manager type like vCenter
        :type  reverse_proxy_https_port: :class:`long` or ``None``
        :param reverse_proxy_https_port: Specifies https port of the reverse proxy to connect to compute
            manager. For e.g. In case of VC, this port can be retrieved from
            this config file /etc/vmware-rhttpproxy/config.xml. format: int64
        :type  server: :class:`str` or ``None``
        :param server: IP address or hostname of compute manager format: hostname-or-ip
        :type  set_as_oidc_provider: :class:`bool` or ``None``
        :param set_as_oidc_provider: If the compute manager is VC and need to set set as OIDC provider
            for NSX then this flag should be set as true. This is specific to
            wcp feature, should be enabled when this feature is being used.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.access_level_for_oidc = access_level_for_oidc
        self.create_service_account = create_service_account
        self.credential = credential
        self.extension_certificate = extension_certificate
        self.multi_nsx = multi_nsx
        self.origin_properties = origin_properties
        self.origin_type = origin_type
        self.reverse_proxy_https_port = reverse_proxy_https_port
        self.server = server
        self.set_as_oidc_provider = set_as_oidc_provider
        VapiStruct.__init__(self)


ComputeManager._set_binding_type(type.StructType(
    'com.vmware.nsx.model.compute_manager', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'access_level_for_oidc': type.OptionalType(type.StringType()),
        'create_service_account': type.OptionalType(type.BooleanType()),
        'credential': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'LoginCredential')])),
        'extension_certificate': type.OptionalType(type.ReferenceType(__name__, 'CertificateData')),
        'multi_nsx': type.OptionalType(type.BooleanType()),
        'origin_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'KeyValuePair'))),
        'origin_type': type.OptionalType(type.StringType()),
        'reverse_proxy_https_port': type.OptionalType(type.IntegerType()),
        'server': type.OptionalType(type.StringType()),
        'set_as_oidc_provider': type.OptionalType(type.BooleanType()),
    },
    ComputeManager,
    False,
    None))



class ComputeManagerListResult(VapiStruct):
    """
    List of compute managers

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ComputeManager` or ``None``
        :param results: List of compute managers
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ComputeManagerListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.compute_manager_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ComputeManager'))),
    },
    ComputeManagerListResult,
    False,
    None))



class ComputeManagerStatus(VapiStruct):
    """
    Runtime status information of the compute manager

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CONNECTION_STATUS_UP = "UP"
    """


    """
    CONNECTION_STATUS_DOWN = "DOWN"
    """


    """
    CONNECTION_STATUS_CONNECTING = "CONNECTING"
    """


    """
    REGISTRATION_STATUS_REGISTERED = "REGISTERED"
    """


    """
    REGISTRATION_STATUS_UNREGISTERED = "UNREGISTERED"
    """


    """
    REGISTRATION_STATUS_REGISTERING = "REGISTERING"
    """


    """
    REGISTRATION_STATUS_REGISTERED_WITH_ERRORS = "REGISTERED_WITH_ERRORS"
    """


    """



    _canonical_to_pep_names = {
                            'connection_errors': 'connection_errors',
                            'connection_status': 'connection_status',
                            'connection_status_details': 'connection_status_details',
                            'last_sync_time': 'last_sync_time',
                            'oidc_end_point_id': 'oidc_end_point_id',
                            'registration_errors': 'registration_errors',
                            'registration_status': 'registration_status',
                            'version': 'version',
                            }

    def __init__(self,
                 connection_errors=None,
                 connection_status=None,
                 connection_status_details=None,
                 last_sync_time=None,
                 oidc_end_point_id=None,
                 registration_errors=None,
                 registration_status=None,
                 version=None,
                ):
        """
        :type  connection_errors: :class:`list` of :class:`ErrorInfo` or ``None``
        :param connection_errors: Errors when connecting with compute manager
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  connection_status: :class:`str` or ``None``
        :param connection_status: Possible values are: 
            
            * :attr:`ComputeManagerStatus.CONNECTION_STATUS_UP`
            * :attr:`ComputeManagerStatus.CONNECTION_STATUS_DOWN`
            * :attr:`ComputeManagerStatus.CONNECTION_STATUS_CONNECTING`
            
            Status of connection with the compute manager
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  connection_status_details: :class:`str` or ``None``
        :param connection_status_details: Details about connection status
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_sync_time: :class:`long` or ``None``
        :param last_sync_time: Timestamp of the last successful update of Inventory, in epoch
            milliseconds. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  oidc_end_point_id: :class:`str` or ``None``
        :param oidc_end_point_id: If Compute manager is trusted as authorization server, then this Id
            will be Id of corresponding oidc end point.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  registration_errors: :class:`list` of :class:`ErrorInfo` or ``None``
        :param registration_errors: Errors when registering with compute manager
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  registration_status: :class:`str` or ``None``
        :param registration_status: Possible values are: 
            
            * :attr:`ComputeManagerStatus.REGISTRATION_STATUS_REGISTERED`
            * :attr:`ComputeManagerStatus.REGISTRATION_STATUS_UNREGISTERED`
            * :attr:`ComputeManagerStatus.REGISTRATION_STATUS_REGISTERING`
            *
              :attr:`ComputeManagerStatus.REGISTRATION_STATUS_REGISTERED_WITH_ERRORS`
            
            Registration status of compute manager
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  version: :class:`str` or ``None``
        :param version: Version of the compute manager
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.connection_errors = connection_errors
        self.connection_status = connection_status
        self.connection_status_details = connection_status_details
        self.last_sync_time = last_sync_time
        self.oidc_end_point_id = oidc_end_point_id
        self.registration_errors = registration_errors
        self.registration_status = registration_status
        self.version = version
        VapiStruct.__init__(self)


ComputeManagerStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.compute_manager_status', {
        'connection_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ErrorInfo'))),
        'connection_status': type.OptionalType(type.StringType()),
        'connection_status_details': type.OptionalType(type.StringType()),
        'last_sync_time': type.OptionalType(type.IntegerType()),
        'oidc_end_point_id': type.OptionalType(type.StringType()),
        'registration_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ErrorInfo'))),
        'registration_status': type.OptionalType(type.StringType()),
        'version': type.OptionalType(type.StringType()),
    },
    ComputeManagerStatus,
    False,
    None))



class ComputeManagerTopology(VapiStruct):
    """
    Details where NVDS will be migrated to

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'compute_manager_id': 'compute_manager_id',
                            'dvswitch': 'dvswitch',
                            }

    def __init__(self,
                 compute_manager_id=None,
                 dvswitch=None,
                ):
        """
        :type  compute_manager_id: :class:`str` or ``None``
        :param compute_manager_id: Identifier of vcenter where VDS will be created
        :type  dvswitch: :class:`list` of :class:`VdsTopology` or ``None``
        :param dvswitch: Datacenter, VDS mapping
        """
        self.compute_manager_id = compute_manager_id
        self.dvswitch = dvswitch
        VapiStruct.__init__(self)


ComputeManagerTopology._set_binding_type(type.StructType(
    'com.vmware.nsx.model.compute_manager_topology', {
        'compute_manager_id': type.OptionalType(type.StringType()),
        'dvswitch': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'VdsTopology'))),
    },
    ComputeManagerTopology,
    False,
    None))



class ConditionalForwarderZone(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'source_ip': 'source_ip',
                            'upstream_servers': 'upstream_servers',
                            'domain_names': 'domain_names',
                            }

    def __init__(self,
                 source_ip=None,
                 upstream_servers=None,
                 domain_names=None,
                ):
        """
        :type  source_ip: :class:`str` or ``None``
        :param source_ip: The source ip used by the fowarder of the zone. If no source ip
            specified, the ip address of listener of the DNS forwarder will be
            used. format: ipv4
        :type  upstream_servers: :class:`list` of :class:`str` or ``None``
        :param upstream_servers: Ip address of the upstream DNS servers the DNS forwarder accesses.
            format: ipv4
        :type  domain_names: :class:`list` of :class:`str` or ``None``
        :param domain_names: A forwarder domain name should be a valid FQDN. If reverse lookup
            is needed for this zone, reverse lookup domain name like
            X.in-addr.arpa can be defined. Here the X represents a subnet.
        """
        self.source_ip = source_ip
        self.upstream_servers = upstream_servers
        self.domain_names = domain_names
        VapiStruct.__init__(self)


ConditionalForwarderZone._set_binding_type(type.StructType(
    'com.vmware.nsx.model.conditional_forwarder_zone', {
        'source_ip': type.OptionalType(type.StringType()),
        'upstream_servers': type.OptionalType(type.ListType(type.StringType())),
        'domain_names': type.OptionalType(type.ListType(type.StringType())),
    },
    ConditionalForwarderZone,
    False,
    None))



class ConfigurationState(VapiStruct):
    """
    Describes status of configuration of an entity

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATE_PENDING = "pending"
    """


    """
    STATE_IN_PROGRESS = "in_progress"
    """


    """
    STATE_SUCCESS = "success"
    """


    """
    STATE_FAILED = "failed"
    """


    """
    STATE_PARTIAL_SUCCESS = "partial_success"
    """


    """
    STATE_ORPHANED = "orphaned"
    """


    """
    STATE_UNKNOWN = "unknown"
    """


    """
    STATE_ERROR = "error"
    """


    """
    STATE_IN_SYNC = "in_sync"
    """


    """
    STATE_NOT_AVAILABLE = "NOT_AVAILABLE"
    """


    """
    STATE_VM_DEPLOYMENT_QUEUED = "VM_DEPLOYMENT_QUEUED"
    """


    """
    STATE_VM_DEPLOYMENT_IN_PROGRESS = "VM_DEPLOYMENT_IN_PROGRESS"
    """


    """
    STATE_VM_DEPLOYMENT_FAILED = "VM_DEPLOYMENT_FAILED"
    """


    """
    STATE_VM_POWER_ON_IN_PROGRESS = "VM_POWER_ON_IN_PROGRESS"
    """


    """
    STATE_VM_POWER_ON_FAILED = "VM_POWER_ON_FAILED"
    """


    """
    STATE_REGISTRATION_PENDING = "REGISTRATION_PENDING"
    """


    """
    STATE_NODE_NOT_READY = "NODE_NOT_READY"
    """


    """
    STATE_NODE_READY = "NODE_READY"
    """


    """
    STATE_VM_POWER_OFF_IN_PROGRESS = "VM_POWER_OFF_IN_PROGRESS"
    """


    """
    STATE_VM_POWER_OFF_FAILED = "VM_POWER_OFF_FAILED"
    """


    """
    STATE_VM_UNDEPLOY_IN_PROGRESS = "VM_UNDEPLOY_IN_PROGRESS"
    """


    """
    STATE_VM_UNDEPLOY_FAILED = "VM_UNDEPLOY_FAILED"
    """


    """
    STATE_VM_UNDEPLOY_SUCCESSFUL = "VM_UNDEPLOY_SUCCESSFUL"
    """


    """
    STATE_EDGE_CONFIG_ERROR = "EDGE_CONFIG_ERROR"
    """


    """
    STATE_VM_DEPLOYMENT_RESTARTED = "VM_DEPLOYMENT_RESTARTED"
    """


    """
    STATE_REGISTRATION_FAILED = "REGISTRATION_FAILED"
    """


    """
    STATE_TRANSPORT_NODE_SYNC_PENDING = "TRANSPORT_NODE_SYNC_PENDING"
    """


    """
    STATE_TRANSPORT_NODE_CONFIGURATION_MISSING = "TRANSPORT_NODE_CONFIGURATION_MISSING"
    """


    """
    STATE_EDGE_HARDWARE_NOT_SUPPORTED = "EDGE_HARDWARE_NOT_SUPPORTED"
    """


    """
    STATE_MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED = "MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED"
    """


    """
    STATE_TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER = "TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER"
    """


    """
    STATE_TZ_ENDPOINTS_NOT_SPECIFIED = "TZ_ENDPOINTS_NOT_SPECIFIED"
    """


    """
    STATE_NO_PNIC_PREPARED_IN_EDGE = "NO_PNIC_PREPARED_IN_EDGE"
    """


    """
    STATE_APPLIANCE_INTERNAL_ERROR = "APPLIANCE_INTERNAL_ERROR"
    """


    """
    STATE_VTEP_DHCP_NOT_SUPPORTED = "VTEP_DHCP_NOT_SUPPORTED"
    """


    """
    STATE_UNSUPPORTED_HOST_SWITCH_PROFILE = "UNSUPPORTED_HOST_SWITCH_PROFILE"
    """


    """
    STATE_UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED = "UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED"
    """


    """
    STATE_HOSTSWITCH_PROFILE_NOT_FOUND = "HOSTSWITCH_PROFILE_NOT_FOUND"
    """


    """
    STATE_LLDP_SEND_ENABLED_NOT_SUPPORTED = "LLDP_SEND_ENABLED_NOT_SUPPORTED"
    """


    """
    STATE_UNSUPPORTED_NAMED_TEAMING_POLICY = "UNSUPPORTED_NAMED_TEAMING_POLICY"
    """


    """
    STATE_LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM = "LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM"
    """


    """
    STATE_LACP_NOT_SUPPORTED_FOR_EDGE_VM = "LACP_NOT_SUPPORTED_FOR_EDGE_VM"
    """


    """
    STATE_STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM = "STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM"
    """


    """
    STATE_MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE = "MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE"
    """


    """
    STATE_UNSUPPORTED_LACP_LB_ALGO_FOR_NODE = "UNSUPPORTED_LACP_LB_ALGO_FOR_NODE"
    """


    """
    STATE_EDGE_NODE_VERSION_NOT_SUPPORTED = "EDGE_NODE_VERSION_NOT_SUPPORTED"
    """


    """
    STATE_NO_PNIC_SPECIFIED_IN_TN = "NO_PNIC_SPECIFIED_IN_TN"
    """


    """
    STATE_INVALID_PNIC_DEVICE_NAME = "INVALID_PNIC_DEVICE_NAME"
    """


    """
    STATE_TRANSPORT_NODE_READY = "TRANSPORT_NODE_READY"
    """


    """
    STATE_VM_NETWORK_EDIT_PENDING = "VM_NETWORK_EDIT_PENDING"
    """


    """
    STATE_UNSUPPORTED_DEFAULT_TEAMING_POLICY = "UNSUPPORTED_DEFAULT_TEAMING_POLICY"
    """


    """
    STATE_MPA_DISCONNECTED = "MPA_DISCONNECTED"
    """


    """
    STATE_VM_RENAME_PENDING = "VM_RENAME_PENDING"
    """


    """
    STATE_VM_CONFIG_EDIT_PENDING = "VM_CONFIG_EDIT_PENDING"
    """


    """
    STATE_VM_NETWORK_EDIT_FAILED = "VM_NETWORK_EDIT_FAILED"
    """


    """
    STATE_VM_RENAME_FAILED = "VM_RENAME_FAILED"
    """


    """
    STATE_VM_CONFIG_EDIT_FAILED = "VM_CONFIG_EDIT_FAILED"
    """


    """
    STATE_VM_CONFIG_DISCREPANCY = "VM_CONFIG_DISCREPANCY"
    """


    """
    STATE_VM_NODE_REFRESH_FAILED = "VM_NODE_REFRESH_FAILED"
    """


    """
    STATE_VM_PLACEMENT_REFRESH_FAILED = "VM_PLACEMENT_REFRESH_FAILED"
    """


    """
    STATE_REGISTRATION_TIMEDOUT = "REGISTRATION_TIMEDOUT"
    """


    """
    STATE_REPLACE_FAILED = "REPLACE_FAILED"
    """


    """
    STATE_UPLINK_FROM_TEAMING_POLICY_NOT_MAPPED = "UPLINK_FROM_TEAMING_POLICY_NOT_MAPPED"
    """


    """
    STATE_LOGICAL_SWITCH_NAMED_TEAMING_HAS_NO_PNIC_BACKING = "LOGICAL_SWITCH_NAMED_TEAMING_HAS_NO_PNIC_BACKING"
    """


    """
    STATE_DELETE_VM_IN_REDEPLOY_FAILED = "DELETE_VM_IN_REDEPLOY_FAILED"
    """


    """
    STATE_DEPLOY_VM_IN_REDEPLOY_FAILED = "DEPLOY_VM_IN_REDEPLOY_FAILED"
    """


    """
    STATE_INSUFFICIENT_RESOURCES_IN_EDGE_NODE_FOR_SERVICE = "INSUFFICIENT_RESOURCES_IN_EDGE_NODE_FOR_SERVICE"
    """


    """
    STATE_VM_RESOURCE_RESERVATION_FAILED = "VM_RESOURCE_RESERVATION_FAILED"
    """


    """
    STATE_DUPLICATE_PNICS_IN_TEAMINGS_WITH_MULTIPLE_UPLINKS_AND_FAILOVER_ORDER = "DUPLICATE_PNICS_IN_TEAMINGS_WITH_MULTIPLE_UPLINKS_AND_FAILOVER_ORDER"
    """


    """
    STATE_DUPLICATE_VLANS_SHARING_SAME_PNICMULTIPLE_UPLINKS_IN_NAMED_TEAMING_NOT_SUPPORTED_IF_UPLINK_IN_DEFAULT_TEAMING = "DUPLICATE_VLANS_SHARING_SAME_PNICMULTIPLE_UPLINKS_IN_NAMED_TEAMING_NOT_SUPPORTED_IF_UPLINK_IN_DEFAULT_TEAMING"
    """


    """
    STATE_EDGE_NODE_SETTINGS_MISMATCH_RESOLVE = "EDGE_NODE_SETTINGS_MISMATCH_RESOLVE"
    """


    """
    STATE_EDGE_VM_VSPHERE_SETTINGS_MISMATCH_RESOLVE = "EDGE_VM_VSPHERE_SETTINGS_MISMATCH_RESOLVE"
    """


    """
    STATE_EDGE_NODE_SETTINGS_AND_VSPHERE_SETTINGS_ARE_CHANGED_RESOLVE = "EDGE_NODE_SETTINGS_AND_VSPHERE_SETTINGS_ARE_CHANGED_RESOLVE"
    """


    """
    STATE_EDGE_VSPHERE_LOCATION_MISMATCH_RESOLVE = "EDGE_VSPHERE_LOCATION_MISMATCH_RESOLVE"
    """


    """
    STATE_COMPUTE_MANAGER_NOT_FOUND = "COMPUTE_MANAGER_NOT_FOUND"
    """


    """
    STATE_DELETE_IN_PROGRESS = "DELETE_IN_PROGRESS"
    """


    """
    STATE_ADVANCED_CONFIG_EDIT_FAILED = "ADVANCED_CONFIG_EDIT_FAILED"
    """


    """
    STATE_UPT_MODE_REALIZATION_POLL_TIMED_OUT = "UPT_MODE_REALIZATION_POLL_TIMED_OUT"
    """


    """
    STATE_DATAPATH_CONFIGURATION_EDIT_FAILED = "DATAPATH_CONFIGURATION_EDIT_FAILED"
    """


    """
    STATE_MAINTENANCE_MODE_ENABLED = "MAINTENANCE_MODE_ENABLED"
    """


    """
    STATE_ERROR_IN_ENABLE_MAINTENANCE_MODE = "ERROR_IN_ENABLE_MAINTENANCE_MODE"
    """


    """
    STATE_ERROR_IN_DISABLE_MAINTENANCE_MODE = "ERROR_IN_DISABLE_MAINTENANCE_MODE"
    """


    """
    STATE_CONFIGURE_UPT_ON_VM_FAILED = "CONFIGURE_UPT_ON_VM_FAILED"
    """


    """
    STATE_VM_VERSION_IS_UPT_INCOMPATIBLE = "VM_VERSION_IS_UPT_INCOMPATIBLE"
    """


    """
    STATE_DELETE_FAILED_FOR_DIFFERENT_MOREF_ID = "DELETE_FAILED_FOR_DIFFERENT_MOREF_ID"
    """


    """
    STATE_DELETE_FAILED_ON_VM_NOT_FOUND = "DELETE_FAILED_ON_VM_NOT_FOUND"
    """


    """
    STATE_DELETE_FAILED_FOR_NON_LCM_EDGE = "DELETE_FAILED_FOR_NON_LCM_EDGE"
    """


    """
    STATE_ADVANCED_CONFIG_EDIT_PENDING = "ADVANCED_CONFIG_EDIT_PENDING"
    """


    """
    STATE_DUPLICATE_VLANS_SHARING_SAME_PNIC = "DUPLICATE_VLANS_SHARING_SAME_PNIC"
    """


    """
    STATE_MULTIPLE_UPLINKS_IN_NAMED_TEAMING_NOT_SUPPORTED_IF_UPLINK_IN_DEFAULT_TEAMING = "MULTIPLE_UPLINKS_IN_NAMED_TEAMING_NOT_SUPPORTED_IF_UPLINK_IN_DEFAULT_TEAMING"
    """


    """
    STATE_REDEPLOY_ACTIVITY_FAILED = "REDEPLOY_ACTIVITY_FAILED"
    """


    """
    STATE_REDEPLOY_ACTIVITY_IN_PROGRESS = "REDEPLOY_ACTIVITY_IN_PROGRESS"
    """


    """
    STATE_REDEPLOY_ACTIVITY_SCHEDULED = "REDEPLOY_ACTIVITY_SCHEDULED"
    """


    """
    STATE_REDEPLOY_ACTIVITY_SUCCESSFUL = "REDEPLOY_ACTIVITY_SUCCESSFUL"
    """


    """
    STATE_REPLACE_ACTIVITY_FAILED = "REPLACE_ACTIVITY_FAILED"
    """


    """
    STATE_REPLACE_ACTIVITY_IN_PROGRESS = "REPLACE_ACTIVITY_IN_PROGRESS"
    """


    """
    STATE_REPLACE_ACTIVITY_SCHEDULED = "REPLACE_ACTIVITY_SCHEDULED"
    """


    """
    STATE_REPLACE_ACTIVITY_SUCCESSFUL = "REPLACE_ACTIVITY_SUCCESSFUL"
    """


    """
    STATE_REPLACED_RPC_CLIENT_OF_TN = "REPLACED_RPC_CLIENT_OF_TN"
    """


    """
    STATE_RETRYING_REPLACE = "RETRYING_REPLACE"
    """


    """
    STATE_UNABLE_TO_DELETE_EDGE_NODE_VM_INTERNAL_ERROR = "UNABLE_TO_DELETE_EDGE_NODE_VM_INTERNAL_ERROR"
    """


    """
    STATE_VM_REDEPLOY_FAILED = "VM_REDEPLOY_FAILED"
    """


    """
    STATE_VM_RESOURCE_RESERVATION_EDIT_PENDING = "VM_RESOURCE_RESERVATION_EDIT_PENDING"
    """


    """
    STATE_REDEPLOYED_VM_REGISTRATION_PENDING = "REDEPLOYED_VM_REGISTRATION_PENDING"
    """


    """



    _canonical_to_pep_names = {
                            'details': 'details',
                            'failure_code': 'failure_code',
                            'failure_message': 'failure_message',
                            'state': 'state',
                            }

    def __init__(self,
                 details=None,
                 failure_code=None,
                 failure_message=None,
                 state=None,
                ):
        """
        :type  details: :class:`list` of :class:`ConfigurationStateElement` or ``None``
        :param details: Array of configuration state of various sub systems
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  failure_code: :class:`long` or ``None``
        :param failure_code: Error code format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  failure_message: :class:`str` or ``None``
        :param failure_message: Error message in case of failure
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  state: :class:`str` or ``None``
        :param state: Possible values are: 
            
            * :attr:`ConfigurationState.STATE_PENDING`
            * :attr:`ConfigurationState.STATE_IN_PROGRESS`
            * :attr:`ConfigurationState.STATE_SUCCESS`
            * :attr:`ConfigurationState.STATE_FAILED`
            * :attr:`ConfigurationState.STATE_PARTIAL_SUCCESS`
            * :attr:`ConfigurationState.STATE_ORPHANED`
            * :attr:`ConfigurationState.STATE_UNKNOWN`
            * :attr:`ConfigurationState.STATE_ERROR`
            * :attr:`ConfigurationState.STATE_IN_SYNC`
            * :attr:`ConfigurationState.STATE_NOT_AVAILABLE`
            * :attr:`ConfigurationState.STATE_VM_DEPLOYMENT_QUEUED`
            * :attr:`ConfigurationState.STATE_VM_DEPLOYMENT_IN_PROGRESS`
            * :attr:`ConfigurationState.STATE_VM_DEPLOYMENT_FAILED`
            * :attr:`ConfigurationState.STATE_VM_POWER_ON_IN_PROGRESS`
            * :attr:`ConfigurationState.STATE_VM_POWER_ON_FAILED`
            * :attr:`ConfigurationState.STATE_REGISTRATION_PENDING`
            * :attr:`ConfigurationState.STATE_NODE_NOT_READY`
            * :attr:`ConfigurationState.STATE_NODE_READY`
            * :attr:`ConfigurationState.STATE_VM_POWER_OFF_IN_PROGRESS`
            * :attr:`ConfigurationState.STATE_VM_POWER_OFF_FAILED`
            * :attr:`ConfigurationState.STATE_VM_UNDEPLOY_IN_PROGRESS`
            * :attr:`ConfigurationState.STATE_VM_UNDEPLOY_FAILED`
            * :attr:`ConfigurationState.STATE_VM_UNDEPLOY_SUCCESSFUL`
            * :attr:`ConfigurationState.STATE_EDGE_CONFIG_ERROR`
            * :attr:`ConfigurationState.STATE_VM_DEPLOYMENT_RESTARTED`
            * :attr:`ConfigurationState.STATE_REGISTRATION_FAILED`
            * :attr:`ConfigurationState.STATE_TRANSPORT_NODE_SYNC_PENDING`
            *
              :attr:`ConfigurationState.STATE_TRANSPORT_NODE_CONFIGURATION_MISSING`
            * :attr:`ConfigurationState.STATE_EDGE_HARDWARE_NOT_SUPPORTED`
            *
              :attr:`ConfigurationState.STATE_MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED`
            *
              :attr:`ConfigurationState.STATE_TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER`
            * :attr:`ConfigurationState.STATE_TZ_ENDPOINTS_NOT_SPECIFIED`
            * :attr:`ConfigurationState.STATE_NO_PNIC_PREPARED_IN_EDGE`
            * :attr:`ConfigurationState.STATE_APPLIANCE_INTERNAL_ERROR`
            * :attr:`ConfigurationState.STATE_VTEP_DHCP_NOT_SUPPORTED`
            * :attr:`ConfigurationState.STATE_UNSUPPORTED_HOST_SWITCH_PROFILE`
            *
              :attr:`ConfigurationState.STATE_UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED`
            * :attr:`ConfigurationState.STATE_HOSTSWITCH_PROFILE_NOT_FOUND`
            * :attr:`ConfigurationState.STATE_LLDP_SEND_ENABLED_NOT_SUPPORTED`
            * :attr:`ConfigurationState.STATE_UNSUPPORTED_NAMED_TEAMING_POLICY`
            *
              :attr:`ConfigurationState.STATE_LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM`
            * :attr:`ConfigurationState.STATE_LACP_NOT_SUPPORTED_FOR_EDGE_VM`
            *
              :attr:`ConfigurationState.STATE_STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM`
            *
              :attr:`ConfigurationState.STATE_MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE`
            *
              :attr:`ConfigurationState.STATE_UNSUPPORTED_LACP_LB_ALGO_FOR_NODE`
            * :attr:`ConfigurationState.STATE_EDGE_NODE_VERSION_NOT_SUPPORTED`
            * :attr:`ConfigurationState.STATE_NO_PNIC_SPECIFIED_IN_TN`
            * :attr:`ConfigurationState.STATE_INVALID_PNIC_DEVICE_NAME`
            * :attr:`ConfigurationState.STATE_TRANSPORT_NODE_READY`
            * :attr:`ConfigurationState.STATE_VM_NETWORK_EDIT_PENDING`
            *
              :attr:`ConfigurationState.STATE_UNSUPPORTED_DEFAULT_TEAMING_POLICY`
            * :attr:`ConfigurationState.STATE_MPA_DISCONNECTED`
            * :attr:`ConfigurationState.STATE_VM_RENAME_PENDING`
            * :attr:`ConfigurationState.STATE_VM_CONFIG_EDIT_PENDING`
            * :attr:`ConfigurationState.STATE_VM_NETWORK_EDIT_FAILED`
            * :attr:`ConfigurationState.STATE_VM_RENAME_FAILED`
            * :attr:`ConfigurationState.STATE_VM_CONFIG_EDIT_FAILED`
            * :attr:`ConfigurationState.STATE_VM_CONFIG_DISCREPANCY`
            * :attr:`ConfigurationState.STATE_VM_NODE_REFRESH_FAILED`
            * :attr:`ConfigurationState.STATE_VM_PLACEMENT_REFRESH_FAILED`
            * :attr:`ConfigurationState.STATE_REGISTRATION_TIMEDOUT`
            * :attr:`ConfigurationState.STATE_REPLACE_FAILED`
            *
              :attr:`ConfigurationState.STATE_UPLINK_FROM_TEAMING_POLICY_NOT_MAPPED`
            *
              :attr:`ConfigurationState.STATE_LOGICAL_SWITCH_NAMED_TEAMING_HAS_NO_PNIC_BACKING`
            * :attr:`ConfigurationState.STATE_DELETE_VM_IN_REDEPLOY_FAILED`
            * :attr:`ConfigurationState.STATE_DEPLOY_VM_IN_REDEPLOY_FAILED`
            *
              :attr:`ConfigurationState.STATE_INSUFFICIENT_RESOURCES_IN_EDGE_NODE_FOR_SERVICE`
            * :attr:`ConfigurationState.STATE_VM_RESOURCE_RESERVATION_FAILED`
            *
              :attr:`ConfigurationState.STATE_DUPLICATE_PNICS_IN_TEAMINGS_WITH_MULTIPLE_UPLINKS_AND_FAILOVER_ORDER`
            *
              :attr:`ConfigurationState.STATE_DUPLICATE_VLANS_SHARING_SAME_PNICMULTIPLE_UPLINKS_IN_NAMED_TEAMING_NOT_SUPPORTED_IF_UPLINK_IN_DEFAULT_TEAMING`
            *
              :attr:`ConfigurationState.STATE_EDGE_NODE_SETTINGS_MISMATCH_RESOLVE`
            *
              :attr:`ConfigurationState.STATE_EDGE_VM_VSPHERE_SETTINGS_MISMATCH_RESOLVE`
            *
              :attr:`ConfigurationState.STATE_EDGE_NODE_SETTINGS_AND_VSPHERE_SETTINGS_ARE_CHANGED_RESOLVE`
            *
              :attr:`ConfigurationState.STATE_EDGE_VSPHERE_LOCATION_MISMATCH_RESOLVE`
            * :attr:`ConfigurationState.STATE_COMPUTE_MANAGER_NOT_FOUND`
            * :attr:`ConfigurationState.STATE_DELETE_IN_PROGRESS`
            * :attr:`ConfigurationState.STATE_ADVANCED_CONFIG_EDIT_FAILED`
            *
              :attr:`ConfigurationState.STATE_UPT_MODE_REALIZATION_POLL_TIMED_OUT`
            *
              :attr:`ConfigurationState.STATE_DATAPATH_CONFIGURATION_EDIT_FAILED`
            * :attr:`ConfigurationState.STATE_MAINTENANCE_MODE_ENABLED`
            * :attr:`ConfigurationState.STATE_ERROR_IN_ENABLE_MAINTENANCE_MODE`
            *
              :attr:`ConfigurationState.STATE_ERROR_IN_DISABLE_MAINTENANCE_MODE`
            * :attr:`ConfigurationState.STATE_CONFIGURE_UPT_ON_VM_FAILED`
            * :attr:`ConfigurationState.STATE_VM_VERSION_IS_UPT_INCOMPATIBLE`
            *
              :attr:`ConfigurationState.STATE_DELETE_FAILED_FOR_DIFFERENT_MOREF_ID`
            * :attr:`ConfigurationState.STATE_DELETE_FAILED_ON_VM_NOT_FOUND`
            * :attr:`ConfigurationState.STATE_DELETE_FAILED_FOR_NON_LCM_EDGE`
            * :attr:`ConfigurationState.STATE_ADVANCED_CONFIG_EDIT_PENDING`
            *
              :attr:`ConfigurationState.STATE_DUPLICATE_VLANS_SHARING_SAME_PNIC`
            *
              :attr:`ConfigurationState.STATE_MULTIPLE_UPLINKS_IN_NAMED_TEAMING_NOT_SUPPORTED_IF_UPLINK_IN_DEFAULT_TEAMING`
            * :attr:`ConfigurationState.STATE_REDEPLOY_ACTIVITY_FAILED`
            * :attr:`ConfigurationState.STATE_REDEPLOY_ACTIVITY_IN_PROGRESS`
            * :attr:`ConfigurationState.STATE_REDEPLOY_ACTIVITY_SCHEDULED`
            * :attr:`ConfigurationState.STATE_REDEPLOY_ACTIVITY_SUCCESSFUL`
            * :attr:`ConfigurationState.STATE_REPLACE_ACTIVITY_FAILED`
            * :attr:`ConfigurationState.STATE_REPLACE_ACTIVITY_IN_PROGRESS`
            * :attr:`ConfigurationState.STATE_REPLACE_ACTIVITY_SCHEDULED`
            * :attr:`ConfigurationState.STATE_REPLACE_ACTIVITY_SUCCESSFUL`
            * :attr:`ConfigurationState.STATE_REPLACED_RPC_CLIENT_OF_TN`
            * :attr:`ConfigurationState.STATE_RETRYING_REPLACE`
            *
              :attr:`ConfigurationState.STATE_UNABLE_TO_DELETE_EDGE_NODE_VM_INTERNAL_ERROR`
            * :attr:`ConfigurationState.STATE_VM_REDEPLOY_FAILED`
            *
              :attr:`ConfigurationState.STATE_VM_RESOURCE_RESERVATION_EDIT_PENDING`
            *
              :attr:`ConfigurationState.STATE_REDEPLOYED_VM_REGISTRATION_PENDING`
            
            Gives details of state of desired configuration. Additional enums
            with more details on progress/success/error states are sent for
            edge node. The success states are NODE_READY and
            TRANSPORT_NODE_READY, pending states are {VM_DEPLOYMENT_QUEUED,
            VM_DEPLOYMENT_IN_PROGRESS, REGISTRATION_PENDING} and other values
            indicate failures. \"in_sync\" state indicates that the desired
            configuration has been received by the host to which it applies,
            but is not yet in effect. When the configuration is actually in
            effect, the state will change to \"success\". Please note, failed
            state is deprecated.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.details = details
        self.failure_code = failure_code
        self.failure_message = failure_message
        self.state = state
        VapiStruct.__init__(self)


ConfigurationState._set_binding_type(type.StructType(
    'com.vmware.nsx.model.configuration_state', {
        'details': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ConfigurationStateElement'))),
        'failure_code': type.OptionalType(type.IntegerType()),
        'failure_message': type.OptionalType(type.StringType()),
        'state': type.OptionalType(type.StringType()),
    },
    ConfigurationState,
    False,
    None))



class ConfigurationStateElement(VapiStruct):
    """
    Describes status of configuration of an entity

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATE_IN_PROGRESS = "in_progress"
    """


    """
    STATE_SUCCESS = "success"
    """


    """
    STATE_FAILED = "failed"
    """


    """
    STATE_PARTIAL_SUCCESS = "partial_success"
    """


    """
    STATE_IN_SYNC = "in_sync"
    """


    """
    STATE_VM_DEPLOYMENT_FAILED = "VM_DEPLOYMENT_FAILED"
    """


    """
    STATE_VM_POWER_ON_FAILED = "VM_POWER_ON_FAILED"
    """


    """
    STATE_VM_POWER_OFF_FAILED = "VM_POWER_OFF_FAILED"
    """


    """
    STATE_VM_UNDEPLOY_FAILED = "VM_UNDEPLOY_FAILED"
    """


    """
    STATE_REPLACE_FAILED = "REPLACE_FAILED"
    """


    """
    STATE_UPLINK_FROM_TEAMING_POLICY_NOT_MAPPED = "UPLINK_FROM_TEAMING_POLICY_NOT_MAPPED"
    """


    """
    STATE_LOGICAL_SWITCH_NAMED_TEAMING_HAS_NO_PNIC_BACKING = "LOGICAL_SWITCH_NAMED_TEAMING_HAS_NO_PNIC_BACKING"
    """


    """
    STATE_DELETE_VM_IN_REDEPLOY_FAILED = "DELETE_VM_IN_REDEPLOY_FAILED"
    """


    """
    STATE_DEPLOY_VM_IN_REDEPLOY_FAILED = "DEPLOY_VM_IN_REDEPLOY_FAILED"
    """


    """
    STATE_INSUFFICIENT_RESOURCES_IN_EDGE_NODE_FOR_SERVICE = "INSUFFICIENT_RESOURCES_IN_EDGE_NODE_FOR_SERVICE"
    """


    """
    STATE_EDGE_CONFIG_ERROR = "EDGE_CONFIG_ERROR"
    """


    """
    STATE_REGISTRATION_FAILED = "REGISTRATION_FAILED"
    """


    """
    STATE_TRANSPORT_NODE_CONFIGURATION_MISSING = "TRANSPORT_NODE_CONFIGURATION_MISSING"
    """


    """
    STATE_EDGE_HARDWARE_NOT_SUPPORTED = "EDGE_HARDWARE_NOT_SUPPORTED"
    """


    """
    STATE_MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED = "MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED"
    """


    """
    STATE_TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER = "TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER"
    """


    """
    STATE_TZ_ENDPOINTS_NOT_SPECIFIED = "TZ_ENDPOINTS_NOT_SPECIFIED"
    """


    """
    STATE_NO_PNIC_PREPARED_IN_EDGE = "NO_PNIC_PREPARED_IN_EDGE"
    """


    """
    STATE_APPLIANCE_INTERNAL_ERROR = "APPLIANCE_INTERNAL_ERROR"
    """


    """
    STATE_VTEP_DHCP_NOT_SUPPORTED = "VTEP_DHCP_NOT_SUPPORTED"
    """


    """
    STATE_UNSUPPORTED_HOST_SWITCH_PROFILE = "UNSUPPORTED_HOST_SWITCH_PROFILE"
    """


    """
    STATE_UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED = "UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED"
    """


    """
    STATE_HOSTSWITCH_PROFILE_NOT_FOUND = "HOSTSWITCH_PROFILE_NOT_FOUND"
    """


    """
    STATE_LLDP_SEND_ENABLED_NOT_SUPPORTED = "LLDP_SEND_ENABLED_NOT_SUPPORTED"
    """


    """
    STATE_UNSUPPORTED_NAMED_TEAMING_POLICY = "UNSUPPORTED_NAMED_TEAMING_POLICY"
    """


    """
    STATE_LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM = "LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM"
    """


    """
    STATE_LACP_NOT_SUPPORTED_FOR_EDGE_VM = "LACP_NOT_SUPPORTED_FOR_EDGE_VM"
    """


    """
    STATE_STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM = "STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM"
    """


    """
    STATE_MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE = "MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE"
    """


    """
    STATE_UNSUPPORTED_LACP_LB_ALGO_FOR_NODE = "UNSUPPORTED_LACP_LB_ALGO_FOR_NODE"
    """


    """
    STATE_EDGE_NODE_VERSION_NOT_SUPPORTED = "EDGE_NODE_VERSION_NOT_SUPPORTED"
    """


    """
    STATE_NO_PNIC_SPECIFIED_IN_TN = "NO_PNIC_SPECIFIED_IN_TN"
    """


    """
    STATE_INVALID_PNIC_DEVICE_NAME = "INVALID_PNIC_DEVICE_NAME"
    """


    """
    STATE_UNSUPPORTED_DEFAULT_TEAMING_POLICY = "UNSUPPORTED_DEFAULT_TEAMING_POLICY"
    """


    """
    STATE_MPA_DISCONNECTED = "MPA_DISCONNECTED"
    """


    """
    STATE_VM_NETWORK_EDIT_PENDING = "VM_NETWORK_EDIT_PENDING"
    """


    """
    STATE_VM_RENAME_PENDING = "VM_RENAME_PENDING"
    """


    """
    STATE_VM_CONFIG_EDIT_PENDING = "VM_CONFIG_EDIT_PENDING"
    """


    """
    STATE_VM_NETWORK_EDIT_FAILED = "VM_NETWORK_EDIT_FAILED"
    """


    """
    STATE_VM_RENAME_FAILED = "VM_RENAME_FAILED"
    """


    """
    STATE_VM_CONFIG_EDIT_FAILED = "VM_CONFIG_EDIT_FAILED"
    """


    """
    STATE_VM_CONFIG_DISCREPANCY = "VM_CONFIG_DISCREPANCY"
    """


    """
    STATE_VM_NODE_REFRESH_FAILED = "VM_NODE_REFRESH_FAILED"
    """


    """
    STATE_VM_PLACEMENT_REFRESH_FAILED = "VM_PLACEMENT_REFRESH_FAILED"
    """


    """
    STATE_NOT_AVAILABLE = "NOT_AVAILABLE"
    """


    """
    STATE_REGISTRATION_TIMEDOUT = "REGISTRATION_TIMEDOUT"
    """


    """
    STATE_ADVANCED_CONFIG_EDIT_FAILED = "ADVANCED_CONFIG_EDIT_FAILED"
    """


    """
    STATE_VM_RESOURCE_RESERVATION_FAILED = "VM_RESOURCE_RESERVATION_FAILED"
    """


    """
    STATE_UPT_MODE_REALIZATION_POLL_TIMED_OUT = "UPT_MODE_REALIZATION_POLL_TIMED_OUT"
    """


    """
    STATE_DATAPATH_CONFIGURATION_EDIT_FAILED = "DATAPATH_CONFIGURATION_EDIT_FAILED"
    """


    """
    STATE_MAINTENANCE_MODE_ENABLED = "MAINTENANCE_MODE_ENABLED"
    """


    """
    STATE_ERROR_IN_ENABLE_MAINTENANCE_MODE = "ERROR_IN_ENABLE_MAINTENANCE_MODE"
    """


    """
    STATE_ERROR_IN_DISABLE_MAINTENANCE_MODE = "ERROR_IN_DISABLE_MAINTENANCE_MODE"
    """


    """
    STATE_CONFIGURE_UPT_ON_VM_FAILED = "CONFIGURE_UPT_ON_VM_FAILED"
    """


    """
    STATE_VM_VERSION_IS_UPT_INCOMPATIBLE = "VM_VERSION_IS_UPT_INCOMPATIBLE"
    """


    """
    STATE_PENDING = "pending"
    """


    """
    STATE_ORPHANED = "orphaned"
    """


    """
    STATE_UNKNOWN = "unknown"
    """


    """
    STATE_ERROR = "error"
    """


    """
    STATE_VM_DEPLOYMENT_QUEUED = "VM_DEPLOYMENT_QUEUED"
    """


    """
    STATE_VM_DEPLOYMENT_IN_PROGRESS = "VM_DEPLOYMENT_IN_PROGRESS"
    """


    """
    STATE_VM_POWER_ON_IN_PROGRESS = "VM_POWER_ON_IN_PROGRESS"
    """


    """
    STATE_REGISTRATION_PENDING = "REGISTRATION_PENDING"
    """


    """
    STATE_NODE_NOT_READY = "NODE_NOT_READY"
    """


    """
    STATE_NODE_READY = "NODE_READY"
    """


    """
    STATE_VM_POWER_OFF_IN_PROGRESS = "VM_POWER_OFF_IN_PROGRESS"
    """


    """
    STATE_VM_UNDEPLOY_IN_PROGRESS = "VM_UNDEPLOY_IN_PROGRESS"
    """


    """
    STATE_VM_UNDEPLOY_SUCCESSFUL = "VM_UNDEPLOY_SUCCESSFUL"
    """


    """
    STATE_VM_DEPLOYMENT_RESTARTED = "VM_DEPLOYMENT_RESTARTED"
    """


    """
    STATE_TRANSPORT_NODE_SYNC_PENDING = "TRANSPORT_NODE_SYNC_PENDING"
    """


    """
    STATE_TRANSPORT_NODE_READY = "TRANSPORT_NODE_READY"
    """


    """
    STATE_DUPLICATE_PNICS_IN_TEAMINGS_WITH_MULTIPLE_UPLINKS_AND_FAILOVER_ORDER = "DUPLICATE_PNICS_IN_TEAMINGS_WITH_MULTIPLE_UPLINKS_AND_FAILOVER_ORDER"
    """


    """
    STATE_DUPLICATE_VLANS_SHARING_SAME_PNICMULTIPLE_UPLINKS_IN_NAMED_TEAMING_NOT_SUPPORTED_IF_UPLINK_IN_DEFAULT_TEAMING = "DUPLICATE_VLANS_SHARING_SAME_PNICMULTIPLE_UPLINKS_IN_NAMED_TEAMING_NOT_SUPPORTED_IF_UPLINK_IN_DEFAULT_TEAMING"
    """


    """
    STATE_EDGE_NODE_SETTINGS_MISMATCH_RESOLVE = "EDGE_NODE_SETTINGS_MISMATCH_RESOLVE"
    """


    """
    STATE_EDGE_VM_VSPHERE_SETTINGS_MISMATCH_RESOLVE = "EDGE_VM_VSPHERE_SETTINGS_MISMATCH_RESOLVE"
    """


    """
    STATE_EDGE_NODE_SETTINGS_AND_VSPHERE_SETTINGS_ARE_CHANGED_RESOLVE = "EDGE_NODE_SETTINGS_AND_VSPHERE_SETTINGS_ARE_CHANGED_RESOLVE"
    """


    """
    STATE_EDGE_VSPHERE_LOCATION_MISMATCH_RESOLVE = "EDGE_VSPHERE_LOCATION_MISMATCH_RESOLVE"
    """


    """
    STATE_COMPUTE_MANAGER_NOT_FOUND = "COMPUTE_MANAGER_NOT_FOUND"
    """


    """
    STATE_ADVANCED_CONFIG_EDIT_PENDING = "ADVANCED_CONFIG_EDIT_PENDING"
    """


    """
    STATE_DELETE_FAILED_FOR_DIFFERENT_MOREF_ID = "DELETE_FAILED_FOR_DIFFERENT_MOREF_ID"
    """


    """
    STATE_DELETE_FAILED_FOR_NON_LCM_EDGE = "DELETE_FAILED_FOR_NON_LCM_EDGE"
    """


    """
    STATE_DELETE_FAILED_ON_VM_NOT_FOUND = "DELETE_FAILED_ON_VM_NOT_FOUND"
    """


    """
    STATE_DELETE_IN_PROGRESS = "DELETE_IN_PROGRESS"
    """


    """
    STATE_DUPLICATE_VLANS_SHARING_SAME_PNIC = "DUPLICATE_VLANS_SHARING_SAME_PNIC"
    """


    """
    STATE_MULTIPLE_UPLINKS_IN_NAMED_TEAMING_NOT_SUPPORTED_IF_UPLINK_IN_DEFAULT_TEAMING = "MULTIPLE_UPLINKS_IN_NAMED_TEAMING_NOT_SUPPORTED_IF_UPLINK_IN_DEFAULT_TEAMING"
    """


    """
    STATE_REDEPLOY_ACTIVITY_FAILED = "REDEPLOY_ACTIVITY_FAILED"
    """


    """
    STATE_REDEPLOY_ACTIVITY_IN_PROGRESS = "REDEPLOY_ACTIVITY_IN_PROGRESS"
    """


    """
    STATE_REDEPLOY_ACTIVITY_SCHEDULED = "REDEPLOY_ACTIVITY_SCHEDULED"
    """


    """
    STATE_REDEPLOY_ACTIVITY_SUCCESSFUL = "REDEPLOY_ACTIVITY_SUCCESSFUL"
    """


    """
    STATE_REPLACE_ACTIVITY_FAILED = "REPLACE_ACTIVITY_FAILED"
    """


    """
    STATE_REPLACE_ACTIVITY_IN_PROGRESS = "REPLACE_ACTIVITY_IN_PROGRESS"
    """


    """
    STATE_REPLACE_ACTIVITY_SCHEDULED = "REPLACE_ACTIVITY_SCHEDULED"
    """


    """
    STATE_REPLACE_ACTIVITY_SUCCESSFUL = "REPLACE_ACTIVITY_SUCCESSFUL"
    """


    """
    STATE_REPLACED_RPC_CLIENT_OF_TN = "REPLACED_RPC_CLIENT_OF_TN"
    """


    """
    STATE_RETRYING_REPLACE = "RETRYING_REPLACE"
    """


    """
    STATE_UNABLE_TO_DELETE_EDGE_NODE_VM_INTERNAL_ERROR = "UNABLE_TO_DELETE_EDGE_NODE_VM_INTERNAL_ERROR"
    """


    """
    STATE_VM_REDEPLOY_FAILED = "VM_REDEPLOY_FAILED"
    """


    """
    STATE_VM_RESOURCE_RESERVATION_EDIT_PENDING = "VM_RESOURCE_RESERVATION_EDIT_PENDING"
    """


    """
    STATE_REDEPLOYED_VM_REGISTRATION_PENDING = "REDEPLOYED_VM_REGISTRATION_PENDING"
    """


    """



    _canonical_to_pep_names = {
                            'failure_code': 'failure_code',
                            'failure_message': 'failure_message',
                            'state': 'state',
                            'sub_system_address': 'sub_system_address',
                            'sub_system_id': 'sub_system_id',
                            'sub_system_name': 'sub_system_name',
                            'sub_system_type': 'sub_system_type',
                            }

    def __init__(self,
                 failure_code=None,
                 failure_message=None,
                 state=None,
                 sub_system_address=None,
                 sub_system_id=None,
                 sub_system_name=None,
                 sub_system_type=None,
                ):
        """
        :type  failure_code: :class:`long` or ``None``
        :param failure_code: Error code format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  failure_message: :class:`str` or ``None``
        :param failure_message: Error message in case of failure
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  state: :class:`str` or ``None``
        :param state: Possible values are: 
            
            * :attr:`ConfigurationStateElement.STATE_IN_PROGRESS`
            * :attr:`ConfigurationStateElement.STATE_SUCCESS`
            * :attr:`ConfigurationStateElement.STATE_FAILED`
            * :attr:`ConfigurationStateElement.STATE_PARTIAL_SUCCESS`
            * :attr:`ConfigurationStateElement.STATE_IN_SYNC`
            * :attr:`ConfigurationStateElement.STATE_VM_DEPLOYMENT_FAILED`
            * :attr:`ConfigurationStateElement.STATE_VM_POWER_ON_FAILED`
            * :attr:`ConfigurationStateElement.STATE_VM_POWER_OFF_FAILED`
            * :attr:`ConfigurationStateElement.STATE_VM_UNDEPLOY_FAILED`
            * :attr:`ConfigurationStateElement.STATE_REPLACE_FAILED`
            *
              :attr:`ConfigurationStateElement.STATE_UPLINK_FROM_TEAMING_POLICY_NOT_MAPPED`
            *
              :attr:`ConfigurationStateElement.STATE_LOGICAL_SWITCH_NAMED_TEAMING_HAS_NO_PNIC_BACKING`
            *
              :attr:`ConfigurationStateElement.STATE_DELETE_VM_IN_REDEPLOY_FAILED`
            *
              :attr:`ConfigurationStateElement.STATE_DEPLOY_VM_IN_REDEPLOY_FAILED`
            *
              :attr:`ConfigurationStateElement.STATE_INSUFFICIENT_RESOURCES_IN_EDGE_NODE_FOR_SERVICE`
            * :attr:`ConfigurationStateElement.STATE_EDGE_CONFIG_ERROR`
            * :attr:`ConfigurationStateElement.STATE_REGISTRATION_FAILED`
            *
              :attr:`ConfigurationStateElement.STATE_TRANSPORT_NODE_CONFIGURATION_MISSING`
            *
              :attr:`ConfigurationStateElement.STATE_EDGE_HARDWARE_NOT_SUPPORTED`
            *
              :attr:`ConfigurationStateElement.STATE_MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED`
            *
              :attr:`ConfigurationStateElement.STATE_TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER`
            *
              :attr:`ConfigurationStateElement.STATE_TZ_ENDPOINTS_NOT_SPECIFIED`
            * :attr:`ConfigurationStateElement.STATE_NO_PNIC_PREPARED_IN_EDGE`
            * :attr:`ConfigurationStateElement.STATE_APPLIANCE_INTERNAL_ERROR`
            * :attr:`ConfigurationStateElement.STATE_VTEP_DHCP_NOT_SUPPORTED`
            *
              :attr:`ConfigurationStateElement.STATE_UNSUPPORTED_HOST_SWITCH_PROFILE`
            *
              :attr:`ConfigurationStateElement.STATE_UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED`
            *
              :attr:`ConfigurationStateElement.STATE_HOSTSWITCH_PROFILE_NOT_FOUND`
            *
              :attr:`ConfigurationStateElement.STATE_LLDP_SEND_ENABLED_NOT_SUPPORTED`
            *
              :attr:`ConfigurationStateElement.STATE_UNSUPPORTED_NAMED_TEAMING_POLICY`
            *
              :attr:`ConfigurationStateElement.STATE_LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM`
            *
              :attr:`ConfigurationStateElement.STATE_LACP_NOT_SUPPORTED_FOR_EDGE_VM`
            *
              :attr:`ConfigurationStateElement.STATE_STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM`
            *
              :attr:`ConfigurationStateElement.STATE_MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE`
            *
              :attr:`ConfigurationStateElement.STATE_UNSUPPORTED_LACP_LB_ALGO_FOR_NODE`
            *
              :attr:`ConfigurationStateElement.STATE_EDGE_NODE_VERSION_NOT_SUPPORTED`
            * :attr:`ConfigurationStateElement.STATE_NO_PNIC_SPECIFIED_IN_TN`
            * :attr:`ConfigurationStateElement.STATE_INVALID_PNIC_DEVICE_NAME`
            *
              :attr:`ConfigurationStateElement.STATE_UNSUPPORTED_DEFAULT_TEAMING_POLICY`
            * :attr:`ConfigurationStateElement.STATE_MPA_DISCONNECTED`
            * :attr:`ConfigurationStateElement.STATE_VM_NETWORK_EDIT_PENDING`
            * :attr:`ConfigurationStateElement.STATE_VM_RENAME_PENDING`
            * :attr:`ConfigurationStateElement.STATE_VM_CONFIG_EDIT_PENDING`
            * :attr:`ConfigurationStateElement.STATE_VM_NETWORK_EDIT_FAILED`
            * :attr:`ConfigurationStateElement.STATE_VM_RENAME_FAILED`
            * :attr:`ConfigurationStateElement.STATE_VM_CONFIG_EDIT_FAILED`
            * :attr:`ConfigurationStateElement.STATE_VM_CONFIG_DISCREPANCY`
            * :attr:`ConfigurationStateElement.STATE_VM_NODE_REFRESH_FAILED`
            *
              :attr:`ConfigurationStateElement.STATE_VM_PLACEMENT_REFRESH_FAILED`
            * :attr:`ConfigurationStateElement.STATE_NOT_AVAILABLE`
            * :attr:`ConfigurationStateElement.STATE_REGISTRATION_TIMEDOUT`
            *
              :attr:`ConfigurationStateElement.STATE_ADVANCED_CONFIG_EDIT_FAILED`
            *
              :attr:`ConfigurationStateElement.STATE_VM_RESOURCE_RESERVATION_FAILED`
            *
              :attr:`ConfigurationStateElement.STATE_UPT_MODE_REALIZATION_POLL_TIMED_OUT`
            *
              :attr:`ConfigurationStateElement.STATE_DATAPATH_CONFIGURATION_EDIT_FAILED`
            * :attr:`ConfigurationStateElement.STATE_MAINTENANCE_MODE_ENABLED`
            *
              :attr:`ConfigurationStateElement.STATE_ERROR_IN_ENABLE_MAINTENANCE_MODE`
            *
              :attr:`ConfigurationStateElement.STATE_ERROR_IN_DISABLE_MAINTENANCE_MODE`
            *
              :attr:`ConfigurationStateElement.STATE_CONFIGURE_UPT_ON_VM_FAILED`
            *
              :attr:`ConfigurationStateElement.STATE_VM_VERSION_IS_UPT_INCOMPATIBLE`
            * :attr:`ConfigurationStateElement.STATE_PENDING`
            * :attr:`ConfigurationStateElement.STATE_ORPHANED`
            * :attr:`ConfigurationStateElement.STATE_UNKNOWN`
            * :attr:`ConfigurationStateElement.STATE_ERROR`
            * :attr:`ConfigurationStateElement.STATE_VM_DEPLOYMENT_QUEUED`
            * :attr:`ConfigurationStateElement.STATE_VM_DEPLOYMENT_IN_PROGRESS`
            * :attr:`ConfigurationStateElement.STATE_VM_POWER_ON_IN_PROGRESS`
            * :attr:`ConfigurationStateElement.STATE_REGISTRATION_PENDING`
            * :attr:`ConfigurationStateElement.STATE_NODE_NOT_READY`
            * :attr:`ConfigurationStateElement.STATE_NODE_READY`
            * :attr:`ConfigurationStateElement.STATE_VM_POWER_OFF_IN_PROGRESS`
            * :attr:`ConfigurationStateElement.STATE_VM_UNDEPLOY_IN_PROGRESS`
            * :attr:`ConfigurationStateElement.STATE_VM_UNDEPLOY_SUCCESSFUL`
            * :attr:`ConfigurationStateElement.STATE_VM_DEPLOYMENT_RESTARTED`
            *
              :attr:`ConfigurationStateElement.STATE_TRANSPORT_NODE_SYNC_PENDING`
            * :attr:`ConfigurationStateElement.STATE_TRANSPORT_NODE_READY`
            *
              :attr:`ConfigurationStateElement.STATE_DUPLICATE_PNICS_IN_TEAMINGS_WITH_MULTIPLE_UPLINKS_AND_FAILOVER_ORDER`
            *
              :attr:`ConfigurationStateElement.STATE_DUPLICATE_VLANS_SHARING_SAME_PNICMULTIPLE_UPLINKS_IN_NAMED_TEAMING_NOT_SUPPORTED_IF_UPLINK_IN_DEFAULT_TEAMING`
            *
              :attr:`ConfigurationStateElement.STATE_EDGE_NODE_SETTINGS_MISMATCH_RESOLVE`
            *
              :attr:`ConfigurationStateElement.STATE_EDGE_VM_VSPHERE_SETTINGS_MISMATCH_RESOLVE`
            *
              :attr:`ConfigurationStateElement.STATE_EDGE_NODE_SETTINGS_AND_VSPHERE_SETTINGS_ARE_CHANGED_RESOLVE`
            *
              :attr:`ConfigurationStateElement.STATE_EDGE_VSPHERE_LOCATION_MISMATCH_RESOLVE`
            * :attr:`ConfigurationStateElement.STATE_COMPUTE_MANAGER_NOT_FOUND`
            *
              :attr:`ConfigurationStateElement.STATE_ADVANCED_CONFIG_EDIT_PENDING`
            *
              :attr:`ConfigurationStateElement.STATE_DELETE_FAILED_FOR_DIFFERENT_MOREF_ID`
            *
              :attr:`ConfigurationStateElement.STATE_DELETE_FAILED_FOR_NON_LCM_EDGE`
            *
              :attr:`ConfigurationStateElement.STATE_DELETE_FAILED_ON_VM_NOT_FOUND`
            * :attr:`ConfigurationStateElement.STATE_DELETE_IN_PROGRESS`
            *
              :attr:`ConfigurationStateElement.STATE_DUPLICATE_VLANS_SHARING_SAME_PNIC`
            *
              :attr:`ConfigurationStateElement.STATE_MULTIPLE_UPLINKS_IN_NAMED_TEAMING_NOT_SUPPORTED_IF_UPLINK_IN_DEFAULT_TEAMING`
            * :attr:`ConfigurationStateElement.STATE_REDEPLOY_ACTIVITY_FAILED`
            *
              :attr:`ConfigurationStateElement.STATE_REDEPLOY_ACTIVITY_IN_PROGRESS`
            *
              :attr:`ConfigurationStateElement.STATE_REDEPLOY_ACTIVITY_SCHEDULED`
            *
              :attr:`ConfigurationStateElement.STATE_REDEPLOY_ACTIVITY_SUCCESSFUL`
            * :attr:`ConfigurationStateElement.STATE_REPLACE_ACTIVITY_FAILED`
            *
              :attr:`ConfigurationStateElement.STATE_REPLACE_ACTIVITY_IN_PROGRESS`
            *
              :attr:`ConfigurationStateElement.STATE_REPLACE_ACTIVITY_SCHEDULED`
            *
              :attr:`ConfigurationStateElement.STATE_REPLACE_ACTIVITY_SUCCESSFUL`
            * :attr:`ConfigurationStateElement.STATE_REPLACED_RPC_CLIENT_OF_TN`
            * :attr:`ConfigurationStateElement.STATE_RETRYING_REPLACE`
            *
              :attr:`ConfigurationStateElement.STATE_UNABLE_TO_DELETE_EDGE_NODE_VM_INTERNAL_ERROR`
            * :attr:`ConfigurationStateElement.STATE_VM_REDEPLOY_FAILED`
            *
              :attr:`ConfigurationStateElement.STATE_VM_RESOURCE_RESERVATION_EDIT_PENDING`
            *
              :attr:`ConfigurationStateElement.STATE_REDEPLOYED_VM_REGISTRATION_PENDING`
            
            State of configuration on this sub system
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sub_system_address: :class:`str` or ``None``
        :param sub_system_address: URI of backing resource on sub system
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sub_system_id: :class:`str` or ``None``
        :param sub_system_id: Identifier of backing resource on sub system
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sub_system_name: :class:`str` or ``None``
        :param sub_system_name: Name of backing resource on sub system
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sub_system_type: :class:`str` or ``None``
        :param sub_system_type: Type of backing resource on sub system
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.failure_code = failure_code
        self.failure_message = failure_message
        self.state = state
        self.sub_system_address = sub_system_address
        self.sub_system_id = sub_system_id
        self.sub_system_name = sub_system_name
        self.sub_system_type = sub_system_type
        VapiStruct.__init__(self)


ConfigurationStateElement._set_binding_type(type.StructType(
    'com.vmware.nsx.model.configuration_state_element', {
        'failure_code': type.OptionalType(type.IntegerType()),
        'failure_message': type.OptionalType(type.StringType()),
        'state': type.OptionalType(type.StringType()),
        'sub_system_address': type.OptionalType(type.StringType()),
        'sub_system_id': type.OptionalType(type.StringType()),
        'sub_system_name': type.OptionalType(type.StringType()),
        'sub_system_type': type.OptionalType(type.StringType()),
    },
    ConfigurationStateElement,
    False,
    None))



class ConsolidatedEffectiveIPAddressMemberListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`EffectiveIPInfo` or ``None``
        :param results: Paged Collection of site wise consolidated effective ip addresses
            for the given NSGroup
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ConsolidatedEffectiveIPAddressMemberListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.consolidated_effective_IP_address_member_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'EffectiveIPInfo'))),
    },
    ConsolidatedEffectiveIPAddressMemberListResult,
    False,
    None))



class ContainerApplication(VapiStruct):
    """
    Container application within a project.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    NETWORK_STATUS_HEALTHY = "HEALTHY"
    """


    """
    NETWORK_STATUS_UNHEALTHY = "UNHEALTHY"
    """


    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """
    STATUS_HEALTHY = "HEALTHY"
    """


    """
    STATUS_UP = "UP"
    """


    """
    STATUS_DOWN = "DOWN"
    """


    """
    STATUS_DEGRADED = "DEGRADED"
    """


    """
    TYPE_CLUSTER_IP = "CLUSTER_IP"
    """


    """
    TYPE_NODE_PORT = "NODE_PORT"
    """


    """
    TYPE_LOAD_BALANCER = "LOAD_BALANCER"
    """


    """
    TYPE_EXTERNAL_NAME = "EXTERNAL_NAME"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_last_sync_time': 'last_sync_time',
                            'description': 'description',
                            'display_name': 'display_name',
                            'resource_type': 'resource_type',
                            'scope': 'scope',
                            'tags': 'tags',
                            'cluster_ips': 'cluster_ips',
                            'container_cluster_id': 'container_cluster_id',
                            'container_project_id': 'container_project_id',
                            'external_id': 'external_id',
                            'load_balancer_ingress': 'load_balancer_ingress',
                            'network_errors': 'network_errors',
                            'network_status': 'network_status',
                            'node_port_local_endpoints': 'node_port_local_endpoints',
                            'origin_properties': 'origin_properties',
                            'service_ports': 'service_ports',
                            'status': 'status',
                            'type': 'type',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 last_sync_time=None,
                 description=None,
                 display_name=None,
                 resource_type=None,
                 scope=None,
                 tags=None,
                 cluster_ips=None,
                 container_cluster_id=None,
                 container_project_id=None,
                 external_id=None,
                 load_balancer_ingress=None,
                 network_errors=None,
                 network_status=None,
                 node_port_local_endpoints=None,
                 origin_properties=None,
                 service_ports=None,
                 status=None,
                 type=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  last_sync_time: :class:`long` or ``None``
        :param last_sync_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  scope: :class:`list` of :class:`DiscoveredResourceScope` or ``None``
        :param scope: Specifies list of scope of discovered resource. e.g. if VHC path is
            associated with principal identity, who owns the discovered
            resource, then scope id will be VHC path and scope type will be
            VHC.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  cluster_ips: :class:`list` of :class:`str` or ``None``
        :param cluster_ips: The IPv4 and IPv6 clusterIPs of the container application. format:
            ip
        :type  container_cluster_id: :class:`str` or ``None``
        :param container_cluster_id: Identifier of the container cluster this container application
            belongs to.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  container_project_id: :class:`str` or ``None``
        :param container_project_id: Identifier of the project which this container application belongs
            to.
        :type  external_id: :class:`str` or ``None``
        :param external_id: Identifier of the container application on container cluster e.g.
            PCF app id, k8s service id.
        :type  load_balancer_ingress: :class:`list` of :class:`ContainerLoadBalancerIngress` or ``None``
        :param load_balancer_ingress: Specifies list of load-balancer ingress points
        :type  network_errors: :class:`list` of :class:`NetworkError` or ``None``
        :param network_errors: List of network errors related to container application.
        :type  network_status: :class:`str` or ``None``
        :param network_status: Possible values are: 
            
            * :attr:`ContainerApplication.NETWORK_STATUS_HEALTHY`
            * :attr:`ContainerApplication.NETWORK_STATUS_UNHEALTHY`
            
            Network status of container application.
        :type  node_port_local_endpoints: :class:`list` of :class:`NodePortLocalEndpoint` or ``None``
        :param node_port_local_endpoints: Specifies list of local endpoint, when service is NodePortLocal.
        :type  origin_properties: :class:`list` of :class:`KeyValuePair` or ``None``
        :param origin_properties: Array of additional specific properties of container application in
            key-value format.
        :type  service_ports: :class:`list` of :class:`ContainerServicePort` or ``None``
        :param service_ports: Specifies list of service port.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ContainerApplication.STATUS_UNKNOWN`
            * :attr:`ContainerApplication.STATUS_HEALTHY`
            * :attr:`ContainerApplication.STATUS_UP`
            * :attr:`ContainerApplication.STATUS_DOWN`
            * :attr:`ContainerApplication.STATUS_DEGRADED`
            
            Status of the container application.
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ContainerApplication.TYPE_CLUSTER_IP`
            * :attr:`ContainerApplication.TYPE_NODE_PORT`
            * :attr:`ContainerApplication.TYPE_LOAD_BALANCER`
            * :attr:`ContainerApplication.TYPE_EXTERNAL_NAME`
            
            Type of container application
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.last_sync_time = last_sync_time
        self.description = description
        self.display_name = display_name
        self.resource_type = resource_type
        self.scope = scope
        self.tags = tags
        self.cluster_ips = cluster_ips
        self.container_cluster_id = container_cluster_id
        self.container_project_id = container_project_id
        self.external_id = external_id
        self.load_balancer_ingress = load_balancer_ingress
        self.network_errors = network_errors
        self.network_status = network_status
        self.node_port_local_endpoints = node_port_local_endpoints
        self.origin_properties = origin_properties
        self.service_ports = service_ports
        self.status = status
        self.type = type
        VapiStruct.__init__(self)


ContainerApplication._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_application', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_last_sync_time': type.OptionalType(type.IntegerType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'scope': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'DiscoveredResourceScope'))),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'cluster_ips': type.OptionalType(type.ListType(type.StringType())),
        'container_cluster_id': type.OptionalType(type.StringType()),
        'container_project_id': type.OptionalType(type.StringType()),
        'external_id': type.OptionalType(type.StringType()),
        'load_balancer_ingress': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ContainerLoadBalancerIngress'))),
        'network_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NetworkError'))),
        'network_status': type.OptionalType(type.StringType()),
        'node_port_local_endpoints': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NodePortLocalEndpoint'))),
        'origin_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'KeyValuePair'))),
        'service_ports': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ContainerServicePort'))),
        'status': type.OptionalType(type.StringType()),
        'type': type.OptionalType(type.StringType()),
    },
    ContainerApplication,
    False,
    None))



class ContainerApplicationInstance(VapiStruct):
    """
    Container application instance within a project.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    NETWORK_STATUS_HEALTHY = "HEALTHY"
    """


    """
    NETWORK_STATUS_UNHEALTHY = "UNHEALTHY"
    """


    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """
    STATUS_HEALTHY = "HEALTHY"
    """


    """
    STATUS_UP = "UP"
    """


    """
    STATUS_DOWN = "DOWN"
    """


    """
    STATUS_DEGRADED = "DEGRADED"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_last_sync_time': 'last_sync_time',
                            'description': 'description',
                            'display_name': 'display_name',
                            'resource_type': 'resource_type',
                            'scope': 'scope',
                            'tags': 'tags',
                            'cluster_node_id': 'cluster_node_id',
                            'container_application_ids': 'container_application_ids',
                            'container_cluster_id': 'container_cluster_id',
                            'container_project_id': 'container_project_id',
                            'external_id': 'external_id',
                            'network_errors': 'network_errors',
                            'network_status': 'network_status',
                            'origin_properties': 'origin_properties',
                            'status': 'status',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 last_sync_time=None,
                 description=None,
                 display_name=None,
                 resource_type=None,
                 scope=None,
                 tags=None,
                 cluster_node_id=None,
                 container_application_ids=None,
                 container_cluster_id=None,
                 container_project_id=None,
                 external_id=None,
                 network_errors=None,
                 network_status=None,
                 origin_properties=None,
                 status=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  last_sync_time: :class:`long` or ``None``
        :param last_sync_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  scope: :class:`list` of :class:`DiscoveredResourceScope` or ``None``
        :param scope: Specifies list of scope of discovered resource. e.g. if VHC path is
            associated with principal identity, who owns the discovered
            resource, then scope id will be VHC path and scope type will be
            VHC.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  cluster_node_id: :class:`str` or ``None``
        :param cluster_node_id: Cluster node id where application instance is running.
        :type  container_application_ids: :class:`list` of :class:`str` or ``None``
        :param container_application_ids: List of identifiers of the container application.
        :type  container_cluster_id: :class:`str` or ``None``
        :param container_cluster_id: Identifier of the container cluster this application instance
            belongs to.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  container_project_id: :class:`str` or ``None``
        :param container_project_id: Identifier of the container project which this container
            application instance belongs to.
        :type  external_id: :class:`str` or ``None``
        :param external_id: Identifier of the container application instance on container
            cluster.
        :type  network_errors: :class:`list` of :class:`NetworkError` or ``None``
        :param network_errors: List of network errors related to container application instance.
        :type  network_status: :class:`str` or ``None``
        :param network_status: Possible values are: 
            
            * :attr:`ContainerApplicationInstance.NETWORK_STATUS_HEALTHY`
            * :attr:`ContainerApplicationInstance.NETWORK_STATUS_UNHEALTHY`
            
            Network status of container application instance.
        :type  origin_properties: :class:`list` of :class:`KeyValuePair` or ``None``
        :param origin_properties: Array of additional specific properties of container application
            instance in key-value format.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ContainerApplicationInstance.STATUS_UNKNOWN`
            * :attr:`ContainerApplicationInstance.STATUS_HEALTHY`
            * :attr:`ContainerApplicationInstance.STATUS_UP`
            * :attr:`ContainerApplicationInstance.STATUS_DOWN`
            * :attr:`ContainerApplicationInstance.STATUS_DEGRADED`
            
            Status of the container application instance.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.last_sync_time = last_sync_time
        self.description = description
        self.display_name = display_name
        self.resource_type = resource_type
        self.scope = scope
        self.tags = tags
        self.cluster_node_id = cluster_node_id
        self.container_application_ids = container_application_ids
        self.container_cluster_id = container_cluster_id
        self.container_project_id = container_project_id
        self.external_id = external_id
        self.network_errors = network_errors
        self.network_status = network_status
        self.origin_properties = origin_properties
        self.status = status
        VapiStruct.__init__(self)


ContainerApplicationInstance._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_application_instance', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_last_sync_time': type.OptionalType(type.IntegerType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'scope': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'DiscoveredResourceScope'))),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'cluster_node_id': type.OptionalType(type.StringType()),
        'container_application_ids': type.OptionalType(type.ListType(type.StringType())),
        'container_cluster_id': type.OptionalType(type.StringType()),
        'container_project_id': type.OptionalType(type.StringType()),
        'external_id': type.OptionalType(type.StringType()),
        'network_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NetworkError'))),
        'network_status': type.OptionalType(type.StringType()),
        'origin_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'KeyValuePair'))),
        'status': type.OptionalType(type.StringType()),
    },
    ContainerApplicationInstance,
    False,
    None))



class ContainerApplicationInstanceListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ContainerApplicationInstance` or ``None``
        :param results: List of Container Applications
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ContainerApplicationInstanceListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_application_instance_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ContainerApplicationInstance'))),
    },
    ContainerApplicationInstanceListResult,
    False,
    None))



class ContainerApplicationListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ContainerApplication` or ``None``
        :param results: List of Container Applications
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ContainerApplicationListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_application_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ContainerApplication'))),
    },
    ContainerApplicationListResult,
    False,
    None))



class ContainerCluster(VapiStruct):
    """
    Details of container cluster.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CLUSTER_TYPE_PAS = "PAS"
    """


    """
    CLUSTER_TYPE_PKS = "PKS"
    """


    """
    CLUSTER_TYPE_KUBERNETES = "Kubernetes"
    """


    """
    CLUSTER_TYPE_OPENSHIFT = "Openshift"
    """


    """
    CLUSTER_TYPE_WCP = "WCP"
    """


    """
    CLUSTER_TYPE_WCP_GUEST = "WCP_Guest"
    """


    """
    CLUSTER_TYPE_AKS = "AKS"
    """


    """
    CLUSTER_TYPE_EKS = "EKS"
    """


    """
    CLUSTER_TYPE_TKGM = "TKGm"
    """


    """
    CLUSTER_TYPE_TKGI = "TKGi"
    """


    """
    CLUSTER_TYPE_GKE = "GKE"
    """


    """
    CLUSTER_TYPE_GARDENER = "Gardener"
    """


    """
    CLUSTER_TYPE_RANCHER = "Rancher"
    """


    """
    CLUSTER_TYPE_TAS = "TAS"
    """


    """
    CLUSTER_TYPE_OTHER = "Other"
    """


    """
    CNI_TYPE_NCP = "NCP"
    """


    """
    CNI_TYPE_ANTREA = "Antrea"
    """


    """
    CNI_TYPE_OTHER = "Other"
    """


    """
    NETWORK_STATUS_HEALTHY = "HEALTHY"
    """


    """
    NETWORK_STATUS_UNHEALTHY = "UNHEALTHY"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_last_sync_time': 'last_sync_time',
                            'description': 'description',
                            'display_name': 'display_name',
                            'resource_type': 'resource_type',
                            'scope': 'scope',
                            'tags': 'tags',
                            'cluster_ip_ranges': 'cluster_ip_ranges',
                            'cluster_type': 'cluster_type',
                            'cni_type': 'cni_type',
                            'external_id': 'external_id',
                            'infrastructure': 'infrastructure',
                            'network_errors': 'network_errors',
                            'network_status': 'network_status',
                            'node_port_local_range': 'node_port_local_range',
                            'node_port_range': 'node_port_range',
                            'origin_properties': 'origin_properties',
                            'supervisor_project_id': 'supervisor_project_id',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 last_sync_time=None,
                 description=None,
                 display_name=None,
                 resource_type=None,
                 scope=None,
                 tags=None,
                 cluster_ip_ranges=None,
                 cluster_type=None,
                 cni_type=None,
                 external_id=None,
                 infrastructure=None,
                 network_errors=None,
                 network_status=None,
                 node_port_local_range=None,
                 node_port_range=None,
                 origin_properties=None,
                 supervisor_project_id=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  last_sync_time: :class:`long` or ``None``
        :param last_sync_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  scope: :class:`list` of :class:`DiscoveredResourceScope` or ``None``
        :param scope: Specifies list of scope of discovered resource. e.g. if VHC path is
            associated with principal identity, who owns the discovered
            resource, then scope id will be VHC path and scope type will be
            VHC.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  cluster_ip_ranges: :class:`list` of :class:`str` or ``None``
        :param cluster_ip_ranges: In case of Kubernetes container cluster, it specifies CIDRs that
            will be assigned to services created on Kubernetes. format:
            ip-cidr-block
        :type  cluster_type: :class:`str` or ``None``
        :param cluster_type: Possible values are: 
            
            * :attr:`ContainerCluster.CLUSTER_TYPE_PAS`
            * :attr:`ContainerCluster.CLUSTER_TYPE_PKS`
            * :attr:`ContainerCluster.CLUSTER_TYPE_KUBERNETES`
            * :attr:`ContainerCluster.CLUSTER_TYPE_OPENSHIFT`
            * :attr:`ContainerCluster.CLUSTER_TYPE_WCP`
            * :attr:`ContainerCluster.CLUSTER_TYPE_WCP_GUEST`
            * :attr:`ContainerCluster.CLUSTER_TYPE_AKS`
            * :attr:`ContainerCluster.CLUSTER_TYPE_EKS`
            * :attr:`ContainerCluster.CLUSTER_TYPE_TKGM`
            * :attr:`ContainerCluster.CLUSTER_TYPE_TKGI`
            * :attr:`ContainerCluster.CLUSTER_TYPE_GKE`
            * :attr:`ContainerCluster.CLUSTER_TYPE_GARDENER`
            * :attr:`ContainerCluster.CLUSTER_TYPE_RANCHER`
            * :attr:`ContainerCluster.CLUSTER_TYPE_TAS`
            * :attr:`ContainerCluster.CLUSTER_TYPE_OTHER`
            
            Type of the container cluster. In case of creating container
            cluster first time, it is expected to pass the valid cluster-type.
            In case of update, if there is no change in cluster-type, then this
            field can be omitted in the request.
        :type  cni_type: :class:`str` or ``None``
        :param cni_type: Possible values are: 
            
            * :attr:`ContainerCluster.CNI_TYPE_NCP`
            * :attr:`ContainerCluster.CNI_TYPE_ANTREA`
            * :attr:`ContainerCluster.CNI_TYPE_OTHER`
            
            Specifies Container Network Interface type for container cluster.
        :type  external_id: :class:`str` or ``None``
        :param external_id: External identifier of the container cluster.
        :type  infrastructure: :class:`ContainerInfrastructureInfo` or ``None``
        :param infrastructure: 
        :type  network_errors: :class:`list` of :class:`NetworkError` or ``None``
        :param network_errors: List of network errors related to container cluster.
        :type  network_status: :class:`str` or ``None``
        :param network_status: Possible values are: 
            
            * :attr:`ContainerCluster.NETWORK_STATUS_HEALTHY`
            * :attr:`ContainerCluster.NETWORK_STATUS_UNHEALTHY`
            
            Network status of container cluster.
        :type  node_port_local_range: :class:`str` or ``None``
        :param node_port_local_range: Specifies the port range to be used for NodePortLocal services.
            format: port-or-range
        :type  node_port_range: :class:`str` or ``None``
        :param node_port_range: In case of Kubernetes container cluster, it specifies port range to
            be used for Kubernetes services created with the type NodePort.
            format: port-or-range
        :type  origin_properties: :class:`list` of :class:`KeyValuePair` or ``None``
        :param origin_properties: Array of additional specific properties of container cluster in
            key-value format.
        :type  supervisor_project_id: :class:`str` or ``None``
        :param supervisor_project_id: Specifies supervisor container project identifier for cluster.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.last_sync_time = last_sync_time
        self.description = description
        self.display_name = display_name
        self.resource_type = resource_type
        self.scope = scope
        self.tags = tags
        self.cluster_ip_ranges = cluster_ip_ranges
        self.cluster_type = cluster_type
        self.cni_type = cni_type
        self.external_id = external_id
        self.infrastructure = infrastructure
        self.network_errors = network_errors
        self.network_status = network_status
        self.node_port_local_range = node_port_local_range
        self.node_port_range = node_port_range
        self.origin_properties = origin_properties
        self.supervisor_project_id = supervisor_project_id
        VapiStruct.__init__(self)


ContainerCluster._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_cluster', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_last_sync_time': type.OptionalType(type.IntegerType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'scope': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'DiscoveredResourceScope'))),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'cluster_ip_ranges': type.OptionalType(type.ListType(type.StringType())),
        'cluster_type': type.OptionalType(type.StringType()),
        'cni_type': type.OptionalType(type.StringType()),
        'external_id': type.OptionalType(type.StringType()),
        'infrastructure': type.OptionalType(type.ReferenceType(__name__, 'ContainerInfrastructureInfo')),
        'network_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NetworkError'))),
        'network_status': type.OptionalType(type.StringType()),
        'node_port_local_range': type.OptionalType(type.StringType()),
        'node_port_range': type.OptionalType(type.StringType()),
        'origin_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'KeyValuePair'))),
        'supervisor_project_id': type.OptionalType(type.StringType()),
    },
    ContainerCluster,
    False,
    None))



class ContainerClusterListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ContainerCluster` or ``None``
        :param results: List of Container Clusters
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ContainerClusterListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_cluster_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ContainerCluster'))),
    },
    ContainerClusterListResult,
    False,
    None))



class ContainerClusterNode(VapiStruct):
    """
    Details of container cluster node i.e. container host.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CNI_AGENT_STATUS_HEALTHY = "HEALTHY"
    """


    """
    CNI_AGENT_STATUS_UNHEALTHY = "UNHEALTHY"
    """


    """
    NETWORK_STATUS_HEALTHY = "HEALTHY"
    """


    """
    NETWORK_STATUS_UNHEALTHY = "UNHEALTHY"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_last_sync_time': 'last_sync_time',
                            'description': 'description',
                            'display_name': 'display_name',
                            'resource_type': 'resource_type',
                            'scope': 'scope',
                            'tags': 'tags',
                            'cni_agent_status': 'cni_agent_status',
                            'container_cluster_id': 'container_cluster_id',
                            'external_id': 'external_id',
                            'external_ip_addresses': 'external_ip_addresses',
                            'ip_addresses': 'ip_addresses',
                            'network_errors': 'network_errors',
                            'network_status': 'network_status',
                            'origin_properties': 'origin_properties',
                            'pod_cidrs': 'pod_cidrs',
                            'provider_id': 'provider_id',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 last_sync_time=None,
                 description=None,
                 display_name=None,
                 resource_type=None,
                 scope=None,
                 tags=None,
                 cni_agent_status=None,
                 container_cluster_id=None,
                 external_id=None,
                 external_ip_addresses=None,
                 ip_addresses=None,
                 network_errors=None,
                 network_status=None,
                 origin_properties=None,
                 pod_cidrs=None,
                 provider_id=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  last_sync_time: :class:`long` or ``None``
        :param last_sync_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  scope: :class:`list` of :class:`DiscoveredResourceScope` or ``None``
        :param scope: Specifies list of scope of discovered resource. e.g. if VHC path is
            associated with principal identity, who owns the discovered
            resource, then scope id will be VHC path and scope type will be
            VHC.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  cni_agent_status: :class:`str` or ``None``
        :param cni_agent_status: Possible values are: 
            
            * :attr:`ContainerClusterNode.CNI_AGENT_STATUS_HEALTHY`
            * :attr:`ContainerClusterNode.CNI_AGENT_STATUS_UNHEALTHY`
            
            Specifies Container Network Interface agent status of container
            cluster node.
        :type  container_cluster_id: :class:`str` or ``None``
        :param container_cluster_id: External identifier of the container cluster.
        :type  external_id: :class:`str` or ``None``
        :param external_id: External identifier of the container cluster node in K8S/PAS.
        :type  external_ip_addresses: :class:`list` of :class:`str` or ``None``
        :param external_ip_addresses: Specifies list of external ip address of Node. format: ip
        :type  ip_addresses: :class:`list` of :class:`str` or ``None``
        :param ip_addresses: List of IP addresses of container cluster node. format: ip
        :type  network_errors: :class:`list` of :class:`NetworkError` or ``None``
        :param network_errors: List of network errors related to container cluster node.
        :type  network_status: :class:`str` or ``None``
        :param network_status: Possible values are: 
            
            * :attr:`ContainerClusterNode.NETWORK_STATUS_HEALTHY`
            * :attr:`ContainerClusterNode.NETWORK_STATUS_UNHEALTHY`
            
            Network status of container cluster node.
        :type  origin_properties: :class:`list` of :class:`KeyValuePair` or ``None``
        :param origin_properties: Array of additional specific properties of container cluster node
            in key-value format.
        :type  pod_cidrs: :class:`list` of :class:`str` or ``None``
        :param pod_cidrs: In case of Kubernetes container cluster, it represents the IP
            ranges assigned to the node for usage by Pod on that node. format:
            ip-cidr-block
        :type  provider_id: :class:`str` or ``None``
        :param provider_id: Specifies identifier of container cluster node given by
            infrastructure provider of container cluster. e.g. in case of
            vSpehere, it will be instance uuid of worker node virtual machine.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.last_sync_time = last_sync_time
        self.description = description
        self.display_name = display_name
        self.resource_type = resource_type
        self.scope = scope
        self.tags = tags
        self.cni_agent_status = cni_agent_status
        self.container_cluster_id = container_cluster_id
        self.external_id = external_id
        self.external_ip_addresses = external_ip_addresses
        self.ip_addresses = ip_addresses
        self.network_errors = network_errors
        self.network_status = network_status
        self.origin_properties = origin_properties
        self.pod_cidrs = pod_cidrs
        self.provider_id = provider_id
        VapiStruct.__init__(self)


ContainerClusterNode._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_cluster_node', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_last_sync_time': type.OptionalType(type.IntegerType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'scope': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'DiscoveredResourceScope'))),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'cni_agent_status': type.OptionalType(type.StringType()),
        'container_cluster_id': type.OptionalType(type.StringType()),
        'external_id': type.OptionalType(type.StringType()),
        'external_ip_addresses': type.OptionalType(type.ListType(type.StringType())),
        'ip_addresses': type.OptionalType(type.ListType(type.StringType())),
        'network_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NetworkError'))),
        'network_status': type.OptionalType(type.StringType()),
        'origin_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'KeyValuePair'))),
        'pod_cidrs': type.OptionalType(type.ListType(type.StringType())),
        'provider_id': type.OptionalType(type.StringType()),
    },
    ContainerClusterNode,
    False,
    None))



class ContainerClusterNodeListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ContainerClusterNode` or ``None``
        :param results: List of container cluster nodes
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ContainerClusterNodeListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_cluster_node_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ContainerClusterNode'))),
    },
    ContainerClusterNodeListResult,
    False,
    None))



class ContainerClusterStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """
    STATUS_HEALTHY = "HEALTHY"
    """


    """
    STATUS_DOWN = "DOWN"
    """


    """
    STATUS_DEGRADED = "DEGRADED"
    """


    """



    _canonical_to_pep_names = {
                            'cluster_id': 'cluster_id',
                            'detail': 'detail',
                            'interval': 'interval',
                            'status': 'status',
                            }

    def __init__(self,
                 cluster_id=None,
                 detail=None,
                 interval=None,
                 status=None,
                ):
        """
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: Identifier of the container cluster.
        :type  detail: :class:`str` or ``None``
        :param detail: Detail information on status.
        :type  interval: :class:`long` or ``None``
        :param interval: Display the cluster check interval in seconds. format: int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ContainerClusterStatus.STATUS_UNKNOWN`
            * :attr:`ContainerClusterStatus.STATUS_HEALTHY`
            * :attr:`ContainerClusterStatus.STATUS_DOWN`
            * :attr:`ContainerClusterStatus.STATUS_DEGRADED`
            
            Display the container cluster status.
        """
        self.cluster_id = cluster_id
        self.detail = detail
        self.interval = interval
        self.status = status
        VapiStruct.__init__(self)


ContainerClusterStatus._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_cluster_status', {
        'cluster_id': type.OptionalType(type.StringType()),
        'detail': type.OptionalType(type.StringType()),
        'interval': type.OptionalType(type.IntegerType()),
        'status': type.OptionalType(type.StringType()),
    },
    ContainerClusterStatus,
    False,
    None))



class ContainerClusterStatusList(VapiStruct):
    """
    List of the Container cluster

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ContainerClusterSummary` or ``None``
        :param results: Container cluster list.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ContainerClusterStatusList._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_cluster_status_list', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ContainerClusterSummary'))),
    },
    ContainerClusterStatusList,
    False,
    None))



class ContainerClusterSummary(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """
    STATUS_HEALTHY = "HEALTHY"
    """


    """
    STATUS_DOWN = "DOWN"
    """


    """
    STATUS_DEGRADED = "DEGRADED"
    """


    """
    TYPE_PAS = "PAS"
    """


    """
    TYPE_PKS = "PKS"
    """


    """
    TYPE_KUBERNETES = "Kubernetes"
    """


    """
    TYPE_OPENSHIFT = "Openshift"
    """


    """
    TYPE_WCP = "WCP"
    """


    """
    TYPE_OTHER = "Other"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'cluster_id': 'cluster_id',
                            'cluster_name': 'cluster_name',
                            'detail': 'detail',
                            'status': 'status',
                            'type': 'type',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 cluster_id=None,
                 cluster_name=None,
                 detail=None,
                 status=None,
                 type=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: Identifier of the container cluster.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  cluster_name: :class:`str` or ``None``
        :param cluster_name: Display the container cluster name
        :type  detail: :class:`str` or ``None``
        :param detail: Detail information on status.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ContainerClusterSummary.STATUS_UNKNOWN`
            * :attr:`ContainerClusterSummary.STATUS_HEALTHY`
            * :attr:`ContainerClusterSummary.STATUS_DOWN`
            * :attr:`ContainerClusterSummary.STATUS_DEGRADED`
            
            Display the container cluster status.
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ContainerClusterSummary.TYPE_PAS`
            * :attr:`ContainerClusterSummary.TYPE_PKS`
            * :attr:`ContainerClusterSummary.TYPE_KUBERNETES`
            * :attr:`ContainerClusterSummary.TYPE_OPENSHIFT`
            * :attr:`ContainerClusterSummary.TYPE_WCP`
            * :attr:`ContainerClusterSummary.TYPE_OTHER`
            
            Container cluster type.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.cluster_id = cluster_id
        self.cluster_name = cluster_name
        self.detail = detail
        self.status = status
        self.type = type
        VapiStruct.__init__(self)


ContainerClusterSummary._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_cluster_summary', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'cluster_id': type.OptionalType(type.StringType()),
        'cluster_name': type.OptionalType(type.StringType()),
        'detail': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
        'type': type.OptionalType(type.StringType()),
    },
    ContainerClusterSummary,
    False,
    None))



class ContainerConfiguration(VapiStruct):
    """
    Represents a container to group widgets that belong to a common category or
    have a common purpose.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ContainerConfiguration"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'header': 'header',
                            'labels': 'labels',
                            'layout': 'layout',
                            'navigation': 'navigation',
                            'widgets': 'widgets',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'condition': 'condition',
                            'datasources': 'datasources',
                            'default_filter_value': 'default_filter_value',
                            'drilldown_id': 'drilldown_id',
                            'feature_set': 'feature_set',
                            'filter': 'filter',
                            'filter_value_required': 'filter_value_required',
                            'filters': 'filters',
                            'footer': 'footer',
                            'icons': 'icons',
                            'is_drilldown': 'is_drilldown',
                            'legend': 'legend',
                            'plot_configs': 'plot_configs',
                            'rowspan': 'rowspan',
                            'shared': 'shared',
                            'show_header': 'show_header',
                            'span': 'span',
                            'weight': 'weight',
                            }

    def __init__(self,
                 header=None,
                 labels=None,
                 layout=None,
                 navigation=None,
                 widgets=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='ContainerConfiguration',
                 tags=None,
                 condition=None,
                 datasources=None,
                 default_filter_value=None,
                 drilldown_id=None,
                 feature_set=None,
                 filter=None,
                 filter_value_required=None,
                 filters=None,
                 footer=None,
                 icons=None,
                 is_drilldown=None,
                 legend=None,
                 plot_configs=None,
                 rowspan=None,
                 shared=None,
                 show_header=None,
                 span=None,
                 weight=None,
                ):
        """
        :type  header: :class:`Header` or ``None``
        :param header: 
        :type  labels: :class:`list` of :class:`Label` or ``None``
        :param labels: Labels for the container.
        :type  layout: :class:`Layout` or ``None``
        :param layout: 
        :type  navigation: :class:`str` or ``None``
        :param navigation: Hyperlink of the specified UI page that provides details.
        :type  widgets: :class:`list` of :class:`WidgetItem` or ``None``
        :param widgets: If not specified, creates an empty container.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Title of the widget. If display_name is omitted, the widget will be
            shown without a title.
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`WidgetConfiguration.RESOURCE_TYPE_LABELVALUECONFIGURATION`
            * :attr:`WidgetConfiguration.RESOURCE_TYPE_DONUTCONFIGURATION`
            *
              :attr:`WidgetConfiguration.RESOURCE_TYPE_MULTIWIDGETCONFIGURATION`
            * :attr:`WidgetConfiguration.RESOURCE_TYPE_CONTAINERCONFIGURATION`
            * :attr:`WidgetConfiguration.RESOURCE_TYPE_STATSCONFIGURATION`
            * :attr:`WidgetConfiguration.RESOURCE_TYPE_GRIDCONFIGURATION`
            * :attr:`WidgetConfiguration.RESOURCE_TYPE_GRAPHCONFIGURATION`
            *
              :attr:`WidgetConfiguration.RESOURCE_TYPE_CUSTOMWIDGETCONFIGURATION`
            *
              :attr:`WidgetConfiguration.RESOURCE_TYPE_CUSTOMFILTERWIDGETCONFIGURATION`
            *
              :attr:`WidgetConfiguration.RESOURCE_TYPE_TIMERANGEDROPDOWNFILTERWIDGETCONFIGURATION`
            *
              :attr:`WidgetConfiguration.RESOURCE_TYPE_DROPDOWNFILTERWIDGETCONFIGURATION`
            *
              :attr:`WidgetConfiguration.RESOURCE_TYPE_SPACERWIDGETCONFIGURATION`
            *
              :attr:`WidgetConfiguration.RESOURCE_TYPE_LEGENDWIDGETCONFIGURATION`
            
            Supported visualization types are LabelValueConfiguration,
            DonutConfiguration, GridConfiguration, StatsConfiguration,
            MultiWidgetConfiguration, GraphConfiguration,
            ContainerConfiguration, CustomWidgetConfiguration,
            CustomFilterWidgetConfiguration,
            TimeRangeDropdownFilterWidgetConfiguration,
            SpacerWidgetConfiguration, LegendWidgetConfiguration and
            DropdownFilterWidgetConfiguration.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  condition: :class:`str` or ``None``
        :param condition: If the condition is met then the widget will be displayed to UI. If
            no condition is provided, then the widget will be displayed
            unconditionally.
        :type  datasources: :class:`list` of :class:`Datasource` or ``None``
        :param datasources: The 'datasources' represent the sources from which data will be
            fetched. Currently, only NSX-API is supported as a 'default'
            datasource. An example of specifying 'default' datasource along
            with the urls to fetch data from is given at 'example_request'
            section of 'CreateWidgetConfiguration' API.
        :type  default_filter_value: :class:`list` of :class:`DefaultFilterValue` or ``None``
        :param default_filter_value: Default filter values to be passed to datasources. This will be
            used when the report is requested without filter values.
        :type  drilldown_id: :class:`str` or ``None``
        :param drilldown_id: Id of drilldown widget, if any. Id should be a valid id of an
            existing widget. A widget is considered as drilldown widget when it
            is associated with any other widget and provides more detailed
            information about any data item from the parent widget.
        :type  feature_set: :class:`FeatureSet` or ``None``
        :param feature_set: 
        :type  filter: :class:`str` or ``None``
        :param filter: Id of filter widget for subscription, if any. Id should be a valid
            id of an existing filter widget. Filter widget should be from the
            same view. Datasource URLs should have placeholder values equal to
            filter alias to accept the filter value on filter change. This
            field is deprecated instead use 'filters' property.

            .. deprecated:: unknown
        :type  filter_value_required: :class:`bool` or ``None``
        :param filter_value_required: Flag to indicate that widget will continue to work without filter
            value. If this flag is set to false then default_filter_value is
            manadatory.
        :type  filters: :class:`list` of :class:`str` or ``None``
        :param filters: A List of filter applied to this widget configuration. This will be
            used to identify the filters applied to this widget.
        :type  footer: :class:`Footer` or ``None``
        :param footer: 
        :type  icons: :class:`list` of :class:`Icon` or ``None``
        :param icons: Icons to be applied at dashboard for widgets and UI elements.
        :type  is_drilldown: :class:`bool` or ``None``
        :param is_drilldown: Set to true if this widget should be used as a drilldown.
        :type  legend: :class:`Legend` or ``None``
        :param legend: 
        :type  plot_configs: :class:`list` of :class:`WidgetPlotConfiguration` or ``None``
        :param plot_configs: List of plotting configuration for a given widget. Widget plotting
            configurations which are common across all the widgets types should
            be define here.
        :type  rowspan: :class:`long` or ``None``
        :param rowspan: Represents the vertical span of the widget / container. 1 Row span
            is equal to 20px. format: int32
        :type  shared: :class:`bool` or ``None``
        :param shared: Please use the property 'shared' of View instead of this. The
            widgets of a shared view are visible to other users.

            .. deprecated:: unknown
        :type  show_header: :class:`bool` or ``None``
        :param show_header: If the value of this field is set to true then card header will be
            displayed otherwise only card will be displayed without header.
        :type  span: :class:`long` or ``None``
        :param span: Represents the horizontal span of the widget / container. format:
            int32
        :type  weight: :class:`long` or ``None``
        :param weight: Specify relavite weight in WidgetItem for placement in a view.
            Please see WidgetItem for details. format: int32

            .. deprecated:: unknown
        """
        self.header = header
        self.labels = labels
        self.layout = layout
        self.navigation = navigation
        self.widgets = widgets
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.condition = condition
        self.datasources = datasources
        self.default_filter_value = default_filter_value
        self.drilldown_id = drilldown_id
        self.feature_set = feature_set
        self.filter = filter
        self.filter_value_required = filter_value_required
        self.filters = filters
        self.footer = footer
        self.icons = icons
        self.is_drilldown = is_drilldown
        self.legend = legend
        self.plot_configs = plot_configs
        self.rowspan = rowspan
        self.shared = shared
        self.show_header = show_header
        self.span = span
        self.weight = weight
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ContainerConfiguration._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_configuration', {
        'header': type.OptionalType(type.ReferenceType(__name__, 'Header')),
        'labels': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Label'))),
        'layout': type.OptionalType(type.ReferenceType(__name__, 'Layout')),
        'navigation': type.OptionalType(type.StringType()),
        'widgets': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'WidgetItem'))),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'condition': type.OptionalType(type.StringType()),
        'datasources': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Datasource'))),
        'default_filter_value': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'DefaultFilterValue'))),
        'drilldown_id': type.OptionalType(type.StringType()),
        'feature_set': type.OptionalType(type.ReferenceType(__name__, 'FeatureSet')),
        'filter': type.OptionalType(type.StringType()),
        'filter_value_required': type.OptionalType(type.BooleanType()),
        'filters': type.OptionalType(type.ListType(type.StringType())),
        'footer': type.OptionalType(type.ReferenceType(__name__, 'Footer')),
        'icons': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Icon'))),
        'is_drilldown': type.OptionalType(type.BooleanType()),
        'legend': type.OptionalType(type.ReferenceType(__name__, 'Legend')),
        'plot_configs': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'WidgetPlotConfiguration'))),
        'rowspan': type.OptionalType(type.IntegerType()),
        'shared': type.OptionalType(type.BooleanType()),
        'show_header': type.OptionalType(type.BooleanType()),
        'span': type.OptionalType(type.IntegerType()),
        'weight': type.OptionalType(type.IntegerType()),
    },
    ContainerConfiguration,
    False,
    None))



class ContainerEgress(VapiStruct):
    """
    Details of Container Egress.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_last_sync_time': 'last_sync_time',
                            'description': 'description',
                            'display_name': 'display_name',
                            'resource_type': 'resource_type',
                            'scope': 'scope',
                            'tags': 'tags',
                            'container_cluster_id': 'container_cluster_id',
                            'egress_ip': 'egress_ip',
                            'external_id': 'external_id',
                            'origin_properties': 'origin_properties',
                            'spec': 'spec',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 last_sync_time=None,
                 description=None,
                 display_name=None,
                 resource_type=None,
                 scope=None,
                 tags=None,
                 container_cluster_id=None,
                 egress_ip=None,
                 external_id=None,
                 origin_properties=None,
                 spec=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  last_sync_time: :class:`long` or ``None``
        :param last_sync_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  scope: :class:`list` of :class:`DiscoveredResourceScope` or ``None``
        :param scope: Specifies list of scope of discovered resource. e.g. if VHC path is
            associated with principal identity, who owns the discovered
            resource, then scope id will be VHC path and scope type will be
            VHC.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  container_cluster_id: :class:`str` or ``None``
        :param container_cluster_id: Identifier of the container cluster this egress belongs to.
        :type  egress_ip: :class:`str` or ``None``
        :param egress_ip: Container egress IP. format: ip
        :type  external_id: :class:`str` or ``None``
        :param external_id: Identifier of the container egress.
        :type  origin_properties: :class:`list` of :class:`KeyValuePair` or ``None``
        :param origin_properties: Array of additional specific properties of container egress in
            key-value format. e.g. key can be externalIPPool, value is a string
        :type  spec: :class:`str` or ``None``
        :param spec: This specifies yaml definition of ContainerEgress resource. e.g.
            yaml definition of kubernetes egress resource.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.last_sync_time = last_sync_time
        self.description = description
        self.display_name = display_name
        self.resource_type = resource_type
        self.scope = scope
        self.tags = tags
        self.container_cluster_id = container_cluster_id
        self.egress_ip = egress_ip
        self.external_id = external_id
        self.origin_properties = origin_properties
        self.spec = spec
        VapiStruct.__init__(self)


ContainerEgress._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_egress', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_last_sync_time': type.OptionalType(type.IntegerType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'scope': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'DiscoveredResourceScope'))),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'container_cluster_id': type.OptionalType(type.StringType()),
        'egress_ip': type.OptionalType(type.StringType()),
        'external_id': type.OptionalType(type.StringType()),
        'origin_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'KeyValuePair'))),
        'spec': type.OptionalType(type.StringType()),
    },
    ContainerEgress,
    False,
    None))



class ContainerEgressListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ContainerEgress` or ``None``
        :param results: Specifies list of container egress.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ContainerEgressListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_egress_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ContainerEgress'))),
    },
    ContainerEgressListResult,
    False,
    None))



class ContainerGateway(VapiStruct):
    """
    A Gateway describes how traffic can be translated to Services within the
    container cluster.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_last_sync_time': 'last_sync_time',
                            'description': 'description',
                            'display_name': 'display_name',
                            'resource_type': 'resource_type',
                            'scope': 'scope',
                            'tags': 'tags',
                            'addresses': 'addresses',
                            'container_cluster_id': 'container_cluster_id',
                            'container_project_id': 'container_project_id',
                            'external_id': 'external_id',
                            'listeners': 'listeners',
                            'origin_properties': 'origin_properties',
                            'spec': 'spec',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 last_sync_time=None,
                 description=None,
                 display_name=None,
                 resource_type=None,
                 scope=None,
                 tags=None,
                 addresses=None,
                 container_cluster_id=None,
                 container_project_id=None,
                 external_id=None,
                 listeners=None,
                 origin_properties=None,
                 spec=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  last_sync_time: :class:`long` or ``None``
        :param last_sync_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  scope: :class:`list` of :class:`DiscoveredResourceScope` or ``None``
        :param scope: Specifies list of scope of discovered resource. e.g. if VHC path is
            associated with principal identity, who owns the discovered
            resource, then scope id will be VHC path and scope type will be
            VHC.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  addresses: :class:`list` of :class:`ContainerGatewayAddress` or ``None``
        :param addresses: Specifies addresses which lists the IP addresses that have actually
            been bound to the gateway.
        :type  container_cluster_id: :class:`str` or ``None``
        :param container_cluster_id: Specifies identifier of the container cluster of this container
            gateway.
        :type  container_project_id: :class:`str` or ``None``
        :param container_project_id: Specifies identifier of the container project of this container
            gateway.
        :type  external_id: :class:`str` or ``None``
        :param external_id: Specifies identifier of the container gateway.
        :type  listeners: :class:`list` of :class:`ContainerGatewayListener` or ``None``
        :param listeners: Specifies list of listeners which defines logical endpoints that
            are bound on this Gateway's addresses.
        :type  origin_properties: :class:`list` of :class:`KeyValuePair` or ``None``
        :param origin_properties: Array of additional specific properties of container ip pool in
            key-value format.
        :type  spec: :class:`str` or ``None``
        :param spec: This specifies yaml definition of ContainerGateway resource.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.last_sync_time = last_sync_time
        self.description = description
        self.display_name = display_name
        self.resource_type = resource_type
        self.scope = scope
        self.tags = tags
        self.addresses = addresses
        self.container_cluster_id = container_cluster_id
        self.container_project_id = container_project_id
        self.external_id = external_id
        self.listeners = listeners
        self.origin_properties = origin_properties
        self.spec = spec
        VapiStruct.__init__(self)


ContainerGateway._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_gateway', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_last_sync_time': type.OptionalType(type.IntegerType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'scope': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'DiscoveredResourceScope'))),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'addresses': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ContainerGatewayAddress'))),
        'container_cluster_id': type.OptionalType(type.StringType()),
        'container_project_id': type.OptionalType(type.StringType()),
        'external_id': type.OptionalType(type.StringType()),
        'listeners': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ContainerGatewayListener'))),
        'origin_properties': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'KeyValuePair'))),
        'spec': type.OptionalType(type.StringType()),
    },
    ContainerGateway,
    False,
    None))



class ContainerGatewayAddress(VapiStruct):
    """
    Specifies an address that can be bound to a container gateway.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_HOST_NAME = "HOST_NAME"
    """


    """
    TYPE_IP_ADDRESS = "IP_ADDRESS"
    """


    """
    TYPE_NAMED_ADDRESS = "NAMED_ADDRESS"
    """


    """



    _canonical_to_pep_names = {
                            'address': 'address',
                            'type': 'type',
                            }

    def __init__(self,
                 address=None,
                 type=None,
                ):
        """
        :type  address: :class:`str` or ``None``
        :param address: Specifies address of container gateway.
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ContainerGatewayAddress.TYPE_HOST_NAME`
            * :attr:`ContainerGatewayAddress.TYPE_IP_ADDRESS`
            * :attr:`ContainerGatewayAddress.TYPE_NAMED_ADDRESS`
            
            Specifies type of gateway address. e.g. Hostname, IPAddress,
            NamedAddress.
        """
        self.address = address
        self.type = type
        VapiStruct.__init__(self)


ContainerGatewayAddress._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_gateway_address', {
        'address': type.OptionalType(type.StringType()),
        'type': type.OptionalType(type.StringType()),
    },
    ContainerGatewayAddress,
    False,
    None))



class ContainerGatewayListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ContainerGateway` or ``None``
        :param results: List of Container Gateway
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ContainerGatewayListResult._set_binding_type(type.StructType(
    'com.vmware.nsx.model.container_gateway_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
       