/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.SliderUI;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.gui.JAttributeSlider;
import org.jhotdraw.gui.JAttributeTextField;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.gui.event.FigureAttributeEditorHandler;
import org.jhotdraw.gui.event.SelectionComponentDisplayer;
import org.jhotdraw.gui.event.SelectionComponentRepainter;
import org.jhotdraw.gui.plaf.palette.PaletteButtonUI;
import org.jhotdraw.gui.plaf.palette.PaletteFormattedTextFieldUI;
import org.jhotdraw.gui.plaf.palette.PaletteSliderUI;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.gui.AbstractToolBar;
import org.jhotdraw.samples.svg.gui.SelectionOpacityIcon;
import org.jhotdraw.text.ColorFormatter;
import org.jhotdraw.text.JavaNumberFormatter;
import org.jhotdraw.util.Images;
import org.jhotdraw.util.ResourceBundleUtil;

public class FillToolBar
extends AbstractToolBar {
    private SelectionComponentDisplayer displayer;

    public FillToolBar() {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        this.setName(resourceBundleUtil.getString(this.getID() + ".toolbar"));
        this.setDisclosureStateCount(3);
    }

    @Override
    public void setEditor(DrawingEditor drawingEditor) {
        DrawingEditor drawingEditor2 = this.getEditor();
        if (this.displayer != null) {
            this.displayer.dispose();
            this.displayer = null;
        }
        super.setEditor(drawingEditor);
        if (drawingEditor != null) {
            this.displayer = new SelectionComponentDisplayer(this.editor, this);
        }
    }

    @Override
    protected JComponent createDisclosedComponent(int n) {
        JPanel jPanel = null;
        switch (n) {
            case 1: {
                jPanel = new JPanel();
                jPanel.setOpaque(false);
                jPanel.setBorder(new EmptyBorder(5, 5, 5, 8));
                if (this.editor == null) break;
                ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                ResourceBundleUtil resourceBundleUtil2 = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout gridBagLayout = new GridBagLayout();
                jPanel.setLayout(gridBagLayout);
                HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
                SVGAttributeKeys.FILL_GRADIENT.put(hashMap, null);
                JPopupButton jPopupButton = ButtonFactory.createSelectionColorButton(this.editor, SVGAttributeKeys.FILL_COLOR, ButtonFactory.HSV_COLORS, 12, "attribute.fillColor", resourceBundleUtil2, hashMap, new Rectangle(3, 3, 10, 10), this.disposables);
                jPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jPopupButton));
                jPopupButton.setAction(null, null);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.anchor = 23;
                jPanel.add((Component)jPopupButton, gridBagConstraints);
                JPopupButton jPopupButton2 = new JPopupButton();
                JAttributeSlider jAttributeSlider = new JAttributeSlider(1, 0, 100, 100);
                jPopupButton2.add(jAttributeSlider);
                resourceBundleUtil2.configureToolBarButton(jPopupButton2, "attribute.fillOpacity");
                jPopupButton2.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jPopupButton2));
                jPopupButton2.setIcon(new SelectionOpacityIcon(this.editor, SVGAttributeKeys.FILL_OPACITY, (AttributeKey<Color>)SVGAttributeKeys.FILL_COLOR, null, Images.createImage(this.getClass(), resourceBundleUtil2.getString("attribute.fillOpacity.icon")), (Shape)new Rectangle(5, 5, 6, 6), (Shape)new Rectangle(4, 4, 7, 7)));
                jPopupButton2.setPopupAnchor(4);
                this.disposables.add(new SelectionComponentRepainter(this.editor, jPopupButton2));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.anchor = 23;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                jPanel.add((Component)jPopupButton2, gridBagConstraints);
                jAttributeSlider.setUI((SliderUI)PaletteSliderUI.createUI(jAttributeSlider));
                jAttributeSlider.setScaleFactor(100.0);
                this.disposables.add(new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.FILL_OPACITY, jAttributeSlider, this.editor));
                break;
            }
            case 2: {
                jPanel = new JPanel();
                jPanel.setOpaque(false);
                if (this.editor == null) break;
                JPanel jPanel2 = new JPanel(new GridBagLayout());
                JPanel jPanel3 = new JPanel(new GridBagLayout());
                JPanel jPanel4 = new JPanel(new GridBagLayout());
                jPanel2.setOpaque(false);
                jPanel3.setOpaque(false);
                jPanel4.setOpaque(false);
                jPanel.setBorder(new EmptyBorder(5, 5, 5, 8));
                jPanel.removeAll();
                ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout gridBagLayout = new GridBagLayout();
                jPanel.setLayout(gridBagLayout);
                HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
                SVGAttributeKeys.FILL_GRADIENT.put(hashMap, null);
                JAttributeTextField jAttributeTextField = new JAttributeTextField();
                jAttributeTextField.setColumns(7);
                jAttributeTextField.setToolTipText(resourceBundleUtil.getString("attribute.fillColor.toolTipText"));
                jAttributeTextField.putClientProperty("Palette.Component.segmentPosition", "first");
                jAttributeTextField.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(jAttributeTextField));
                jAttributeTextField.setFormatterFactory(ColorFormatter.createFormatterFactory());
                jAttributeTextField.setHorizontalAlignment(2);
                this.disposables.add(new FigureAttributeEditorHandler(SVGAttributeKeys.FILL_COLOR, hashMap, jAttributeTextField, this.editor, true));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 23;
                jPanel2.add(jAttributeTextField, gridBagConstraints);
                JPopupButton jPopupButton = ButtonFactory.createSelectionColorButton(this.editor, SVGAttributeKeys.FILL_COLOR, ButtonFactory.HSV_COLORS, 12, "attribute.fillColor", resourceBundleUtil, hashMap, new Rectangle(3, 3, 10, 10), this.disposables);
                jPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jPopupButton));
                jPopupButton.setAction(null, null);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.anchor = 23;
                jPanel2.add((Component)jPopupButton, gridBagConstraints);
                JAttributeTextField jAttributeTextField2 = new JAttributeTextField();
                jAttributeTextField2.setColumns(3);
                jAttributeTextField2.setToolTipText(resourceBundleUtil.getString("attribute.fillOpacity.toolTipText"));
                jAttributeTextField2.putClientProperty("Palette.Component.segmentPosition", "first");
                jAttributeTextField2.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(jAttributeTextField2));
                jAttributeTextField2.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 1.0, 100.0));
                jAttributeTextField2.setHorizontalAlignment(2);
                this.disposables.add(new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.FILL_OPACITY, jAttributeTextField2, this.editor));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 23;
                jPanel3.add(jAttributeTextField2, gridBagConstraints);
                JPopupButton jPopupButton3 = new JPopupButton();
                JAttributeSlider jAttributeSlider = new JAttributeSlider(1, 0, 100, 100);
                jPopupButton3.add(jAttributeSlider);
                resourceBundleUtil.configureToolBarButton(jPopupButton3, "attribute.fillOpacity");
                jPopupButton3.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jPopupButton3));
                jPopupButton3.setPopupAnchor(4);
                jPopupButton3.setIcon(new SelectionOpacityIcon(this.editor, SVGAttributeKeys.FILL_OPACITY, (AttributeKey<Color>)SVGAttributeKeys.FILL_COLOR, null, Images.createImage(this.getClass(), resourceBundleUtil.getString("attribute.fillOpacity.icon")), (Shape)new Rectangle(5, 5, 6, 6), (Shape)new Rectangle(4, 4, 7, 7)));
                jPopupButton3.setPopupAnchor(4);
                this.disposables.add(new SelectionComponentRepainter(this.editor, jPopupButton3));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.anchor = 23;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                jPanel3.add((Component)jPopupButton3, gridBagConstraints);
                jAttributeSlider.setUI((SliderUI)PaletteSliderUI.createUI(jAttributeSlider));
                jAttributeSlider.setScaleFactor(100.0);
                this.disposables.add(new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.FILL_OPACITY, jAttributeSlider, this.editor));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = 23;
                jPanel.add((Component)jPanel2, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = 23;
                jPanel.add((Component)jPanel3, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 2;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.anchor = 23;
                jPanel.add((Component)jPanel4, gridBagConstraints);
            }
        }
        return jPanel;
    }

    @Override
    protected String getID() {
        return "fill";
    }

    @Override
    protected int getDefaultDisclosureState() {
        return 1;
    }

    private void initComponents() {
        this.setOpaque(false);
    }
}

