/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.scheduler;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.graalvm.visualvm.core.scheduler.DefaultScheduledTask;
import org.graalvm.visualvm.core.scheduler.Quantum;
import org.graalvm.visualvm.core.scheduler.ScheduledTask;
import org.graalvm.visualvm.core.scheduler.SchedulerTask;

public class Scheduler {
    private static final Logger LOGGER = Logger.getLogger(Scheduler.class.getName());
    private static final Scheduler INSTANCE = new Scheduler();
    private final ExecutorService immediateTaskService = Executors.newCachedThreadPool();

    private Scheduler() {
    }

    public static final Scheduler sharedInstance() {
        return INSTANCE;
    }

    public final ScheduledTask schedule(SchedulerTask task, Quantum interval) {
        return this.schedule(task, interval, true);
    }

    public final ScheduledTask schedule(final SchedulerTask task, Quantum interval, boolean immediate) {
        boolean suspended = interval.equals(Quantum.SUSPENDED);
        if (immediate && !suspended) {
            this.immediateTaskService.submit(new Runnable(){

                @Override
                public void run() {
                    task.onSchedule(System.currentTimeMillis());
                }
            });
        }
        DefaultScheduledTask scheduled = new DefaultScheduledTask(interval, task);
        return scheduled;
    }

    public final void unschedule(ScheduledTask task) {
        if (task == null) {
            return;
        }
        task.suspend();
    }
}

