/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.popupswitcher;

import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.popupswitcher.Item;
import org.openide.windows.TopComponent;

class Model
extends AbstractTableModel {
    private final Item[] documents;
    private final Item[] views;
    private int rowCount;
    private int colCount;
    private int documentCol = -1;
    private int viewCol = 0;
    private int initialColumn;
    private final boolean hasIcons;
    private int selCol = -1;
    private int selRow = -1;
    private Item selectedTopItem = null;
    private int extraRows = 0;

    Model(boolean bl) {
        this(Model.createItems(true), bl ? new Item[]{} : Model.createItems(false), Model.isEditorTCActive());
    }

    Model(Item[] itemArray, Item[] itemArray2, boolean bl) {
        Icon icon;
        int n;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        this.documents = itemArray;
        for (n = 0; n < itemArray.length; ++n) {
            icon = itemArray[n].getIcon();
            bl4 |= null != icon && icon.getIconWidth() > 0;
            bl2 |= itemArray[n].hasSubItems();
        }
        this.views = itemArray2;
        for (n = 0; n < itemArray2.length; ++n) {
            icon = itemArray2[n].getIcon();
            bl4 |= null != icon && icon.getIconWidth() > 0;
            bl3 |= itemArray2[n].hasSubItems();
        }
        this.hasIcons = bl4;
        this.rowCount = Math.max(itemArray2.length, itemArray.length);
        n = 0;
        if (itemArray.length > 0) {
            ++n;
            this.documentCol = 0;
            ++this.viewCol;
            if (bl2) {
                ++n;
                ++this.viewCol;
            }
        }
        if (itemArray2.length > 0) {
            ++n;
            if (bl3) {
                ++n;
            }
        } else {
            this.viewCol = -1;
        }
        this.colCount = n;
        this.initialColumn = bl ? this.documentCol : this.viewCol;
    }

    @Override
    public int getRowCount() {
        return this.rowCount + this.extraRows;
    }

    @Override
    public int getColumnCount() {
        return this.colCount;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.selCol >= 0 && n2 == this.selCol + 1) {
            if (n < this.selRow) {
                return null;
            }
            Item[] itemArray = this.selectedTopItem.getActivatableSubItems();
            if (null == itemArray || (n -= this.selRow) >= itemArray.length) {
                return null;
            }
            return this.selectedTopItem.getActivatableSubItems()[n];
        }
        Item[] itemArray = null;
        if (n2 == this.documentCol) {
            itemArray = this.documents;
        } else if (n2 == this.viewCol) {
            itemArray = this.views;
        }
        if (null == itemArray || n >= itemArray.length || n < 0) {
            return null;
        }
        return itemArray[n];
    }

    int getInitialColumn() {
        return this.initialColumn;
    }

    int getRowCount(int n) {
        if (n != this.viewCol && n != this.documentCol) {
            throw new IllegalArgumentException();
        }
        if (n == this.viewCol) {
            return this.views.length;
        }
        return this.documents.length;
    }

    boolean hasIcons() {
        return this.hasIcons;
    }

    void setCurrentSelection(int n, int n2) {
        if (n < 0 || n2 < 0) {
            this.showSubTabs(-1, -1);
        }
        if (n2 != this.viewCol && n2 != this.documentCol) {
            return;
        }
        this.showSubTabs(n, n2);
    }

    private void showSubTabs(int n, int n2) {
        this.selCol = n2;
        this.selRow = n;
        int n3 = this.rowCount;
        this.selectedTopItem = null;
        if (this.selCol >= 0) {
            Item item = this.selectedTopItem = this.selCol == this.documentCol ? this.documents[this.selRow] : this.views[this.selRow];
            if (this.selectedTopItem.hasSubItems()) {
                n3 = Math.max(this.rowCount, this.selectedTopItem.getActivatableSubItems().length + this.selRow);
            } else {
                this.selCol = -1;
                this.selRow = -1;
                this.selectedTopItem = null;
            }
        }
        if (this.documentCol >= 0) {
            this.fireTableChanged(new TableModelEvent(this, 0, this.getRowCount(), this.documentCol + 1));
        }
        if (this.viewCol >= 0) {
            this.fireTableChanged(new TableModelEvent(this, 0, this.getRowCount(), this.viewCol + 1));
        }
        int n4 = n3 - this.getRowCount();
        this.extraRows = n3 - this.rowCount;
        if (n4 < 0) {
            this.fireTableRowsDeleted(this.rowCount, this.rowCount - n4);
        } else if (n4 > 0) {
            this.fireTableRowsInserted(this.rowCount, this.rowCount + n4);
        }
    }

    boolean isTopItemColumn(int n) {
        return n >= 0 && (n == this.viewCol || n == this.documentCol);
    }

    int getMaxRowCount() {
        int n;
        int n2 = this.rowCount;
        for (n = 0; n < this.documents.length; ++n) {
            if (!this.documents[n].hasSubItems()) continue;
            n2 = Math.max(n2, n + this.documents[n].getActivatableSubItems().length);
        }
        for (n = 0; n < this.views.length; ++n) {
            if (!this.views[n].hasSubItems()) continue;
            n2 = Math.max(n2, n + this.views[n].getActivatableSubItems().length);
        }
        return n2;
    }

    private static Item[] createItems(boolean bl) {
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        TopComponent[] topComponentArray = windowManagerImpl.getRecentViewList();
        ArrayList<Item> arrayList = new ArrayList<Item>(topComponentArray.length);
        for (TopComponent topComponent : topComponentArray) {
            boolean bl2;
            if (topComponent == null) continue;
            ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
            boolean bl3 = bl2 = null != modeImpl && modeImpl.getKind() == 1;
            if (bl != bl2) continue;
            arrayList.add(Item.create(topComponent));
        }
        return arrayList.toArray(new Item[0]);
    }

    private static boolean isEditorTCActive() {
        ModeImpl modeImpl;
        boolean bl = true;
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (null != topComponent && null != (modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent))) {
            bl = modeImpl.getKind() == 1;
        }
        return bl;
    }
}

