/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql.jdbcwrapper;

import ca.sqlpower.sql.CachedRowSet;
import ca.sqlpower.sql.SQL;
import ca.sqlpower.sql.jdbcwrapper.ConnectionDecorator;
import ca.sqlpower.sql.jdbcwrapper.DatabaseMetaDataDecorator;
import ca.sqlpower.sql.jdbcwrapper.ResultSetDecorator;
import ca.sqlpower.sql.jdbcwrapper.SQLServerResultSetDecorator;
import ca.sqlpower.sql.jdbcwrapper.SQLServerStatementDecorator;
import ca.sqlpower.sql.jdbcwrapper.StatementDecorator;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class SQLServerDatabaseMetaDataDecorator
extends DatabaseMetaDataDecorator {
    private static final Logger logger = Logger.getLogger(SQLServerDatabaseMetaDataDecorator.class);

    public SQLServerDatabaseMetaDataDecorator(DatabaseMetaData delegate, ConnectionDecorator connectionDecorator) {
        super(delegate, connectionDecorator);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        boolean fudgeAutoInc;
        ResultSet rs = super.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        CachedRowSet crs = new CachedRowSet();
        boolean bl = fudgeAutoInc = SQL.findColumnIndex(rs, "IS_AUTOINCREMENT") == -1;
        if (fudgeAutoInc) {
            crs.populate(rs, null, "IS_AUTOINCREMENT");
        } else {
            crs.populate(rs);
        }
        rs.close();
        if (fudgeAutoInc) {
            int autoIncColNum = crs.findColumn("IS_AUTOINCREMENT");
            int defaultColNum = crs.findColumn("COLUMN_DEF");
            while (crs.next()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Examining col " + crs.getString(4) + " (" + crs.getString(6) + ")"));
                }
                if (crs.getString(6) != null && crs.getString(6).toLowerCase().indexOf(" identity") >= 0) {
                    crs.updateString(autoIncColNum, "YES");
                    logger.debug((Object)"  AUTO-INC!");
                } else {
                    crs.updateString(autoIncColNum, "NO");
                    logger.debug((Object)"  NOT AUTO-INC!");
                }
                crs.updateString(defaultColNum, SQLServerDatabaseMetaDataDecorator.stripParens(crs.getString(defaultColNum)));
            }
            crs.beforeFirst();
        }
        return crs;
    }

    public static String stripParens(String original) {
        if (original == null) {
            return null;
        }
        Pattern p = Pattern.compile("\\((.*)\\)");
        Matcher m = p.matcher(original);
        while (m.matches()) {
            original = m.group(1);
            m = p.matcher(original);
        }
        return original;
    }

    @Override
    protected ResultSetDecorator wrap(ResultSet rs) throws SQLException {
        return new SQLServerResultSetDecorator(this.wrap(rs.getStatement()), rs);
    }

    @Override
    protected StatementDecorator wrap(Statement statement) {
        return new SQLServerStatementDecorator(this.connectionDecorator, statement);
    }
}

