/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.object.AbstractPoolingSPListener;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.log4j.Logger;

public class SQLTableListModel
extends AbstractPoolingSPListener
implements ListModel {
    private static final Logger logger = Logger.getLogger(SQLTableListModel.class);
    protected SQLTable table;
    protected ArrayList listeners;

    public SQLTableListModel(SQLTable table) {
        this.table = table;
        this.listeners = new ArrayList();
    }

    @Override
    public int getSize() {
        try {
            return this.table.getColumns().size();
        }
        catch (SQLObjectException ex) {
            throw new RuntimeException("Couldn't get child count", ex);
        }
    }

    public Object getElementAt(int index) {
        try {
            return this.table.getColumns().get(index);
        }
        catch (SQLObjectException ex) {
            throw new RuntimeException("Couldn't get child " + index, ex);
        }
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    protected void fireContentsChanged(int index0, int index1) {
        ListDataEvent e = new ListDataEvent(this, 0, index0, index1);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((ListDataListener)it.next()).contentsChanged(e);
        }
    }

    protected void fireIntervalAdded(int index0, int index1) {
        ListDataEvent e = new ListDataEvent(this, 1, index0, index1);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((ListDataListener)it.next()).intervalAdded(e);
        }
    }

    protected void fireIntervalRemoved(int index0, int index1) {
        ListDataEvent e = new ListDataEvent(this, 2, index0, index1);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((ListDataListener)it.next()).intervalRemoved(e);
        }
    }

    public void childAddedImpl(SPChildEvent e) {
        this.fireIntervalAdded(e.getIndex(), e.getIndex());
    }

    public void childRemovedImpl(SPChildEvent e) {
        this.fireIntervalRemoved(e.getIndex(), e.getIndex());
    }

    public void propertyChangeImpl(PropertyChangeEvent e) {
        if (e.getSource() == this.table) {
            int index = ((SPObject)e.getSource()).getChildren(((SPObject)e.getSource()).getClass()).indexOf(e.getSource());
            logger.debug((Object)("Firing contentsChanged event for index " + index));
            this.fireContentsChanged(index, index);
        } else if (e.getSource() instanceof SQLColumn) {
            try {
                int index = this.table.getColumns().indexOf(e.getSource());
                if (index >= 0) {
                    this.fireContentsChanged(index, index);
                }
            }
            catch (SQLObjectException ex) {
                logger.error((Object)"Exception in dbObjectChanged", (Throwable)ex);
            }
        } else {
            logger.warn((Object)("Unexpected SQLObjectEvent: " + e));
        }
    }
}

