/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

public final class ReplicationManagerAckPolicy {
    public static final ReplicationManagerAckPolicy ALL = new ReplicationManagerAckPolicy("ALL", 1);
    public static final ReplicationManagerAckPolicy ALL_PEERS = new ReplicationManagerAckPolicy("ALL_PEERS", 2);
    public static final ReplicationManagerAckPolicy NONE = new ReplicationManagerAckPolicy("NONE", 3);
    public static final ReplicationManagerAckPolicy ONE = new ReplicationManagerAckPolicy("ONE", 4);
    public static final ReplicationManagerAckPolicy ONE_PEER = new ReplicationManagerAckPolicy("ONE_PEER", 5);
    public static final ReplicationManagerAckPolicy QUORUM = new ReplicationManagerAckPolicy("QUORUM", 6);
    private String statusName;
    private int id;

    static ReplicationManagerAckPolicy fromInt(int n) {
        switch (n) {
            case 1: {
                return ALL;
            }
            case 2: {
                return ALL_PEERS;
            }
            case 3: {
                return NONE;
            }
            case 4: {
                return ONE;
            }
            case 5: {
                return ONE_PEER;
            }
            case 6: {
                return QUORUM;
            }
        }
        throw new IllegalArgumentException("Unknown ACK policy: " + n);
    }

    private ReplicationManagerAckPolicy(String string, int n) {
        this.statusName = string;
        this.id = n;
    }

    int getId() {
        return this.id;
    }

    public String toString() {
        return "ReplicationManagerAckPolicy." + this.statusName;
    }
}

