/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import org.jgroups.annotations.Component;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class CompareMetrics {
    protected static final String ROOT_PACKAGE = "org.jgroups";
    protected static final String[] PACKAGES = new String[]{"org.jgroups.protocols", "org.jgroups.protocols.pbcast", "org.jgroups.protocols.dns", "org.jgroups.protocols.relay"};

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        String from_file = null;
        String to_file = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-from".equals(args[i])) {
                from_file = args[++i];
                continue;
            }
            if ("-to".equals(args[i])) {
                to_file = args[++i];
                continue;
            }
            System.out.printf("%s (-from <read from file> | -to <dump to file>)\n", CompareMetrics.class.getSimpleName());
            return;
        }
        if (from_file == null && to_file == null || from_file != null && to_file != null) {
            throw new IllegalArgumentException("(only) one of '-from' or '-to' has to be defined");
        }
        Map<String, Collection<String>> old_metrics = null;
        if (from_file != null) {
            old_metrics = CompareMetrics.readOldMetrics(from_file);
            long total_attrs = old_metrics.values().stream().mapToLong(Collection::size).sum();
            System.out.printf("-- read old metrics: %d protocols and %,d attributes\n", old_metrics.size(), total_attrs);
        }
        Map<String, Collection<String>> new_metrics = CompareMetrics.readCurrentMetrics();
        long total_attrs = new_metrics.values().stream().mapToLong(Collection::size).sum();
        System.out.printf("-- read current metrics: %d protocols and %,d attributes\n", new_metrics.size(), total_attrs);
        if (to_file != null) {
            CompareMetrics.writeMetricsToFile(new_metrics, to_file);
            return;
        }
        CompareMetrics.compareMetrics(new_metrics, old_metrics);
        old_metrics.put("UDP", List.of("number_of_messages"));
        new_metrics.put("UDP", List.of("num_msgs"));
        if (old_metrics.isEmpty() && new_metrics.isEmpty()) {
            System.out.println("\n** Success: both old and new metrics are the same");
            return;
        }
        if (!old_metrics.isEmpty()) {
            System.out.printf("\n** Failure: the following protocols/attributes are only found in old metrics, but not in new:\n%s\n", CompareMetrics.print(old_metrics));
        }
        if (!new_metrics.isEmpty()) {
            System.out.printf("\n** The following protocols/attributes are only found in new, but not in old (this may not be an error, e.g. when new protocols or attributes have been added):\n%s\n", CompareMetrics.print(new_metrics));
        }
    }

    protected static Map<String, Collection<String>> readOldMetrics(String from_file) throws IOException {
        ConcurrentSkipListMap<String, Collection<String>> map = new ConcurrentSkipListMap<String, Collection<String>>();
        try (FileInputStream in = new FileInputStream(from_file);){
            String line;
            boolean i = true;
            while ((line = Util.readLine(in)) != null) {
                int index = line.indexOf(":");
                String protocol = line.substring(0, index).trim();
                index = line.indexOf("[");
                int end = line.indexOf("]");
                String attributes = line.substring(index + 1, end);
                StringTokenizer tok = new StringTokenizer(attributes, ",");
                ConcurrentSkipListSet<String> attrs = new ConcurrentSkipListSet<String>();
                while (tok.hasMoreTokens()) {
                    String attr = tok.nextToken().trim();
                    attrs.add(attr);
                }
                map.put(protocol, attrs);
            }
        }
        return map;
    }

    protected static Map<String, Collection<String>> readCurrentMetrics() throws IOException, ClassNotFoundException {
        ConcurrentSkipListMap<String, Collection<String>> map = new ConcurrentSkipListMap<String, Collection<String>>();
        Set<Class<?>> classes = CompareMetrics.getProtocols();
        for (Class<?> cl : classes) {
            Collection<String> attrs = CompareMetrics.getAttributes(cl, null);
            if (attrs.isEmpty()) continue;
            map.put(cl.getSimpleName(), attrs);
        }
        return map;
    }

    protected static Set<Class<?>> getProtocols() throws IOException, ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        HashSet s = new HashSet();
        for (String p : PACKAGES) {
            Set<Class<?>> tmp = Util.findClassesAssignableFrom(p, Protocol.class, cl);
            s.addAll(tmp);
        }
        return s;
    }

    protected static void writeMetricsToFile(Map<String, Collection<String>> metrics, String to_file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(to_file);){
            for (Map.Entry<String, Collection<String>> e : metrics.entrySet()) {
                String s = String.format("%s: %s\n", e.getKey(), e.getValue());
                ((OutputStream)out).write(s.getBytes());
            }
        }
    }

    protected static void compareMetrics(Map<String, Collection<String>> new_metrics, Map<String, Collection<String>> old_metrics) {
        Iterator<Map.Entry<String, Collection<String>>> it = old_metrics.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Collection<String>> old_entry = it.next();
            String key = old_entry.getKey();
            Collection<String> old_attrs = old_entry.getValue();
            Collection<String> new_attrs = new_metrics.get(key);
            boolean rc = new_attrs != null && CompareMetrics.compareAttributes(new_attrs, old_attrs);
            if (!rc) continue;
            it.remove();
            new_metrics.remove(key);
        }
    }

    protected static boolean compareAttributes(Collection<String> new_attrs, Collection<String> old_attrs) {
        Iterator<String> it = old_attrs.iterator();
        while (it.hasNext()) {
            String old_attr = it.next();
            if (!new_attrs.contains(old_attr)) continue;
            it.remove();
            new_attrs.remove(old_attr);
        }
        return old_attrs.isEmpty() && new_attrs.isEmpty();
    }

    protected static String print(Map<String, Collection<String>> map) {
        return map.entrySet().stream().filter(e -> e.getValue() != null && !((Collection)e.getValue()).isEmpty()).map(e -> String.format("%s: %s", e.getKey(), e.getValue())).collect(Collectors.joining("\n"));
    }

    protected static Collection<String> getAttributes(Class<?> clazz, String prefix) throws IOException, ClassNotFoundException {
        Method[] methods;
        Object name;
        Property annotation;
        Field[] fields;
        ConcurrentSkipListSet<String> ret = new ConcurrentSkipListSet<String>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (field.isAnnotationPresent(Property.class)) {
                Object property = field.getName();
                annotation = field.getAnnotation(Property.class);
                name = annotation.name();
                if (name != null && !((String)name).trim().isEmpty()) {
                    property = ((String)name).trim();
                }
                if (prefix != null && !prefix.isEmpty()) {
                    property = prefix + "." + (String)property;
                }
                ret.add((String)property);
            }
            if (!field.isAnnotationPresent(Component.class)) continue;
            Component ann = field.getAnnotation(Component.class);
            Class<?> type = field.getType();
            if (type.isInterface() || Modifier.isAbstract(type.getModifiers())) {
                Set<Class<?>> implementations = Util.findClassesAssignableFrom(ROOT_PACKAGE, type, Thread.currentThread().getContextClassLoader());
                for (Class<?> impl : implementations) {
                    ret.addAll(CompareMetrics.getAttributes(impl, ann.name()));
                }
                continue;
            }
            ret.addAll(CompareMetrics.getAttributes(type, ann.name()));
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Property.class)) continue;
            annotation = method.getAnnotation(Property.class);
            name = annotation.name();
            if (((String)name).isEmpty()) {
                name = Util.methodNameToAttributeName(method.getName());
            }
            if (prefix != null && !prefix.isEmpty()) {
                name = prefix + "." + (String)name;
            }
            ret.add((String)name);
        }
        return ret;
    }

    protected static void replaceVariables(InputStream in, OutputStream out, Properties p) {
        boolean looping = true;
        block6: while (looping) {
            try {
                int ch = in.read();
                if (ch == -1) break;
                switch (ch) {
                    case 92: {
                        String s;
                        int n1 = in.read();
                        int n2 = in.read();
                        if (n1 == -1 || n2 == -1) {
                            looping = false;
                            if (n1 == -1) continue block6;
                            out.write(n1);
                            continue block6;
                        }
                        if (n1 == 36 && n2 == 123) {
                            s = CompareMetrics.readUntilBracket(in);
                            out.write(n1);
                            out.write(n2);
                            out.write(s.getBytes());
                            out.write(125);
                            continue block6;
                        }
                        out.write(ch);
                        out.write(n1);
                        out.write(n2);
                        continue block6;
                    }
                    case 36: {
                        String s;
                        int n1 = in.read();
                        if (n1 == -1) {
                            out.write(ch);
                            looping = false;
                            continue block6;
                        }
                        if (n1 == 123) {
                            s = CompareMetrics.readUntilBracket(in);
                            CompareMetrics.writeVarToStream(s, p, out);
                            continue block6;
                        }
                        out.write(ch);
                        out.write(n1);
                        continue block6;
                    }
                }
                out.write(ch);
            }
            catch (IOException e) {
                // empty catch block
                break;
            }
        }
        Util.close(in, out);
    }

    protected static void writeVarToStream(String var, Properties p, OutputStream out) throws IOException {
        String val = (String)p.get(var);
        if (val != null) {
            out.write(val.getBytes());
        }
    }

    protected static String readUntilBracket(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            int ch = in.read();
            switch (ch) {
                case -1: {
                    throw new EOFException("no matching } found");
                }
                case 125: {
                    return sb.toString();
                }
            }
            sb.append((char)ch);
        }
    }

    private static String fileToString(File f) throws Exception {
        StringWriter output = new StringWriter();
        try (FileReader input = new FileReader(f);){
            int n;
            char[] buffer = new char[8192];
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
            }
        }
        return output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[8192];
        int count = 0;
        int n = 0;
        try {
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += n;
            }
        }
        finally {
            output.flush();
            output.close();
        }
        return count;
    }
}

