/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.connections;

import com.sun.star.comp.loader.FactoryHelper;
import com.sun.star.connection.XConnection;
import com.sun.star.io.IOException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.uno.RuntimeException;

public class PipedConnection
implements XConnection {
    public static final boolean DEBUG = false;
    private static final String __serviceName = "com.sun.star.connection.PipedConnection";
    protected static final int __waitTime = 10000;
    protected byte[] _buffer = new byte[4096];
    protected int _in;
    protected int _out;
    protected boolean _closed;
    protected PipedConnection _otherSide;

    public static XSingleServiceFactory __getServiceFactory(String string, XMultiServiceFactory xMultiServiceFactory, XRegistryKey xRegistryKey) {
        XSingleServiceFactory xSingleServiceFactory = null;
        if (string.equals(PipedConnection.class.getName())) {
            xSingleServiceFactory = FactoryHelper.getServiceFactory(PipedConnection.class, __serviceName, xMultiServiceFactory, xRegistryKey);
        }
        return xSingleServiceFactory;
    }

    public PipedConnection(Object[] objectArray) throws RuntimeException {
        PipedConnection pipedConnection = this._otherSide = objectArray.length == 1 ? (PipedConnection)objectArray[0] : null;
        if (this._otherSide != null) {
            if (this._otherSide == this) {
                throw new java.lang.RuntimeException("can not connect to myself");
            }
            this._otherSide._otherSide = this;
        }
    }

    private synchronized void receive(byte[] byArray) throws IOException {
        int n = 0;
        while (n < byArray.length) {
            int n2;
            while (this._out == this._in - 1 || this._in == 0 && this._out == this._buffer.length - 1) {
                try {
                    this.notify();
                    this.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException);
                }
            }
            if (this._closed) {
                throw new IOException("connection has been closed");
            }
            if (this._out < this._in) {
                n2 = Math.min(byArray.length - n, this._in - this._out - 1);
                System.arraycopy(byArray, n, this._buffer, this._out, n2);
            } else {
                n2 = this._in > 0 ? Math.min(byArray.length - n, this._buffer.length - this._out) : Math.min(byArray.length - n, this._buffer.length - this._out - 1);
                System.arraycopy(byArray, n, this._buffer, this._out, n2);
            }
            n += n2;
            this._out += n2;
            if (this._out < this._buffer.length) continue;
            this._out = 0;
        }
    }

    @Override
    public synchronized int read(byte[][] byArray, int n) throws IOException, RuntimeException {
        byArray[0] = new byte[n];
        while (!(n <= 0 || this._in == this._out && this._closed)) {
            int n2;
            while (this._in == this._out && !this._closed) {
                try {
                    this.notify();
                    this.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException);
                }
            }
            if (this._in < this._out) {
                n2 = Math.min(n, this._out - this._in);
                System.arraycopy(this._buffer, this._in, byArray[0], byArray[0].length - n, n2);
                n -= n2;
                this._in += n2;
                continue;
            }
            if (this._in <= this._out) continue;
            n2 = Math.min(n, this._buffer.length - this._in);
            System.arraycopy(this._buffer, this._in, byArray[0], byArray[0].length - n, n2);
            n -= n2;
            this._in += n2;
            if (this._in < this._buffer.length) continue;
            this._in = 0;
        }
        if (n > 0) {
            byte[] byArray2 = new byte[byArray[0].length - n];
            System.arraycopy(byArray[0], 0, byArray2, 0, byArray2.length);
            byArray[0] = byArray2;
        }
        return byArray[0].length;
    }

    @Override
    public void write(byte[] byArray) throws IOException, RuntimeException {
        this._otherSide.receive(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException, RuntimeException {
        PipedConnection pipedConnection = this._otherSide;
        synchronized (pipedConnection) {
            this._otherSide.notify();
        }
    }

    @Override
    public synchronized void close() throws IOException, RuntimeException {
        if (!this._closed) {
            this._closed = true;
            this._otherSide.close();
            this.notify();
        }
    }

    @Override
    public String getDescription() throws RuntimeException {
        return this.getClass().getName();
    }
}

