/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExtent3D
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int DEPTH;

    public VkExtent3D(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkExtent3D.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int width() {
        return VkExtent3D.nwidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int height() {
        return VkExtent3D.nheight(this.address());
    }

    @NativeType(value="uint32_t")
    public int depth() {
        return VkExtent3D.ndepth(this.address());
    }

    public VkExtent3D width(@NativeType(value="uint32_t") int value) {
        VkExtent3D.nwidth(this.address(), value);
        return this;
    }

    public VkExtent3D height(@NativeType(value="uint32_t") int value) {
        VkExtent3D.nheight(this.address(), value);
        return this;
    }

    public VkExtent3D depth(@NativeType(value="uint32_t") int value) {
        VkExtent3D.ndepth(this.address(), value);
        return this;
    }

    public VkExtent3D set(int width, int height, int depth) {
        this.width(width);
        this.height(height);
        this.depth(depth);
        return this;
    }

    public VkExtent3D set(VkExtent3D src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkExtent3D malloc() {
        return (VkExtent3D)VkExtent3D.wrap(VkExtent3D.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkExtent3D calloc() {
        return (VkExtent3D)VkExtent3D.wrap(VkExtent3D.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkExtent3D create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkExtent3D)VkExtent3D.wrap(VkExtent3D.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkExtent3D create(long address) {
        return (VkExtent3D)VkExtent3D.wrap(VkExtent3D.class, (long)address);
    }

    @Nullable
    public static VkExtent3D createSafe(long address) {
        return address == 0L ? null : (VkExtent3D)VkExtent3D.wrap(VkExtent3D.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkExtent3D.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkExtent3D.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkExtent3D.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExtent3D.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkExtent3D.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkExtent3D.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkExtent3D.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkExtent3D mallocStack() {
        return VkExtent3D.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExtent3D callocStack() {
        return VkExtent3D.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExtent3D mallocStack(MemoryStack stack) {
        return VkExtent3D.malloc(stack);
    }

    @Deprecated
    public static VkExtent3D callocStack(MemoryStack stack) {
        return VkExtent3D.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkExtent3D.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkExtent3D.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExtent3D.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExtent3D.calloc(capacity, stack);
    }

    public static VkExtent3D malloc(MemoryStack stack) {
        return (VkExtent3D)VkExtent3D.wrap(VkExtent3D.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExtent3D calloc(MemoryStack stack) {
        return (VkExtent3D)VkExtent3D.wrap(VkExtent3D.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkExtent3D.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkExtent3D.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nwidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEIGHT);
    }

    public static int ndepth(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEPTH);
    }

    public static void nwidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEIGHT, value);
    }

    public static void ndepth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEPTH, value);
    }

    static {
        Struct.Layout layout = VkExtent3D.__struct((Struct.Member[])new Struct.Member[]{VkExtent3D.__member((int)4), VkExtent3D.__member((int)4), VkExtent3D.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
        DEPTH = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExtent3D, Buffer>
    implements NativeResource {
        private static final VkExtent3D ELEMENT_FACTORY = VkExtent3D.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkExtent3D getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int width() {
            return VkExtent3D.nwidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int height() {
            return VkExtent3D.nheight(this.address());
        }

        @NativeType(value="uint32_t")
        public int depth() {
            return VkExtent3D.ndepth(this.address());
        }

        public Buffer width(@NativeType(value="uint32_t") int value) {
            VkExtent3D.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(@NativeType(value="uint32_t") int value) {
            VkExtent3D.nheight(this.address(), value);
            return this;
        }

        public Buffer depth(@NativeType(value="uint32_t") int value) {
            VkExtent3D.ndepth(this.address(), value);
            return this;
        }
    }
}

