/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.threads;

import java.awt.Color;
import org.graalvm.visualvm.lib.jfluid.global.CommonConstants;

public class ThreadData {
    static final byte NO_STATE = 127;
    private final Object dataLock = new Object();
    private final String name;
    private final String className;
    private long[] times = new long[6];
    private byte[] threadStates;
    private long[] timeStamps;
    private int capacity;
    private int curSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadData(String name, String className) {
        Object object = this.dataLock;
        synchronized (object) {
            this.capacity = 50;
            this.timeStamps = new long[this.capacity];
            this.threadStates = new byte[this.capacity];
            this.curSize = 0;
        }
        this.name = name;
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getFirstState() {
        Object object = this.dataLock;
        synchronized (object) {
            if (this.curSize == 0) {
                return 127;
            }
            return this.threadStates[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFirstTimeStamp() {
        Object object = this.dataLock;
        synchronized (object) {
            if (this.curSize == 0) {
                return 0L;
            }
            return this.timeStamps[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getLastState() {
        Object object = this.dataLock;
        synchronized (object) {
            if (this.curSize == 0) {
                return 127;
            }
            return this.threadStates[this.curSize - 1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastTimeStamp() {
        Object object = this.dataLock;
        synchronized (object) {
            if (this.curSize == 0) {
                return 0L;
            }
            return this.timeStamps[this.curSize - 1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        Object object = this.dataLock;
        synchronized (object) {
            return this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRunningTime(long lastTimestamp) {
        Object object = this.dataLock;
        synchronized (object) {
            long time = this.times[1];
            if (this.getLastState() == 1) {
                time += lastTimestamp - this.getLastTimeStamp();
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSleepingTime(long lastTimestamp) {
        Object object = this.dataLock;
        synchronized (object) {
            long time = this.times[2];
            if (this.getLastState() == 2) {
                time += lastTimestamp - this.getLastTimeStamp();
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWaitTime(long lastTimestamp) {
        Object object = this.dataLock;
        synchronized (object) {
            long time = this.times[4];
            if (this.getLastState() == 4) {
                time += lastTimestamp - this.getLastTimeStamp();
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getParkTime(long lastTimestamp) {
        Object object = this.dataLock;
        synchronized (object) {
            long time = this.times[5];
            if (this.getLastState() == 5) {
                time += lastTimestamp - this.getLastTimeStamp();
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMonitorTime(long lastTimestamp) {
        Object object = this.dataLock;
        synchronized (object) {
            long time = this.times[3];
            if (this.getLastState() == 3) {
                time += lastTimestamp - this.getLastTimeStamp();
            }
            return time;
        }
    }

    public long getTotalTime(long lastTimestamp) {
        return ThreadData.isAliveState(this.getLastState()) ? lastTimestamp - this.getFirstTimeStamp() : this.getLastTimeStamp() - this.getFirstTimeStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getStateAt(int idx) {
        Object object = this.dataLock;
        synchronized (object) {
            return this.threadStates[idx];
        }
    }

    public static Color getThreadStateColor(int threadState) {
        switch (threadState) {
            case -1: {
                return CommonConstants.THREAD_STATUS_UNKNOWN_COLOR;
            }
            case 0: {
                return CommonConstants.THREAD_STATUS_ZOMBIE_COLOR;
            }
            case 1: {
                return CommonConstants.THREAD_STATUS_RUNNING_COLOR;
            }
            case 2: {
                return CommonConstants.THREAD_STATUS_SLEEPING_COLOR;
            }
            case 3: {
                return CommonConstants.THREAD_STATUS_MONITOR_COLOR;
            }
            case 4: {
                return CommonConstants.THREAD_STATUS_WAIT_COLOR;
            }
            case 5: {
                return CommonConstants.THREAD_STATUS_PARK_COLOR;
            }
        }
        return CommonConstants.THREAD_STATUS_UNKNOWN_COLOR;
    }

    public static boolean isAliveState(int threadState) {
        if (threadState == 1) {
            return true;
        }
        if (threadState == 2) {
            return true;
        }
        if (threadState == 3) {
            return true;
        }
        if (threadState == 4) {
            return true;
        }
        return threadState == 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color getThreadStateColorAt(int idx) {
        Object object = this.dataLock;
        synchronized (object) {
            return ThreadData.getThreadStateColor(this.threadStates[idx]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeStampAt(int idx) {
        Object object = this.dataLock;
        synchronized (object) {
            return this.timeStamps[idx];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long timeStamp, byte threadState) {
        Object object = this.dataLock;
        synchronized (object) {
            if (this.curSize == this.capacity) {
                long[] oldStamps = this.timeStamps;
                byte[] oldStates = this.threadStates;
                int oldCapacity = this.capacity;
                this.capacity *= 2;
                this.timeStamps = new long[this.capacity];
                this.threadStates = new byte[this.capacity];
                System.arraycopy(oldStamps, 0, this.timeStamps, 0, oldCapacity);
                System.arraycopy(oldStates, 0, this.threadStates, 0, oldCapacity);
            }
            this.timeStamps[this.curSize] = timeStamp;
            this.threadStates[this.curSize] = threadState;
            if (this.curSize > 0) {
                long duration = timeStamp - this.timeStamps[this.curSize - 1];
                byte by = this.threadStates[this.curSize - 1];
                this.times[by] = this.times[by] + duration;
                this.times[0] = this.times[0] + duration;
            }
            ++this.curSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStates() {
        Object object = this.dataLock;
        synchronized (object) {
            this.capacity = 50;
            this.timeStamps = new long[this.capacity];
            this.threadStates = new byte[this.capacity];
            this.curSize = 0;
            this.times = new long[6];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.dataLock;
        synchronized (object) {
            return this.curSize;
        }
    }

    public String toString() {
        return this.getName();
    }
}

