/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.netbeans.core.multitabs.Controller;
import org.netbeans.core.multitabs.Settings;
import org.netbeans.core.multitabs.impl.ProjectColorTabDecorator;
import org.netbeans.core.multitabs.impl.ProjectSupport;
import org.netbeans.core.multitabs.impl.TabDataRenderer;
import org.netbeans.swing.popupswitcher.SwitcherTable;
import org.netbeans.swing.popupswitcher.SwitcherTableItem;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.openide.awt.CloseButtonFactory;
import org.openide.windows.TopComponent;

class DocumentSwitcherTable
extends SwitcherTable {
    private final JButton btnClose;
    private final Controller controller;
    private final ProjectColorTabDecorator decorator;
    private final ItemBorder ITEM_BORDER = new ItemBorder();
    private final Border SEPARATOR_BORDER = BorderFactory.createEmptyBorder(2, 2, 0, 5);
    private int lastRow = -1;
    private int lastCol = -1;
    private boolean inCloseButtonRect = false;
    private static final SwitcherTableItem.Activatable NONACTIVATABLE = new SwitcherTableItem.Activatable(){

        public void activate() {
        }
    };
    static final Item NO_PROJECT_SEPARATOR = new Item("<no project>", "<html><b>&lt;no project&gt;", null, null);

    public DocumentSwitcherTable(Controller controller, SwitcherTableItem[] switcherTableItemArray, int n) {
        super(switcherTableItemArray, n);
        this.controller = controller;
        this.btnClose = this.createCloseButton();
        this.decorator = Settings.getDefault().isSameProjectSameColor() ? new ProjectColorTabDecorator() : null;
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
    }

    public Item getSelectedItem() {
        Item item = (Item)((Object)this.getValueAt(this.getSelectedRow(), this.getSelectedColumn()));
        return item;
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        TabData tabData;
        Item item = (Item)((Object)this.getModel().getValueAt(n, n2));
        boolean bl = n == this.getSelectedRow() && n2 == this.getSelectedColumn() && item != null;
        boolean bl2 = null != item && item.isSeparator();
        this.ITEM_BORDER.color = null;
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        JLabel jLabel = null;
        if (component instanceof JLabel) {
            jLabel = (JLabel)component;
            if (bl2) {
                jLabel.setBorder(this.SEPARATOR_BORDER);
                jLabel.setIcon(null);
                jLabel.setText(item.getHtmlName());
            } else {
                jLabel.setBorder(this.ITEM_BORDER);
            }
        }
        if (bl) {
            JPanel jPanel = new JPanel(new BorderLayout(5, 0));
            jPanel.add(component, "Center");
            if (bl2 || TabDataRenderer.isClosable(item.getTabData())) {
                jPanel.add((Component)this.btnClose, "East");
            }
            jPanel.setBackground(component.getBackground());
            return jPanel;
        }
        if (null != this.decorator && null != item && !bl && null != (tabData = item.getTabData())) {
            this.ITEM_BORDER.color = this.decorator.getBackground(tabData, bl);
        }
        return component;
    }

    boolean onMouseEvent(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, (Component)((Object)this));
        int n = this.getSelectedRow();
        int n2 = this.getSelectedColumn();
        if (n < 0 || n2 < 0) {
            return false;
        }
        Rectangle rectangle = this.getCellRect(n, n2, false);
        if (rectangle.contains(point)) {
            Dimension dimension = this.btnClose.getPreferredSize();
            int n3 = rectangle.x + rectangle.width - dimension.width;
            int n4 = rectangle.y + (rectangle.height - dimension.height) / 2;
            Rectangle rectangle2 = new Rectangle(n3, n4, dimension.width, dimension.height);
            boolean bl = rectangle2.contains(point);
            boolean bl2 = this.inCloseButtonRect != bl;
            this.inCloseButtonRect = bl;
            if (bl && mouseEvent.getID() == 501) {
                Item item = (Item)((Object)this.getModel().getValueAt(n, n2));
                TabData tabData = item.getTabData();
                int n5 = this.controller.getTabModel().size();
                int n6 = this.controller.getTabModel().indexOf(tabData);
                if (n6 >= 0) {
                    TabActionEvent tabActionEvent = new TabActionEvent((Object)this, "close", n6);
                    this.controller.postActionEvent(tabActionEvent);
                    return n5 == 1;
                }
                if (item.isSeparator()) {
                    return this.closeSelectedDocumentList();
                }
            }
            if (bl2 && this.lastRow == n && this.lastCol == n2) {
                this.repaint(rectangle2);
            }
            this.lastCol = n2;
            this.lastRow = n;
            return bl;
        }
        return false;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        if (n >= 0 && n2 <= 0) {
            SwitcherTableItem switcherTableItem = (SwitcherTableItem)this.getModel().getValueAt(n, n2);
            return switcherTableItem.getDescription();
        }
        return null;
    }

    boolean closeSelectedDocumentList() {
        ArrayList arrayList = new ArrayList(this.controller.getTabModel().getTabs());
        Item item = (Item)((Object)this.getModel().getValueAt(this.getSelectedRow(), this.getSelectedColumn()));
        ProjectSupport.ProjectProxy projectProxy = item.getProject();
        ProjectSupport projectSupport = ProjectSupport.getDefault();
        int n = 0;
        for (TabData tabData : arrayList) {
            ProjectSupport.ProjectProxy projectProxy2 = projectSupport.getProjectForTab(tabData);
            if (projectProxy == null && projectProxy2 == null || projectProxy2 != null && projectProxy2.equals(projectProxy)) {
                Component component = tabData.getComponent();
                if (component instanceof TopComponent) {
                    TopComponent topComponent = (TopComponent)component;
                    if (!DocumentSwitcherTable.isClosingEnabled(topComponent)) continue;
                    topComponent.putClientProperty((Object)"inCloseAll", (Object)Boolean.TRUE);
                    if (topComponent.close()) continue;
                    break;
                }
                int n2 = this.controller.getTabModel().indexOf(tabData);
                TabActionEvent tabActionEvent = new TabActionEvent((Object)this, "close", n2);
                this.controller.postActionEvent(tabActionEvent);
                continue;
            }
            ++n;
        }
        return n == 0;
    }

    private static boolean isClosingEnabled(TopComponent topComponent) {
        return !Boolean.TRUE.equals(topComponent.getClientProperty((Object)"netbeans.winsys.tc.closing_disabled"));
    }

    private JButton createCloseButton() {
        Icon icon;
        JButton jButton = CloseButtonFactory.createBigCloseButton();
        jButton.setModel(new DefaultButtonModel(){

            @Override
            public boolean isRollover() {
                return DocumentSwitcherTable.this.inCloseButtonRect;
            }
        });
        Icon icon2 = UIManager.getIcon("nb.popupswitcher.closebutton.defaultIcon");
        if (null != icon2) {
            jButton.setIcon(icon2);
        }
        if (null != (icon = UIManager.getIcon("nb.popupswitcher.closebutton.rolloverIcon"))) {
            jButton.setRolloverIcon(icon);
        }
        return jButton;
    }

    private static class ItemBorder
    implements Border {
        private Color color;

        private ItemBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (null != this.color) {
                graphics.setColor(this.color);
                graphics.fillRect(n, n2, 5, n4);
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(2, 5, 0, 5);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    static class Item
    extends SwitcherTableItem {
        private final TabData tabData;
        private final ProjectSupport.ProjectProxy project;
        private final boolean isSeparator;

        public Item(SwitcherTableItem.Activatable activatable, String string, String string2, TabData tabData, boolean bl, ProjectSupport.ProjectProxy projectProxy) {
            super(activatable, string, string2, tabData.getIcon(), bl, tabData.getTooltip());
            this.tabData = tabData;
            this.project = projectProxy;
            this.isSeparator = false;
        }

        public static Item create(ProjectSupport.ProjectProxy projectProxy) {
            String string = null;
            string = projectProxy.getPath();
            return new Item(projectProxy.getDisplayName(), "<html><b>" + projectProxy.getDisplayName(), string, projectProxy);
        }

        private Item(String string, String string2, String string3, ProjectSupport.ProjectProxy projectProxy) {
            super(NONACTIVATABLE, string, string2, null, false, string3);
            this.tabData = null;
            this.project = projectProxy;
            this.isSeparator = true;
        }

        public TabData getTabData() {
            return this.tabData;
        }

        public boolean isSeparator() {
            return this.isSeparator;
        }

        public int compareTo(Object object) {
            if (object instanceof Item) {
                ProjectSupport.ProjectProxy projectProxy = ((Item)((Object)object)).project;
                if (null == this.project && null != projectProxy) {
                    return 1;
                }
                if (null != this.project && null == projectProxy) {
                    return -1;
                }
                if (null != this.project && null != projectProxy) {
                    int n = this.project.getDisplayName().compareTo(projectProxy.getDisplayName());
                    if (n != 0) {
                        return n;
                    }
                    n = this.project.getPath().compareTo(projectProxy.getPath());
                    if (n != 0) {
                        return n;
                    }
                }
            }
            return super.compareTo(object);
        }

        ProjectSupport.ProjectProxy getProject() {
            return this.project;
        }
    }
}

