/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.data;

import java.io.Serializable;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.rrd4j.core.Util;
import org.rrd4j.data.Source;
import org.rrd4j.data.VDef;

public abstract class Variable {
    public static final Value INVALIDVALUE = new Value(0L, Double.NaN);
    private Value val = null;

    void calculate(Source s, long start, long end) {
        long step = s.timestamps[1] - s.timestamps[0];
        int first = -1;
        int last = -1;
        int i = 0;
        for (int j = s.timestamps.length - 1; i < s.timestamps.length && j >= 0; ++i, --j) {
            if (first == -1) {
                long leftdown = Math.max(s.timestamps[i] - step, start);
                long rightdown = Math.min(s.timestamps[i], end);
                if (rightdown > leftdown) {
                    first = i;
                }
            }
            if (last == -1) {
                long leftup = Math.max(s.timestamps[j] - step, start);
                long rightup = Math.min(s.timestamps[j], end);
                if (rightup > leftup) {
                    last = j;
                }
            }
            if ((last != -1 || j <= first) && (first != -1 || last != -1 && i >= last)) break;
        }
        if (first == -1 || last == -1) {
            this.val = INVALIDVALUE;
        } else if (s instanceof VDef) {
            Value v = ((VDef)s).getValue();
            this.val = v.timestamp == 0L ? v : (v.timestamp < end && v.timestamp > start ? v : new Value(0L, Double.NaN));
        } else {
            long[] timestamps = new long[last - first + 1];
            System.arraycopy(s.timestamps, first, timestamps, 0, timestamps.length);
            double[] values = new double[last - first + 1];
            System.arraycopy(s.getValues(), first, values, 0, values.length);
            this.val = this.fill(timestamps, values, start, end);
        }
    }

    public Value getValue() {
        assert (this.val != null) : "Used before calculation";
        return this.val;
    }

    protected abstract Value fill(long[] var1, double[] var2, long var3, long var5);

    public static final class Value {
        public final double value;
        public final long timestamp;

        Value(long timestamp, double value) {
            this.value = value;
            this.timestamp = timestamp;
        }

        public String toString() {
            return "Value [value=" + this.value + ", timestamp=" + this.timestamp + "]";
        }
    }

    public static class LSLCORREL
    extends Variable {
        @Override
        protected Value fill(long[] timestamps, double[] values, long start, long end) {
            int cnt = 0;
            int lslstep = 0;
            double SUMx = 0.0;
            double SUMy = 0.0;
            double SUMxy = 0.0;
            double SUMxx = 0.0;
            double SUMyy = 0.0;
            for (double value : values) {
                if (!Double.isNaN(value)) {
                    ++cnt;
                    SUMx += (double)lslstep;
                    SUMxx += (double)(lslstep * lslstep);
                    SUMy += value;
                    SUMxy += (double)lslstep * value;
                    SUMyy += value * value;
                }
                ++lslstep;
            }
            if (cnt > 0) {
                double lslcorrel = (SUMxy - SUMx * SUMy / (double)cnt) / Math.sqrt((SUMxx - SUMx * SUMx / (double)cnt) * (SUMyy - SUMy * SUMy / (double)cnt));
                return new Value(0L, lslcorrel);
            }
            return new Value(0L, Double.NaN);
        }
    }

    public static class LSLINT
    extends Variable {
        @Override
        protected Value fill(long[] timestamps, double[] values, long start, long end) {
            int cnt = 0;
            int lslstep = 0;
            double SUMx = 0.0;
            double SUMy = 0.0;
            double SUMxy = 0.0;
            double SUMxx = 0.0;
            for (double value : values) {
                if (!Double.isNaN(value)) {
                    ++cnt;
                    SUMx += (double)lslstep;
                    SUMxx += (double)(lslstep * lslstep);
                    SUMy += value;
                    SUMxy += (double)lslstep * value;
                }
                ++lslstep;
            }
            double divisor = SUMx * SUMx - (double)cnt * SUMxx;
            if (cnt > 0 && divisor != 0.0) {
                double lslslope = (SUMx * SUMy - (double)cnt * SUMxy) / divisor;
                double lslint = (SUMy - lslslope * SUMx) / (double)cnt;
                return new Value(0L, lslint);
            }
            return new Value(0L, Double.NaN);
        }
    }

    public static class LSLSLOPE
    extends Variable {
        @Override
        protected Value fill(long[] timestamps, double[] values, long start, long end) {
            int cnt = 0;
            int lslstep = 0;
            double SUMx = 0.0;
            double SUMy = 0.0;
            double SUMxy = 0.0;
            double SUMxx = 0.0;
            for (double value : values) {
                if (!Double.isNaN(value)) {
                    ++cnt;
                    SUMx += (double)lslstep;
                    SUMxx += (double)(lslstep * lslstep);
                    SUMy += value;
                    SUMxy += (double)lslstep * value;
                }
                ++lslstep;
            }
            double divisor = SUMx * SUMx - (double)cnt * SUMxx;
            if (divisor != 0.0) {
                double lslslope = (SUMx * SUMy - (double)cnt * SUMxy) / divisor;
                return new Value(0L, lslslope);
            }
            return new Value(0L, Double.NaN);
        }
    }

    public static class PERCENTILENAN
    extends PERCENTILE {
        public PERCENTILENAN(float percentile) {
            super(percentile, false);
        }

        public PERCENTILENAN(double percentile) {
            super((float)percentile, false);
        }
    }

    public static class PERCENTILE
    extends Variable {
        private final float percentile;
        private final boolean withNaN;

        protected PERCENTILE(float percentile, boolean withNaN) {
            this.percentile = percentile;
            this.withNaN = withNaN;
        }

        public PERCENTILE(double percentile) {
            this((float)percentile, true);
        }

        public PERCENTILE(float percentile) {
            this(percentile, true);
        }

        @Override
        protected Value fill(long[] timestamps, double[] values, long start, long end) {
            PercentElem[] element;
            int pos;
            SortedSet<PercentElem> valuesSet = new TreeSet<PercentElem>(new ComparPercentElemen());
            for (int i = 0; i < values.length; ++i) {
                valuesSet.add(new PercentElem(i, timestamps[i], values[i]));
            }
            if (!this.withNaN) {
                valuesSet = valuesSet.tailSet(new PercentElem(0, 0L, Double.NEGATIVE_INFINITY));
            }
            if ((pos = Math.round(this.percentile * (float)((element = valuesSet.toArray(new PercentElem[0])).length - 1) / 100.0f)) >= 0) {
                double value = element[pos].value;
                long timestamp = element[pos].timestamp;
                return new Value(timestamp, value);
            }
            return new Value(0L, Double.NaN);
        }
    }

    static final class ComparPercentElemen
    implements Comparator<PercentElem>,
    Serializable {
        ComparPercentElemen() {
        }

        @Override
        public int compare(PercentElem arg0, PercentElem arg1) {
            if (Double.isNaN(arg0.value) && Double.isNaN(arg1.value)) {
                return Long.signum(arg0.timestamp - arg1.timestamp);
            }
            if (Double.isNaN(arg0.value)) {
                return -1;
            }
            if (Double.isNaN(arg1.value)) {
                return 1;
            }
            int compared = Double.compare(arg0.value, arg1.value);
            if (compared == 0) {
                compared = Long.signum(arg0.timestamp - arg1.timestamp);
            }
            return compared;
        }
    }

    static final class PercentElem {
        final long timestamp;
        final double value;

        PercentElem(int pos, long timestamp, double value) {
            this.timestamp = timestamp;
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PercentElem other = (PercentElem)obj;
            return this.timestamp == other.timestamp;
        }

        public int hashCode() {
            return Long.valueOf(this.timestamp).hashCode();
        }

        public String toString() {
            return String.format("[%d, %f]", this.timestamp, this.value);
        }
    }

    public static class STDDEV
    extends Variable {
        @Override
        protected Value fill(long[] timestamps, double[] values, long start, long end) {
            double value = Double.NaN;
            int count = 0;
            double M = 0.0;
            double S = 0.0;
            for (double cursVal : values) {
                if (Double.isNaN(cursVal)) continue;
                if (++count == 1) {
                    M = cursVal;
                    S = 0.0;
                    continue;
                }
                double dM = cursVal - M;
                S += dM * (cursVal - (M += dM / (double)count));
            }
            if (count > 1) {
                value = Math.sqrt(S / (double)(count - 1));
            }
            return new Value(0L, value);
        }
    }

    public static class AVERAGE
    extends Variable {
        @Override
        protected Value fill(long[] timestamps, double[] values, long start, long end) {
            double value = 0.0;
            int count = 0;
            for (int i = values.length - 1; i >= 0; --i) {
                if (Double.isNaN(values[i])) continue;
                ++count;
                value = Double.isNaN(value) ? values[i] : values[i] + value;
            }
            value = !Double.isNaN(value) && count > 0 ? (value /= (double)count) : Double.NaN;
            return new Value(0L, value);
        }
    }

    public static class TOTAL
    extends Variable {
        @Override
        protected Value fill(long[] timestamps, double[] values, long start, long end) {
            double value = Double.NaN;
            for (double tempVal : values) {
                value = Util.sum(value, tempVal);
            }
            return new Value(0L, value * (double)(timestamps[1] - timestamps[0]));
        }
    }

    public static class MAX
    extends Variable {
        @Override
        protected Value fill(long[] timestamps, double[] values, long start, long end) {
            long timestamp = 0L;
            double value = Double.NaN;
            for (int i = values.length - 1; i >= 0; --i) {
                if (!Double.isNaN(values[i]) && Double.isNaN(value)) {
                    timestamp = timestamps[i];
                    value = values[i];
                    continue;
                }
                if (Double.isNaN(values[i]) || !(value < values[i])) continue;
                timestamp = timestamps[i];
                value = values[i];
            }
            return new Value(timestamp, value);
        }
    }

    public static class MIN
    extends Variable {
        @Override
        protected Value fill(long[] timestamps, double[] values, long start, long end) {
            long timestamp = 0L;
            double value = Double.NaN;
            for (int i = values.length - 1; i >= 0; --i) {
                if (!Double.isNaN(values[i]) && Double.isNaN(value)) {
                    timestamp = timestamps[i];
                    value = values[i];
                    continue;
                }
                if (Double.isNaN(values[i]) || !(value > values[i])) continue;
                timestamp = timestamps[i];
                value = values[i];
            }
            return new Value(timestamp, value);
        }
    }

    public static class LAST
    extends Variable {
        @Override
        protected Value fill(long[] timestamps, double[] values, long start, long end) {
            for (int i = values.length - 1; i >= 0; --i) {
                if (Double.isNaN(values[i])) continue;
                return new Value(timestamps[i], values[i]);
            }
            return new Value(0L, Double.NaN);
        }
    }

    public static class FIRST
    extends Variable {
        @Override
        protected Value fill(long[] timestamps, double[] values, long start, long end) {
            for (int i = 0; i < values.length; ++i) {
                if (timestamps[i] <= start || timestamps[i] >= end || Double.isNaN(values[i])) continue;
                return new Value(timestamps[i], values[i]);
            }
            return new Value(0L, Double.NaN);
        }
    }
}

