/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.binding;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.binding.AssignedName;
import org.jruby.javasupport.binding.MethodGatherer;
import org.jruby.javasupport.binding.NamedInstaller;
import org.jruby.javasupport.binding.Priority;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.StringSupport;

public abstract class MethodInstaller
extends NamedInstaller {
    final ArrayList<Method> methods = new ArrayList(4);
    private List<String> aliases;
    private boolean localMethod;

    public MethodInstaller(String name2, int type2) {
        super(name2, type2);
    }

    final void addMethod(Method method2, Class<?> clazz) {
        this.methods.add(method2);
        Class<?> declaringClass = method2.getDeclaringClass();
        this.localMethod |= clazz == declaringClass || !Modifier.isPublic(declaringClass.getModifiers()) || declaringClass.isInterface();
    }

    final void addAlias(String alias) {
        List<String> aliases2 = this.aliases;
        if (aliases2 == null) {
            aliases2 = this.aliases = new ArrayList<String>(4);
        }
        if (!aliases2.contains(alias)) {
            aliases2.add(alias);
        }
    }

    void assignAliases(Map<String, AssignedName> assignedNames) {
        String name2 = this.name;
        String rubyCasedName = JavaUtil.getRubyCasedName(name2);
        this.addUnassignedAlias(rubyCasedName, assignedNames, Priority.ALIAS);
        String javaPropertyName = JavaUtil.getJavaPropertyName(name2);
        ArrayList<Method> methods2 = this.methods;
        for (int i2 = 0; i2 < methods2.size(); ++i2) {
            Method method2 = (Method)methods2.get(i2);
            Class<?>[] argTypes = method2.getParameterTypes();
            Class<?> resultType = method2.getReturnType();
            int argCount = argTypes.length;
            if (name2.equals("apply")) {
                this.addUnassignedAlias("[]", assignedNames, Priority.ALIAS);
            } else if (argCount == 2 && name2.equals("update")) {
                this.addUnassignedAlias("[]=", assignedNames, Priority.ALIAS);
            } else if (StringSupport.startsWith((CharSequence)name2, '$')) {
                this.addUnassignedAlias(MethodGatherer.fixScalaNames(name2), assignedNames, Priority.ALIAS);
            }
            String rubyPropertyName = null;
            if (javaPropertyName != null) {
                if (rubyCasedName.startsWith("get_")) {
                    rubyPropertyName = rubyCasedName.substring(4);
                    if (argCount == 0) {
                        this.addUnassignedAlias(javaPropertyName, assignedNames, Priority.GET_ALIAS);
                        this.addUnassignedAlias(rubyPropertyName, assignedNames, Priority.GET_ALIAS);
                    }
                } else if (rubyCasedName.startsWith("set_")) {
                    rubyPropertyName = rubyCasedName.substring(4);
                    if (argCount == 1) {
                        this.addUnassignedAlias(javaPropertyName + "=", assignedNames, Priority.ALIAS);
                        this.addUnassignedAlias(rubyPropertyName + "=", assignedNames, Priority.ALIAS);
                    }
                } else if (rubyCasedName.startsWith("is_")) {
                    rubyPropertyName = rubyCasedName.substring(3);
                    if (resultType == Boolean.TYPE) {
                        this.addUnassignedAlias(javaPropertyName, assignedNames, Priority.IS_ALIAS);
                        this.addUnassignedAlias(rubyPropertyName, assignedNames, Priority.IS_ALIAS);
                    }
                }
            }
            if (resultType != Boolean.TYPE) continue;
            this.addUnassignedAlias(rubyCasedName + "?", assignedNames, Priority.ALIAS);
            if (rubyPropertyName == null) continue;
            this.addUnassignedAlias(rubyPropertyName + "?", assignedNames, Priority.ALIAS);
        }
    }

    boolean addUnassignedAlias(String name2, Map<String, AssignedName> assignedNames, Priority aliasType) {
        AssignedName assignedName = assignedNames.get(name2);
        if (aliasType.moreImportantThan(assignedName)) {
            this.addAlias(name2);
            assignedNames.put(name2, new AssignedName(name2, aliasType));
            return true;
        }
        if (aliasType.asImportantAs(assignedName)) {
            this.addAlias(name2);
            return true;
        }
        return false;
    }

    final void removeAlias(String alias) {
        List<String> aliases2 = this.aliases;
        if (aliases2 == null) {
            return;
        }
        aliases2.remove(alias);
    }

    @Deprecated(since="10.0.0.0")
    final void defineMethods(RubyModule target2, DynamicMethod invoker) {
        this.defineMethods(target2.getCurrentContext(), target2, invoker, true);
    }

    @Deprecated(since="10.0.0.0")
    protected final void defineMethods(RubyModule target2, DynamicMethod invoker, boolean checkDups) {
        this.defineMethods(target2.getCurrentContext(), target2, invoker, checkDups);
    }

    protected final void defineMethods(ThreadContext context, RubyModule target2, DynamicMethod invoker, boolean checkDups) {
        String oldName = this.name;
        target2.addMethod(context, oldName, invoker);
        List<String> aliases2 = this.aliases;
        if (aliases2 != null && this.isPublic()) {
            for (int i2 = 0; i2 < aliases2.size(); ++i2) {
                String name2 = aliases2.get(i2);
                if (checkDups && oldName.equals(name2)) continue;
                target2.addMethod(context, name2, invoker);
            }
        }
    }

    @Override
    boolean hasLocalMethod() {
        return this.localMethod;
    }

    void setLocalMethod(boolean flag) {
        this.localMethod = flag;
    }
}

